/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class PortConflictValidator {
    private final Set<PortInfo> gatheredPorts = new HashSet<PortInfo>();

    public String check(String parameterName, String rangePort) {
        String retMsg = this.checkPortConflict(parameterName, rangePort);
        if (retMsg != null) {
            return retMsg;
        }
        return null;
    }

    public String check(String parameterName, int port) {
        String retMsg = this.checkPortConflict(parameterName, String.valueOf(port));
        if (retMsg != null) {
            return retMsg;
        }
        return null;
    }

    private String checkPortConflict(String parameterName, String port) {
        PortInfo currentPortInfo = new PortInfo(parameterName, port);
        PortConflictInfo portConflictInfo = this.findAllPortsConflict(currentPortInfo, this.gatheredPorts);
        this.gatheredPorts.add(currentPortInfo);
        if (portConflictInfo != null && portConflictInfo.getConflictPort() > 0) {
            return "Specified " + parameterName + " " + portConflictInfo.getConflictPort() + " is already assigned as " + portConflictInfo.getMessage();
        }
        return null;
    }

    private int findPortsConflict(int port1, int port2) {
        if (port1 == port2) {
            return port1;
        }
        return 0;
    }

    private int findPortsConflict(int port, String rangePorts) {
        StringTokenizer tokenizer = new StringTokenizer(rangePorts, ",");
        int firstHAPort = Integer.parseInt(tokenizer.nextToken());
        int secondHAPort = Integer.parseInt(tokenizer.nextToken());
        for (int i = firstHAPort; i <= secondHAPort; ++i) {
            if (port != i) continue;
            return port;
        }
        return 0;
    }

    private int findRangePortsConflict(String rangePorts1, String rangePorts2) {
        StringTokenizer tokenizer1 = new StringTokenizer(rangePorts1, ",");
        int firstHAPort1 = Integer.parseInt(tokenizer1.nextToken());
        int secondHAPort1 = Integer.parseInt(tokenizer1.nextToken());
        StringTokenizer tokenizer2 = new StringTokenizer(rangePorts2, ",");
        int firstHAPort2 = Integer.parseInt(tokenizer2.nextToken());
        int secondHAPort2 = Integer.parseInt(tokenizer2.nextToken());
        for (int i = firstHAPort1; i <= secondHAPort1; ++i) {
            for (int j = firstHAPort2; j <= secondHAPort2; ++j) {
                if (i != j) continue;
                return i;
            }
        }
        return 0;
    }

    private int findPortsConflict(String port1, String port2) {
        boolean isRangePort1 = false;
        boolean isRangePort2 = false;
        if (port1.indexOf(",") >= 0) {
            isRangePort1 = true;
        }
        if (port2.indexOf(",") >= 0) {
            isRangePort2 = true;
        }
        int conflictPort = 0;
        conflictPort = !isRangePort1 && !isRangePort2 ? this.findPortsConflict(Integer.parseInt(port1), Integer.parseInt(port2)) : (!isRangePort1 && isRangePort2 ? this.findPortsConflict(Integer.parseInt(port1), port2) : (isRangePort1 && !isRangePort2 ? this.findPortsConflict(Integer.parseInt(port2), port1) : this.findRangePortsConflict(port1, port2)));
        return conflictPort;
    }

    private PortConflictInfo findAllPortsConflict(PortInfo currPortInfo, Set<PortInfo> portSet) {
        PortConflictInfo portConflictInfo = null;
        if (portSet == null || portSet.size() < 1) {
            return portConflictInfo;
        }
        for (PortInfo comPortInfo : portSet) {
            int conflictPort = this.findPortsConflict(currPortInfo.getPort(), comPortInfo.getPort());
            if (conflictPort <= 0) continue;
            portConflictInfo = new PortConflictInfo(comPortInfo.getName(), conflictPort);
            return portConflictInfo;
        }
        return portConflictInfo;
    }

    public static class PortConflictInfo {
        private String message;
        private int conflictPort;

        public PortConflictInfo(String message, int conflictPort) {
            this.message = message;
            this.conflictPort = conflictPort;
        }

        public String getMessage() {
            return this.message;
        }

        public int getConflictPort() {
            return this.conflictPort;
        }
    }

    public class PortInfo {
        private String name;
        private String port;

        public PortInfo(String name, String port) {
            this.name = name;
            this.port = port;
        }

        public String getName() {
            return this.name;
        }

        public String getPort() {
            return this.port;
        }
    }
}

