/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class DiagnosticTask {
    private int totalSubTaskCount = 0;
    private int completedSubTaskCount = 0;
    private Queue<String> messageQueue = new LinkedBlockingQueue<String>();

    public DiagnosticTask() {
        this(1);
    }

    public DiagnosticTask(int totalSubTaskCount) {
        this.totalSubTaskCount = totalSubTaskCount;
    }

    public int getTotalSubTaskCount() {
        return this.totalSubTaskCount;
    }

    public int getCompletedSubTaskCount() {
        return this.completedSubTaskCount;
    }

    public void notifyCompleteSubTask(String message) {
        ++this.completedSubTaskCount;
        this.messageQueue.add(message);
    }

    public Queue<String> getMessageQueue() {
        return this.messageQueue;
    }

    protected void setTotalSubTaskCount(int totalSubTaskCount) {
        this.totalSubTaskCount = totalSubTaskCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws Exception {
        try {
            this.doWork();
        }
        finally {
            this.completedSubTaskCount = this.totalSubTaskCount;
        }
    }

    public abstract void doWork() throws Exception;
}

