/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic;

import java.util.Arrays;
import java.util.List;
import oracle.kv.impl.diagnostic.DiagnosticConfigFile;
import oracle.kv.impl.diagnostic.DiagnosticSSHRunnable;
import oracle.kv.impl.diagnostic.DiagnosticSSHTask;
import oracle.kv.impl.diagnostic.DiagnosticTask;
import oracle.kv.impl.diagnostic.DiagnosticTaskManager;
import oracle.kv.impl.diagnostic.ParametersValidator;
import oracle.kv.impl.diagnostic.SNAInfo;
import oracle.kv.impl.diagnostic.ssh.SSHClient;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellException;
import oracle.kv.util.shell.ShellUsageException;

public class DiagnosticSetupCommand
extends CommandWithSubs {
    private static final String DEFAULT_WORK_DIR = System.getProperty("user.dir");
    private static final String STORE_FLAG = "-store";
    private static final String SN_FLAG = "-sn";
    private static final String SSH_USER_FLAG = "-sshusername";
    private static final String USER_FLAG = "-user";
    private static final String HOST_FLAG = "-host";
    private static final String ROOT_DIR_FLAG = "-rootdir";
    private static final String CONFIG_DIRECTORY_FLAG = "-configdir";
    private static final String CONFIG_FILE_NAME = "sn-target-list";
    private static final String NEW_LINE_TAB = "\n\t";
    private static final String EMPTY_STRING = "";
    private static final String NOT_FOUND_ROOT_MESSAGE = "Cannot find root directory: ";
    private static final String COMMAND_NAME = "setup";
    private static final String ADD_SUBCOMMAND_NAME = "-add";
    private static final String LIST_SUBCOMMAND_NAME = "-list";
    private static final String DELETE_SUBCOMMAND_NAME = "-delete";
    private static final String CLEAR_SUBCOMMAND_NAME = "-clear";
    private static final List<? extends CommandWithSubs.SubCommand> subs = Arrays.asList(new DiagnosticSetupAddSub(), new DiagnosticSetupListSub(), new DiagnosticSetupDeleteSub(), new DiagnosticSetupClearSub());

    public DiagnosticSetupCommand() {
        super(subs, COMMAND_NAME, 4, 0);
    }

    @Override
    protected String getCommandOverview() {
        return "The Setup command creates the list of storage nodes which are targeted " + eol + "by the diagnostics collect " + "command. This list is saved in the " + CONFIG_FILE_NAME + eol + "file.The sn-target-list file can also be created by " + "connecting to a running" + eol + "node in the cluster, " + "using the collect -logfiles -host <name> -port <number>" + eol + "command.";
    }

    static class DiagnosticSetupClearSub
    extends CommandWithSubs.SubCommand {
        String configdir = null;

        DiagnosticSetupClearSub() {
            super(DiagnosticSetupCommand.CLEAR_SUBCOMMAND_NAME, 4);
        }

        @Override
        protected String getCommandSyntax() {
            return "setup -clear [-configdir <configuration file directory>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Clear info of all SNAs from configuration file";
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            this.configdir = null;
            Shell.checkHelp(args, this);
            if (args.length > 1) {
                for (int i = 1; i < args.length; ++i) {
                    if (DiagnosticSetupCommand.CONFIG_DIRECTORY_FLAG.equals(args[i])) {
                        this.configdir = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    shell.unknownArgument(args[i], this);
                }
            }
            if (this.configdir == null || this.configdir.isEmpty()) {
                this.configdir = DEFAULT_WORK_DIR;
            }
            this.clear();
            return null;
        }

        private void clear() throws ShellUsageException {
            DiagnosticConfigFile configFile = new DiagnosticConfigFile(this.configdir);
            try {
                configFile.clear();
            }
            catch (Exception ex) {
                throw new ShellUsageException(ex.getMessage(), this);
            }
        }
    }

    static class DiagnosticSetupDeleteSub
    extends CommandWithSubs.SubCommand {
        String storename = null;
        String snname = null;
        String username = null;
        String hostname = null;
        String rootdir = null;
        String configdir = null;

        DiagnosticSetupDeleteSub() {
            super(DiagnosticSetupCommand.DELETE_SUBCOMMAND_NAME, 4);
        }

        @Override
        protected String getCommandSyntax() {
            return "setup -delete" + eolt + "[" + DiagnosticSetupCommand.STORE_FLAG + " <store name>]" + eolt + "[" + DiagnosticSetupCommand.SN_FLAG + " <SN name>]" + eolt + "[" + DiagnosticSetupCommand.HOST_FLAG + " <host>]" + eolt + "[" + DiagnosticSetupCommand.ROOT_DIR_FLAG + " <kvroot directory>]" + eolt + "[" + DiagnosticSetupCommand.USER_FLAG + " <user>] " + eolt + "[" + DiagnosticSetupCommand.CONFIG_DIRECTORY_FLAG + " <configuration file directory>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Delete SNA descriptors from the sn-target-list file";
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            this.storename = null;
            this.snname = null;
            this.username = null;
            this.hostname = null;
            this.rootdir = null;
            this.configdir = null;
            Shell.checkHelp(args, this);
            if (args.length > 1) {
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if (DiagnosticSetupCommand.STORE_FLAG.equals(arg)) {
                        this.storename = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (DiagnosticSetupCommand.SN_FLAG.equals(arg)) {
                        this.snname = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (DiagnosticSetupCommand.USER_FLAG.equals(arg)) {
                        this.username = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (DiagnosticSetupCommand.HOST_FLAG.equals(arg)) {
                        this.hostname = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (DiagnosticSetupCommand.ROOT_DIR_FLAG.equals(arg)) {
                        this.rootdir = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (DiagnosticSetupCommand.CONFIG_DIRECTORY_FLAG.equals(arg)) {
                        this.configdir = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    shell.unknownArgument(args[i], this);
                }
            }
            if (this.configdir == null || this.configdir.isEmpty()) {
                this.configdir = DEFAULT_WORK_DIR;
            }
            this.delete(shell);
            return null;
        }

        private void delete(Shell shell) throws ShellUsageException {
            String OUTPUT_MESSAGE = " line has been deleted from ";
            String PLURAL_OUTPUT_MESSAGE = " lines have been deleted from ";
            int numberOfDeleted = 0;
            DiagnosticConfigFile configFile = new DiagnosticConfigFile(this.configdir);
            try {
                SNAInfo patternSNAInfo = new SNAInfo(this.storename, this.snname, this.hostname, this.username, this.rootdir);
                numberOfDeleted = configFile.delete(patternSNAInfo);
                if (numberOfDeleted > 1) {
                    shell.getOutput().println(numberOfDeleted + PLURAL_OUTPUT_MESSAGE + configFile.getFilePath());
                } else {
                    shell.getOutput().println(numberOfDeleted + OUTPUT_MESSAGE + configFile.getFilePath());
                }
            }
            catch (Exception ex) {
                throw new ShellUsageException(ex.getMessage(), this);
            }
        }
    }

    static class DiagnosticSetupListSub
    extends CommandWithSubs.SubCommand {
        String configdir = null;
        String sshUser = null;

        DiagnosticSetupListSub() {
            super(DiagnosticSetupCommand.LIST_SUBCOMMAND_NAME, 4);
        }

        @Override
        protected String getCommandSyntax() {
            return "setup -list [-configdir <configuration file directory>]" + eol + "[" + DiagnosticSetupCommand.SSH_USER_FLAG + " <SSH username>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Display and validate all storage nodes descriptors in the sn-target-list file.";
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            this.configdir = null;
            this.sshUser = null;
            Shell.checkHelp(args, this);
            if (args.length > 1) {
                for (int i = 1; i < args.length; ++i) {
                    if (DiagnosticSetupCommand.CONFIG_DIRECTORY_FLAG.equals(args[i])) {
                        this.configdir = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (DiagnosticSetupCommand.SSH_USER_FLAG.equals(args[i])) {
                        this.sshUser = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    shell.unknownArgument(args[i], this);
                }
            }
            if (this.configdir == null || this.configdir.isEmpty()) {
                this.configdir = DEFAULT_WORK_DIR;
            }
            this.list(shell);
            return null;
        }

        private void list(Shell shell) throws ShellUsageException {
            try {
                DiagnosticConfigFile configFile = new DiagnosticConfigFile(this.configdir);
                configFile.verify();
            }
            catch (Exception ex) {
                throw new ShellUsageException(ex.getMessage(), this);
            }
            try {
                DiagnosticTaskManager taskManager = new DiagnosticTaskManager(shell);
                DiagnosticSSHTask task = new DiagnosticSSHTask(this.configdir, this.sshUser){

                    @Override
                    public DiagnosticSSHRunnable getSSHRunnable(SNAInfo snaInfo, SSHClient client, List<SNAInfo> taskSNList) {
                        return new ConfigurationFileChecker(snaInfo, this, client);
                    }
                };
                taskManager.addTask(task);
                taskManager.execute();
            }
            catch (Exception ex) {
                throw new ShellUsageException(ex.toString(), this);
            }
        }

        private class ConfigurationFileChecker
        extends DiagnosticSSHRunnable {
            public ConfigurationFileChecker(SNAInfo snaInfo, DiagnosticTask threadOwner, SSHClient client) {
                super(snaInfo, threadOwner, client);
            }

            @Override
            public String doWork() throws Exception {
                String message = DiagnosticSetupCommand.EMPTY_STRING;
                String retMsg = ParametersValidator.checkHostname("host", this.snaInfo.getHost());
                if (retMsg != null) {
                    message = message + DiagnosticSetupCommand.NEW_LINE_TAB + retMsg;
                    return message.trim();
                }
                if (this.client == null) {
                    message = message + "Cannot connect " + this.snaInfo.getHost();
                    return message.trim();
                }
                if (!this.client.checkFile(this.snaInfo.getRootdir())) {
                    message = message + "\n\tCannot find root directory: " + this.snaInfo.getRootdir();
                }
                return message.trim();
            }
        }
    }

    static class DiagnosticSetupAddSub
    extends CommandWithSubs.SubCommand {
        String storename = null;
        String snname = null;
        String username = null;
        String hostname = null;
        String rootdir = null;
        String configdir = null;

        DiagnosticSetupAddSub() {
            super(DiagnosticSetupCommand.ADD_SUBCOMMAND_NAME, 4);
        }

        @Override
        protected String getCommandSyntax() {
            return "setup -add -store <store name>" + eolt + DiagnosticSetupCommand.SN_FLAG + " <SN name>" + eolt + DiagnosticSetupCommand.HOST_FLAG + " <host>" + eolt + DiagnosticSetupCommand.ROOT_DIR_FLAG + " <kvroot directory>" + eolt + DiagnosticSetupCommand.USER_FLAG + " <user>" + eolt + "[" + DiagnosticSetupCommand.CONFIG_DIRECTORY_FLAG + " <directory of configuration>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Add a descriptor for this storage node to the sn-target-list file.";
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            String retMsg;
            this.storename = null;
            this.snname = null;
            this.username = null;
            this.hostname = null;
            this.rootdir = null;
            this.configdir = null;
            Shell.checkHelp(args, this);
            if (args.length > 1) {
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if (DiagnosticSetupCommand.STORE_FLAG.equals(arg)) {
                        this.storename = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (DiagnosticSetupCommand.SN_FLAG.equals(arg)) {
                        this.snname = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (DiagnosticSetupCommand.USER_FLAG.equals(arg)) {
                        this.username = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (DiagnosticSetupCommand.HOST_FLAG.equals(arg)) {
                        this.hostname = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (DiagnosticSetupCommand.ROOT_DIR_FLAG.equals(arg)) {
                        this.rootdir = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (DiagnosticSetupCommand.CONFIG_DIRECTORY_FLAG.equals(arg)) {
                        this.configdir = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    shell.unknownArgument(args[i], this);
                }
            }
            if (this.storename == null || this.storename.isEmpty()) {
                shell.requiredArg(DiagnosticSetupCommand.STORE_FLAG, this);
            }
            if (this.snname == null || this.snname.isEmpty()) {
                shell.requiredArg(DiagnosticSetupCommand.SN_FLAG, this);
            }
            if (this.hostname == null || this.hostname.isEmpty()) {
                shell.requiredArg(DiagnosticSetupCommand.HOST_FLAG, this);
            }
            if (this.username == null || this.username.isEmpty()) {
                shell.requiredArg(DiagnosticSetupCommand.USER_FLAG, this);
            }
            if (this.rootdir == null || this.rootdir.isEmpty()) {
                shell.requiredArg(DiagnosticSetupCommand.ROOT_DIR_FLAG, this);
            }
            if (this.configdir == null || this.configdir.isEmpty()) {
                this.configdir = DEFAULT_WORK_DIR;
            }
            if ((retMsg = ParametersValidator.checkHostname(DiagnosticSetupCommand.HOST_FLAG, this.hostname)) != null) {
                throw new ShellUsageException(retMsg, this);
            }
            SNAInfo snaInfo = new SNAInfo(this.storename, this.snname, this.hostname, this.username, this.rootdir);
            this.add(snaInfo);
            return null;
        }

        private void add(SNAInfo snaInfo) throws ShellUsageException {
            DiagnosticConfigFile configFile = new DiagnosticConfigFile(this.configdir);
            try {
                List<SNAInfo> currentList = configFile.getAllSNAInfo();
                for (SNAInfo existingSNAInfo : currentList) {
                    if (!snaInfo.equals(existingSNAInfo)) continue;
                    throw new Exception("Duplicated line " + existingSNAInfo.getSNAInfo() + " already exists in " + "configuration file " + configFile.getFilePath());
                }
                currentList.add(snaInfo);
                configFile.rewrite(currentList);
            }
            catch (Exception ex) {
                throw new ShellUsageException(ex.getMessage(), this);
            }
        }
    }
}

