/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.util.ListIterator;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.StringDefImpl;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.table.FieldDef;
import oracle.kv.table.MapDef;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;

@Persistent(version=1)
class MapDefImpl
extends FieldDefImpl
implements MapDef {
    private static final long serialVersionUID = 1L;
    private final FieldDefImpl element;
    private static final StringDefImpl keyType = new StringDefImpl();

    MapDefImpl(FieldDefImpl element, String description) {
        super(FieldDef.Type.MAP, description);
        if (element == null) {
            throw new IllegalArgumentException("Map has no field and cannot be built");
        }
        this.element = element;
    }

    MapDefImpl(FieldDefImpl element) {
        this(element, null);
    }

    private MapDefImpl(MapDefImpl impl) {
        super(impl);
        this.element = impl.element.clone();
    }

    private MapDefImpl() {
        this.element = null;
    }

    @Override
    public boolean isValidIndexField() {
        return true;
    }

    @Override
    public FieldDef getElement() {
        return this.element;
    }

    @Override
    public FieldDef getKeyDefinition() {
        return keyType;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public MapDef asMap() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof MapDefImpl) {
            return this.element.equals(((MapDefImpl)other).getElement());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.element.hashCode();
    }

    @Override
    public MapValueImpl createMap() {
        return new MapValueImpl(this);
    }

    @Override
    void toJson(ObjectNode node) {
        super.toJson(node);
        ObjectNode collNode = node.putObject("collection");
        if (this.element != null) {
            this.element.toJson(collNode);
        }
    }

    @Override
    public JsonNode mapTypeToAvro(ObjectNode node) {
        if (node == null) {
            node = JsonUtils.createObjectNode();
        }
        node.put("type", "map");
        node.put("values", this.element.mapTypeToAvroJsonNode());
        return node;
    }

    @Override
    public MapDefImpl clone() {
        return new MapDefImpl(this);
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isObject()) {
            throw new IllegalArgumentException("Default value for type MAP is not a map");
        }
        if (node.size() != 0) {
            throw new IllegalArgumentException("Default value for map must be null or an empty map");
        }
        return this.createMap();
    }

    @Override
    FieldDefImpl findField(ListIterator<String> fieldPath) {
        assert (fieldPath.hasNext());
        String currentField = fieldPath.next();
        if ("_key".equalsIgnoreCase(currentField)) {
            if (fieldPath.hasNext()) {
                throw new IllegalArgumentException("_key must be the final component of the field");
            }
            return keyType;
        }
        if (!fieldPath.hasNext()) {
            return this.element;
        }
        return this.element.findField(fieldPath);
    }

    @Override
    FieldDefImpl findField(String fieldName) {
        return this.element;
    }

    static boolean isMapKeyTag(String target) {
        return "_key".equalsIgnoreCase(target);
    }

    static boolean isMapValueTag(String target) {
        return "[]".equalsIgnoreCase(target);
    }
}

