/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.rgstate;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.utilint.VLSN;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import oracle.kv.Consistency;
import oracle.kv.impl.api.RequestHandlerAPI;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.util.registry.RegistryUtils;

public class RepNodeState {
    private final RepNodeId rnId;
    private volatile DatacenterId znId = null;
    private final ReqHandlerRef reqHandlerRef;
    private volatile ReplicatedEnvironment.State repState = null;
    private final VLSNState vlsnState;
    private int topoSeqNum = -1;
    public static final int SAMPLE_SIZE = 8;
    private final ResponseTimeAccumulator readAccumulator;
    private final AtomicLong accumRespTimeMs = new AtomicLong(0L);
    private final AtomicInteger activeRequestCount = new AtomicInteger(0);
    private volatile int maxActiveRequestCount = 0;
    private volatile long totalRequestCount;
    private volatile int errorCount;
    public static int RATE_INTERVAL_MS = 10000;

    RepNodeState(RepNodeId rnId) {
        this(rnId, RATE_INTERVAL_MS);
    }

    RepNodeState(RepNodeId rnId, int rateIntervalMs) {
        this.rnId = rnId;
        this.readAccumulator = new ResponseTimeAccumulator();
        this.reqHandlerRef = new ReqHandlerRef();
        this.vlsnState = new VLSNState(rateIntervalMs);
        this.repState = ReplicatedEnvironment.State.REPLICA;
    }

    public RepNodeId getRepNodeId() {
        return this.rnId;
    }

    public DatacenterId getZoneId() {
        return this.znId;
    }

    public void setZoneId(DatacenterId znId) {
        this.znId = znId;
    }

    public RequestHandlerAPI getReqHandlerRef(RegistryUtils registryUtils, long timeoutMs) throws InterruptedException {
        return this.reqHandlerRef.get(registryUtils, timeoutMs);
    }

    public boolean reqHandlerNeedsResolution() {
        return this.reqHandlerRef.needsResolution();
    }

    public boolean reqHandlerNeedsRepair() {
        return this.reqHandlerRef.needsRepair();
    }

    public RequestHandlerAPI resolveReqHandlerRef(RegistryUtils registryUtils, long timeoutMs) throws InterruptedException {
        return this.reqHandlerRef.resolve(registryUtils, timeoutMs);
    }

    public void resetReqHandlerRef() throws InterruptedException {
        this.reqHandlerRef.reset();
    }

    public void noteReqHandlerException(Exception e) throws InterruptedException {
        this.reqHandlerRef.noteException(e);
    }

    public short getRequestHandlerSerialVersion() {
        return this.reqHandlerRef.getSerialVersion();
    }

    public ReplicatedEnvironment.State getRepState() {
        return this.repState;
    }

    void updateRepState(ReplicatedEnvironment.State state) {
        this.repState = state;
    }

    VLSN getVLSN() {
        return this.vlsnState.getVLSN();
    }

    boolean isObsoleteVLSNState() {
        return this.vlsnState.isObsolete();
    }

    void updateVLSN(VLSN newVLSN) {
        this.vlsnState.updateVLSN(newVLSN);
    }

    int getTopoSeqNum() {
        return this.topoSeqNum;
    }

    synchronized void updateTopoSeqNum(int newTopoSeqNum) {
        if (this.topoSeqNum < newTopoSeqNum) {
            this.topoSeqNum = newTopoSeqNum;
        }
    }

    synchronized void resetTopoSeqNum(int endSeqNum) {
        this.topoSeqNum = endSeqNum;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int incErrorCount() {
        return ++this.errorCount;
    }

    int getAvReadRespTimeMs() {
        return this.readAccumulator.getAverage();
    }

    public void accumRespTime(boolean forWrite, int responseTimeMs) {
        if (!forWrite) {
            this.readAccumulator.update(responseTimeMs);
        }
        this.accumRespTimeMs.getAndAdd(responseTimeMs);
    }

    int getActiveRequestCount() {
        return this.activeRequestCount.get();
    }

    public int getMaxActiveRequestCount() {
        return this.maxActiveRequestCount;
    }

    public long getTotalRequestCount() {
        return this.totalRequestCount;
    }

    public long getAccumRespTimeMs() {
        return this.accumRespTimeMs.get();
    }

    public void resetStatsCounts() {
        this.totalRequestCount = 0L;
        this.maxActiveRequestCount = 0;
        this.accumRespTimeMs.set(0L);
        this.errorCount = 0;
    }

    public int requestStart() {
        ++this.totalRequestCount;
        int count = this.activeRequestCount.incrementAndGet();
        this.maxActiveRequestCount = Math.max(this.maxActiveRequestCount, count);
        return count;
    }

    public void requestEnd() {
        this.activeRequestCount.decrementAndGet();
    }

    public String printString() {
        return String.format("node: %s state: %s errors: %,dav resp time %,d ms total requests: %,d", this.getRepNodeId().toString(), this.getRepState().toString(), this.getErrorCount(), this.getAvReadRespTimeMs(), this.getTotalRequestCount());
    }

    public String toString() {
        return "RepNodeState[" + this.getRepNodeId() + ", " + (Object)((Object)this.getRepState()) + "]";
    }

    boolean inConsistencyRange(long timeMs, Consistency.Version consistency) {
        assert (consistency != null);
        VLSN consistencyVLSN = new VLSN(consistency.getVersion().getVLSN());
        return this.vlsnState.vlsnAt(timeMs).compareTo(consistencyVLSN) >= 0;
    }

    boolean inConsistencyRange(long timeMs, Consistency.Time consistency, RepNodeState master) {
        assert (consistency != null);
        if (master == null) {
            return true;
        }
        long lagMs = consistency.getPermissibleLag(TimeUnit.MILLISECONDS);
        VLSN consistencyVLSN = master.vlsnState.vlsnAt(timeMs - lagMs);
        return this.vlsnState.vlsnAt(timeMs).compareTo(consistencyVLSN) >= 0;
    }

    private static class VLSNState {
        private volatile VLSN vlsn = VLSN.NULL_VLSN;
        private long lastUpdateMs;
        private VLSN intervalStart = VLSN.NULL_VLSN;
        private long intervalStartMs = 0L;
        private long vlsnsPerSec = 0L;
        private final int rateIntervalMs;

        private VLSNState(int rateIntervalMs) {
            this.rateIntervalMs = rateIntervalMs;
        }

        private VLSN getVLSN() {
            return this.vlsn;
        }

        private synchronized boolean isObsolete() {
            return this.lastUpdateMs + (long)this.rateIntervalMs < System.currentTimeMillis();
        }

        private synchronized void updateVLSN(VLSN newVLSN) {
            long intervalMs;
            if (newVLSN == null || newVLSN.isNull()) {
                return;
            }
            this.lastUpdateMs = System.currentTimeMillis();
            if (newVLSN.compareTo(this.vlsn) > 0) {
                this.vlsn = newVLSN;
            }
            if ((intervalMs = this.lastUpdateMs - this.intervalStartMs) <= (long)this.rateIntervalMs) {
                return;
            }
            if (this.intervalStartMs == 0L) {
                this.resetRate(this.lastUpdateMs);
                return;
            }
            long vlsnDelta = this.vlsn.getSequence() - this.intervalStart.getSequence();
            if (vlsnDelta < 0L) {
                this.resetRate(this.lastUpdateMs);
            } else {
                this.intervalStart = this.vlsn;
                this.intervalStartMs = this.lastUpdateMs;
                this.vlsnsPerSec = vlsnDelta * 1000L / intervalMs;
            }
        }

        private synchronized VLSN vlsnAt(long timeMs) {
            if (this.vlsn.isNull()) {
                return VLSN.NULL_VLSN;
            }
            long deltaMs = timeMs - this.lastUpdateMs;
            long vlsnAt = this.vlsn.getSequence() + deltaMs * this.vlsnsPerSec / 1000L;
            return vlsnAt < 0L ? new VLSN(0L) : new VLSN(vlsnAt);
        }

        private void resetRate(long now) {
            this.intervalStart = this.vlsn;
            this.intervalStartMs = now;
            this.vlsnsPerSec = 0L;
        }
    }

    private static class ExceptionSummary {
        private int errorCount = 0;
        private Exception exception = null;
        private long exceptionTimeMs = 0L;

        private ExceptionSummary() {
        }

        private void noteException(Exception e) {
            this.exception = e;
            ++this.errorCount;
            this.exceptionTimeMs = System.currentTimeMillis();
        }

        private Exception getException() {
            return this.exception;
        }

        private long getExceptionTimeMs() {
            return this.exceptionTimeMs;
        }

        private int getErrorCount() {
            return this.errorCount;
        }
    }

    private class ReqHandlerRef {
        private final Semaphore semaphore = new Semaphore(1, true);
        private volatile RequestHandlerAPI requestHandler = null;
        private volatile ExceptionSummary exceptionSummary = null;
        private volatile short serialVersion = (short)7;

        private ReqHandlerRef() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset() throws InterruptedException {
            this.semaphore.acquire();
            try {
                this.requestHandler = null;
                this.serialVersion = (short)7;
                this.exceptionSummary = null;
            }
            finally {
                this.semaphore.release();
            }
        }

        private short getSerialVersion() {
            return this.serialVersion;
        }

        private boolean needsResolution() {
            return this.requestHandler == null;
        }

        private boolean needsRepair() {
            return this.exceptionSummary != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RequestHandlerAPI resolve(RegistryUtils registryUtils, long timeoutMs) throws InterruptedException {
            RequestHandlerAPI refNonVloatile = this.requestHandler;
            if (refNonVloatile != null) {
                return refNonVloatile;
            }
            if (!this.semaphore.tryAcquire()) {
                if (!this.semaphore.tryAcquire(timeoutMs, TimeUnit.MILLISECONDS)) {
                    return null;
                }
                boolean needsRepair = true;
                try {
                    needsRepair = this.needsRepair();
                    if (needsRepair) {
                        RequestHandlerAPI requestHandlerAPI = null;
                        return requestHandlerAPI;
                    }
                }
                finally {
                    if (needsRepair) {
                        this.semaphore.release();
                    }
                }
            }
            try {
                RequestHandlerAPI needsRepair;
                if (this.requestHandler != null) {
                    needsRepair = this.requestHandler;
                    return needsRepair;
                }
                this.requestHandler = registryUtils.getRequestHandler(RepNodeState.this.rnId);
                if (this.requestHandler == null) {
                    this.noteExceptionInternal(new IllegalArgumentException(RepNodeState.this.rnId + " not in topology"));
                    needsRepair = null;
                    return needsRepair;
                }
                this.serialVersion = this.requestHandler.getSerialVersion();
                this.exceptionSummary = null;
                needsRepair = this.requestHandler;
                return needsRepair;
            }
            finally {
                this.semaphore.release();
            }
        }

        private RequestHandlerAPI get(RegistryUtils registryUtils, long timeoutMs) throws InterruptedException {
            RequestHandlerAPI refNonVolatile = this.requestHandler;
            if (refNonVolatile != null) {
                return refNonVolatile;
            }
            if (this.exceptionSummary == null) {
                return this.resolve(registryUtils, timeoutMs);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void noteException(Exception e) throws InterruptedException {
            this.semaphore.acquire();
            try {
                this.noteExceptionInternal(e);
            }
            finally {
                this.semaphore.release();
            }
        }

        private void noteExceptionInternal(Exception e) {
            assert (this.semaphore.availablePermits() == 0);
            this.requestHandler = null;
            if (this.exceptionSummary == null) {
                this.exceptionSummary = new ExceptionSummary();
            }
            this.exceptionSummary.noteException(e);
        }
    }

    private static class ResponseTimeAccumulator {
        final short[] samples = new short[8];
        int sumMs = 0;
        int index = 0;

        private ResponseTimeAccumulator() {
        }

        private synchronized void update(int sampleMs) {
            if (sampleMs > Short.MAX_VALUE) {
                sampleMs = Short.MAX_VALUE;
            }
            this.index = ++this.index >= 8 ? 0 : this.index;
            this.sumMs += sampleMs - this.samples[this.index];
            this.samples[this.index] = (short)sampleMs;
        }

        private int getAverage() {
            return this.sumMs / 8;
        }
    }

    private static class AttributeValue<V> {
        final V value;
        final long sequence;

        private AttributeValue(V value, long sequence) {
            this.value = value;
            this.sequence = sequence;
        }

        private V getValue() {
            return this.value;
        }

        private long getSequence() {
            return this.sequence;
        }
    }
}

