/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import oracle.kv.FaultException;
import oracle.kv.UnauthorizedException;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.TableOperationHandler;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.security.AccessCheckUtils;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.security.TablePrivilege;
import oracle.kv.impl.util.UserDataControl;

public abstract class SingleKeyOperation
extends InternalOperation
implements InternalOperation.PrivilegedTableAccessor {
    private final byte[] keyBytes;

    public SingleKeyOperation(InternalOperation.OpCode opCode, byte[] keyBytes) {
        super(opCode);
        this.keyBytes = keyBytes;
    }

    SingleKeyOperation(InternalOperation.OpCode opCode, ObjectInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        short keyLen = in.readShort();
        this.keyBytes = new byte[keyLen];
        in.readFully(this.keyBytes);
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeShort(this.keyBytes.length);
        out.write(this.keyBytes);
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    @Override
    public String toString() {
        return super.toString() + " Key: " + UserDataControl.displayKey(this.keyBytes);
    }

    @Override
    public List<? extends KVStorePrivilege> getRequiredPrivileges() {
        InternalOperation.Keyspace.KeyspaceType keyspace = InternalOperation.Keyspace.identifyKeyspace(this.keyBytes);
        switch (keyspace) {
            case PRIVATE: {
                return SystemPrivilege.internalPrivList;
            }
            case SCHEMA: {
                return this.schemaAccessPrivileges();
            }
            case GENERAL: {
                return SystemPrivilege.usrviewPrivList;
            }
        }
        throw new AssertionError();
    }

    void verifyDataAccess(OperationHandler operationHandler, long tableId) throws FaultException, UnauthorizedException {
        ExecutionContext exeCtx;
        TableImpl accessedTable = null;
        if (tableId != 0L) {
            accessedTable = TableOperationHandler.getAndCheckTable(operationHandler, tableId);
        }
        if ((exeCtx = ExecutionContext.getCurrent()) == null || !InternalOperation.Keyspace.isGeneralAccess(this.keyBytes) || exeCtx.hasAllPrivileges(this.generalAccessPrivileges())) {
            return;
        }
        if (tableId == 0L) {
            accessedTable = TableOperationHandler.findTableByKeyBytes(operationHandler, this.keyBytes);
        }
        if (accessedTable == null) {
            throw new UnauthorizedException("Insufficient access rights granted");
        }
        if (AccessCheckUtils.currentUserOwnsResource(accessedTable)) {
            return;
        }
        if (!exeCtx.hasAllPrivileges(this.tableAccessPrivileges(accessedTable.getId()))) {
            throw new UnauthorizedException("Insufficient access rights granted on table, id: " + accessedTable.getId());
        }
        for (TableImpl parent = (TableImpl)accessedTable.getParent(); parent != null; parent = (TableImpl)parent.getParent()) {
            long pTableId = parent.getId();
            TablePrivilege.ReadTable parentReadPriv = new TablePrivilege.ReadTable(pTableId);
            if (exeCtx.hasPrivilege(parentReadPriv) || exeCtx.hasAllPrivileges(this.tableAccessPrivileges(pTableId))) continue;
            throw new UnauthorizedException("Insufficient access rights on parent table, id: " + pTableId);
        }
    }

    abstract List<? extends KVStorePrivilege> schemaAccessPrivileges();

    abstract List<? extends KVStorePrivilege> generalAccessPrivileges();
}

