/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.kv.impl.util.FastExternalizable;

public class ResultIndexKeys
implements FastExternalizable {
    private final byte[] primaryKeyBytes;
    private final byte[] indexKeyBytes;

    public ResultIndexKeys(byte[] primaryKeyBytes, byte[] indexKeyBytes) {
        this.primaryKeyBytes = primaryKeyBytes;
        this.indexKeyBytes = indexKeyBytes;
    }

    public ResultIndexKeys(ObjectInput in, short serialVersion) throws IOException {
        short keyLen = in.readShort();
        this.primaryKeyBytes = new byte[keyLen];
        in.readFully(this.primaryKeyBytes);
        keyLen = in.readShort();
        this.indexKeyBytes = new byte[keyLen];
        in.readFully(this.indexKeyBytes);
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        out.writeShort(this.primaryKeyBytes.length);
        out.write(this.primaryKeyBytes);
        out.writeShort(this.indexKeyBytes.length);
        out.write(this.indexKeyBytes);
    }

    public byte[] getPrimaryKeyBytes() {
        return this.primaryKeyBytes;
    }

    public byte[] getIndexKeyBytes() {
        return this.indexKeyBytes;
    }
}

