/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.lob;

import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Key;
import oracle.kv.ValueVersion;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.lob.ChunkEncapsulatingInputStream;
import oracle.kv.impl.api.lob.ReadOperation;
import oracle.kv.lob.InputStreamVersion;
import oracle.kv.lob.KVLargeObject;

public class GetOperation
extends ReadOperation {
    GetOperation(KVStoreImpl kvsImpl, Key appLobKey, Consistency consistency, long chunkTimeout, TimeUnit timeoutUnit) {
        super(kvsImpl, appLobKey, consistency, chunkTimeout, timeoutUnit);
    }

    InputStreamVersion execute() {
        ValueVersion appValueVersion = this.kvsImpl.get(this.appLOBKey, this.consistency, this.chunkTimeoutMs, TimeUnit.MILLISECONDS);
        if (appValueVersion == null) {
            return null;
        }
        this.internalLOBKey = GetOperation.valueToILK(appValueVersion.getValue());
        ValueVersion metadataVV = this.initMetadata(KVLargeObject.LOBState.COMPLETE);
        long lastSuperChunkId = this.lobProps.getLastSuperChunkId();
        if (lastSuperChunkId > 1L && this.consistency instanceof Consistency.Version) {
            String msg = "Version consistency cannot be used to read a LOB striped across more than one partition. This LOB is striped across " + lastSuperChunkId + "partitions. Use a different consistency policy";
            throw new IllegalArgumentException(msg);
        }
        ChunkEncapsulatingInputStream inputStream = new ChunkEncapsulatingInputStream(this, metadataVV.getVersion());
        return new InputStreamVersion(inputStream, appValueVersion.getVersion());
    }
}

