/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.lob;

import java.io.IOException;
import java.io.InputStream;
import java.util.ConcurrentModificationException;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Durability;
import oracle.kv.Key;
import oracle.kv.ValueVersion;
import oracle.kv.Version;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.lob.WriteOperation;
import oracle.kv.impl.util.UserDataControl;
import oracle.kv.lob.KVLargeObject;

public class AppendOperation
extends WriteOperation {
    AppendOperation(KVStoreImpl kvsImpl, Key appLobKey, InputStream lobAppendStream, Durability durability, long chunkTimeout, TimeUnit timeoutUnit) {
        super(kvsImpl, appLobKey, lobAppendStream, durability, chunkTimeout, timeoutUnit);
    }

    Version execute() throws IOException {
        ValueVersion lastChunkVV;
        ValueVersion appValueVersion = this.kvsImpl.get(this.appLOBKey, Consistency.ABSOLUTE, this.chunkTimeoutMs, TimeUnit.MILLISECONDS);
        if (appValueVersion == null) {
            throw new IllegalArgumentException("LOB not present. Key:" + this.appLOBKey + "The key/value pair must be created " + "using putLOB() before invoking appendLOB(). ");
        }
        this.internalLOBKey = AppendOperation.valueToILK(appValueVersion.getValue());
        ValueVersion metadataVV = this.initMetadata(KVLargeObject.LOBState.PARTIAL_APPEND);
        if (this.lobProps.getVersion() == 1) {
            String msg = "appendLOB is only supported for LOBs created by KVS version 2.1.55 or later.";
            throw new UnsupportedOperationException(msg);
        }
        Version mdVersion = metadataVV.getVersion();
        if (this.lobProps.isPartiallyAppended()) {
            lastChunkVV = this.setupForResume(mdVersion);
        } else {
            lastChunkVV = this.getLastChunk();
            this.lobProps.startAppend();
            mdVersion = this.updateMetadata(mdVersion);
        }
        byte[] prefixChunk = lastChunkVV == null || lastChunkVV.getValue().getValue().length == this.chunkSize ? null : lastChunkVV.getValue().getValue();
        mdVersion = this.putChunks(this.lobSize, prefixChunk, mdVersion);
        this.lobProps.endAppend();
        this.updateMetadata(mdVersion);
        Version appLobVersion = this.kvsImpl.putIfVersion(this.appLOBKey, appValueVersion.getValue(), appValueVersion.getVersion(), null, CHUNK_DURABILITY, this.chunkTimeoutMs, TimeUnit.MILLISECONDS);
        if (appLobVersion == null) {
            String msg = "Concurrent LOB operation detected for key: " + UserDataControl.displayKey(this.appLOBKey) + " Internal LOB key:" + this.internalLOBKey;
            throw new ConcurrentModificationException(msg);
        }
        return appLobVersion;
    }

    @Override
    protected long positionLobStream(long chunkStreamPos) throws IOException {
        long bytesSkipped;
        long appendStartPos = this.lobProps.getAppendLobSize();
        long lobStreamPos = chunkStreamPos - appendStartPos;
        if (lobStreamPos != (bytesSkipped = AppendOperation.skipInput(this.lobStream, lobStreamPos))) {
            throw new IllegalArgumentException("The LOB input stream did not skip the requested number of bytes. Bytes skipped:" + bytesSkipped + " Requested:" + lobStreamPos + " absolute lob pos:" + chunkStreamPos + " append start pos:" + appendStartPos);
        }
        return lobStreamPos;
    }

    @Override
    protected long getVerificationByteCount() {
        long verificationByteCount = super.getVerificationByteCount();
        long appendStartPos = this.lobProps.getAppendLobSize();
        long availVerificationBytes = this.lobSize - appendStartPos;
        return Math.min(availVerificationBytes, verificationByteCount);
    }
}

