/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.avro;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.kv.Consistency;
import oracle.kv.KVStore;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.AdminService;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.api.avro.AvroSchemaMetadata;
import oracle.kv.impl.api.avro.SchemaAccessor;
import oracle.kv.impl.api.avro.SchemaChecker;
import oracle.kv.impl.api.avro.SchemaData;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.util.Pair;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;

public class AvroDdl {
    private static final String eol = System.getProperty("line.separator");
    private final SchemaAccessor accessor;

    public static <T> T execute(final AdminService aservice, final Command<T> cmd) {
        return (T)aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<T>(){

            @Override
            public T execute() {
                KVStore store = aservice.getAdmin().openKVStore();
                boolean noException = false;
                try {
                    Object result = cmd.execute(new AvroDdl(store));
                    noException = true;
                    Object t = result;
                    return t;
                }
                catch (IllegalCommandException e) {
                    throw e;
                }
                catch (NonfatalAssertionException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw new NonfatalAssertionException("Unexpected exception during schema command: " + e.toString(), e);
                }
                finally {
                    block11: {
                        try {
                            store.close();
                        }
                        catch (RuntimeException e) {
                            if (!noException) break block11;
                            throw new NonfatalAssertionException("Exception closing KVStore after successful schema command", e);
                        }
                    }
                }
            }
        });
    }

    public AvroDdl(KVStore store) {
        this.accessor = new SchemaAccessor(store);
    }

    public SortedMap<String, SchemaSummary> getSchemaSummaries(boolean includeDisabled) {
        TreeMap<String, SchemaSummary> results = new TreeMap<String, SchemaSummary>();
        SortedMap<Integer, SchemaData> schemas = this.accessor.readAllSchemas(includeDisabled, Consistency.ABSOLUTE);
        for (Map.Entry<Integer, SchemaData> entry : schemas.entrySet()) {
            Integer id = entry.getKey();
            SchemaData data = entry.getValue();
            String name = data.getSchema().getFullName();
            SchemaSummary prevVersion = (SchemaSummary)results.get(name);
            SchemaSummary summary = new SchemaSummary(data.getMetadata(), name, id, prevVersion);
            results.put(name, summary);
        }
        return results;
    }

    public SchemaDetails getSchemaDetails(int schemaId) {
        SchemaData data;
        try {
            data = this.accessor.readSchema(schemaId, Consistency.ABSOLUTE);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalCommandException(e.getMessage(), e);
        }
        Schema schema = data.getSchema();
        String text = schema.toString(true);
        return new SchemaDetails(data.getMetadata(), schema.getFullName(), schemaId, text);
    }

    public boolean updateSchemaStatus(int schemaId, AvroSchemaMetadata metadata, KVVersion version) {
        try {
            return this.accessor.updateSchemaStatus(schemaId, metadata, version);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalCommandException(e.getMessage(), e);
        }
    }

    public AddSchemaResult addSchema(AvroSchemaMetadata metadata, String schemaText, AddSchemaOptions options, KVVersion version) {
        Schema newSchema;
        try {
            newSchema = new Schema.Parser().parse(schemaText);
        }
        catch (SchemaParseException e) {
            throw new IllegalCommandException(e.getMessage(), e);
        }
        String name = newSchema.getFullName();
        if (newSchema.getType() != Schema.Type.RECORD) {
            throw new IllegalCommandException("Top level schema is not a 'record': " + name);
        }
        SortedMap<Integer, SchemaData> allSchemas = this.accessor.readAllSchemas(false, Consistency.ABSOLUTE);
        TreeMap<Integer, Schema> oldSchemas = new TreeMap<Integer, Schema>();
        for (Map.Entry<Integer, SchemaData> entry : allSchemas.entrySet()) {
            Schema schema = entry.getValue().getSchema();
            if (!name.equals(schema.getFullName())) continue;
            oldSchemas.put(entry.getKey(), schema);
        }
        if (options.getEvolve()) {
            if (oldSchemas.size() == 0) {
                throw new IllegalCommandException("Cannot change schema, does not exist: " + name);
            }
        } else if (oldSchemas.size() != 0) {
            throw new IllegalCommandException("Cannot add schema, already exists: " + name);
        }
        int nErrors = 0;
        int nWarnings = 0;
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> warnings = new ArrayList<String>();
        SchemaChecker.checkSchema(newSchema, errors, warnings);
        nErrors += errors.size();
        nWarnings += warnings.size();
        Pair<List<String>, List<String>> newSchemaErrorsAndWarnings = new Pair<List<String>, List<String>>(errors, warnings);
        TreeMap<Integer, Pair<List<String>, List<String>>> evolutionErrorsAndWarnings = new TreeMap<Integer, Pair<List<String>, List<String>>>();
        for (Map.Entry entry : oldSchemas.entrySet()) {
            Schema oldSchema = (Schema)entry.getValue();
            errors = new ArrayList();
            warnings = new ArrayList();
            SchemaChecker.checkEvolution(oldSchema, newSchema, errors, warnings);
            nErrors += errors.size();
            nWarnings += warnings.size();
            if (errors.size() <= 0 && warnings.size() <= 0) continue;
            Integer oldVersion = (Integer)entry.getKey();
            evolutionErrorsAndWarnings.put(oldVersion, new Pair<ArrayList<String>, ArrayList<String>>(errors, warnings));
        }
        if (nErrors > 0 || nWarnings > 0 && !options.getForce()) {
            String msg = this.formatErrorsAndWarnings(newSchema.getFullName(), nErrors, nWarnings, newSchemaErrorsAndWarnings, evolutionErrorsAndWarnings);
            throw new IllegalCommandException(msg);
        }
        SchemaData data = new SchemaData(metadata, newSchema);
        int newId = this.accessor.insertSchema(data, version);
        StringBuilder extraMsg = new StringBuilder(100);
        if (nErrors > 0 || nWarnings > 0) {
            this.appendErrorsAndWarningsSummary(extraMsg, nErrors, nWarnings, "was", "were");
            extraMsg.append(" ignored.");
        }
        return new AddSchemaResult(newId, extraMsg.toString());
    }

    private String formatErrorsAndWarnings(String schemaName, int nTotalErrors, int nTotalWarnings, Pair<List<String>, List<String>> newSchemaErrorsAndWarnings, SortedMap<Integer, Pair<List<String>, List<String>>> evolutionErrorsAndWarnings) {
        StringBuilder b = new StringBuilder(1000);
        b.append("Schema was not added because ");
        this.appendErrorsAndWarningsSummary(b, nTotalErrors, nTotalWarnings, "was", "were");
        b.append(" detected.");
        b.append(eol);
        if (nTotalWarnings > 0) {
            b.append("To override warnings, specify -force.");
        }
        if (nTotalErrors > 0) {
            if (nTotalWarnings > 0) {
                b.append(' ');
            }
            b.append("Errors cannot be overridden with -force.");
        }
        b.append(eol);
        if (newSchemaErrorsAndWarnings.first().size() > 0 || newSchemaErrorsAndWarnings.second().size() > 0) {
            b.append(eol);
            b.append("The following ");
            this.appendErrorsAndWarningsSummary(b, newSchemaErrorsAndWarnings.first().size(), newSchemaErrorsAndWarnings.second().size(), "applies", "apply");
            b.append(" to the new schema being added.");
            b.append(eol).append(eol);
            this.appendErrorsAndWarnings(b, newSchemaErrorsAndWarnings.first(), newSchemaErrorsAndWarnings.second());
        }
        for (Map.Entry<Integer, Pair<List<String>, List<String>>> entry : evolutionErrorsAndWarnings.entrySet()) {
            String oldName = schemaName + "." + entry.getKey();
            Pair<List<String>, List<String>> errorsAndWarnings = entry.getValue();
            b.append(eol);
            b.append("The following ");
            this.appendErrorsAndWarningsSummary(b, errorsAndWarnings.first().size(), errorsAndWarnings.second().size(), "applies", "apply");
            b.append(" to evolution from ");
            b.append(eol);
            b.append(oldName).append(" to the schema being added.");
            b.append(eol).append(eol);
            this.appendErrorsAndWarnings(b, errorsAndWarnings.first(), errorsAndWarnings.second());
        }
        return b.toString();
    }

    private void appendErrorsAndWarningsSummary(StringBuilder b, int nErrors, int nWarnings, String singularSuffix, String pluralSuffix) {
        if (nErrors > 0) {
            b.append(nErrors).append(" error");
            if (nErrors > 1) {
                b.append('s');
            }
            if (nWarnings > 0) {
                b.append(" and ");
            }
        }
        if (nWarnings > 0) {
            b.append(nWarnings).append(" warning");
            if (nWarnings > 1) {
                b.append('s');
            }
        }
        b.append(' ');
        if (nErrors > 1 || nWarnings > 1 || nErrors > 0 && nWarnings > 0) {
            b.append(pluralSuffix);
        } else {
            b.append(singularSuffix);
        }
    }

    private void appendErrorsAndWarnings(StringBuilder b, List<String> errors, List<String> warnings) {
        for (String error : errors) {
            b.append("ERROR: ").append(error).append(eol);
        }
        for (String warning : warnings) {
            b.append("WARNING: ").append(warning).append(eol);
        }
    }

    public void deleteAllSchemas() {
        this.accessor.deleteAllSchemas();
    }

    public static interface Command<T> {
        public T execute(AvroDdl var1);
    }

    public static class AddSchemaResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int id;
        private final String extraMsg;

        AddSchemaResult(int id, String extraMsg) {
            this.id = id;
            this.extraMsg = extraMsg;
        }

        public int getId() {
            return this.id;
        }

        public String getExtraMessage() {
            return this.extraMsg;
        }
    }

    public static class AddSchemaOptions
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean evolve;
        private final boolean force;

        public AddSchemaOptions(boolean evolve, boolean force) {
            this.evolve = evolve;
            this.force = force;
        }

        public boolean getEvolve() {
            return this.evolve;
        }

        public boolean getForce() {
            return this.force;
        }
    }

    public static class SchemaDetails
    extends BaseSchemaSummary {
        private static final long serialVersionUID = 1L;
        private final String text;

        SchemaDetails(AvroSchemaMetadata metadata, String name, int id, String text) {
            super(metadata, name, id);
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    public static class SchemaSummary
    extends BaseSchemaSummary {
        private static final long serialVersionUID = 1L;
        private final SchemaSummary prevVersion;

        SchemaSummary(AvroSchemaMetadata metadata, String name, int id, SchemaSummary prevVersion) {
            super(metadata, name, id);
            this.prevVersion = prevVersion;
        }

        public SchemaSummary getPreviousVersion() {
            return this.prevVersion;
        }
    }

    static class BaseSchemaSummary
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final AvroSchemaMetadata metadata;
        private final String name;
        private final int id;

        BaseSchemaSummary(AvroSchemaMetadata metadata, String name, int id) {
            this.metadata = metadata;
            this.name = name;
            this.id = id;
        }

        public AvroSchemaMetadata getMetadata() {
            return this.metadata;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }
    }
}

