/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.change.TopologyChange;

public class TopologyInfo
implements MetadataInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long topoId;
    private final int respSeqNum;
    private final List<TopologyChange> changes;
    private final byte[] topoSignature;
    public static TopologyInfo EMPTY_TOPO_INFO = new TopologyInfo(-1L, 0, null, null);

    public TopologyInfo(Topology topo, List<TopologyChange> changes) {
        this(topo.getId(), topo.getSequenceNumber(), changes, topo.getSignature());
    }

    public TopologyInfo(long topoId, int respSeqNum, List<TopologyChange> changes, byte[] topoSignature) {
        this.topoId = topoId;
        this.respSeqNum = respSeqNum;
        this.changes = changes;
        this.topoSignature = topoSignature;
    }

    @Override
    public Metadata.MetadataType getType() {
        return Metadata.MetadataType.TOPOLOGY;
    }

    @Override
    public int getSourceSeqNum() {
        return this.respSeqNum;
    }

    @Override
    public boolean isEmpty() {
        return this.changes == null || this.changes.isEmpty();
    }

    public long getTopoId() {
        return this.topoId;
    }

    public byte[] getTopoSignature() {
        if (this.topoSignature == null) {
            return null;
        }
        return Arrays.copyOf(this.topoSignature, this.topoSignature.length);
    }

    public List<TopologyChange> getChanges() {
        return this.changes;
    }
}

