/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.rep.DatabasePreemptedException;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.StateChangeEvent;
import com.sleepycat.je.rep.StateChangeListener;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.utilint.VLSN;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.Consistency;
import oracle.kv.FaultException;
import oracle.kv.KVSecurityException;
import oracle.kv.RequestTimeoutException;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.RequestDispatcher;
import oracle.kv.impl.api.RequestHandler;
import oracle.kv.impl.api.Response;
import oracle.kv.impl.api.StatusChanges;
import oracle.kv.impl.api.TopologyInfo;
import oracle.kv.impl.api.TopologyManager;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.rgstate.RepGroupState;
import oracle.kv.impl.api.rgstate.RepGroupStateTable;
import oracle.kv.impl.api.rgstate.RepNodeState;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.fault.RNUnavailableException;
import oracle.kv.impl.rep.IncorrectRoutingException;
import oracle.kv.impl.rep.OperationsStatsTracker;
import oracle.kv.impl.rep.RepEnvHandleManager;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.security.AccessChecker;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.OperationContext;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.test.TestHook;
import oracle.kv.impl.test.TestHookExecute;
import oracle.kv.impl.topo.Partition;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ConsistencyTranslator;
import oracle.kv.impl.util.DurabilityTranslator;
import oracle.kv.impl.util.PollCondition;
import oracle.kv.impl.util.RateLimitingLogger;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RMISocketPolicy;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.impl.util.registry.VersionedRemoteImpl;
import oracle.kv.impl.util.server.LoggerUtils;

public class RequestHandlerImpl
extends VersionedRemoteImpl
implements RequestHandler {
    private static final int LOCK_CONFLICT_RETRY_NS = 100000000;
    private static final int ENV_RESTART_RETRY_NS = 100000000;
    private static final int LIMIT_FAULTS = 20;
    private static final int ONE_MINUTE_MS = 60000;
    private static final List<KVStorePrivilege> emptyPrivilegeList = Collections.emptyList();
    private RepNodeService.Params params;
    private RepNode repNode;
    private RepNodeId repNodeId;
    private final AtomicInteger activeRequests = new AtomicInteger(0);
    private OperationHandler operationHandler;
    private final RequestDispatcher requestDispatcher;
    private final TopologyManager topoManager;
    private final RepGroupStateTable stateTable;
    private volatile StateChangeEvent stateChangeEvent;
    private final Map<ResourceId, StateChangeEvent> requesterMap;
    private OperationsStatsTracker opTracker;
    private int requestQuiesceMs;
    private static final int REQUEST_QUIESCE_POLL_MS = 100;
    private final ProcessFaultHandler faultHandler;
    private TestHook<Request> requestExecute;
    private TestHook<Request> requestNOPExecute;
    private final AccessChecker accessChecker;
    private TestHook<RepImpl> preCommitTestHook;
    private final LogMessageAbbrev logAbbrev;
    private Logger logger = null;
    private RateLimitingLogger<String> rateLimitingLogger;

    public RequestHandlerImpl(RequestDispatcher requestDispatcher, ProcessFaultHandler faultHandler, AccessChecker accessChecker) {
        this.requestDispatcher = requestDispatcher;
        this.faultHandler = faultHandler;
        this.topoManager = requestDispatcher.getTopologyManager();
        this.accessChecker = accessChecker;
        this.stateTable = requestDispatcher.getRepGroupStateTable();
        this.requesterMap = new ConcurrentHashMap<ResourceId, StateChangeEvent>();
        this.logAbbrev = new LogMessageAbbrev();
    }

    public void initialize(RepNodeService.Params params, RepNode repNode, OperationsStatsTracker opStatsTracker) {
        this.params = params;
        this.repNode = repNode;
        this.opTracker = opStatsTracker;
        this.repNodeId = repNode.getRepNodeId();
        this.operationHandler = new OperationHandler(repNode, params);
        this.requestQuiesceMs = params.getRepNodeParams().getRequestQuiesceMs();
        this.logger = LoggerUtils.getLogger(this.getClass(), params);
        this.rateLimitingLogger = new RateLimitingLogger(60000, 20, this.logger);
    }

    public RepNode getRepNode() {
        return this.repNode;
    }

    public RequestDispatcher getRequestDispatcher() {
        return this.requestDispatcher;
    }

    public RepEnvHandleManager.StateChangeListenerFactory getListenerFactory() {
        return new RepEnvHandleManager.StateChangeListenerFactory(){

            @Override
            public StateChangeListener create(ReplicatedEnvironment repEnv) {
                return new Listener(repEnv);
            }
        };
    }

    public void setTestHook(TestHook<Request> hook) {
        this.requestExecute = hook;
    }

    public void setTestNOPHook(TestHook<Request> hook) {
        this.requestNOPExecute = hook;
    }

    public void setPreCommitTestHook(TestHook<RepImpl> hook) {
        this.preCommitTestHook = hook;
    }

    @Override
    public Response execute(final Request request) throws FaultException, RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Response>(){

            @Override
            public Response execute() {
                ExecutionContext execCtx = RequestHandlerImpl.this.checkSecurity(request);
                if (execCtx == null) {
                    return RequestHandlerImpl.this.executeRequest(request);
                }
                return ExecutionContext.runWithContext(new ExecutionContext.SimpleOperation<Response>(){

                    @Override
                    public Response run() {
                        return RequestHandlerImpl.this.executeRequest(request);
                    }
                }, execCtx);
            }
        });
    }

    private ExecutionContext checkSecurity(Request request) throws SessionAccessException, KVSecurityException {
        if (this.accessChecker == null) {
            return null;
        }
        RequestContext reqCtx = new RequestContext(request);
        return ExecutionContext.create(this.accessChecker, request.getAuthContext(), reqCtx);
    }

    private Response executeRequest(Request request) {
        this.activeRequests.incrementAndGet();
        try {
            InternalOperation.OpCode opCode = request.getOperation().getOpCode();
            if (InternalOperation.OpCode.NOP.equals((Object)opCode)) {
                Response response = this.executeNOPInternal(request);
                return response;
            }
            if (this.topoManager.getTopology() != null) {
                Response response = this.executeInternal(request);
                return response;
            }
            try {
                String message = "awaiting topology push";
                throw new RNUnavailableException("awaiting topology push");
            }
            catch (ThreadInterruptedException tie) {
                String message = "RN: " + this.repNodeId + " was interrupted.";
                this.logger.info(message);
                throw new RNUnavailableException(message);
            }
        }
        finally {
            this.activeRequests.decrementAndGet();
        }
    }

    /*
     * Exception decompiling
     */
    private Response executeInternal(Request request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 47[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Response handleRuntimeException(ReplicatedEnvironment repEnv, Transaction txn, Request request, RuntimeException re) throws RNUnavailableException {
        if (repEnv == null || repEnv.isValid()) {
            if (re instanceof IllegalStateException) {
                Response resp = this.forwardIfRequired(request);
                if (resp != null) {
                    this.logger.log(Level.INFO, "Request forwarded due to ISE: {0}", re.getMessage());
                    return resp;
                }
                if (this.notCommitted(txn)) {
                    String msg = "ISE:" + re.getMessage() + " Retry at some different RN.";
                    this.logger.info(msg);
                    throw new RNUnavailableException(msg);
                }
            }
            this.logger.log(Level.SEVERE, "unexpected exception", re);
            throw re;
        }
        this.logAbbrev.log(Level.INFO, "Ignoring exception and retrying at this RN, environment has been closed or invalidated", (Environment)repEnv, re);
        return null;
    }

    private boolean notCommitted(Transaction txn) {
        return txn == null || txn.getState() != Transaction.State.COMMITTED && txn.getState() != Transaction.State.POSSIBLY_COMMITTED;
    }

    private Response executeNOPInternal(Request request) throws RequestTimeoutException {
        assert (TestHookExecute.doHookIfSet(this.requestNOPExecute, request));
        ReplicatedEnvironment repEnv = this.repNode.getEnv(request.getTimeout());
        if (repEnv == null) {
            throw new RequestTimeoutException(request.getTimeout(), "Timed out trying to obtain environment handle.", null, true);
        }
        Result result = request.getOperation().execute(null, null, null);
        return this.createResponse(repEnv, request, result);
    }

    private Response handleException(Request request, RuntimeException re) {
        assert (re instanceof DatabasePreemptedException || re instanceof IncorrectRoutingException);
        if (request.getPartitionId().isNull()) {
            throw re;
        }
        Topology topology = this.topoManager.getLocalTopology();
        Partition partition = topology.get(request.getPartitionId());
        if (topology.getSequenceNumber() > request.getTopoSeqNumber() && !partition.getRepGroupId().sameGroup(this.repNode.getRepNodeId())) {
            request.clearForwardingRNs();
            return this.forward(request, partition.getRepGroupId().getGroupId());
        }
        throw new RNUnavailableException("Partition database is missing for partition: " + partition.getResourceId());
    }

    private Response forwardIfRequired(Request request) {
        RepGroupId repGroupId = request.getRepGroupId();
        if (repGroupId.isNull()) {
            PartitionId partitionId = request.getPartitionId();
            RepGroupId repGroupId2 = repGroupId = partitionId.isNull() ? new RepGroupId(this.repNodeId.getGroupId()) : this.topoManager.getLocalTopology().getRepGroupId(partitionId);
        }
        if (repGroupId.getGroupId() != this.repNodeId.getGroupId()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("RN does not contain group: " + repGroupId + ", forwarding request.");
            }
            request.clearForwardingRNs();
            return this.forward(request, repGroupId.getGroupId());
        }
        RepGroupState rgState = this.stateTable.getGroupState(repGroupId);
        RepNodeState master = rgState.getMaster();
        if (request.needsMaster()) {
            if (master != null && this.repNodeId.equals(master.getRepNodeId())) {
                return null;
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("RN is not master, forwarding request. Last known master is: " + (master != null ? master.getRepNodeId() : "unknown"));
            }
            return this.forward(request, this.repNodeId.getGroupId());
        }
        if (request.needsReplica()) {
            ReplicatedEnvironment.State rnState = rgState.get(this.repNodeId).getRepState();
            if (master != null && this.repNodeId.equals(master.getRepNodeId())) {
                rnState = ReplicatedEnvironment.State.MASTER;
            } else if (rnState.isReplica() || rnState.isUnknown()) {
                return null;
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("With requested consistency policy, RepNode cannot be MASTER or DETACHED, but RepNode [" + this.repNodeId + "] is " + (Object)((Object)rnState) + ". Forward the " + "request.");
            }
            return this.forward(request, this.repNodeId.getGroupId());
        }
        return null;
    }

    private TopologyInfo getTopologyInfo(int reqTopoSeqNum) {
        Topology topology = this.topoManager.getTopology();
        if (topology == null) {
            return TopologyInfo.EMPTY_TOPO_INFO;
        }
        int topoSeqNum = topology.getSequenceNumber();
        if (topoSeqNum == reqTopoSeqNum) {
            return null;
        }
        return topology.getChangeInfo(reqTopoSeqNum + 1);
    }

    private Response createResponse(ReplicatedEnvironment repEnv, Request request, Result result) {
        RepImpl repImpl;
        StatusChanges statusChanges = this.getStatusChanges(request.getInitialDispatcherId());
        VLSN currentVLSN = VLSN.NULL_VLSN;
        if (repEnv.isValid() && (repImpl = RepInternal.getRepImpl((ReplicatedEnvironment)repEnv)) != null) {
            currentVLSN = repImpl.getVLSNIndex().getRange().getLast();
        }
        return new Response(this.repNodeId, currentVLSN, result, this.getTopologyInfo(request.getTopoSeqNumber()), statusChanges, request.getSerialVersion());
    }

    private void sleepBeforeRetry(Request request, OperationFailureException exception, long sleepNs, long limitNs) throws RequestTimeoutException {
        if (System.nanoTime() + sleepNs > limitNs) {
            String message = "Request handler: " + this.repNodeId + " Request: " + request.getOperation() + " timeout: " + request.getTimeout() + "ms. exceeded." + (exception != null ? " Last retried exception: " + ((Object)((Object)exception)).getClass().getName() + " Message: " + exception.getMessage() : "");
            throw new RequestTimeoutException(request.getTimeout(), message, (Exception)((Object)exception), true);
        }
        if (sleepNs == 0L) {
            return;
        }
        try {
            Thread.sleep(TimeUnit.NANOSECONDS.toMillis(sleepNs));
        }
        catch (InterruptedException ie) {
            throw new IllegalStateException("unexpected interrupt", ie);
        }
    }

    private Response forward(Request request, int repGroupId) {
        Set<RepNodeId> excludeRN = null;
        if (this.repNodeId.getGroupId() == repGroupId) {
            excludeRN = request.getForwardingRNs(repGroupId);
            excludeRN.add(this.repNodeId);
        }
        short requestSerialVersion = request.getSerialVersion();
        int topoSeqNumber = request.getTopoSeqNumber();
        request.setTopoSeqNumber(this.topoManager.getTopology().getSequenceNumber());
        Response response = this.requestDispatcher.execute(request, excludeRN, null);
        return this.updateForwardedResponse(requestSerialVersion, topoSeqNumber, response);
    }

    private Response updateForwardedResponse(short requestSerialVersion, int reqTopoSeqNum, Response response) {
        response.setSerialVersion(requestSerialVersion);
        response.setTopoInfo(this.getTopologyInfo(reqTopoSeqNum));
        return response;
    }

    private TransactionConfig setupTxnConfig(Request request) {
        TransactionConfig txnConfig = new TransactionConfig();
        if (request.isWrite()) {
            Durability haDurability = DurabilityTranslator.translate(request.getDurability());
            txnConfig.setDurability(haDurability);
            return txnConfig;
        }
        txnConfig.setDurability(Durability.READ_ONLY_TXN);
        Consistency reqConsistency = request.getConsistency();
        NoConsistencyRequiredPolicy haConsistency = Consistency.ABSOLUTE.equals(reqConsistency) ? NoConsistencyRequiredPolicy.NO_CONSISTENCY : ConsistencyTranslator.translate(reqConsistency);
        txnConfig.setConsistencyPolicy((ReplicaConsistencyPolicy)haConsistency);
        return txnConfig;
    }

    public void startup() throws RemoteException {
        StorageNodeParams snParams = this.params.getStorageNodeParams();
        GlobalParams globalParams = this.params.getGlobalParams();
        RepNodeParams repNodeParams = this.params.getRepNodeParams();
        String kvStoreName = globalParams.getKVStoreName();
        String csfName = ClientSocketFactory.factoryName(kvStoreName, RepNodeId.getPrefix(), RegistryUtils.InterfaceType.MAIN.interfaceName());
        RMISocketPolicy rmiPolicy = this.params.getSecurityParams().getRMISocketPolicy();
        RMISocketPolicy.SocketFactoryPair sfp = repNodeParams.getRHSFP(rmiPolicy, snParams.getServicePortRange(), csfName, kvStoreName);
        RegistryUtils.rebind(snParams.getHostname(), snParams.getRegistryPort(), kvStoreName, this.repNode.getRepNodeId().getFullName(), RegistryUtils.InterfaceType.MAIN, this, sfp.getClientFactory(), sfp.getServerFactory());
    }

    public void stop() {
        StorageNodeParams snParams = this.params.getStorageNodeParams();
        GlobalParams globalParams = this.params.getGlobalParams();
        try {
            RegistryUtils.unbind(snParams.getHostname(), snParams.getRegistryPort(), globalParams.getKVStoreName(), this.repNode.getRepNodeId().getFullName(), RegistryUtils.InterfaceType.MAIN, this);
        }
        catch (RemoteException e) {
            this.logger.log(Level.INFO, "Ignoring exception while stopping request handler", e);
            return;
        }
        new PollCondition(100, this.requestQuiesceMs){

            @Override
            protected boolean condition() {
                return RequestHandlerImpl.this.activeRequests.get() == 0;
            }
        }.await();
        int activeRequestCount = this.activeRequests.get();
        if (activeRequestCount > 0) {
            this.logger.info("Requested quiesce period: " + this.requestQuiesceMs + "ms was insufficient to quiesce all active " + "requests for soft shutdown. " + "Pending active requests: " + activeRequestCount);
        }
        this.requestDispatcher.shutdown(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusChanges getStatusChanges(ResourceId resourceId) {
        if (this.stateChangeEvent == null) {
            return null;
        }
        if (this.requesterMap.get(resourceId) == this.stateChangeEvent) {
            return null;
        }
        try {
            ReplicatedEnvironment.State state = this.stateChangeEvent.getState();
            if (state.isMaster() || state.isReplica()) {
                String masterName = this.stateChangeEvent.getMasterNodeName();
                StatusChanges statusChanges = new StatusChanges(state, RepNodeId.parse(masterName), this.stateChangeEvent.getEventTime());
                return statusChanges;
            }
            StatusChanges statusChanges = new StatusChanges(state, null, 0L);
            return statusChanges;
        }
        finally {
            this.requesterMap.put(resourceId, this.stateChangeEvent);
        }
    }

    LogMessageAbbrev getMessageAbbrev() {
        return this.logAbbrev;
    }

    private class RequestContext
    implements OperationContext {
        private final Request request;

        private RequestContext(Request request) {
            this.request = request;
        }

        @Override
        public String describe() {
            return "API request: " + this.request.getOperation().toString();
        }

        @Override
        public List<? extends KVStorePrivilege> getRequiredPrivileges() {
            InternalOperation.OpCode opCode = this.request.getOperation().getOpCode();
            if (InternalOperation.OpCode.NOP.equals((Object)opCode)) {
                return emptyPrivilegeList;
            }
            return this.request.getOperation().getRequiredPrivileges();
        }
    }

    private class ForwardException
    extends Exception {
        private ForwardException() {
        }
    }

    class LogMessageAbbrev {
        private final AtomicReference<Environment> lastEnv = new AtomicReference();
        volatile int abbrevCount = 0;
        volatile int fullCount = 0;

        LogMessageAbbrev() {
        }

        private void log(Level level, String logMessage, Environment env, RuntimeException exception) {
            if (env != null && this.lastEnv.getAndSet(env) != env) {
                RequestHandlerImpl.this.logger.log(level, logMessage, exception);
                ++this.fullCount;
            } else {
                StackTraceElement[] traces = exception.getStackTrace();
                RequestHandlerImpl.this.logger.log(level, logMessage + " Exception:" + exception.getClass().getName() + ", Message:" + exception.getMessage() + ", Method:" + (traces == null || traces.length == 0 ? "unknown" : exception.getStackTrace()[0]));
                ++this.abbrevCount;
            }
        }
    }

    private class Listener
    implements StateChangeListener {
        final ReplicatedEnvironment repEnv;

        public Listener(ReplicatedEnvironment repEnv) {
            this.repEnv = repEnv;
        }

        public void stateChange(StateChangeEvent sce) throws RuntimeException {
            RequestHandlerImpl.this.stateChangeEvent = sce;
            ReplicatedEnvironment.State state = sce.getState();
            RequestHandlerImpl.this.logger.info("State change event: " + new Date(sce.getEventTime()) + ", State: " + (Object)((Object)state) + ", Master: " + (state.isMaster() || state.isReplica() ? sce.getMasterNodeName() : "none"));
            RequestHandlerImpl.this.requesterMap.clear();
            RequestHandlerImpl.this.stateTable.update(sce);
            if (RequestHandlerImpl.this.repNode != null) {
                RequestHandlerImpl.this.repNode.noteStateChange(this.repEnv, sce);
            }
        }
    }
}

