/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import com.sleepycat.je.utilint.PropUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.Consistency;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.Durability;
import oracle.kv.ExecutionFuture;
import oracle.kv.FaultException;
import oracle.kv.KVSecurityException;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.KeyValueVersion;
import oracle.kv.LoginCredentials;
import oracle.kv.Operation;
import oracle.kv.OperationExecutionException;
import oracle.kv.OperationFactory;
import oracle.kv.OperationResult;
import oracle.kv.ParallelScanIterator;
import oracle.kv.ReauthenticateHandler;
import oracle.kv.RequestTimeoutException;
import oracle.kv.ReturnValueVersion;
import oracle.kv.StatementResult;
import oracle.kv.StoreIteratorConfig;
import oracle.kv.Value;
import oracle.kv.ValueVersion;
import oracle.kv.Version;
import oracle.kv.avro.AvroCatalog;
import oracle.kv.impl.admin.AdminFaultException;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.api.KeySerializer;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.RequestDispatcher;
import oracle.kv.impl.api.SharedThreadPool;
import oracle.kv.impl.api.avro.AvroCatalogImpl;
import oracle.kv.impl.api.lob.KVLargeObjectImpl;
import oracle.kv.impl.api.ops.Delete;
import oracle.kv.impl.api.ops.DeleteIfVersion;
import oracle.kv.impl.api.ops.Execute;
import oracle.kv.impl.api.ops.Get;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiDelete;
import oracle.kv.impl.api.ops.MultiGet;
import oracle.kv.impl.api.ops.MultiGetIterate;
import oracle.kv.impl.api.ops.MultiGetKeys;
import oracle.kv.impl.api.ops.MultiGetKeysIterate;
import oracle.kv.impl.api.ops.Put;
import oracle.kv.impl.api.ops.PutIfAbsent;
import oracle.kv.impl.api.ops.PutIfPresent;
import oracle.kv.impl.api.ops.PutIfVersion;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.ops.StoreIterate;
import oracle.kv.impl.api.ops.StoreKeysIterate;
import oracle.kv.impl.api.parallelscan.ParallelScan;
import oracle.kv.impl.api.parallelscan.ParallelScanHook;
import oracle.kv.impl.api.parallelscan.StoreIteratorMetricsImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.client.admin.DdlFuture;
import oracle.kv.impl.client.admin.DdlStatementExecutor;
import oracle.kv.impl.client.admin.ExecutionInfo;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.login.RepNodeLoginManager;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.lob.InputStreamVersion;
import oracle.kv.stats.KVStats;
import oracle.kv.table.TableAPI;

public class KVStoreImpl
implements KVStore,
Cloneable {
    private static int DEFAULT_TTL = 5;
    public static int DEFAULT_ITERATOR_BATCH_SIZE = 100;
    private final RequestDispatcher dispatcher;
    private final boolean isDispatcherOwner;
    private final int defaultRequestTimeoutMs;
    private final int readTimeoutMs;
    private final Consistency defaultConsistency;
    private final Durability defaultDurability;
    private final long defaultLOBTimeout;
    private final String defaultLOBSuffix;
    private final long defaultLOBVerificationBytes;
    private final int defaultChunksPerPartition;
    private final int defaultChunkSize;
    private final long checkIntervalMillis;
    private final int maxCheckRetries;
    private final OperationFactory operationFactory;
    private final int nPartitions;
    private final KeySerializer keySerializer;
    final KVLargeObjectImpl largeObjectImpl;
    private final StoreIteratorMetricsImpl storeIteratorMetrics;
    private ParallelScanHook parallelScanHook;
    private volatile LoginManager loginMgr;
    private final Object loginLock = new Object();
    private final ReauthenticateHandler reauthHandler;
    private KVStoreImpl external = null;
    private final AtomicReference<AvroCatalog> avroCatalogRef;
    private final SharedThreadPool sharedThreadPool;
    private final DdlStatementExecutor statementExecutor;
    private final Logger logger;

    public KVStoreImpl(Logger logger, RequestDispatcher dispatcher, KVStoreConfig config, LoginManager loginMgr) {
        this(logger, dispatcher, config, loginMgr, null, false);
    }

    public KVStoreImpl(Logger logger, RequestDispatcher dispatcher, KVStoreConfig config, LoginManager loginMgr, ReauthenticateHandler reauthHandler) {
        this(logger, dispatcher, config, loginMgr, reauthHandler, true);
    }

    private KVStoreImpl(Logger logger, RequestDispatcher dispatcher, KVStoreConfig config, LoginManager loginMgr, ReauthenticateHandler reauthHandler, boolean isDispatcherOwner) {
        this.logger = logger;
        this.dispatcher = dispatcher;
        this.isDispatcherOwner = isDispatcherOwner;
        this.loginMgr = loginMgr;
        this.reauthHandler = reauthHandler;
        this.defaultRequestTimeoutMs = (int)config.getRequestTimeout(TimeUnit.MILLISECONDS);
        this.readTimeoutMs = (int)config.getSocketReadTimeout(TimeUnit.MILLISECONDS);
        this.defaultConsistency = config.getConsistency();
        this.defaultDurability = config.getDurability();
        this.checkIntervalMillis = config.getCheckInterval(TimeUnit.MILLISECONDS);
        this.maxCheckRetries = config.getMaxCheckRetries();
        this.keySerializer = KeySerializer.PROHIBIT_INTERNAL_KEYSPACE;
        this.operationFactory = new Execute.OperationFactoryImpl(this.keySerializer);
        this.nPartitions = dispatcher.getTopologyManager().getTopology().getPartitionMap().getNPartitions();
        this.defaultLOBTimeout = config.getLOBTimeout(TimeUnit.MILLISECONDS);
        this.defaultLOBSuffix = config.getLOBSuffix();
        this.defaultLOBVerificationBytes = config.getLOBVerificationBytes();
        this.defaultChunksPerPartition = config.getLOBChunksPerPartition();
        this.defaultChunkSize = config.getLOBChunkSize();
        this.largeObjectImpl = new KVLargeObjectImpl();
        this.avroCatalogRef = new AtomicReference<Object>(null);
        this.storeIteratorMetrics = new StoreIteratorMetricsImpl();
        this.sharedThreadPool = new SharedThreadPool(logger);
        this.largeObjectImpl.setKVSImpl(this);
        this.statementExecutor = new DdlStatementExecutor(this);
    }

    public KVLargeObjectImpl getLargeObjectImpl() {
        return this.largeObjectImpl;
    }

    public static KVStore makeInternalHandle(KVStore other) {
        return new KVStoreImpl((KVStoreImpl)other, true){

            @Override
            public void close() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void logout() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void login(LoginCredentials creds) {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoginManager getLoginManager(KVStore store) {
        KVStoreImpl impl = (KVStoreImpl)store;
        Object object = impl.loginLock;
        synchronized (object) {
            return impl.loginMgr;
        }
    }

    private boolean isInternalHandle() {
        return this.keySerializer == KeySerializer.ALLOW_INTERNAL_KEYSPACE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renewLoginManager(LoginManager loginManager) {
        if (this.isInternalHandle()) {
            Object object = this.loginLock;
            synchronized (object) {
                this.loginMgr = loginManager;
            }
        }
    }

    private KVStoreImpl(KVStoreImpl other, boolean allowInternalKeyspace) {
        this.logger = other.logger;
        this.loginMgr = KVStoreImpl.getLoginManager(other);
        this.dispatcher = other.dispatcher;
        this.isDispatcherOwner = false;
        this.defaultRequestTimeoutMs = other.defaultRequestTimeoutMs;
        this.readTimeoutMs = other.readTimeoutMs;
        this.defaultConsistency = other.defaultConsistency;
        this.defaultDurability = other.defaultDurability;
        this.maxCheckRetries = other.maxCheckRetries;
        this.checkIntervalMillis = other.checkIntervalMillis;
        this.keySerializer = allowInternalKeyspace ? KeySerializer.ALLOW_INTERNAL_KEYSPACE : KeySerializer.PROHIBIT_INTERNAL_KEYSPACE;
        this.operationFactory = new Execute.OperationFactoryImpl(this.keySerializer);
        this.nPartitions = other.nPartitions;
        this.defaultLOBTimeout = other.defaultLOBTimeout;
        this.defaultLOBSuffix = other.defaultLOBSuffix;
        this.defaultLOBVerificationBytes = other.defaultLOBVerificationBytes;
        this.defaultChunksPerPartition = other.defaultChunksPerPartition;
        this.defaultChunkSize = other.defaultChunkSize;
        this.largeObjectImpl = other.largeObjectImpl;
        this.reauthHandler = other.reauthHandler;
        if (this.largeObjectImpl == null) {
            throw new IllegalStateException("null large object impl");
        }
        this.avroCatalogRef = other.avroCatalogRef;
        this.storeIteratorMetrics = new StoreIteratorMetricsImpl();
        this.sharedThreadPool = new SharedThreadPool(this.logger);
        if (this.isInternalHandle()) {
            this.external = other;
        }
        this.statementExecutor = new DdlStatementExecutor(this);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public KeySerializer getKeySerializer() {
        return this.keySerializer;
    }

    public StoreIteratorMetricsImpl getStoreIteratorMetrics() {
        return this.storeIteratorMetrics;
    }

    public int getNPartitions() {
        return this.nPartitions;
    }

    public RequestDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setParallelScanHook(ParallelScanHook parallelScanHook) {
        this.parallelScanHook = parallelScanHook;
    }

    public ParallelScanHook getParallelScanHook() {
        return this.parallelScanHook;
    }

    public int getDefaultRequestTimeoutMs() {
        return this.defaultRequestTimeoutMs;
    }

    public int getReadTimeoutMs() {
        return this.readTimeoutMs;
    }

    public long getCheckIntervalMillis() {
        return this.checkIntervalMillis;
    }

    public int getMaxCheckRetries() {
        return this.maxCheckRetries;
    }

    @Override
    public ValueVersion get(Key key) throws FaultException {
        return this.get(key, null, 0L, null);
    }

    @Override
    public ValueVersion get(Key key, Consistency consistency, long timeout, TimeUnit timeoutUnit) throws FaultException {
        return this.getInternal(key, 0L, consistency, timeout, timeoutUnit);
    }

    public ValueVersion getInternal(Key key, long tableId, Consistency consistency, long timeout, TimeUnit timeoutUnit) throws FaultException {
        PartitionId partitionId;
        byte[] keyBytes = this.keySerializer.toByteArray(key);
        Get get = new Get(keyBytes, tableId);
        Request req = this.makeReadRequest((InternalOperation)get, partitionId = this.dispatcher.getPartitionId(keyBytes), consistency, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        Value value = result.getPreviousValue();
        if (value == null) {
            assert (!result.getSuccess());
            return null;
        }
        assert (result.getSuccess());
        ValueVersion ret = new ValueVersion();
        ret.setValue(value);
        ret.setVersion(result.getPreviousVersion());
        return ret;
    }

    @Override
    public SortedMap<Key, ValueVersion> multiGet(Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.multiGet(parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public SortedMap<Key, ValueVersion> multiGet(Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit) throws FaultException {
        if (depth == null) {
            depth = Depth.PARENT_AND_DESCENDANTS;
        }
        byte[] parentKeyBytes = this.keySerializer.toByteArray(parentKey);
        PartitionId partitionId = this.dispatcher.getPartitionId(parentKeyBytes);
        MultiGet get = new MultiGet(parentKeyBytes, subRange, depth);
        Request req = this.makeReadRequest((InternalOperation)get, partitionId, consistency, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        List<ResultKeyValueVersion> byteKeyResults = result.getKeyValueVersionList();
        TreeMap<Key, ValueVersion> stringKeyResults = new TreeMap<Key, ValueVersion>();
        for (ResultKeyValueVersion entry : byteKeyResults) {
            stringKeyResults.put(this.keySerializer.fromByteArray(entry.getKeyBytes()), new ValueVersion(entry.getValue(), entry.getVersion()));
        }
        assert (result.getSuccess() == !stringKeyResults.isEmpty());
        return stringKeyResults;
    }

    @Override
    public SortedSet<Key> multiGetKeys(Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.multiGetKeys(parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public SortedSet<Key> multiGetKeys(Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit) throws FaultException {
        if (depth == null) {
            depth = Depth.PARENT_AND_DESCENDANTS;
        }
        byte[] parentKeyBytes = this.keySerializer.toByteArray(parentKey);
        PartitionId partitionId = this.dispatcher.getPartitionId(parentKeyBytes);
        MultiGetKeys get = new MultiGetKeys(parentKeyBytes, subRange, depth);
        Request req = this.makeReadRequest((InternalOperation)get, partitionId, consistency, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        List<byte[]> byteKeyResults = result.getKeyList();
        TreeSet<Key> stringKeySet = new TreeSet<Key>();
        for (byte[] entry : byteKeyResults) {
            stringKeySet.add(this.keySerializer.fromByteArray(entry));
        }
        assert (result.getSuccess() == !stringKeySet.isEmpty());
        return stringKeySet;
    }

    @Override
    public Iterator<KeyValueVersion> multiGetIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.multiGetIterator(direction, batchSize, parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public Iterator<KeyValueVersion> multiGetIterator(final Direction direction, int batchSize, Key parentKey, final KeyRange subRange, Depth depth, final Consistency consistency, final long timeout, final TimeUnit timeoutUnit) throws FaultException {
        if (direction != Direction.FORWARD && direction != Direction.REVERSE) {
            throw new IllegalArgumentException("Only Direction.FORWARD and REVERSE are supported, got: " + (Object)((Object)direction));
        }
        final Depth useDepth = depth != null ? depth : Depth.PARENT_AND_DESCENDANTS;
        final int useBatchSize = batchSize > 0 ? batchSize : DEFAULT_ITERATOR_BATCH_SIZE;
        final byte[] parentKeyBytes = this.keySerializer.toByteArray(parentKey);
        final PartitionId partitionId = this.dispatcher.getPartitionId(parentKeyBytes);
        return new ArrayIterator<KeyValueVersion>(){
            private boolean moreElements = true;
            private byte[] resumeKey = null;

            KeyValueVersion[] getMoreElements() {
                if (!this.moreElements) {
                    return null;
                }
                MultiGetIterate get = new MultiGetIterate(parentKeyBytes, subRange, useDepth, direction, useBatchSize, this.resumeKey);
                Request req = KVStoreImpl.this.makeReadRequest((InternalOperation)get, partitionId, consistency, timeout, timeoutUnit);
                Result result = KVStoreImpl.this.executeRequest(req);
                this.moreElements = result.hasMoreElements();
                List<ResultKeyValueVersion> byteKeyResults = result.getKeyValueVersionList();
                if (byteKeyResults.size() == 0) {
                    assert (!this.moreElements);
                    return null;
                }
                this.resumeKey = byteKeyResults.get(byteKeyResults.size() - 1).getKeyBytes();
                KeyValueVersion[] stringKeyResults = new KeyValueVersion[byteKeyResults.size()];
                for (int i = 0; i < stringKeyResults.length; ++i) {
                    ResultKeyValueVersion entry = byteKeyResults.get(i);
                    stringKeyResults[i] = new KeyValueVersion(KVStoreImpl.this.keySerializer.fromByteArray(entry.getKeyBytes()), entry.getValue(), entry.getVersion());
                }
                return stringKeyResults;
            }
        };
    }

    @Override
    public Iterator<Key> multiGetKeysIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.multiGetKeysIterator(direction, batchSize, parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public Iterator<Key> multiGetKeysIterator(final Direction direction, int batchSize, Key parentKey, final KeyRange subRange, Depth depth, final Consistency consistency, final long timeout, final TimeUnit timeoutUnit) throws FaultException {
        if (direction != Direction.FORWARD && direction != Direction.REVERSE) {
            throw new IllegalArgumentException("Only Direction.FORWARD and REVERSE are supported, got: " + (Object)((Object)direction));
        }
        final Depth useDepth = depth != null ? depth : Depth.PARENT_AND_DESCENDANTS;
        final int useBatchSize = batchSize > 0 ? batchSize : DEFAULT_ITERATOR_BATCH_SIZE;
        final byte[] parentKeyBytes = this.keySerializer.toByteArray(parentKey);
        final PartitionId partitionId = this.dispatcher.getPartitionId(parentKeyBytes);
        return new ArrayIterator<Key>(){
            private boolean moreElements = true;
            private byte[] resumeKey = null;

            Key[] getMoreElements() {
                if (!this.moreElements) {
                    return null;
                }
                MultiGetKeysIterate get = new MultiGetKeysIterate(parentKeyBytes, subRange, useDepth, direction, useBatchSize, this.resumeKey);
                Request req = KVStoreImpl.this.makeReadRequest((InternalOperation)get, partitionId, consistency, timeout, timeoutUnit);
                Result result = KVStoreImpl.this.executeRequest(req);
                this.moreElements = result.hasMoreElements();
                List<byte[]> byteKeyResults = result.getKeyList();
                if (byteKeyResults.size() == 0) {
                    assert (!this.moreElements);
                    return null;
                }
                this.resumeKey = byteKeyResults.get(byteKeyResults.size() - 1);
                Key[] stringKeyResults = new Key[byteKeyResults.size()];
                for (int i = 0; i < stringKeyResults.length; ++i) {
                    byte[] entry = byteKeyResults.get(i);
                    stringKeyResults[i] = KVStoreImpl.this.keySerializer.fromByteArray(entry);
                }
                return stringKeyResults;
            }
        };
    }

    @Override
    public Iterator<KeyValueVersion> storeIterator(Direction direction, int batchSize) throws FaultException {
        return this.storeIterator(direction, batchSize, null, null, null, null, 0L, null);
    }

    @Override
    public Iterator<KeyValueVersion> storeIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.storeIterator(direction, batchSize, parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public Iterator<KeyValueVersion> storeIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit) throws FaultException {
        return this.storeIterator(direction, batchSize, 1, this.nPartitions, parentKey, subRange, depth, consistency, timeout, timeoutUnit);
    }

    @Override
    public ParallelScanIterator<KeyValueVersion> storeIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit, StoreIteratorConfig storeIteratorConfig) throws FaultException {
        if (storeIteratorConfig == null) {
            throw new IllegalArgumentException("The StoreIteratorConfig argument must be supplied.");
        }
        return ParallelScan.createParallelScan(this, direction, batchSize, parentKey, subRange, depth, consistency, timeout, timeoutUnit, storeIteratorConfig);
    }

    public Iterator<KeyValueVersion> partitionIterator(Direction direction, int batchSize, int partition, Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit) throws FaultException {
        if (direction != Direction.FORWARD && direction != Direction.UNORDERED) {
            throw new IllegalArgumentException("Only Direction.FORWARD or Direction.UNORDERED is currently supported, got: " + (Object)((Object)direction));
        }
        return this.storeIterator(Direction.UNORDERED, batchSize, partition, partition, parentKey, subRange, depth, consistency, timeout, timeoutUnit);
    }

    private Iterator<KeyValueVersion> storeIterator(Direction direction, int batchSize, final int firstPartition, final int lastPartition, Key parentKey, KeyRange subRange, Depth depth, final Consistency consistency, final long timeout, final TimeUnit timeoutUnit) throws FaultException {
        if (direction != Direction.UNORDERED) {
            throw new IllegalArgumentException("Only Direction.UNORDERED is currently supported, got: " + (Object)((Object)direction));
        }
        if (parentKey != null && parentKey.getMinorPath().size() > 0) {
            throw new IllegalArgumentException("Minor path of parentKey must be empty");
        }
        final Depth useDepth = depth != null ? depth : Depth.PARENT_AND_DESCENDANTS;
        final int useBatchSize = batchSize > 0 ? batchSize : DEFAULT_ITERATOR_BATCH_SIZE;
        final byte[] parentKeyBytes = parentKey != null ? this.keySerializer.toByteArray(parentKey) : null;
        final KeyRange useRange = this.keySerializer.restrictRange(parentKey, subRange);
        return new ArrayIterator<KeyValueVersion>(){
            private boolean moreElements = true;
            private byte[] resumeKey = null;
            private PartitionId partitionId = new PartitionId(firstPartition);

            KeyValueVersion[] getMoreElements() {
                List<ResultKeyValueVersion> byteKeyResults;
                block4: {
                    while (true) {
                        if (!this.moreElements && this.partitionId.getPartitionId() < lastPartition) {
                            this.partitionId = new PartitionId(this.partitionId.getPartitionId() + 1);
                            this.moreElements = true;
                            this.resumeKey = null;
                        }
                        if (!this.moreElements) {
                            return null;
                        }
                        StoreIterate get = new StoreIterate(parentKeyBytes, useRange, useDepth, Direction.FORWARD, useBatchSize, this.resumeKey);
                        Request req = KVStoreImpl.this.makeReadRequest((InternalOperation)get, this.partitionId, consistency, timeout, timeoutUnit);
                        Result result = KVStoreImpl.this.executeRequest(req);
                        this.moreElements = result.hasMoreElements();
                        byteKeyResults = result.getKeyValueVersionList();
                        if (byteKeyResults.size() != 0) break block4;
                        assert (!this.moreElements);
                    }
                }
                this.resumeKey = byteKeyResults.get(byteKeyResults.size() - 1).getKeyBytes();
                KeyValueVersion[] stringKeyResults = new KeyValueVersion[byteKeyResults.size()];
                for (int i = 0; i < stringKeyResults.length; ++i) {
                    ResultKeyValueVersion entry = byteKeyResults.get(i);
                    stringKeyResults[i] = new KeyValueVersion(KVStoreImpl.this.keySerializer.fromByteArray(entry.getKeyBytes()), entry.getValue(), entry.getVersion());
                }
                return stringKeyResults;
            }
        };
    }

    @Override
    public Iterator<Key> storeKeysIterator(Direction direction, int batchSize) throws FaultException {
        return this.storeKeysIterator(direction, batchSize, null, null, null, null, 0L, null);
    }

    @Override
    public Iterator<Key> storeKeysIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.storeKeysIterator(direction, batchSize, parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public Iterator<Key> storeKeysIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth, final Consistency consistency, final long timeout, final TimeUnit timeoutUnit) throws FaultException {
        if (direction != Direction.UNORDERED) {
            throw new IllegalArgumentException("Only Direction.UNORDERED is currently supported, got: " + (Object)((Object)direction));
        }
        if (parentKey != null && parentKey.getMinorPath().size() > 0) {
            throw new IllegalArgumentException("Minor path of parentKey must be empty");
        }
        final Depth useDepth = depth != null ? depth : Depth.PARENT_AND_DESCENDANTS;
        final int useBatchSize = batchSize > 0 ? batchSize : DEFAULT_ITERATOR_BATCH_SIZE;
        final byte[] parentKeyBytes = parentKey != null ? this.keySerializer.toByteArray(parentKey) : null;
        final KeyRange useRange = this.keySerializer.restrictRange(parentKey, subRange);
        return new ArrayIterator<Key>(){
            private boolean moreElements = true;
            private byte[] resumeKey = null;
            private PartitionId partitionId = new PartitionId(1);

            Key[] getMoreElements() {
                List<byte[]> byteKeyResults;
                block4: {
                    while (true) {
                        if (!this.moreElements && this.partitionId.getPartitionId() < KVStoreImpl.this.nPartitions) {
                            this.partitionId = new PartitionId(this.partitionId.getPartitionId() + 1);
                            this.moreElements = true;
                            this.resumeKey = null;
                        }
                        if (!this.moreElements) {
                            return null;
                        }
                        StoreKeysIterate get = new StoreKeysIterate(parentKeyBytes, useRange, useDepth, Direction.FORWARD, useBatchSize, this.resumeKey);
                        Request req = KVStoreImpl.this.makeReadRequest((InternalOperation)get, this.partitionId, consistency, timeout, timeoutUnit);
                        Result result = KVStoreImpl.this.executeRequest(req);
                        this.moreElements = result.hasMoreElements();
                        byteKeyResults = result.getKeyList();
                        if (byteKeyResults.size() != 0) break block4;
                        assert (!this.moreElements);
                    }
                }
                this.resumeKey = byteKeyResults.get(byteKeyResults.size() - 1);
                Key[] stringKeyResults = new Key[byteKeyResults.size()];
                for (int i = 0; i < stringKeyResults.length; ++i) {
                    byte[] entry = byteKeyResults.get(i);
                    stringKeyResults[i] = KVStoreImpl.this.keySerializer.fromByteArray(entry);
                }
                return stringKeyResults;
            }
        };
    }

    @Override
    public ParallelScanIterator<Key> storeKeysIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit, StoreIteratorConfig storeIteratorConfig) throws FaultException {
        if (storeIteratorConfig == null) {
            throw new IllegalArgumentException("The StoreIteratorConfig argument must be supplied.");
        }
        return ParallelScan.createParallelKeyScan(this, direction, batchSize, parentKey, subRange, depth, consistency, timeout, timeoutUnit, storeIteratorConfig);
    }

    @Override
    public Version put(Key key, Value value) throws FaultException {
        return this.put(key, value, null, null, 0L, null);
    }

    @Override
    public Version put(Key key, Value value, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        return this.putInternal(key, value, prevValue, 0L, durability, timeout, timeoutUnit);
    }

    public Version putInternal(Key key, Value value, ReturnValueVersion prevValue, long tableId, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        byte[] keyBytes = this.keySerializer.toByteArray(key);
        PartitionId partitionId = this.dispatcher.getPartitionId(keyBytes);
        ReturnValueVersion.Choice prevValChoice = prevValue != null ? prevValue.getReturnChoice() : ReturnValueVersion.Choice.NONE;
        Put put = new Put(keyBytes, value, prevValChoice, tableId);
        Request req = this.makeWriteRequest(put, partitionId, durability, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        if (prevValue != null) {
            prevValue.setValue(result.getPreviousValue());
            prevValue.setVersion(result.getPreviousVersion());
        }
        assert (result.getSuccess() == (result.getNewVersion() != null));
        return result.getNewVersion();
    }

    @Override
    public Version putIfAbsent(Key key, Value value) throws FaultException {
        return this.putIfAbsent(key, value, null, null, 0L, null);
    }

    @Override
    public Version putIfAbsent(Key key, Value value, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        return this.putIfAbsentInternal(key, value, prevValue, 0L, durability, timeout, timeoutUnit);
    }

    public Version putIfAbsentInternal(Key key, Value value, ReturnValueVersion prevValue, long tableId, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        byte[] keyBytes = this.keySerializer.toByteArray(key);
        PartitionId partitionId = this.dispatcher.getPartitionId(keyBytes);
        ReturnValueVersion.Choice prevValChoice = prevValue != null ? prevValue.getReturnChoice() : ReturnValueVersion.Choice.NONE;
        PutIfAbsent put = new PutIfAbsent(keyBytes, value, prevValChoice, tableId);
        Request req = this.makeWriteRequest(put, partitionId, durability, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        if (prevValue != null) {
            prevValue.setValue(result.getPreviousValue());
            prevValue.setVersion(result.getPreviousVersion());
        }
        assert (result.getSuccess() == (result.getNewVersion() != null));
        return result.getNewVersion();
    }

    @Override
    public Version putIfPresent(Key key, Value value) throws FaultException {
        return this.putIfPresent(key, value, null, null, 0L, null);
    }

    @Override
    public Version putIfPresent(Key key, Value value, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        return this.putIfPresentInternal(key, value, prevValue, 0L, durability, timeout, timeoutUnit);
    }

    public Version putIfPresentInternal(Key key, Value value, ReturnValueVersion prevValue, long tableId, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        byte[] keyBytes = this.keySerializer.toByteArray(key);
        PartitionId partitionId = this.dispatcher.getPartitionId(keyBytes);
        ReturnValueVersion.Choice prevValChoice = prevValue != null ? prevValue.getReturnChoice() : ReturnValueVersion.Choice.NONE;
        PutIfPresent put = new PutIfPresent(keyBytes, value, prevValChoice, tableId);
        Request req = this.makeWriteRequest(put, partitionId, durability, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        if (prevValue != null) {
            prevValue.setValue(result.getPreviousValue());
            prevValue.setVersion(result.getPreviousVersion());
        }
        assert (result.getSuccess() == (result.getNewVersion() != null));
        return result.getNewVersion();
    }

    @Override
    public Version putIfVersion(Key key, Value value, Version matchVersion) throws FaultException {
        return this.putIfVersion(key, value, matchVersion, null, null, 0L, null);
    }

    @Override
    public Version putIfVersion(Key key, Value value, Version matchVersion, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        return this.putIfVersionInternal(key, value, matchVersion, prevValue, 0L, durability, timeout, timeoutUnit);
    }

    public Version putIfVersionInternal(Key key, Value value, Version matchVersion, ReturnValueVersion prevValue, long tableId, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        byte[] keyBytes = this.keySerializer.toByteArray(key);
        PartitionId partitionId = this.dispatcher.getPartitionId(keyBytes);
        ReturnValueVersion.Choice prevValChoice = prevValue != null ? prevValue.getReturnChoice() : ReturnValueVersion.Choice.NONE;
        PutIfVersion put = new PutIfVersion(keyBytes, value, prevValChoice, matchVersion, tableId);
        Request req = this.makeWriteRequest(put, partitionId, durability, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        if (prevValue != null) {
            prevValue.setValue(result.getPreviousValue());
            prevValue.setVersion(result.getPreviousVersion());
        }
        assert (result.getSuccess() == (result.getNewVersion() != null));
        return result.getNewVersion();
    }

    @Override
    public boolean delete(Key key) throws FaultException {
        return this.delete(key, null, null, 0L, null);
    }

    @Override
    public boolean delete(Key key, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        return this.deleteInternal(key, prevValue, durability, timeout, timeoutUnit, 0L);
    }

    public boolean deleteInternal(Key key, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit, long tableId) throws FaultException {
        byte[] keyBytes = this.keySerializer.toByteArray(key);
        PartitionId partitionId = this.dispatcher.getPartitionId(keyBytes);
        ReturnValueVersion.Choice prevValChoice = prevValue != null ? prevValue.getReturnChoice() : ReturnValueVersion.Choice.NONE;
        Delete del = new Delete(keyBytes, prevValChoice, tableId);
        Request req = this.makeWriteRequest(del, partitionId, durability, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        if (prevValue != null) {
            prevValue.setValue(result.getPreviousValue());
            prevValue.setVersion(result.getPreviousVersion());
        }
        return result.getSuccess();
    }

    @Override
    public boolean deleteIfVersion(Key key, Version matchVersion) throws FaultException {
        return this.deleteIfVersion(key, matchVersion, null, null, 0L, null);
    }

    @Override
    public boolean deleteIfVersion(Key key, Version matchVersion, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        return this.deleteIfVersionInternal(key, matchVersion, prevValue, durability, timeout, timeoutUnit, 0L);
    }

    public boolean deleteIfVersionInternal(Key key, Version matchVersion, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit, long tableId) throws FaultException {
        byte[] keyBytes = this.keySerializer.toByteArray(key);
        PartitionId partitionId = this.dispatcher.getPartitionId(keyBytes);
        ReturnValueVersion.Choice prevValChoice = prevValue != null ? prevValue.getReturnChoice() : ReturnValueVersion.Choice.NONE;
        DeleteIfVersion del = new DeleteIfVersion(keyBytes, prevValChoice, matchVersion, tableId);
        Request req = this.makeWriteRequest(del, partitionId, durability, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        if (prevValue != null) {
            prevValue.setValue(result.getPreviousValue());
            prevValue.setVersion(result.getPreviousVersion());
        }
        return result.getSuccess();
    }

    @Override
    public int multiDelete(Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.multiDelete(parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public int multiDelete(Key parentKey, KeyRange subRange, Depth depth, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        if (depth == null) {
            depth = Depth.PARENT_AND_DESCENDANTS;
        }
        byte[] parentKeyBytes = this.keySerializer.toByteArray(parentKey);
        PartitionId partitionId = this.dispatcher.getPartitionId(parentKeyBytes);
        MultiDelete del = new MultiDelete(parentKeyBytes, subRange, depth, this.largeObjectImpl.getLOBSuffixBytes());
        Request req = this.makeWriteRequest(del, partitionId, durability, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        return result.getNDeletions();
    }

    @Override
    public List<OperationResult> execute(List<Operation> operations) throws OperationExecutionException, FaultException {
        return this.execute(operations, null, 0L, null);
    }

    @Override
    public List<OperationResult> execute(List<Operation> operations, Durability durability, long timeout, TimeUnit timeoutUnit) throws OperationExecutionException, FaultException {
        List<Execute.OperationImpl> ops = Execute.OperationImpl.downcast(operations);
        if (ops == null || ops.size() == 0) {
            throw new IllegalArgumentException("operations must be non-null and non-empty");
        }
        Execute.OperationImpl firstOp = ops.get(0);
        List<String> firstMajorPath = firstOp.getKey().getMajorPath();
        HashSet<Key> keySet = new HashSet<Key>();
        keySet.add(firstOp.getKey());
        this.checkLOBKeySuffix(firstOp.getInternalOp());
        for (int i = 1; i < ops.size(); ++i) {
            Execute.OperationImpl op = ops.get(i);
            Key opKey = op.getKey();
            if (!opKey.getMajorPath().equals(firstMajorPath)) {
                throw new IllegalArgumentException("Two operations have different major paths, first: " + firstOp.getKey() + " other: " + opKey);
            }
            if (!keySet.add(opKey)) {
                throw new IllegalArgumentException("More than one operation has the same Key: " + opKey);
            }
            this.checkLOBKeySuffix(op.getInternalOp());
        }
        Execute exe = new Execute(ops);
        PartitionId partitionId = this.dispatcher.getPartitionId(firstOp.getInternalOp().getKeyBytes());
        Request req = this.makeWriteRequest(exe, partitionId, durability, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        OperationExecutionException exception = result.getExecuteException(operations);
        if (exception != null) {
            throw exception;
        }
        return result.getExecuteResult();
    }

    @Override
    public OperationFactory getOperationFactory() {
        return this.operationFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.loginLock;
        synchronized (object) {
            if (this.loginMgr != null) {
                this.logout();
            }
        }
        this.dispatcher.shutdown(null);
        this.sharedThreadPool.shutdownNow();
    }

    public Request makeWriteRequest(InternalOperation op, PartitionId partitionId, Durability durability, long timeout, TimeUnit timeoutUnit) {
        this.checkLOBKeySuffix(op);
        return this.makeRequest(op, partitionId, null, true, durability != null ? durability : this.defaultDurability, null, timeout, timeoutUnit);
    }

    private void checkLOBKeySuffix(InternalOperation op) {
        if (this.isInternalHandle()) {
            return;
        }
        byte[] keyBytes = op.checkLOBSuffix(this.largeObjectImpl.getLOBSuffixBytes());
        if (keyBytes == null) {
            return;
        }
        String msg = "Operation: " + (Object)((Object)op.getOpCode()) + " Illegal LOB key argument: " + Key.fromByteArray(keyBytes) + ". Use LOB-specific APIs to modify a LOB key/value pair.";
        throw new IllegalArgumentException(msg);
    }

    public Request makeReadRequest(InternalOperation op, PartitionId partitionId, Consistency consistency, long timeout, TimeUnit timeoutUnit) {
        return this.makeRequest(op, partitionId, null, false, null, consistency != null ? consistency : this.defaultConsistency, timeout, timeoutUnit);
    }

    public Request makeReadRequest(InternalOperation op, RepGroupId repGroupId, Consistency consistency, long timeout, TimeUnit timeoutUnit) {
        return this.makeRequest(op, null, repGroupId, false, null, consistency != null ? consistency : this.defaultConsistency, timeout, timeoutUnit);
    }

    private Request makeRequest(InternalOperation op, PartitionId partitionId, RepGroupId repGroupId, boolean write, Durability durability, Consistency consistency, long timeout, TimeUnit timeoutUnit) {
        int requestTimeoutMs = this.defaultRequestTimeoutMs;
        if (timeout > 0L && (requestTimeoutMs = PropUtil.durationToMillis(timeout, timeoutUnit)) > this.readTimeoutMs) {
            String format = "Request timeout parameter: %,d ms exceeds socket read timeout: %,d ms";
            throw new IllegalArgumentException(String.format(format, requestTimeoutMs, this.readTimeoutMs));
        }
        return partitionId != null ? new Request(op, partitionId, write, durability, consistency, DEFAULT_TTL, this.dispatcher.getTopologyManager().getTopology().getSequenceNumber(), this.dispatcher.getDispatcherId(), requestTimeoutMs, !write ? this.dispatcher.getReadZoneIds() : null) : new Request(op, repGroupId, write, durability, consistency, DEFAULT_TTL, this.dispatcher.getTopologyManager().getTopology().getSequenceNumber(), this.dispatcher.getDispatcherId(), requestTimeoutMs, !write ? this.dispatcher.getReadZoneIds() : null);
    }

    public Result executeRequest(Request request) throws FaultException {
        LoginManager requestLoginMgr = this.loginMgr;
        try {
            return this.dispatcher.execute(request, this.loginMgr).getResult();
        }
        catch (AuthenticationRequiredException are) {
            if (!this.tryReauthenticate(requestLoginMgr)) {
                throw are;
            }
            return this.dispatcher.execute(request, this.loginMgr).getResult();
        }
    }

    @Override
    public KVStats getStats(boolean clear) {
        return new KVStats(clear, this.dispatcher, this.storeIteratorMetrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AvroCatalog getAvroCatalog() {
        AvroCatalog catalog = this.avroCatalogRef.get();
        if (catalog != null) {
            return catalog;
        }
        AtomicReference<AvroCatalog> atomicReference = this.avroCatalogRef;
        synchronized (atomicReference) {
            catalog = this.avroCatalogRef.get();
            if (catalog != null) {
                return catalog;
            }
            catalog = new AvroCatalogImpl(this);
            this.avroCatalogRef.set(catalog);
            return catalog;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void login(LoginCredentials creds) throws RequestTimeoutException, AuthenticationFailureException, FaultException {
        LoginManager priorLoginMgr;
        if (creds == null) {
            throw new IllegalArgumentException("No credentials provided");
        }
        Object object = this.loginLock;
        synchronized (object) {
            if (this.loginMgr != null && (this.loginMgr.getUsername() == null && creds.getUsername() != null || this.loginMgr.getUsername() != null && !this.loginMgr.getUsername().equals(creds.getUsername()))) {
                throw new AuthenticationFailureException("Logout required prior to logging in with new user identity.");
            }
            RepNodeLoginManager rnlm = new RepNodeLoginManager(creds.getUsername(), true);
            rnlm.setTopology(this.dispatcher.getTopologyManager());
            rnlm.login(creds);
            priorLoginMgr = this.loginMgr;
            if (this.isDispatcherOwner) {
                this.dispatcher.setRegUtilsLoginManager(rnlm);
            }
            this.loginMgr = rnlm;
            this.largeObjectImpl.renewLoginMgr(this.loginMgr);
        }
        if (priorLoginMgr != null) {
            FaultException logException = null;
            try {
                priorLoginMgr.logout();
            }
            catch (SessionAccessException re) {
                logException = re;
            }
            catch (AuthenticationRequiredException are) {
                logException = are;
            }
            if (logException != null) {
                this.logger.info(logException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout() throws RequestTimeoutException, FaultException {
        Object object = this.loginLock;
        synchronized (object) {
            if (this.loginMgr == null) {
                throw new AuthenticationRequiredException("The KVStore handle has no associated login", false);
            }
            try {
                this.loginMgr.logout();
            }
            catch (SessionAccessException sae) {
                this.logger.fine(sae.getMessage());
            }
            finally {
                if (this.isDispatcherOwner) {
                    this.dispatcher.setRegUtilsLoginManager(null);
                }
            }
        }
    }

    public boolean isAvroCatalogPopulated() {
        return this.avroCatalogRef.get() != null;
    }

    public PartitionId getPartitionId(Key key) {
        byte[] keyBytes = this.keySerializer.toByteArray(key);
        return this.dispatcher.getPartitionId(keyBytes);
    }

    public long getDefaultLOBTimeout() {
        return this.defaultLOBTimeout;
    }

    public String getDefaultLOBSuffix() {
        return this.defaultLOBSuffix;
    }

    public long getDefaultLOBVerificationBytes() {
        return this.defaultLOBVerificationBytes;
    }

    public Consistency getDefaultConsistency() {
        return this.defaultConsistency;
    }

    public Durability getDefaultDurability() {
        return this.defaultDurability;
    }

    public int getDefaultChunksPerPartition() {
        return this.defaultChunksPerPartition;
    }

    public int getDefaultChunkSize() {
        return this.defaultChunkSize;
    }

    @Override
    public Version putLOB(Key lobKey, InputStream lobStream, Durability durability, long lobTimeout, TimeUnit timeoutUnit) throws IOException {
        return this.largeObjectImpl.putLOB(lobKey, lobStream, durability, lobTimeout, timeoutUnit);
    }

    @Override
    public boolean deleteLOB(Key lobKey, Durability durability, long lobTimeout, TimeUnit timeoutUnit) {
        return this.largeObjectImpl.deleteLOB(lobKey, durability, lobTimeout, timeoutUnit);
    }

    @Override
    public InputStreamVersion getLOB(Key lobKey, Consistency consistency, long lobTimeout, TimeUnit timeoutUnit) {
        return this.largeObjectImpl.getLOB(lobKey, consistency, lobTimeout, timeoutUnit);
    }

    @Override
    public Version putLOBIfAbsent(Key lobKey, InputStream lobStream, Durability durability, long lobTimeout, TimeUnit timeoutUnit) throws IOException {
        return this.largeObjectImpl.putLOBIfAbsent(lobKey, lobStream, durability, lobTimeout, timeoutUnit);
    }

    @Override
    public Version putLOBIfPresent(Key lobKey, InputStream lobStream, Durability durability, long lobTimeout, TimeUnit timeoutUnit) throws IOException {
        return this.largeObjectImpl.putLOBIfPresent(lobKey, lobStream, durability, lobTimeout, timeoutUnit);
    }

    @Override
    public TableAPI getTableAPI() {
        return new TableAPIImpl(this);
    }

    @Override
    public Version appendLOB(Key lobKey, InputStream lobAppendStream, Durability durability, long lobTimeout, TimeUnit timeoutUnit) throws IOException {
        return this.largeObjectImpl.appendLOB(lobKey, lobAppendStream, durability, lobTimeout, timeoutUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryReauthenticate(LoginManager requestLoginMgr) throws FaultException {
        if (this.reauthHandler == null) {
            return false;
        }
        Object object = this.loginLock;
        synchronized (object) {
            if (this.loginMgr == requestLoginMgr) {
                try {
                    if (this.isInternalHandle()) {
                        this.reauthHandler.reauthenticate(this.external);
                    } else {
                        this.reauthHandler.reauthenticate(this);
                    }
                }
                catch (KVSecurityException kvse) {
                    this.logger.fine(kvse.getMessage());
                    return false;
                }
            }
        }
        return true;
    }

    public TaskExecutor getTaskExecutor(int maxConcurrentTasks) {
        return this.sharedThreadPool.getTaskExecutor(maxConcurrentTasks);
    }

    @Override
    public ExecutionFuture execute(String statement) throws IllegalArgumentException, FaultException {
        try {
            ExecutionInfo info = this.statementExecutor.getClientAdminService().execute(statement);
            return new DdlFuture(statement, info, this.statementExecutor, this.getLogger());
        }
        catch (AdminFaultException e) {
            if (e.getFaultClassName().equals(IllegalCommandException.class.getName())) {
                throw new IllegalArgumentException(e.getMessage());
            }
            if (e.getFaultClassName().equals(FaultException.class.getName())) {
                throw new FaultException(e.getMessage(), false);
            }
            throw new FaultException(e.getMessage(), e, false);
        }
        catch (KVSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FaultException(e.getMessage(), e, false);
        }
    }

    @Override
    public StatementResult executeSync(String statement) throws FaultException {
        ExecutionFuture f = this.execute(statement);
        try {
            StatementResult r = f.get();
            return r;
        }
        catch (ExecutionException e) {
            if (e.getCause() != null) {
                throw new FaultException(e.getMessage(), e.getCause(), false);
            }
            throw new FaultException(e.getMessage(), false);
        }
        catch (KVSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FaultException(e.getMessage(), e, false);
        }
    }

    @Override
    public ExecutionFuture getFuture(byte[] futureBytes) {
        return new DdlFuture(futureBytes, this.statementExecutor, this.getLogger());
    }

    public static interface TaskExecutor {
        public Future<?> submit(Runnable var1);

        public List<Runnable> shutdownNow();
    }

    private abstract class ArrayIterator<E>
    implements Iterator<E> {
        private E[] elements = null;
        private int nextElement = 0;

        private ArrayIterator() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (this.elements != null && this.nextElement < this.elements.length) {
                return true;
            }
            this.elements = this.getMoreElements();
            if (this.elements == null) {
                return false;
            }
            assert (this.elements.length > 0);
            this.nextElement = 0;
            return true;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.elements[this.nextElement++];
        }

        abstract E[] getMoreElements();
    }
}

