/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.webapp.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.kv.impl.admin.webapp.client.ButtonController;
import oracle.kv.impl.admin.webapp.client.KVAdminUI;
import oracle.kv.impl.admin.webapp.client.TopoBrowser;
import oracle.kv.impl.admin.webapp.shared.Describable;
import oracle.kv.impl.admin.webapp.shared.FieldDesc;
import oracle.kv.impl.admin.webapp.shared.PerfEventDTO;
import oracle.kv.impl.admin.webapp.shared.StatusEventDTO;
import oracle.kv.impl.admin.webapp.shared.TopologyDTO;
import oracle.kv.impl.admin.webapp.shared.UpdateInfo;

public class TopoBrowser
implements ButtonController {
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    private final KVAdminUI root;
    @UiField
    Panel container;
    @UiField
    Panel statusPanel;
    @UiField
    Panel overviewPanel;
    @UiField
    Panel snPanel;
    @UiField
    Grid snTable;
    @UiField
    Panel rgPanel;
    @UiField
    Grid rgTable;
    @UiField
    Panel detailPanel;
    @UiField
    Label detailTitle;
    @UiField
    Grid detailTable;
    @UiField
    Button verifyButton;
    TopologyDTO theTopology;

    TopoBrowser(KVAdminUI root) {
        this.root = root;
        binder.createAndBindUi((Object)this);
        this.theTopology = null;
        this.verifyButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    void display(Panel place) {
        place.clear();
        place.add((Widget)this.container);
        if (this.theTopology != null) {
            this.redisplay();
        }
        this.refreshTopologyFromServer();
    }

    void refreshTopologyFromServer() {
        this.root.getRpcService().getTopology((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void redisplay() {
        MouseTargetMap targets = new MouseTargetMap(this);
        this.showSNHierarchy(this.theTopology, targets);
        this.showRGHierarchy(this.theTopology, targets);
        targets.attachHandlers();
    }

    private void showSNHierarchy(TopologyDTO t, MouseTargetMap targets) {
        Map dcMap = t.getDatacenterMap();
        ArrayList dcids = new ArrayList(dcMap.keySet());
        Collections.sort(dcids);
        Map snMap = t.getStorageNodeMap();
        ArrayList snids = new ArrayList(snMap.keySet());
        Collections.sort(snids);
        Map rgMap = t.getRepGroupMap();
        ArrayList rgids = new ArrayList(rgMap.keySet());
        Collections.sort(rgids);
        Map adminMap = t.getAdminMap();
        ArrayList aids = new ArrayList(adminMap.keySet());
        int nRows = t.getRepNodeCount() + snMap.size() + dcMap.size() + adminMap.size() + 2;
        this.snTable.clear(true);
        this.snTable.resize(nRows, 4);
        int nRunningRNs = 0;
        int nDownRNs = 0;
        int nNeedsAttentionRNs = 0;
        int nRunningSNs = 0;
        int nDownSNs = 0;
        int nNeedsAttentionSNs = 0;
        HTMLTable.CellFormatter cf = this.snTable.getCellFormatter();
        HTMLTable.RowFormatter rf = this.snTable.getRowFormatter();
        HTMLTable.ColumnFormatter colf = this.snTable.getColumnFormatter();
        colf.addStyleName(0, "odd-row");
        colf.addStyleName(1, "even-row");
        colf.addStyleName(2, "odd-row");
        colf.addStyleName(3, "even-row");
        this.snTable.setWidget(0, 0, (Widget)new Label("Performance/Status"));
        this.snTable.setWidget(0, 1, (Widget)new Label("Zone"));
        this.snTable.setWidget(0, 2, (Widget)new Label("StorageNode"));
        this.snTable.setWidget(0, 3, (Widget)new Label("RepNode/Admin"));
        rf.addStyleName(0, "header-row");
        this.showPerfKey(nRows - 1);
        for (int i = 0; i < nRows; ++i) {
            rf.addStyleName(i, "topoRow");
            for (int j = 0; j < 3; ++j) {
                cf.removeStyleName(i, j, "criticalCell");
                cf.removeStyleName(i, j, "teejoint");
                cf.removeStyleName(i, j, "pipe");
                cf.removeStyleName(i, j, "elljoint");
                cf.addStyleName(i, j, "topoCell");
            }
        }
        int currentRow = 1;
        for (Integer dcid : dcids) {
            TopologyDTO.Datacenter dc = (TopologyDTO.Datacenter)dcMap.get(dcid);
            Label lbl = new Label(dc.getName());
            targets.add((Describable)dc, new CellInfo(lbl, cf, currentRow, 1));
            this.snTable.setWidget(currentRow++, 1, (Widget)lbl);
            int lastSNRow = -1;
            for (Integer snid : snids) {
                StatusEventDTO.ServiceStatus snStatus;
                TopologyDTO.StorageNode sn = (TopologyDTO.StorageNode)snMap.get(snid);
                if (sn.getDatacenterId() != dcid.intValue()) continue;
                StatusEventDTO snStatusEvent = sn.getStatusEvent();
                StatusEventDTO.ServiceStatus serviceStatus = snStatus = snStatusEvent == null ? StatusEventDTO.ServiceStatus.UNREPORTED : snStatusEvent.getStatus();
                if (snStatus == StatusEventDTO.ServiceStatus.RUNNING) {
                    ++nRunningSNs;
                } else {
                    this.snTable.setWidget(currentRow, 0, (Widget)new Label(snStatus.toString()));
                    ++nDownSNs;
                }
                if (snStatus.getSeverity() > 1) {
                    cf.setStyleName(currentRow, 0, "criticalCell");
                    ++nNeedsAttentionSNs;
                } else {
                    cf.removeStyleName(currentRow, 0, "criticalCell");
                }
                cf.setStyleName(currentRow, 1, "teejoint");
                lbl = new Label("SN " + sn.getId() + " " + sn.getHostname() + ":" + sn.getRegistryPort());
                targets.add((Describable)sn, new CellInfo(lbl, cf, currentRow, 2));
                this.snTable.setWidget(currentRow, 2, (Widget)lbl);
                lastSNRow = currentRow++;
                int lastRNRow = -1;
                for (Integer rgid : rgids) {
                    Map rnMap = (Map)rgMap.get(rgid);
                    ArrayList rnids = new ArrayList(rnMap.keySet());
                    Collections.sort(rnids);
                    for (Integer rnid : rnids) {
                        StatusEventDTO.ServiceStatus rnStatus;
                        TopologyDTO.RepNode rn = (TopologyDTO.RepNode)rnMap.get(rnid);
                        if (rn.getStorageNodeId() != snid.intValue()) continue;
                        StatusEventDTO rnStatusEvent = rn.getStatusEvent();
                        StatusEventDTO.ServiceStatus serviceStatus2 = rnStatus = rnStatusEvent == null ? StatusEventDTO.ServiceStatus.UNREPORTED : rnStatusEvent.getStatus();
                        if (rnStatus == StatusEventDTO.ServiceStatus.RUNNING) {
                            this.showPerf(rn, currentRow, targets);
                            ++nRunningRNs;
                        } else {
                            this.snTable.setWidget(currentRow, 0, (Widget)new Label(rnStatus.toString()));
                            ++nDownRNs;
                        }
                        if (rnStatus.getSeverity() > 1) {
                            cf.setStyleName(currentRow, 0, "criticalCell");
                            ++nNeedsAttentionRNs;
                        } else {
                            cf.removeStyleName(currentRow, 0, "criticalCell");
                        }
                        cf.setStyleName(currentRow, 1, "pipe");
                        cf.setStyleName(currentRow, 2, "teejoint");
                        lbl = new Label("RG=" + rgid + ", RN=" + rnid);
                        targets.add((Describable)rn, new CellInfo(lbl, cf, currentRow, 3));
                        this.snTable.setWidget(currentRow, 3, (Widget)lbl);
                        lastRNRow = currentRow++;
                    }
                }
                for (Integer aid : aids) {
                    TopologyDTO.Admin a = (TopologyDTO.Admin)adminMap.get(aid);
                    if (a.getStorageNodeId() != snid.intValue()) continue;
                    cf.setStyleName(currentRow, 1, "pipe");
                    cf.setStyleName(currentRow, 2, "teejoint");
                    lbl = new Label("Admin " + aid);
                    targets.add((Describable)a, new CellInfo(lbl, cf, currentRow, 3));
                    this.snTable.setWidget(currentRow, 3, (Widget)lbl);
                    lastRNRow = currentRow++;
                }
                if (lastRNRow == -1) continue;
                cf.setStyleName(lastRNRow, 2, "elljoint");
            }
            if (lastSNRow == -1) continue;
            cf.setStyleName(lastSNRow, 1, "elljoint");
            for (int i = lastSNRow + 1; i < currentRow; ++i) {
                cf.removeStyleName(i, 1, "pipe");
            }
        }
        this.statusPanel.clear();
        this.statusPanel.removeStyleName("criticalCell");
        this.statusPanel.add((Widget)new Label(nRunningRNs + nDownRNs + " RepNodes (" + nRunningRNs + " Running, " + nDownRNs + " Down, " + nNeedsAttentionRNs + " Needing Attention)"));
        this.statusPanel.add((Widget)new Label(nRunningSNs + nDownSNs + " StorageNodes (" + nRunningSNs + " Running, " + nDownSNs + " Down, " + nNeedsAttentionSNs + " Needing Attention)"));
        if (nNeedsAttentionRNs > 0 || nNeedsAttentionSNs > 0) {
            this.statusPanel.setStyleName("criticalCell");
        }
    }

    void showPerf(TopologyDTO.RepNode rn, int currentRow, MouseTargetMap targets) {
        PerfEventDTO pev = rn.getPerfEvent();
        if (pev != null) {
            Grid g = new Grid(1, 3);
            g.setWidth("100%");
            g.addStyleName("perfTable");
            HTMLTable.CellFormatter cf = g.getCellFormatter();
            String[] s = pev.briefIntervalSummary();
            for (int i = 0; i < 3; ++i) {
                Label lbl = new Label(s[i]);
                g.setWidget(0, i, (Widget)lbl);
                cf.addStyleName(0, i, "perfCell");
                cf.setWidth(0, i, "33%");
                targets.add((Describable)pev, new CellInfo(lbl, cf, 0, i));
            }
            this.snTable.setWidget(currentRow, 0, (Widget)g);
        }
    }

    void showPerfKey(int row) {
        Grid g = new Grid(1, 3);
        g.setWidth("100%");
        g.addStyleName("perfTable");
        HTMLTable.CellFormatter cf = g.getCellFormatter();
        String[] perfKeyContents = new String[]{"Avg latency", "95th %ile", "Throughput"};
        for (int i = 0; i < 3; ++i) {
            Label lbl = new Label(perfKeyContents[i]);
            lbl.setStyleName("deck");
            g.setWidget(0, i, (Widget)lbl);
            cf.addStyleName(0, i, "perfCell");
            cf.setWidth(0, i, "33%");
        }
        this.snTable.setWidget(row, 0, (Widget)g);
    }

    private void showRGHierarchy(TopologyDTO t, MouseTargetMap targets) {
        Map rgMap = t.getRepGroupMap();
        ArrayList rgids = new ArrayList(rgMap.keySet());
        Collections.sort(rgids);
        int nRows = t.getRepNodeCount() + rgMap.size() + 1;
        this.rgTable.clear(true);
        this.rgTable.resize(nRows, 2);
        HTMLTable.CellFormatter cf = this.rgTable.getCellFormatter();
        HTMLTable.RowFormatter rf = this.rgTable.getRowFormatter();
        HTMLTable.ColumnFormatter colf = this.rgTable.getColumnFormatter();
        colf.addStyleName(0, "odd-row");
        colf.addStyleName(1, "even-row");
        this.rgTable.setWidget(0, 0, (Widget)new Label("RepNode"));
        this.rgTable.setWidget(0, 1, (Widget)new Label("Shard"));
        rf.addStyleName(0, "header-row");
        for (int i = 0; i < nRows; ++i) {
            rf.addStyleName(i, "topoRow");
            for (int j = 0; j < 2; ++j) {
                cf.removeStyleName(i, j, "mirrorteejoint");
                cf.removeStyleName(i, j, "mirrorelljoint");
                cf.addStyleName(i, j, "mirrorTopoCell");
            }
        }
        int currentRow = 1;
        for (Integer rgid : rgids) {
            this.rgTable.setWidget(currentRow++, 1, (Widget)new Label("RG=" + Integer.toString(rgid)));
            Map rnMap = (Map)rgMap.get(rgid);
            ArrayList rnids = new ArrayList(rnMap.keySet());
            Collections.sort(rnids);
            int lastRNRow = -1;
            for (Integer rnid : rnids) {
                TopologyDTO.RepNode rn = (TopologyDTO.RepNode)rnMap.get(rnid);
                cf.setStyleName(currentRow, 1, "mirrorteejoint");
                Label lbl = new Label("RN=" + Integer.toString(rnid));
                targets.add((Describable)rn, new CellInfo(lbl, cf, currentRow, 0));
                this.rgTable.setWidget(currentRow, 0, (Widget)lbl);
                lastRNRow = currentRow++;
            }
            if (lastRNRow == -1) continue;
            cf.setStyleName(lastRNRow, 1, "mirrorelljoint");
        }
    }

    private void showDetail(Describable d) {
        this.detailTitle.setText(d.getTitle());
        this.detailTable.clear(true);
        List dFields = d.getDescriptions(true);
        this.detailTable.resize(dFields.size(), 2);
        HTMLTable.CellFormatter cf = this.detailTable.getCellFormatter();
        HTMLTable.RowFormatter rf = this.detailTable.getRowFormatter();
        int currentRow = 0;
        for (FieldDesc f : dFields) {
            if (f.isSectionTitle()) {
                cf.setAlignment(currentRow, 0, HasHorizontalAlignment.ALIGN_LEFT, HasVerticalAlignment.ALIGN_MIDDLE);
                Label title = new Label(f.getName());
                title.addStyleName("subsubtitle");
                this.detailTable.setWidget(currentRow, 0, (Widget)title);
                rf.removeStyleName(currentRow, "even-row");
                rf.removeStyleName(currentRow, "odd-row");
            } else {
                cf.setAlignment(currentRow, 0, HasHorizontalAlignment.ALIGN_RIGHT, HasVerticalAlignment.ALIGN_MIDDLE);
                String dName = f.getName();
                if (!"".equals(dName)) {
                    dName = dName + ": ";
                }
                this.detailTable.setWidget(currentRow, 0, (Widget)new Label(dName));
                this.detailTable.setWidget(currentRow, 1, (Widget)new Label(f.getValue()));
                rf.removeStyleName(currentRow, "subsubtitle");
                if (currentRow % 2 == 0) {
                    rf.addStyleName(currentRow, "even-row");
                } else {
                    rf.addStyleName(currentRow, "odd-row");
                }
            }
            ++currentRow;
        }
    }

    long getTopologyTimestamp() {
        if (this.theTopology == null) {
            return 0L;
        }
        return this.theTopology.getTimestamp();
    }

    void applyUpdates(UpdateInfo updates) {
        if (this.theTopology == null) {
            return;
        }
        List sEvents = updates.getStatusEvents();
        List pEvents = updates.getPerfEvents();
        Map snMap = this.theTopology.getStorageNodeMap();
        Map rgMap = this.theTopology.getRepGroupMap();
        Map adminMap = this.theTopology.getAdminMap();
        boolean topologyIsStale = false;
        for (StatusEventDTO se : sEvents) {
            if (se instanceof StatusEventDTO.StorageNodeStatusEvent) {
                StatusEventDTO.StorageNodeStatusEvent snse = (StatusEventDTO.StorageNodeStatusEvent)se;
                TopologyDTO.StorageNode sn = (TopologyDTO.StorageNode)snMap.get(snse.getSnId());
                if (sn == null) {
                    topologyIsStale = true;
                    continue;
                }
                sn.setStatusEvent((StatusEventDTO)snse);
                this.theTopology.maybeSetTimestamp(snse.getChangeTime());
                if (snse.getStatus().needsAlert()) {
                    this.root.showError("StorageNode " + snse.getSnId() + " is " + snse.getStatus().toString());
                }
            }
            if (se instanceof StatusEventDTO.RepNodeStatusEvent) {
                StatusEventDTO.RepNodeStatusEvent rnse = (StatusEventDTO.RepNodeStatusEvent)se;
                Map rnMap = (Map)rgMap.get(rnse.getGroupId());
                if (rnMap == null) {
                    topologyIsStale = true;
                    continue;
                }
                TopologyDTO.RepNode rn = (TopologyDTO.RepNode)rnMap.get(rnse.getNodeNum());
                if (rn == null) {
                    topologyIsStale = true;
                    continue;
                }
                rn.setStatusEvent((StatusEventDTO)rnse);
                this.theTopology.maybeSetTimestamp(rnse.getChangeTime());
                if (rnse.getStatus().needsAlert()) {
                    this.root.showError("RepNode " + rnse.getGroupId() + "," + rnse.getNodeNum() + " is " + rnse.getStatus().toString());
                }
            }
            if (!(se instanceof StatusEventDTO.AdminStatusEvent)) continue;
            StatusEventDTO.AdminStatusEvent ase = (StatusEventDTO.AdminStatusEvent)se;
            TopologyDTO.Admin a = (TopologyDTO.Admin)adminMap.get(ase.getAId());
            if (a == null) {
                topologyIsStale = true;
                continue;
            }
            a.setStatusEvent((StatusEventDTO)ase);
            this.theTopology.maybeSetTimestamp(ase.getChangeTime());
            if (!ase.getStatus().needsAlert()) continue;
            this.root.showError("Admin " + ase.getAId() + " is " + ase.getStatus().toString());
        }
        for (PerfEventDTO pe : pEvents) {
            Map rnMap = (Map)rgMap.get(pe.getGroupId());
            if (rnMap == null) {
                topologyIsStale = true;
                continue;
            }
            TopologyDTO.RepNode rn = (TopologyDTO.RepNode)rnMap.get(pe.getNodeNum());
            if (rn == null) {
                topologyIsStale = true;
                continue;
            }
            rn.setPerfEvent(pe);
            this.theTopology.maybeSetTimestamp(pe.getChangeTime());
            if (!pe.needsAlert()) continue;
            this.root.showError("RepNode " + pe.getGroupId() + "," + pe.getNodeNum() + " has a throughput or latency exception.");
        }
        this.redisplay();
        if (topologyIsStale) {
            this.refreshTopologyFromServer();
        }
    }

    private void doVerify() {
        this.disableButtons();
        this.root.getRpcService().verifyConfiguration((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void enableButtons() {
        this.verifyButton.setEnabled(true);
    }

    public void disableButtons() {
        this.verifyButton.setEnabled(false);
    }

    static /* synthetic */ void access$000(TopoBrowser x0) {
        x0.doVerify();
    }

    static /* synthetic */ KVAdminUI access$100(TopoBrowser x0) {
        return x0.root;
    }

    static /* synthetic */ void access$200(TopoBrowser x0) {
        x0.redisplay();
    }

    static /* synthetic */ void access$300(TopoBrowser x0, Describable x1) {
        x0.showDetail(x1);
    }
}

