/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.topo;

import com.sleepycat.je.rep.NodeType;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import oracle.kv.impl.admin.TopologyCheck;
import oracle.kv.impl.admin.VerifyConfiguration;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.AdminType;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.DatacenterType;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.ObjectUtil;

public class Validations {
    private static String plural(int num, String noun) {
        if (num == 1) {
            return num + " " + noun;
        }
        return num + " " + noun + "s";
    }

    public static class BadAdmin
    implements RulesProblem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final AdminId adminId;
        private final StorageNodeId snId;
        private final String desc;

        public BadAdmin(AdminId adminId, StorageNodeId snId) {
            ObjectUtil.checkNull("adminId", adminId);
            ObjectUtil.checkNull("snId", snId);
            this.adminId = adminId;
            this.snId = snId;
            this.desc = adminId + " assigned to " + snId + " but storage " + "node not found";
        }

        @Override
        public ResourceId getResourceId() {
            return this.adminId;
        }

        public String toString() {
            return this.desc;
        }

        @Override
        public boolean isViolation() {
            return true;
        }

        @Override
        public TopologyCheck.Remedy getRemedy() {
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.desc.hashCode();
            result = 31 * result + this.adminId.hashCode();
            result = 31 * result + this.snId.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BadAdmin)) {
                return false;
            }
            BadAdmin other = (BadAdmin)obj;
            return this.desc.equals(other.desc) && this.adminId.equals(other.adminId) && this.snId.equals(other.snId);
        }
    }

    public static class ExcessAdmins
    implements RulesProblem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final DatacenterId dcId;
        private final int requiredRF;
        private final int numExcess;

        ExcessAdmins(DatacenterId dcId, int requiredRF, int numExcess) {
            ObjectUtil.checkNull("dcId", dcId);
            if (requiredRF < 1) {
                throw new IllegalArgumentException("The value of requiredRF must be > 0");
            }
            if (numExcess < 1) {
                throw new IllegalArgumentException("The value of numExcess must be > 0");
            }
            this.dcId = dcId;
            this.requiredRF = requiredRF;
            this.numExcess = numExcess;
        }

        @Override
        public ResourceId getResourceId() {
            return this.dcId;
        }

        public String toString() {
            return this.dcId + " has " + this.numExcess + " more Admins than are needed for the required repFactor of " + this.requiredRF;
        }

        @Override
        public boolean isViolation() {
            return false;
        }

        @Override
        public TopologyCheck.Remedy getRemedy() {
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.dcId.hashCode();
            result = 31 * result + this.numExcess;
            result = 31 * result + this.requiredRF;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ExcessAdmins)) {
                return false;
            }
            ExcessAdmins other = (ExcessAdmins)obj;
            return this.dcId.equals(other.dcId) && this.numExcess == other.numExcess && this.requiredRF == other.requiredRF;
        }
    }

    public static class InsufficientAdmins
    implements RulesProblem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final DatacenterId dcId;
        private final int requiredRF;
        private final int numMissing;

        InsufficientAdmins(DatacenterId dcId, int requiredRF, int numMissing) {
            ObjectUtil.checkNull("dcId", dcId);
            if (requiredRF < 1) {
                throw new IllegalArgumentException("The value of requiredRF must be > 0");
            }
            if (numMissing < 1) {
                throw new IllegalArgumentException("The value of numMissing must be > 0");
            }
            if (numMissing > requiredRF) {
                throw new IllegalArgumentException("The value of numMissing must be <= requiredRF");
            }
            this.dcId = dcId;
            this.requiredRF = requiredRF;
            this.numMissing = numMissing;
        }

        @Override
        public ResourceId getResourceId() {
            return this.dcId;
        }

        public String toString() {
            return this.dcId + " needs " + this.numMissing + " Admins to meet the required repFactor of " + this.requiredRF;
        }

        @Override
        public boolean isViolation() {
            return true;
        }

        @Override
        public TopologyCheck.Remedy getRemedy() {
            return null;
        }

        DatacenterId getDCId() {
            return this.dcId;
        }

        int getNumNeeded() {
            return this.numMissing;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.dcId.hashCode();
            result = 31 * result + this.numMissing;
            result = 31 * result + this.requiredRF;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof InsufficientAdmins)) {
                return false;
            }
            InsufficientAdmins other = (InsufficientAdmins)obj;
            return this.dcId.equals(other.dcId) && this.numMissing == other.numMissing && this.requiredRF == other.requiredRF;
        }
    }

    public static class WrongAdminType
    implements RulesProblem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final AdminId adminId;
        private final AdminType adminType;
        private final DatacenterId dcId;
        private final DatacenterType dcType;

        WrongAdminType(AdminId adminId, AdminType adminType, DatacenterId dcId, DatacenterType dcType) {
            ObjectUtil.checkNull("adminId", adminId);
            ObjectUtil.checkNull("adminType", (Object)adminType);
            ObjectUtil.checkNull("dcId", dcId);
            ObjectUtil.checkNull("dcType", (Object)dcType);
            this.adminId = adminId;
            this.adminType = adminType;
            this.dcId = dcId;
            this.dcType = dcType;
        }

        @Override
        public ResourceId getResourceId() {
            return this.adminId;
        }

        public String toString() {
            return this.adminId + " has node type " + (Object)((Object)this.adminType) + ", but its zone, " + this.dcId + ", has type " + (Object)((Object)this.dcType);
        }

        @Override
        public boolean isViolation() {
            return true;
        }

        @Override
        public TopologyCheck.Remedy getRemedy() {
            return new TopologyCheck.Remedy(null, this.adminId, TopologyCheck.REMEDY_TYPE.FIX_ADMIN_TYPE, null);
        }

        public int hashCode() {
            int prime = 89;
            int result = 1;
            result = 89 * result + this.adminId.hashCode();
            result = 89 * result + this.adminType.hashCode();
            result = 89 * result + this.dcId.hashCode();
            result = 89 * result + this.dcType.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WrongAdminType)) {
                return false;
            }
            WrongAdminType other = (WrongAdminType)obj;
            return this.adminId.equals(other.adminId) && this.adminType.equals((Object)other.adminType) && this.dcId.equals(other.dcId) && this.dcType.equals((Object)other.dcType);
        }
    }

    public static class EmptyZone
    implements RulesProblem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final DatacenterId dcId;

        EmptyZone(DatacenterId dcId) {
            ObjectUtil.checkNull("dcId", dcId);
            this.dcId = dcId;
        }

        @Override
        public boolean isViolation() {
            return true;
        }

        @Override
        public TopologyCheck.Remedy getRemedy() {
            return null;
        }

        @Override
        public ResourceId getResourceId() {
            return this.dcId;
        }

        DatacenterId getDCId() {
            return this.dcId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.dcId.hashCode();
            return result;
        }

        public String toString() {
            return "Zone " + this.dcId + " is empty";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EmptyZone)) {
                return false;
            }
            EmptyZone other = (EmptyZone)obj;
            return this.dcId.equals(other.dcId);
        }
    }

    public static class WrongNodeType
    implements RulesProblem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final RepNodeId rnId;
        private final NodeType nodeType;
        private final DatacenterId dcId;
        private final DatacenterType dcType;

        WrongNodeType(RepNodeId rnId, NodeType nodeType, DatacenterId dcId, DatacenterType dcType) {
            ObjectUtil.checkNull("rnId", rnId);
            ObjectUtil.checkNull("nodeType", nodeType);
            ObjectUtil.checkNull("dcId", dcId);
            ObjectUtil.checkNull("dcType", (Object)dcType);
            if (nodeType == Datacenter.ServerUtil.getDefaultRepNodeType(dcType)) {
                throw new IllegalArgumentException("The nodeType should not match the default node type for datacenter");
            }
            this.rnId = rnId;
            this.nodeType = nodeType;
            this.dcId = dcId;
            this.dcType = dcType;
        }

        @Override
        public ResourceId getResourceId() {
            return this.rnId;
        }

        public String toString() {
            return this.rnId + " has node type " + this.nodeType + ", but its zone, " + this.dcId + ", has type " + (Object)((Object)this.dcType) + " and expects its replication nodes to have type " + Datacenter.ServerUtil.getDefaultRepNodeType(this.dcType);
        }

        @Override
        public boolean isViolation() {
            return true;
        }

        @Override
        public TopologyCheck.Remedy getRemedy() {
            return null;
        }

        public int hashCode() {
            int prime = 89;
            int result = 1;
            result = 89 * result + this.rnId.hashCode();
            result = 89 * result + this.nodeType.hashCode();
            result = 89 * result + this.dcId.hashCode();
            result = 89 * result + this.dcType.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WrongNodeType)) {
                return false;
            }
            WrongNodeType other = (WrongNodeType)obj;
            return this.rnId.equals(other.rnId) && this.nodeType.equals((Object)other.nodeType) && this.dcId.equals(other.dcId) && this.dcType.equals((Object)other.dcType);
        }
    }

    public static class NoPrimaryDC
    implements RulesProblem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final RepGroupId rgId;

        NoPrimaryDC(RepGroupId rgId) {
            ObjectUtil.checkNull("rgId", rgId);
            this.rgId = rgId;
        }

        @Override
        public ResourceId getResourceId() {
            return this.rgId;
        }

        public String toString() {
            return this.rgId + " has no RNs in a primary zone";
        }

        @Override
        public boolean isViolation() {
            return true;
        }

        @Override
        public TopologyCheck.Remedy getRemedy() {
            return null;
        }

        public int hashCode() {
            int prime = 83;
            int result = 1;
            result = 83 * result + this.rgId.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof NoPrimaryDC)) {
                return false;
            }
            NoPrimaryDC other = (NoPrimaryDC)obj;
            return this.rgId.equals(other.rgId);
        }
    }

    public static class MultipleRNsInRoot
    implements RulesProblem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final StorageNodeId snId;
        private final List<RepNodeId> residentRNs;
        private final String rootDir;

        MultipleRNsInRoot(StorageNodeId snId, List<RepNodeId> residentRNs, String rootDir) {
            this.snId = snId;
            this.residentRNs = residentRNs;
            this.rootDir = rootDir;
        }

        @Override
        public ResourceId getResourceId() {
            return this.snId;
        }

        private String getRNList() {
            StringBuilder sb = new StringBuilder();
            if (this.residentRNs != null) {
                for (RepNodeId rnId : this.residentRNs) {
                    if (sb.length() > 1) {
                        sb.append(", ");
                    }
                    sb.append(rnId);
                }
            }
            return sb.toString();
        }

        public String toString() {
            return this.snId + " hosts " + Validations.plural(this.residentRNs == null ? 0 : this.residentRNs.size(), "RN") + " (" + this.getRNList() + ") in " + this.rootDir + ". If this leads to insufficient I/O performance, consider " + "adding storage directories.";
        }

        @Override
        public boolean isViolation() {
            return false;
        }

        @Override
        public TopologyCheck.Remedy getRemedy() {
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.residentRNs == null ? 0 : this.residentRNs.hashCode());
            result = 31 * result + (this.rootDir == null ? 0 : this.rootDir.hashCode());
            result = 31 * result + (this.snId == null ? 0 : this.snId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MultipleRNsInRoot)) {
                return false;
            }
            MultipleRNsInRoot other = (MultipleRNsInRoot)obj;
            if (this.residentRNs == null ? other.residentRNs != null : !this.residentRNs.equals(other.residentRNs)) {
                return false;
            }
            if (this.rootDir == null ? other.rootDir != null : !this.rootDir.equals(other.rootDir)) {
                return false;
            }
            return !(this.snId == null ? other.snId != null : !this.snId.equals(other.snId));
        }
    }

    public static class NonOptimalNumPartitions
    implements RulesProblem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final RepGroupId rgId;
        private final int actualCount;
        private final int minPartitions;
        private final int maxPartitions;

        NonOptimalNumPartitions(RepGroupId rgId, int actualCount, int minPartitions, int maxPartitions) {
            this.rgId = rgId;
            this.actualCount = actualCount;
            this.minPartitions = minPartitions;
            this.maxPartitions = maxPartitions;
        }

        @Override
        public ResourceId getResourceId() {
            return this.rgId;
        }

        public String toString() {
            return this.rgId + " should have " + this.minPartitions + (this.minPartitions != this.maxPartitions ? " to " + this.maxPartitions : "") + " partitions if balanced, but has " + this.actualCount;
        }

        @Override
        public boolean isViolation() {
            return false;
        }

        @Override
        public TopologyCheck.Remedy getRemedy() {
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.actualCount;
            result = 31 * result + this.maxPartitions;
            result = 31 * result + this.minPartitions;
            result = 31 * result + (this.rgId == null ? 0 : this.rgId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof NonOptimalNumPartitions)) {
                return false;
            }
            NonOptimalNumPartitions other = (NonOptimalNumPartitions)obj;
            if (this.actualCount != other.actualCount) {
                return false;
            }
            if (this.maxPartitions != other.maxPartitions) {
                return false;
            }
            if (this.minPartitions != other.minPartitions) {
                return false;
            }
            return !(this.rgId == null ? other.rgId != null : !this.rgId.equals(other.rgId));
        }
    }

    public static class UnderCapacity
    implements RulesProblem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final StorageNodeId snId;
        private final int rnCount;
        private final int capacityVal;

        UnderCapacity(StorageNodeId snId, int rnCount, int capacityVal) {
            this.snId = snId;
            this.rnCount = rnCount;
            this.capacityVal = capacityVal;
        }

        @Override
        public ResourceId getResourceId() {
            return this.snId;
        }

        public String toString() {
            return this.snId + " has " + this.rnCount + " RepNodes and is under its capacity limit of " + this.capacityVal;
        }

        @Override
        public boolean isViolation() {
            return false;
        }

        @Override
        public TopologyCheck.Remedy getRemedy() {
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.capacityVal;
            result = 31 * result + this.rnCount;
            result = 31 * result + (this.snId == null ? 0 : this.snId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof UnderCapacity)) {
                return false;
            }
            UnderCapacity other = (UnderCapacity)obj;
            if (this.capacityVal != other.capacityVal) {
                return false;
            }
            if (this.rnCount != other.rnCount) {
                return false;
            }
            return !(this.snId == null ? other.snId != null : !this.snId.equals(other.snId));
        }
    }

    public static class RNHeapExceedsSNMemory
    implements RulesProblem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final StorageNodeId snId;
        private final long memoryMB;
        private final Set<RepNodeId> rnIds;
        private final long totalRNHeapMB;
        private final String rnMemList;

        public RNHeapExceedsSNMemory(StorageNodeId snId, int memoryMB, Set<RepNodeId> rnIds, long totalRNHeapMB, String rnMemList) {
            this.snId = snId;
            this.memoryMB = memoryMB;
            this.rnIds = rnIds;
            this.totalRNHeapMB = totalRNHeapMB;
            this.rnMemList = rnMemList;
        }

        public String toString() {
            return this.snId + " is hosting " + (this.rnIds == null ? 0 : this.rnIds.size()) + " RNs whose combined heap of " + this.totalRNHeapMB + "MB exceeds the SN's limit of " + this.memoryMB + "MB. Resident RNs are " + this.rnMemList;
        }

        @Override
        public ResourceId getResourceId() {
            return this.snId;
        }

        @Override
        public boolean isViolation() {
            return true;
        }

        @Override
        public TopologyCheck.Remedy getRemedy() {
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.memoryMB ^ this.memoryMB >>> 32);
            result = 31 * result + (this.rnIds == null ? 0 : this.rnIds.hashCode());
            result = 31 * result + (this.rnMemList == null ? 0 : this.rnMemList.hashCode());
            result = 31 * result + (this.snId == null ? 0 : this.snId.hashCode());
            result = 31 * result + (int)(this.totalRNHeapMB ^ this.totalRNHeapMB >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RNHeapExceedsSNMemory)) {
                return false;
            }
            RNHeapExceedsSNMemory other = (RNHeapExceedsSNMemory)obj;
            if (this.memoryMB != other.memoryMB) {
                return false;
            }
            if (this.rnIds == null ? other.rnIds != null : !this.rnIds.equals(other.rnIds)) {
                return false;
            }
            if (this.rnMemList == null ? other.rnMemList != null : !this.rnMemList.equals(other.rnMemList)) {
                return false;
            }
            if (this.snId == null ? other.snId != null : !this.snId.equals(other.snId)) {
                return false;
            }
            return this.totalRNHeapMB == other.totalRNHeapMB;
        }
    }

    public static class OverCapacity
    implements RulesProblem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final StorageNodeId snId;
        private final int rnCount;
        private final int capacityVal;

        OverCapacity(StorageNodeId snId, int rnCount, int capacityVal) {
            this.snId = snId;
            this.rnCount = rnCount;
            this.capacityVal = capacityVal;
        }

        @Override
        public ResourceId getResourceId() {
            return this.snId;
        }

        public String toString() {
            return this.snId + " has " + this.rnCount + " repNodes and is over its capacity limit of " + this.capacityVal;
        }

        @Override
        public boolean isViolation() {
            return true;
        }

        @Override
        public TopologyCheck.Remedy getRemedy() {
            return null;
        }

        public int getExcess() {
            return this.rnCount - this.capacityVal;
        }

        public StorageNodeId getSNId() {
            return this.snId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.capacityVal;
            result = 31 * result + this.rnCount;
            result = 31 * result + (this.snId == null ? 0 : this.snId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof OverCapacity)) {
                return false;
            }
            OverCapacity other = (OverCapacity)obj;
            if (this.capacityVal != other.capacityVal) {
                return false;
            }
            if (this.rnCount != other.rnCount) {
                return false;
            }
            return !(this.snId == null ? other.snId != null : !this.snId.equals(other.snId));
        }
    }

    public static class RNProximity
    implements RulesProblem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final StorageNodeId snId;
        private final RepGroupId rgId;
        private final List<RepNodeId> rnIds;

        RNProximity(StorageNodeId snId, RepGroupId rgId, List<RepNodeId> rnIds) {
            this.snId = snId;
            this.rgId = rgId;
            this.rnIds = rnIds;
        }

        @Override
        public ResourceId getResourceId() {
            return this.snId;
        }

        public String toString() {
            return this.snId + " has too many RNs from the same shard(" + this.rgId + "): " + this.rnIds;
        }

        @Override
        public boolean isViolation() {
            return true;
        }

        @Override
        public TopologyCheck.Remedy getRemedy() {
            return null;
        }

        public StorageNodeId getSNId() {
            return this.snId;
        }

        public List<RepNodeId> getRNList() {
            return this.rnIds;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.rgId == null ? 0 : this.rgId.hashCode());
            result = 31 * result + (this.rnIds == null ? 0 : this.rnIds.hashCode());
            result = 31 * result + (this.snId == null ? 0 : this.snId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RNProximity)) {
                return false;
            }
            RNProximity other = (RNProximity)obj;
            if (this.rgId == null ? other.rgId != null : !this.rgId.equals(other.rgId)) {
                return false;
            }
            if (this.rnIds == null ? other.rnIds != null : !this.rnIds.equals(other.rnIds)) {
                return false;
            }
            return !(this.snId == null ? other.snId != null : !this.snId.equals(other.snId));
        }
    }

    public static class ExcessRNs
    implements RulesProblem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final DatacenterId dcId;
        private final int requiredRF;
        private final RepGroupId rgId;
        private final int numExcess;

        ExcessRNs(DatacenterId dcId, int requiredRF, RepGroupId rgId, int numExcess) {
            this.dcId = dcId;
            this.requiredRF = requiredRF;
            this.rgId = rgId;
            this.numExcess = numExcess;
        }

        @Override
        public ResourceId getResourceId() {
            return this.rgId;
        }

        public String toString() {
            return this.rgId + " has " + this.numExcess + " more RNs than are needed for the required repFactor of " + this.requiredRF + " for " + this.dcId;
        }

        @Override
        public boolean isViolation() {
            return false;
        }

        @Override
        public TopologyCheck.Remedy getRemedy() {
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dcId == null ? 0 : this.dcId.hashCode());
            result = 31 * result + this.numExcess;
            result = 31 * result + this.requiredRF;
            result = 31 * result + (this.rgId == null ? 0 : this.rgId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ExcessRNs)) {
                return false;
            }
            ExcessRNs other = (ExcessRNs)obj;
            if (this.dcId == null ? other.dcId != null : !this.dcId.equals(other.dcId)) {
                return false;
            }
            if (this.numExcess != other.numExcess) {
                return false;
            }
            if (this.requiredRF != other.requiredRF) {
                return false;
            }
            return !(this.rgId == null ? other.rgId != null : !this.rgId.equals(other.rgId));
        }
    }

    public static class InsufficientRNs
    implements RulesProblem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final DatacenterId dcId;
        private final int requiredRF;
        private final RepGroupId rgId;
        private final int numMissing;

        InsufficientRNs(DatacenterId dcId, int requiredRF, RepGroupId rgId, int numMissing) {
            this.dcId = dcId;
            this.requiredRF = requiredRF;
            this.rgId = rgId;
            this.numMissing = numMissing;
        }

        @Override
        public ResourceId getResourceId() {
            return this.rgId;
        }

        public String toString() {
            return this.rgId + " needs " + this.numMissing + " RNs to meet the required repFactor of " + this.requiredRF + " for " + this.dcId;
        }

        @Override
        public boolean isViolation() {
            return true;
        }

        @Override
        public TopologyCheck.Remedy getRemedy() {
            return null;
        }

        DatacenterId getDCId() {
            return this.dcId;
        }

        int getNumNeeded() {
            return this.numMissing;
        }

        RepGroupId getRGId() {
            return this.rgId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dcId == null ? 0 : this.dcId.hashCode());
            result = 31 * result + this.numMissing;
            result = 31 * result + this.requiredRF;
            result = 31 * result + (this.rgId == null ? 0 : this.rgId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof InsufficientRNs)) {
                return false;
            }
            InsufficientRNs other = (InsufficientRNs)obj;
            if (this.dcId == null ? other.dcId != null : !this.dcId.equals(other.dcId)) {
                return false;
            }
            if (this.numMissing != other.numMissing) {
                return false;
            }
            if (this.requiredRF != other.requiredRF) {
                return false;
            }
            return !(this.rgId == null ? other.rgId != null : !this.rgId.equals(other.rgId));
        }
    }

    public static interface RulesProblem
    extends VerifyConfiguration.Problem {
        public boolean isViolation();

        public TopologyCheck.Remedy getRemedy();
    }
}

