/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.topo;

import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.text.DateFormat;
import java.util.Date;
import oracle.kv.impl.admin.plan.DeploymentInfo;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.FormatUtils;
import oracle.kv.impl.util.TopologyPrinter;

@Entity
public class RealizedTopology {
    @PrimaryKey
    private Long deployStartMillis;
    private String candidateName;
    private String planName;
    private int planId;
    private Topology topology;

    private RealizedTopology() {
    }

    public RealizedTopology(String storeName) {
        this.topology = new Topology(storeName);
        this.candidateName = "none";
        this.planName = "none";
        this.planId = 0;
        this.setStartTime();
    }

    public RealizedTopology(Topology topo, DeploymentInfo info) {
        this.deployStartMillis = info.getDeployStartTime();
        this.topology = topo;
        this.planName = info.getPlanName();
        this.planId = info.getPlanId();
        this.candidateName = info.getCandidateName();
    }

    public void setStartTime() {
        this.deployStartMillis = System.currentTimeMillis();
    }

    public long getStartTime() {
        return this.deployStartMillis;
    }

    public Topology getTopology() {
        return this.topology;
    }

    public void setTopology(Topology topo) {
        this.topology = topo;
    }

    public String display(boolean concise) {
        StringBuilder sb = new StringBuilder();
        sb.append("deployTime=");
        DateFormat fm = FormatUtils.getDateTimeAndTimeZoneFormatter();
        sb.append(fm.format(new Date(this.deployStartMillis)));
        sb.append(" plan=").append(this.planId).append("/").append(this.planName);
        sb.append(" candidate=").append(this.candidateName);
        if (!concise) {
            sb.append('\n');
            sb.append(TopologyPrinter.printTopology(this.topology));
        }
        return sb.toString();
    }
}

