/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.registry.RegistryUtils;

@Persistent(version=1)
public class WriteNewSNParams
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private AbstractPlan plan;
    private ParameterMap newParams;
    private StorageNodeId targetSNId;

    public WriteNewSNParams(AbstractPlan plan, StorageNodeId targetSNId, ParameterMap newParams) {
        this.plan = plan;
        this.newParams = newParams;
        this.targetSNId = targetSNId;
    }

    private WriteNewSNParams() {
    }

    @Override
    public Task.State doWork() throws Exception {
        ParameterMap mountMap;
        Admin admin = this.plan.getAdmin();
        StorageNodeParams snp = admin.getStorageNodeParams(this.targetSNId);
        ParameterMap snMap = snp.getMap();
        ParameterMap parameterMap = mountMap = this.newParams.getName().equals("mountPoints") ? this.newParams : null;
        if (mountMap != null) {
            this.plan.getLogger().info("Changing storage directories for " + this.targetSNId + ": " + mountMap);
            mountMap.remove("storageNodeId");
            snp.setMountMap(mountMap);
            snMap = null;
        } else {
            ParameterMap diff = snMap.diff(this.newParams, true);
            snMap.merge(this.newParams, true);
            this.plan.getLogger().info("Changing these params for " + this.targetSNId + ": " + diff);
        }
        admin.updateParams(snp, null);
        Topology topology = admin.getCurrentTopology();
        LoginManager loginMgr = admin.getLoginManager();
        RegistryUtils registryUtils = new RegistryUtils(topology, loginMgr);
        StorageNodeAgentAPI sna = registryUtils.getStorageNodeAgent(this.targetSNId);
        sna.newStorageNodeParameters(snMap != null ? snMap : mountMap);
        return Task.State.SUCCEEDED;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + " write new " + this.targetSNId + " parameters into the Admin database: " + this.newParams.showContents();
    }
}

