/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.registry.RegistryUtils;

@Persistent
public class WriteNewGlobalParams
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private boolean continuePastError;
    private AbstractPlan plan;
    private ParameterMap newParamMap;
    private StorageNodeId targetSNId;

    public WriteNewGlobalParams(AbstractPlan plan, ParameterMap newParams, StorageNodeId targetSNId, boolean continuePastError) {
        this.plan = plan;
        this.newParamMap = newParams;
        this.continuePastError = continuePastError;
        this.targetSNId = targetSNId;
    }

    private WriteNewGlobalParams() {
    }

    @Override
    public boolean continuePastError() {
        return this.continuePastError;
    }

    @Override
    public Task.State doWork() throws Exception {
        Admin admin = this.plan.getAdmin();
        GlobalParams gp = admin.getCurrentParameters().getGlobalParams();
        ParameterMap gpMap = gp.getMap();
        ParameterMap diff = gpMap.diff(this.newParamMap, true);
        this.plan.getLogger().info("Changing Global params for " + this.targetSNId + ": " + diff);
        gpMap.merge(this.newParamMap, true);
        admin.updateParams(gp);
        Topology topology = admin.getCurrentTopology();
        LoginManager loginMgr = admin.getLoginManager();
        RegistryUtils registryUtils = new RegistryUtils(topology, loginMgr);
        StorageNodeAgentAPI sna = registryUtils.getStorageNodeAgent(this.targetSNId);
        sna.newGlobalParameters(gpMap);
        return Task.State.SUCCEEDED;
    }

    @Override
    public String toString() {
        return super.toString() + " write new global parameters into the Admin database and SN " + this.targetSNId + "'s configuration file : " + this.newParamMap.showContents();
    }
}

