/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.TopologyCheck;
import oracle.kv.impl.admin.VerifyConfiguration;
import oracle.kv.impl.admin.VerifyResults;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;

@Persistent
public class VerifyAndRepair
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private AbstractPlan plan;
    private boolean shouldContinuePastError;

    VerifyAndRepair() {
    }

    public VerifyAndRepair(AbstractPlan plan, boolean continuePastError) {
        this.plan = plan;
        this.shouldContinuePastError = continuePastError;
    }

    @Override
    public String getName() {
        return "VerifyAndRepair";
    }

    @Override
    public boolean continuePastError() {
        return this.shouldContinuePastError;
    }

    @Override
    public Task.State doWork() throws Exception {
        Admin admin = this.plan.getAdmin();
        VerifyConfiguration checker = new VerifyConfiguration(admin, false, true, false, this.plan.getLogger());
        checker.verifyTopology();
        VerifyResults results = checker.getResults();
        TopologyCheck topoCheck = checker.getTopoChecker();
        this.plan.getLogger().info("Found repairs: " + checker.getRepairs());
        topoCheck.applyRemedies(checker.getRepairs(), this.plan);
        topoCheck.repairInitialEmptyShards(results, this.plan, this.plan.getDeployedInfo());
        return Task.State.SUCCEEDED;
    }
}

