/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.DeployTopoPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.Topology;

@Persistent(version=1)
public class UpdateDatacenter
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private DatacenterId dcId;
    private int newRepFactor;
    private DeployTopoPlan plan;

    public UpdateDatacenter(DeployTopoPlan plan, DatacenterId dcId, int newRepFactor) {
        this.plan = plan;
        this.dcId = dcId;
        this.newRepFactor = newRepFactor;
    }

    private UpdateDatacenter() {
    }

    @Override
    public Task.State doWork() throws Exception {
        Topology current = this.plan.getAdmin().getCurrentTopology();
        Datacenter currentdc = current.get(this.dcId);
        if (currentdc.getRepFactor() == this.newRepFactor) {
            return Task.State.SUCCEEDED;
        }
        if (currentdc.getRepFactor() > this.newRepFactor) {
            throw new IllegalCommandException("The proposed replication factor of " + this.newRepFactor + "is less than the current replication factor of " + currentdc.getRepFactor() + " for " + currentdc + ". Oracle NoSQL Database doesn't yet " + " support the ability to reduce replication factor");
        }
        current.update(this.dcId, Datacenter.newInstance(currentdc.getName(), this.newRepFactor, currentdc.getDatacenterType()));
        this.plan.getAdmin().saveTopo(current, this.plan.getDeployedInfo(), this.plan);
        return Task.State.SUCCEEDED;
    }

    @Override
    public String toString() {
        return super.toString() + " zone=" + this.dcId;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }
}

