/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.util.Set;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.SecurityMetadataPlan;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.UpdateMetadata;
import oracle.kv.impl.security.metadata.KVStoreUser;
import oracle.kv.impl.security.metadata.SecurityMetadata;

@Persistent
public class RevokeRoles
extends UpdateMetadata<SecurityMetadata> {
    private static final long serialVersionUID = 1L;
    private String userName;
    private Set<String> roles;

    public RevokeRoles(SecurityMetadataPlan plan, String userName, Set<String> roles) {
        super(plan);
        SecurityMetadata secMd = (SecurityMetadata)plan.getMetadata();
        this.userName = userName;
        this.roles = roles;
        if (secMd == null || secMd.getUser(userName) == null) {
            throw new IllegalCommandException("User with name " + userName + " does not exist in store");
        }
        if (roles.contains("sysadmin")) {
            this.guardLastSystemUser(secMd);
        }
    }

    private void guardLastSystemUser(SecurityMetadata secMd) {
        if (secMd == null) {
            return;
        }
        if (secMd.isLastSysadminUser(this.userName)) {
            throw new IllegalCommandException("Cannot revoke sysadmin role from the last enabled admin user " + this.userName);
        }
    }

    private RevokeRoles() {
    }

    @Override
    protected SecurityMetadata updateMetadata() {
        SecurityMetadata secMd = (SecurityMetadata)this.plan.getMetadata();
        if (secMd == null || secMd.getUser(this.userName) == null) {
            return null;
        }
        KVStoreUser newCopy = secMd.getUser(this.userName).clone();
        secMd.updateUser(newCopy.getElementId(), newCopy.revokeRoles(this.roles));
        this.plan.getAdmin().saveMetadata(secMd, this.plan);
        return secMd;
    }

    @Override
    public boolean logicalCompare(Task t) {
        if (this == t) {
            return true;
        }
        if (t == null) {
            return false;
        }
        if (this.getClass() != t.getClass()) {
            return false;
        }
        RevokeRoles other = (RevokeRoles)t;
        if (!this.userName.equals(other.userName)) {
            return false;
        }
        return this.roles.equals(other.roles);
    }
}

