/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.admin.plan.TopologyPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class RemoveSN
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private StorageNodeId target;
    private TopologyPlan plan;

    public RemoveSN(TopologyPlan plan, StorageNodeId target) {
        this.plan = plan;
        this.target = target;
    }

    private RemoveSN() {
    }

    @Override
    public Task.State doWork() throws Exception {
        Topology currentTopo = this.plan.getTopology();
        currentTopo.remove(this.target);
        if (this.plan.isFirstExecutionAttempt()) {
            this.plan.getAdmin().saveTopoAndRemoveSN(currentTopo, this.plan.getDeployedInfo(), this.target, this.plan);
        }
        if (!Utils.broadcastTopoChangesToRNs(this.plan.getLogger(), currentTopo, "remove SN " + this.target, this.plan.getAdmin().getParams().getAdminParams(), this.plan)) {
            return Task.State.INTERRUPTED;
        }
        return Task.State.SUCCEEDED;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }
}

