/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import oracle.kv.impl.admin.plan.task.JobWrapper;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.param.DurationParameter;

public class NextJob {
    public static final NextJob END_WITH_SUCCESS = new NextJob(Task.State.SUCCEEDED, null, null);
    private final Task.State prevJobTaskState;
    private final JobWrapper followOnWork;
    private final TimeUnit timeUnit;
    private final long time;
    private final String additionalInfo;

    public NextJob(Task.State prevJobState, JobWrapper followOnWork, DurationParameter scheduleInterval, String additionalInfo) {
        this.prevJobTaskState = prevJobState;
        this.followOnWork = followOnWork;
        if ((prevJobState == Task.State.ERROR || prevJobState == Task.State.SUCCEEDED || prevJobState == Task.State.INTERRUPTED) && followOnWork != null) {
            throw new IllegalStateException("Task state was " + (Object)((Object)prevJobState) + " and there should not be any" + " additional task work.");
        }
        if (scheduleInterval == null) {
            this.timeUnit = TimeUnit.SECONDS;
            this.time = 0L;
        } else {
            this.timeUnit = scheduleInterval.getUnit();
            this.time = scheduleInterval.getAmount();
        }
        this.additionalInfo = additionalInfo;
    }

    public NextJob(Task.State prevJobState, JobWrapper followOnWork, DurationParameter scheduleInterval) {
        this(prevJobState, followOnWork, scheduleInterval, null);
    }

    public NextJob(Task.State prevJobState, String additionalInfo) {
        this(prevJobState, null, null, additionalInfo);
    }

    public Task.State getPrevJobTaskState() {
        return this.prevJobTaskState;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public long getDelay() {
        return this.time;
    }

    public Callable<Task.State> getNextCallable() {
        return this.followOnWork;
    }

    public String toString() {
        if (this.followOnWork != null) {
            return this.followOnWork.getDescription() + " scheduled in " + this.time + " " + (Object)((Object)this.timeUnit);
        }
        return "none";
    }

    public String getDescription() {
        if (this.followOnWork == null) {
            return "no work";
        }
        return this.followOnWork.getDescription();
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }
}

