/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.util.HashSet;
import java.util.Set;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.admin.plan.PortTracker;
import oracle.kv.impl.admin.plan.TopologyPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;

@Persistent(version=1)
public class MigrateParamsAndTopo
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private StorageNodeId oldNode;
    private StorageNodeId newNode;
    private TopologyPlan plan;
    private int httpPort;
    private Set<RepNodeParams> changedRepNodeParams;
    private Set<AdminParams> changedAdminParams;

    public MigrateParamsAndTopo(TopologyPlan plan, StorageNodeId oldNode, StorageNodeId newNode, int httpPort) {
        this.oldNode = oldNode;
        this.newNode = newNode;
        this.plan = plan;
        this.httpPort = httpPort;
        this.changedAdminParams = new HashSet<AdminParams>();
        this.changedRepNodeParams = new HashSet<RepNodeParams>();
    }

    private MigrateParamsAndTopo() {
    }

    @Override
    public Task.State doWork() throws Exception {
        Parameters parameters = this.plan.getAdmin().getCurrentParameters();
        PortTracker portTracker = new PortTracker(this.plan.getTopology(), parameters, this.newNode);
        this.transferParamsToNewNode(parameters, portTracker);
        this.transferTopoToNewNode();
        if (this.plan.isFirstExecutionAttempt()) {
            this.plan.getAdmin().saveTopoAndParams(this.plan.getTopology(), this.plan.getDeployedInfo(), this.changedRepNodeParams, this.changedAdminParams, (Plan)this.plan);
        } else {
            this.plan.getAdmin().saveParams(this.changedRepNodeParams, this.changedAdminParams);
        }
        if (!Utils.broadcastTopoChangesToRNs(this.plan.getLogger(), this.plan.getTopology(), "replace " + this.oldNode + " with " + this.newNode, this.plan.getAdmin().getParams().getAdminParams(), this.plan)) {
            return Task.State.INTERRUPTED;
        }
        return Task.State.SUCCEEDED;
    }

    private void transferParamsToNewNode(Parameters parameters, PortTracker portTracker) {
        String nodeHostPort;
        int haPort;
        String newNodeHAHostname = parameters.get(this.newNode).getHAHostname();
        AdminId foundAdmin = null;
        for (AdminParams ap : parameters.getAdminParams()) {
            if (!ap.getStorageNodeId().equals(this.oldNode)) continue;
            if (foundAdmin != null) {
                throw new NonfatalAssertionException("More than one admin service exists on " + this.oldNode + ": " + foundAdmin + ", " + ap.getAdminId());
            }
            foundAdmin = ap.getAdminId();
            ap.setStorageNodeId(this.newNode);
            ap.setHttpPort(this.httpPort);
            haPort = portTracker.getNextPort(this.newNode);
            nodeHostPort = newNodeHAHostname + ":" + haPort;
            this.plan.getLogger().info("transferring HA port for " + foundAdmin + " from " + ap.getNodeHostPort() + " to " + nodeHostPort);
            ap.setJEInfo(nodeHostPort, this.findAdminHelpers(parameters, ap.getAdminId()));
            this.changedAdminParams.add(ap);
        }
        for (RepNodeParams rnp : parameters.getRepNodeParams()) {
            if (!rnp.getStorageNodeId().equals(this.oldNode)) continue;
            rnp.setStorageNodeId(this.newNode);
            haPort = portTracker.getNextPort(this.newNode);
            nodeHostPort = newNodeHAHostname + ":" + haPort;
            this.plan.getLogger().info("transferring HA port for " + rnp.getRepNodeId() + " from " + rnp.getJENodeHostPort() + " to " + nodeHostPort);
            rnp.setJENodeHostPort(nodeHostPort);
            rnp.setJEHelperHosts(this.findRNHelpers(parameters, rnp.getRepNodeId()));
            this.changedRepNodeParams.add(rnp);
        }
    }

    private String findRNHelpers(Parameters parameters, RepNodeId rnId) {
        Topology topo = this.plan.getTopology();
        RepNode targetRN = topo.get(rnId);
        RepGroup rg = topo.get(targetRN.getRepGroupId());
        StringBuilder helperHosts = new StringBuilder();
        for (RepNode rn : rg.getRepNodes()) {
            if (((RepNodeId)rn.getResourceId()).equals(rnId)) continue;
            if (helperHosts.length() != 0) {
                helperHosts.append(",");
            }
            RepNodeParams peerParams = parameters.get((RepNodeId)rn.getResourceId());
            helperHosts.append(peerParams.getJENodeHostPort());
        }
        return helperHosts.toString();
    }

    private String findAdminHelpers(Parameters parameters, AdminId adId) {
        StringBuilder helperHosts = new StringBuilder();
        for (AdminParams otherParams : parameters.getAdminParams()) {
            if (otherParams.getAdminId().equals(adId)) continue;
            if (helperHosts.length() != 0) {
                helperHosts.append(",");
            }
            helperHosts.append(otherParams.getNodeHostPort());
        }
        return helperHosts.toString();
    }

    private void transferTopoToNewNode() {
        Topology topo = this.plan.getTopology();
        for (RepGroup rg : topo.getRepGroupMap().getAll()) {
            for (RepNode rn : rg.getRepNodes()) {
                if (!rn.getStorageNodeId().equals(this.oldNode)) continue;
                RepNode updatedRN = new RepNode(this.newNode);
                rg.update((RepNodeId)rn.getResourceId(), updatedRN);
            }
        }
    }

    @Override
    public boolean continuePastError() {
        return false;
    }
}

