/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.util.logging.Logger;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.plan.DeployTopoPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class DeployShard
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    protected DeployTopoPlan plan;
    private int planShardIdx;
    private String snDescList;

    public DeployShard(DeployTopoPlan plan, int planShardIdx, String snDescList) {
        this.plan = plan;
        this.planShardIdx = planShardIdx;
        this.snDescList = snDescList;
    }

    DeployShard() {
    }

    @Override
    public Task.State doWork() throws Exception {
        Logger logger = this.plan.getLogger();
        Admin plannerAdmin = this.plan.getAdmin();
        Topology current = plannerAdmin.getCurrentTopology();
        RepGroupId shardId = this.plan.getShardId(this.planShardIdx);
        if (shardId != null) {
            RepGroup rg = current.get(shardId);
            if (rg != null) {
                logger.info(shardId + " was previously created.");
                return Task.State.SUCCEEDED;
            }
            this.plan.setNewShardId(this.planShardIdx, null);
            logger.fine(shardId + " not present in topology, although saved " + "in plan, reset and repeat creation.");
        }
        RepGroup repGroup = new RepGroup();
        current.add(repGroup);
        this.plan.setNewShardId(this.planShardIdx, (RepGroupId)repGroup.getResourceId());
        plannerAdmin.saveTopo(current, this.plan.getDeployedInfo(), this.plan);
        return Task.State.SUCCEEDED;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public String toString() {
        RepGroupId shardId = this.plan.getShardId(this.planShardIdx);
        if (shardId != null) {
            return super.toString() + " " + shardId + " on " + this.snDescList;
        }
        return super.toString() + " on " + this.snDescList;
    }
}

