/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.TopologyPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.Topology;

@Persistent
public class ConfirmDatacenterStatus
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private DatacenterId targetId;
    private TopologyPlan plan;
    private String infoMsg;

    public ConfirmDatacenterStatus(TopologyPlan plan, DatacenterId targetId, String infoMsg) {
        this.targetId = targetId;
        this.plan = plan;
        this.infoMsg = infoMsg;
    }

    private ConfirmDatacenterStatus() {
    }

    @Override
    public Task.State doWork() throws Exception {
        Topology topo = this.plan.getTopology();
        for (StorageNode sn : topo.getSortedStorageNodes()) {
            if (!this.targetId.equals(sn.getDatacenterId())) continue;
            throw new IllegalCommandException(this.infoMsg);
        }
        return Task.State.SUCCEEDED;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }
}

