/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.UnauthorizedException;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.plan.SecurityMetadataPlan;
import oracle.kv.impl.admin.plan.task.UpdateMetadata;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVStoreUserPrincipal;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.security.metadata.KVStoreUser;
import oracle.kv.impl.security.metadata.SecurityMetadata;
import oracle.kv.impl.security.util.SecurityUtils;
import oracle.kv.impl.test.TestStatus;

@Persistent(version=1)
public class ChangeUser
extends UpdateMetadata<SecurityMetadata> {
    private static final long serialVersionUID = 1L;
    private String userName;
    private Boolean isEnabled;
    private char[] plainPassword;
    private boolean retainPassword;
    private boolean clearRetainedPassword;
    private Long pwdLifetime;

    public ChangeUser(SecurityMetadataPlan plan, String userName, Boolean isEnabled, char[] plainPassword, boolean retainPassword, boolean clearRetainedPassword, Long pwdLifetime) {
        super(plan);
        SecurityMetadata secMd = (SecurityMetadata)plan.getMetadata();
        if (secMd == null || secMd.getUser(userName) == null) {
            throw new IllegalCommandException("User with name " + userName + " does not exist!");
        }
        KVStoreUser modifyUser = secMd.getUser(userName);
        ExecutionContext execCtx = ExecutionContext.getCurrent();
        if (execCtx == null) {
            if (!TestStatus.isActive()) {
                throw new AuthenticationRequiredException("Authentication required for access", false);
            }
        } else {
            Subject reqSubject = execCtx.requestorSubject();
            KVStoreUserPrincipal reqUser = ExecutionContext.getSubjectUserPrincipal(reqSubject);
            if (reqUser != null && !modifyUser.getElementId().equals(reqUser.getUserId()) && !execCtx.hasPrivilege(SystemPrivilege.SYSOPER)) {
                throw new UnauthorizedException("Admin privilege is required in order to modify other users.");
            }
        }
        if (isEnabled != null && !isEnabled.booleanValue() && secMd.isLastSysadminUser(userName)) {
            throw new IllegalCommandException("Cannot disable the last enabled admin user " + userName);
        }
        if (!clearRetainedPassword && retainPassword && secMd.getUser(userName).retainedPasswordValid()) {
            throw new IllegalCommandException("Could not retain password: existing retained password should be cleared first.");
        }
        this.userName = userName;
        this.isEnabled = isEnabled;
        this.plainPassword = plainPassword == null ? null : Arrays.copyOf(plainPassword, plainPassword.length);
        this.retainPassword = retainPassword;
        this.clearRetainedPassword = clearRetainedPassword;
        this.pwdLifetime = pwdLifetime;
    }

    private ChangeUser() {
    }

    @Override
    protected SecurityMetadata updateMetadata() {
        SecurityMetadata secMd = (SecurityMetadata)this.plan.getMetadata();
        if (secMd == null || secMd.getUser(this.userName) == null) {
            return null;
        }
        KVStoreUser newCopy = secMd.getUser(this.userName).clone();
        if (this.isEnabled != null) {
            newCopy.setEnabled(this.isEnabled);
        }
        if (this.clearRetainedPassword || !newCopy.retainedPasswordValid()) {
            newCopy.clearRetainedPassword();
        }
        if (this.plainPassword != null) {
            if (this.retainPassword) {
                try {
                    newCopy.retainPassword();
                    newCopy.getRetainedPassword().setLifetime(TimeUnit.MILLISECONDS.convert(24L, TimeUnit.HOURS));
                }
                catch (IllegalStateException ise) {}
            } else {
                newCopy.clearRetainedPassword();
            }
            GlobalParams params = this.plan.getAdmin().getParams().getGlobalParams();
            long duration = params.getPasswordDefaultLifeTime();
            newCopy.setPassword(((SecurityMetadataPlan)this.plan).makeDefaultHashDigest(this.plainPassword)).setPasswordLifetime(params.getPasswordDefaultLifeTimeUnit().toMillis(duration));
            SecurityUtils.clearPassword(this.plainPassword);
        }
        if (this.pwdLifetime != null) {
            newCopy.setPasswordLifetime(this.pwdLifetime);
        }
        secMd.updateUser(newCopy.getElementId(), newCopy);
        this.plan.getAdmin().saveMetadata(secMd, this.plan);
        return secMd;
    }
}

