/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.util.Arrays;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.plan.SecurityMetadataPlan;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.UpdateMetadata;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.security.metadata.KVStoreUser;
import oracle.kv.impl.security.metadata.SecurityMetadata;
import oracle.kv.impl.security.util.SecurityUtils;

@Persistent(version=1)
public class AddUser
extends UpdateMetadata<SecurityMetadata> {
    private static final long serialVersionUID = 1L;
    private String userName;
    private boolean isEnabled;
    private boolean isAdmin;
    private char[] plainPassword;
    private Long pwdLifeTime;

    public AddUser(SecurityMetadataPlan plan, String userName, boolean isEnabled, boolean isAdmin, char[] plainPassword, Long pwdLifetime) {
        super(plan);
        KVStoreUser preExistUser;
        SecurityMetadata secMd = (SecurityMetadata)plan.getMetadata();
        if (!(secMd != null && !secMd.getAllUsers().isEmpty() || isAdmin && isEnabled)) {
            throw new IllegalCommandException("The first user in the store must be -admin and enabled.");
        }
        this.userName = userName;
        this.isAdmin = isAdmin;
        this.isEnabled = isEnabled;
        this.plainPassword = Arrays.copyOf(plainPassword, plainPassword.length);
        this.pwdLifeTime = pwdLifetime;
        if (secMd != null && (preExistUser = secMd.getUser(userName)) != null) {
            this.checkPreExistingUser(preExistUser);
        }
    }

    private AddUser() {
    }

    private void checkPreExistingUser(KVStoreUser user) {
        if (user.isEnabled() != this.isEnabled) {
            throw new IllegalCommandException("User with name " + this.userName + " already exists but has enabled state of " + user.isEnabled() + " rather than the requested enabled state of " + this.isEnabled);
        }
        if (user.isAdmin() != this.isAdmin) {
            throw new IllegalCommandException("User with name " + this.userName + " already exists but has admin setting of " + user.isAdmin() + " rather than the requested admin setting of " + this.isAdmin);
        }
        if (!user.verifyPassword(this.plainPassword)) {
            throw new IllegalCommandException("User with name " + this.userName + " already exists but has different password with the" + " requested one.");
        }
    }

    @Override
    protected SecurityMetadata updateMetadata() {
        SecurityMetadata md = (SecurityMetadata)this.plan.getMetadata();
        if (md == null) {
            String storeName = this.plan.getAdmin().getParams().getGlobalParams().getKVStoreName();
            md = new SecurityMetadata(storeName);
        }
        if (md.getUser(this.userName) == null) {
            boolean enableRoles = Utils.storeHasVersion(this.plan.getAdmin(), SecurityMetadataPlan.BASIC_AUTHORIZATION_VERSION);
            KVStoreUser newUser = KVStoreUser.newInstance(this.userName, enableRoles);
            newUser.setEnabled(this.isEnabled).setAdmin(this.isAdmin).setPassword(((SecurityMetadataPlan)this.plan).makeDefaultHashDigest(this.plainPassword));
            if (this.pwdLifeTime == null) {
                GlobalParams params = this.plan.getAdmin().getParams().getGlobalParams();
                long duration = params.getPasswordDefaultLifeTime();
                newUser.setPasswordLifetime(params.getPasswordDefaultLifeTimeUnit().toMillis(duration));
            } else {
                newUser.setPasswordLifetime(this.pwdLifeTime);
            }
            md.addUser(newUser);
            this.plan.getAdmin().saveMetadata(md, this.plan);
        }
        SecurityUtils.clearPassword(this.plainPassword);
        return md;
    }

    @Override
    public boolean logicalCompare(Task t) {
        if (this == t) {
            return true;
        }
        if (t == null) {
            return false;
        }
        if (this.getClass() != t.getClass()) {
            return false;
        }
        AddUser other = (AddUser)t;
        if (!this.userName.equals(other.userName)) {
            return false;
        }
        if (this.isEnabled != other.isEnabled || this.isAdmin != other.isAdmin) {
            return false;
        }
        if (this.pwdLifeTime == null ? other.pwdLifeTime != null : !this.pwdLifeTime.equals(other.pwdLifeTime)) {
            return false;
        }
        return Arrays.equals(this.plainPassword, other.plainPassword);
    }
}

