/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.AdminServiceParams;
import oracle.kv.impl.admin.plan.DeployTopoPlan;
import oracle.kv.impl.admin.plan.task.AddPartitions;
import oracle.kv.impl.admin.plan.task.BroadcastMetadata;
import oracle.kv.impl.admin.plan.task.BroadcastTopo;
import oracle.kv.impl.admin.plan.task.CheckRNMemorySettings;
import oracle.kv.impl.admin.plan.task.DeployNewRN;
import oracle.kv.impl.admin.plan.task.DeployShard;
import oracle.kv.impl.admin.plan.task.MigratePartition;
import oracle.kv.impl.admin.plan.task.NewNthRNParameters;
import oracle.kv.impl.admin.plan.task.NewRepNodeParameters;
import oracle.kv.impl.admin.plan.task.ParallelBundle;
import oracle.kv.impl.admin.plan.task.RelocateRN;
import oracle.kv.impl.admin.plan.task.UpdateDatacenter;
import oracle.kv.impl.admin.plan.task.UpdateHelperHost;
import oracle.kv.impl.admin.plan.task.UpdateNthRNHelperHost;
import oracle.kv.impl.admin.topo.TopologyCandidate;
import oracle.kv.impl.admin.topo.TopologyDiff;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.security.metadata.SecurityMetadata;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.server.LoggerUtils;

class TopoTaskGenerator {
    private final DeployTopoPlan plan;
    private final TopologyCandidate candidate;
    private final Logger logger;
    private final TopologyDiff diff;

    TopoTaskGenerator(DeployTopoPlan plan, Topology source, TopologyCandidate candidate, AdminServiceParams adminServiceParams) {
        this.plan = plan;
        this.candidate = candidate;
        this.logger = LoggerUtils.getLogger(this.getClass(), adminServiceParams);
        this.diff = new TopologyDiff(source, null, candidate, plan.getAdmin().getCurrentParameters());
        this.logger.log(Level.FINE, "task generator sees diff of {0}", this.diff.display(true));
    }

    void generate() {
        this.makeDatacenterUpdates();
        this.makeRelocatedRNTasks();
        this.makeCreateRNTasks();
        this.plan.addTask(new BroadcastTopo(this.plan));
        SecurityMetadata md = this.plan.getAdmin().getMetadata(SecurityMetadata.class, Metadata.MetadataType.SECURITY);
        this.plan.addTask(new BroadcastMetadata<SecurityMetadata>(this.plan, md));
        this.makePartitionTasks();
    }

    private void makeDatacenterUpdates() {
        for (Datacenter dc : this.candidate.getTopology().getSortedDatacenters()) {
            this.plan.addTask(new UpdateDatacenter(this.plan, (DatacenterId)dc.getResourceId(), dc.getRepFactor()));
        }
    }

    private void makeCreateRNTasks() {
        Topology target = this.candidate.getTopology();
        List<RepGroupId> newShards = this.diff.getNewShards();
        for (int planShardIdx = 0; planShardIdx < newShards.size(); ++planShardIdx) {
            RepGroupId candidateShard = newShards.get(planShardIdx);
            TopologyDiff.ShardChange change = this.diff.getShardChange(candidateShard);
            String snSetDescription = change.getSNSetDescription(target);
            if (change.getRelocatedRNs().size() > 0) {
                throw new IllegalStateException("New shard " + candidateShard + " to be deployed on " + snSetDescription + ", should not host existing RNs " + change.getRelocatedRNs());
            }
            this.plan.addTask(new DeployShard(this.plan, planShardIdx, snSetDescription));
            ArrayList<RepNodeId> newRnIds = new ArrayList<RepNodeId>(change.getNewRNs());
            Iterator i = newRnIds.iterator();
            while (i.hasNext()) {
                RepNodeId rnId = (RepNodeId)i.next();
                Datacenter dc = target.getDatacenter(rnId);
                if (!dc.getDatacenterType().isPrimary()) continue;
                i.remove();
                newRnIds.add(0, rnId);
                break;
            }
            for (RepNodeId proposedRNId : newRnIds) {
                RepNode rn = target.get(proposedRNId);
                String newMountPoint = this.diff.getMountPoint(proposedRNId);
                this.plan.addTask(new DeployNewRN(this.plan, rn.getStorageNodeId(), planShardIdx, newMountPoint));
            }
            for (int i2 = 0; i2 < change.getNewRNs().size(); ++i2) {
                this.plan.addTask(new UpdateNthRNHelperHost(this.plan, planShardIdx, i2));
                this.plan.addTask(new NewNthRNParameters(this.plan, planShardIdx, i2));
            }
        }
        for (Map.Entry<RepGroupId, TopologyDiff.ShardChange> change : this.diff.getChangedShards().entrySet()) {
            RepGroupId rgId = change.getKey();
            if (newShards.contains(rgId)) continue;
            for (RepNodeId proposedRNId : change.getValue().getNewRNs()) {
                RepNode rn = target.get(proposedRNId);
                String newMountPoint = this.diff.getMountPoint(proposedRNId);
                this.plan.addTask(new DeployNewRN(this.plan, rn.getStorageNodeId(), rgId, newMountPoint));
            }
            for (RepNode member : target.get(rgId).getRepNodes()) {
                RepNodeId rnId = (RepNodeId)member.getResourceId();
                this.plan.addTask(new UpdateHelperHost(this.plan, rnId, rgId));
                this.plan.addTask(new NewRepNodeParameters(this.plan, rnId));
            }
        }
    }

    private void makeRelocatedRNTasks() {
        HashSet<StorageNodeId> sourceSNs = new HashSet<StorageNodeId>();
        for (Map.Entry<RepGroupId, TopologyDiff.ShardChange> change : this.diff.getChangedShards().entrySet()) {
            for (TopologyDiff.RelocatedRN reloc : change.getValue().getRelocatedRNs()) {
                RepNodeId rnId = reloc.getRnId();
                StorageNodeId oldSNId = reloc.getOldSNId();
                StorageNodeId newSNId = reloc.getNewSNId();
                this.plan.addTask(new RelocateRN(this.plan, oldSNId, newSNId, rnId, this.diff.getMountPoint(rnId)));
                sourceSNs.add(oldSNId);
            }
            for (StorageNodeId snId : sourceSNs) {
                this.plan.addTask(new CheckRNMemorySettings(this.plan, snId));
            }
        }
    }

    private void makePartitionTasks() {
        if (this.diff.getNumCreatedPartitions() > 0) {
            List<RepGroupId> newShards = this.diff.getNewShards();
            ArrayList<Integer> partitionCount = new ArrayList<Integer>(newShards.size());
            for (int i = 0; i < newShards.size(); ++i) {
                TopologyDiff.ShardChange change = this.diff.getShardChange(newShards.get(i));
                int newParts = change.getNumNewPartitions();
                partitionCount.add(newParts);
            }
            this.plan.addTask(new AddPartitions(this.plan, partitionCount, this.diff.getNumCreatedPartitions()));
            return;
        }
        if (this.diff.getChangedShards().isEmpty()) {
            return;
        }
        ParallelBundle bundle = new ParallelBundle();
        for (Map.Entry<RepGroupId, TopologyDiff.ShardChange> entry : this.diff.getChangedShards().entrySet()) {
            RepGroupId targetRGId = entry.getKey();
            List<TopologyDiff.RelocatedPartition> pChanges = entry.getValue().getMigrations();
            for (TopologyDiff.RelocatedPartition pt : pChanges) {
                MigratePartition t = new MigratePartition(this.plan, pt.getSourceShard(), targetRGId, pt.getPartitionId());
                bundle.addTask(t);
            }
        }
        if (!bundle.isEmpty()) {
            this.plan.addTask(bundle);
        }
    }
}

