/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.AdminFaultException;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.param.DatacenterParams;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.TopologyPlan;
import oracle.kv.impl.admin.plan.task.DeployDatacenter;
import oracle.kv.impl.admin.topo.Rules;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.DatacenterMap;
import oracle.kv.impl.topo.DatacenterType;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.VersionUtil;

@Persistent
public class DeployDatacenterPlan
extends TopologyPlan {
    private static final long serialVersionUID = 1L;
    private static final KVVersion MULTI_DC_VERSION = KVVersion.R2_1;
    public static final KVVersion SECONDARY_DC_VERSION = KVVersion.R3_0;
    private String datacenterName;
    @Deprecated
    private String comment;
    private DatacenterId datacenterId;
    private Datacenter preexistingDC;
    private DatacenterParams newDCParams;

    DeployDatacenterPlan(AtomicInteger idGen, String planName, Planner planner, Topology topology, String datacenterName, int repFactor, DatacenterType datacenterType) {
        super(idGen, planName, planner, topology);
        this.datacenterName = datacenterName;
        Rules.validateReplicationFactor(repFactor);
        this.preexistingDC = this.getPreexistingDatacenter();
        this.checkVersionRequirements(datacenterType);
        if (this.preexistingDC != null) {
            this.checkPreexistingDCParams(repFactor, datacenterType);
            this.datacenterId = (DatacenterId)this.preexistingDC.getResourceId();
            this.newDCParams = planner.getAdmin().getCurrentParameters().get(this.datacenterId);
        } else {
            Datacenter newDc = Datacenter.newInstance(datacenterName, repFactor, datacenterType);
            this.datacenterId = (DatacenterId)topology.add(newDc).getResourceId();
            this.newDCParams = new DatacenterParams(this.datacenterId, datacenterName);
        }
        this.addTask(new DeployDatacenter(this));
    }

    private Datacenter getPreexistingDatacenter() {
        for (Datacenter dc : this.getTopology().getDatacenterMap().getAll()) {
            if (!dc.getName().equals(this.datacenterName)) continue;
            return dc;
        }
        return null;
    }

    private void checkPreexistingDCParams(int repFactor, DatacenterType datacenterType) {
        if (this.preexistingDC.getRepFactor() != repFactor) {
            throw new IllegalCommandException("Zone " + this.datacenterName + " already exists but has a repFactor of " + this.preexistingDC.getRepFactor() + " rather than the requested repFactor of " + repFactor);
        }
        if (this.preexistingDC.getDatacenterType() != datacenterType) {
            throw new IllegalCommandException("Zone " + this.datacenterName + " already exists but has type " + (Object)((Object)this.preexistingDC.getDatacenterType()) + " rather than the requested type " + (Object)((Object)datacenterType));
        }
    }

    private void checkVersionRequirements(DatacenterType datacenterType) {
        DatacenterMap dcMap;
        Admin admin = this.planner.getAdmin();
        if (datacenterType.isSecondary()) {
            KVVersion storeVersion;
            try {
                storeVersion = admin.getStoreVersion();
            }
            catch (AdminFaultException e) {
                throw new IllegalCommandException("Cannot create zone " + this.datacenterName + " as a secondary zone when unable to confirm" + " that all nodes in the store support secondary" + " zones, which require version " + SECONDARY_DC_VERSION.getNumericVersionString() + " or later.", e);
            }
            if (VersionUtil.compareMinorVersion(storeVersion, SECONDARY_DC_VERSION) < 0) {
                throw new IllegalCommandException("Cannot create zone " + this.datacenterName + " as a secondary zone when not all nodes in the" + " store support secondary zones." + " The highest version supported by all nodes is " + storeVersion.getNumericVersionString() + ", but secondary zones require version " + SECONDARY_DC_VERSION.getNumericVersionString() + " or later.");
            }
        }
        if (this.preexistingDC == null && (dcMap = this.getTopology().getDatacenterMap()).size() > 0) {
            KVVersion storeVersion;
            try {
                storeVersion = admin.getStoreVersion();
            }
            catch (AdminFaultException e) {
                throw new IllegalCommandException("Cannot create another zone when unable to confirm that all nodes in the store support multiple zones, which requires version " + MULTI_DC_VERSION.getNumericVersionString() + " or later." + " Zone " + this.datacenterName + " can't be created because of existing zones: " + dcMap.getAll() + ".", e);
            }
            if (VersionUtil.compareMinorVersion(storeVersion, MULTI_DC_VERSION) < 0) {
                throw new IllegalCommandException("Cannot create another zone when not all nodes in the store support multiple zones. The highest version supported by all nodes is " + storeVersion.getNumericVersionString() + ", but multiple zones requires version " + MULTI_DC_VERSION.getNumericVersionString() + " or later." + " Zone " + this.datacenterName + " can't be created because of existing zones: " + dcMap.getAll() + ".");
            }
        }
    }

    private DeployDatacenterPlan() {
    }

    @Override
    void preExecutionSave() {
        if (this.isFirstExecutionAttempt()) {
            this.getAdmin().saveTopoAndParams(this.getTopology(), this.getDeployedInfo(), this.newDCParams, this);
        }
    }

    @Override
    public String getDefaultName() {
        return "Deploy Zone";
    }

    public String getDatacenterName() {
        return this.datacenterName;
    }

    public int getRepFactor() {
        return this.getTopology().get(this.datacenterId).getRepFactor();
    }
}

