/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.je.Transaction;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.AdminEntity;
import oracle.kv.impl.admin.AdminServiceParams;
import oracle.kv.impl.admin.PlanLocksHeldException;
import oracle.kv.impl.admin.PlanWaiter;
import oracle.kv.impl.admin.plan.DeploymentInfo;
import oracle.kv.impl.admin.plan.ExecutionListener;
import oracle.kv.impl.admin.plan.ExecutionState;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.admin.plan.PlanExecutor;
import oracle.kv.impl.admin.plan.PlanRun;
import oracle.kv.impl.admin.plan.PlanStore;
import oracle.kv.impl.admin.plan.PlanTracker;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.TaskRun;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.TaskList;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.security.ResourceOwner;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.util.SecurityUtils;
import oracle.kv.impl.util.FormatUtils;

@Entity
public abstract class AbstractPlan
implements Plan,
AdminEntity<Integer>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MAXPLANS = 10;
    private static final int INITIAL_PLAN_VERSION = 1;
    private static final int CURRENT_PLAN_VERSION = 2;
    @PrimaryKey
    private int id;
    private String name;
    protected long createTime;
    protected TaskList taskList;
    private ExecutionState executionState;
    protected transient Planner planner;
    private transient LinkedList<ExecutionListener> listeners;
    protected transient Logger logger;
    private transient ResourceOwner owner;
    private transient Integer version;

    public AbstractPlan(AtomicInteger idGenerator, String name, Planner planner) {
        this.version = 2;
        this.id = idGenerator.getAndIncrement();
        planner.getAdmin().saveNextId(idGenerator.get());
        this.name = name == null ? this.getDefaultName() + " (" + this.id + ")" : name;
        this.createTime = System.currentTimeMillis();
        this.taskList = new TaskList(TaskList.ExecutionStrategy.SERIAL);
        this.initTransientFields();
        this.planner = planner;
        this.executionState = new ExecutionState(name);
        this.initWithParams(planner.getAdmin().getParams());
        this.owner = SecurityUtils.currentUserAsOwner();
    }

    AbstractPlan() {
        this.initTransientFields();
    }

    protected synchronized void initTransientFields() {
        this.listeners = new LinkedList();
    }

    private void initWithParams(AdminServiceParams aServiceParams) {
        this.addListener(new PlanTracker(aServiceParams));
    }

    public void initPlansFromDb(Planner planner1, AdminServiceParams aServiceParams) {
        this.planner = planner1;
        this.initWithParams(aServiceParams);
    }

    void setLogger(Logger logger1) {
        this.logger = logger1;
    }

    @Override
    public int getId() {
        return this.id;
    }

    synchronized void validateStartOfRun() {
        this.executionState.validateStartOfNewRun(this);
    }

    synchronized PlanRun startNewRun() {
        return this.executionState.startNewRun();
    }

    @Override
    public abstract boolean isExclusive();

    @Override
    public synchronized Plan.State getState() {
        return this.executionState.getLatestState();
    }

    synchronized void requestApproval() {
        Plan.State currentState = this.getState();
        if (currentState.approvedAndCanExecute()) {
            return;
        }
        this.executionState.setPlanState(this.planner, this, Plan.State.APPROVED, "approval requested");
    }

    synchronized void requestCancellation() {
        this.executionState.setPlanState(this.planner, this, Plan.State.CANCELED, "cancellation requested");
    }

    synchronized boolean cancelIfNotStarted() {
        Plan.State state = this.executionState.getLatestState();
        if (state == Plan.State.CANCELED) {
            return true;
        }
        if (state == Plan.State.PENDING || state == Plan.State.APPROVED) {
            this.executionState.setPlanState(this.planner, this, Plan.State.CANCELED, "cancellation requested");
            return true;
        }
        return false;
    }

    @Override
    public synchronized void markAsInterrupted() {
        Plan.State state = this.executionState.getLatestState();
        if (state == Plan.State.RUNNING) {
            this.executionState.setPlanState(this.planner, this, Plan.State.INTERRUPT_REQUESTED, "plan recovery");
            this.executionState.setPlanState(this.planner, this, Plan.State.INTERRUPTED, "plan recovery");
        } else if (state == Plan.State.INTERRUPT_REQUESTED) {
            this.executionState.setPlanState(this.planner, this, Plan.State.INTERRUPTED, "plan recovery");
        }
    }

    synchronized void setState(PlanRun planRun, Planner planner, Plan.State newState, String msg) {
        planRun.setState(planner, this, newState, msg);
    }

    synchronized void requestInterrupt() {
        PlanRun planRun = this.executionState.getLatestPlanRun();
        if (planRun == null) {
            return;
        }
        if (this.getState() == Plan.State.RUNNING) {
            this.executionState.setPlanState(this.planner, this, Plan.State.INTERRUPT_REQUESTED, "plan interrupt");
            this.planner.getAdmin().savePlan(this, "after interrupt requested");
        }
        planRun.requestInterrupt();
    }

    @Override
    public synchronized void addTask(Task t) {
        this.taskList.add(t);
    }

    @Override
    public TaskList getTaskList() {
        return this.taskList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Plan " + this.id + "[" + this.name + "]";
    }

    @Override
    public Date getCreateTime() {
        return new Date(this.createTime);
    }

    @Override
    public Date getStartTime() {
        return this.executionState.getLatestStartTime();
    }

    @Override
    public Date getEndTime() {
        return this.executionState.getLatestEndTime();
    }

    @Override
    public Planner getPlanner() {
        return this.planner;
    }

    abstract void preExecutionSave();

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void persist(PlanStore planStore, Transaction txn) {
        planStore.persist(txn, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, Plan> fetchActivePlans(PlanStore planStore, Transaction txn, Planner planner, AdminServiceParams aServiceParams) {
        HashMap<Integer, Plan> activePlans = new HashMap<Integer, Plan>();
        PlanStore.PlanCursor cursor = planStore.getPlanCursor(txn, null);
        try {
            AbstractPlan p = cursor.first();
            while (p != null) {
                if (!p.getState().isTerminal()) {
                    p.initPlansFromDb(planner, aServiceParams);
                    activePlans.put(new Integer(p.getId()), p);
                }
                p = cursor.next();
            }
        }
        finally {
            cursor.close();
        }
        return activePlans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getPlanIdRange(PlanStore planStore, Transaction txn, long startTime, long endTime, int howMany, String ownerId) {
        int[] range;
        block14: {
            range = new int[]{0, 0};
            PlanStore.PlanCursor cursor = planStore.getPlanCursor(txn, null);
            int n = 0;
            try {
                block15: {
                    if (startTime != 0L) break block15;
                    AbstractPlan p = cursor.last();
                    while (p != null && n < howMany) {
                        block17: {
                            long creation;
                            block16: {
                                String planOwnerId;
                                if (ownerId == null) break block16;
                                String string = planOwnerId = p.getOwner() == null ? null : p.getOwner().id();
                                if (!ownerId.equals(planOwnerId)) break block17;
                            }
                            if ((creation = p.getCreateTime().getTime()) < endTime) {
                                ++n;
                                range[0] = p.getId();
                            }
                        }
                        p = cursor.prev();
                    }
                    range[1] = n;
                    break block14;
                }
                AbstractPlan p = cursor.first();
                while (p != null) {
                    block19: {
                        long creation;
                        block18: {
                            String planOwnerId;
                            if (ownerId == null) break block18;
                            String string = planOwnerId = p.getOwner() == null ? null : p.getOwner().id();
                            if (!ownerId.equals(planOwnerId)) break block19;
                        }
                        if ((creation = p.getCreateTime().getTime()) >= startTime) {
                            if (range[0] == 0) {
                                range[0] = p.getId();
                            }
                            if (endTime != 0L && creation > endTime || howMany != 0 && n >= howMany) break;
                            ++n;
                        }
                    }
                    p = cursor.next();
                }
                range[1] = n;
            }
            finally {
                cursor.close();
            }
        }
        return range;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, Plan> getPlanRange(PlanStore planStore, Transaction txn, Planner planner, AdminServiceParams aServiceParams, int firstPlanId, int howMany, String ownerId) {
        if (howMany > 10) {
            howMany = 10;
        }
        HashMap<Integer, Plan> fetchedPlans = new HashMap<Integer, Plan>();
        PlanStore.PlanCursor cursor = planStore.getPlanCursor(txn, firstPlanId);
        try {
            AbstractPlan p = cursor.first();
            while (p != null && howMany > 0) {
                block10: {
                    block9: {
                        String planOwnerId;
                        if (ownerId == null) break block9;
                        String string = planOwnerId = p.getOwner() == null ? null : p.getOwner().id();
                        if (!ownerId.equals(planOwnerId)) break block10;
                    }
                    p.initPlansFromDb(planner, aServiceParams);
                    p.stripForDisplay();
                    fetchedPlans.put(new Integer(p.getId()), p);
                    --howMany;
                }
                p = cursor.next();
            }
        }
        finally {
            cursor.close();
        }
        return fetchedPlans;
    }

    public static Plan fetchPlanById(int id, PlanStore planStore, Transaction txn, Planner planner, AdminServiceParams aServiceParams) {
        AbstractPlan p = planStore.fetch(txn, id);
        if (p != null) {
            p.initPlansFromDb(planner, aServiceParams);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Map<Integer, Plan> fetchRecentPlansForDisplay(int howMany, PlanStore planStore, Transaction txn, Planner planner, AdminServiceParams aServiceParams) {
        HashMap<Integer, Plan> fetchedPlans = new HashMap<Integer, Plan>();
        PlanStore.PlanCursor cursor = planStore.getPlanCursor(txn, null);
        try {
            AbstractPlan p = cursor.last();
            for (int n = 0; p != null && n < howMany; ++n) {
                p.initPlansFromDb(planner, aServiceParams);
                p.stripForDisplay();
                fetchedPlans.put(new Integer(p.getId()), p);
                p = cursor.prev();
            }
        }
        finally {
            cursor.close();
        }
        return fetchedPlans;
    }

    abstract void stripForDisplay();

    public Admin getAdmin() {
        if (this.planner != null) {
            return this.planner.getAdmin();
        }
        return null;
    }

    synchronized void addListener(ExecutionListener listener) {
        this.listeners.addFirst(listener);
    }

    synchronized List<ExecutionListener> getListeners() {
        return new ArrayList<ExecutionListener>(this.listeners);
    }

    @Override
    public synchronized PlanRun addWaiter(PlanWaiter waiter) {
        this.listeners.addLast(waiter);
        if (this.logger != null) {
            this.logger.log(Level.FINE, "Adding plan waiter to {0}/{1}, state={2}", new Object[]{this.getId(), this.getName(), this.getState()});
        }
        if (this.getState().planExecutionFinished()) {
            waiter.planEnd(this);
        }
        return this.getExecutionState().getLatestPlanRun();
    }

    @Override
    public synchronized void removeWaiter(PlanWaiter waiter) {
        this.listeners.remove(waiter);
    }

    @Override
    public String getLatestRunFailureDescription() {
        return this.executionState.getLatestRunFailureDescription();
    }

    ExecutionState.ExceptionTransfer getExceptionTransfer() {
        return this.executionState.getLatestExceptionTransfer();
    }

    @Override
    public String showRuns() {
        return this.executionState.showRuns();
    }

    @Override
    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    @Override
    public int getTotalTaskCount() {
        return this.taskList.getTotalTaskCount();
    }

    public synchronized boolean isInterruptRequested() {
        return this.executionState.getLatestPlanRun().isInterruptRequested();
    }

    public synchronized boolean cleanupInterrupted() {
        return this.executionState.getLatestPlanRun().cleanupInterrupted();
    }

    synchronized void setCleanupStarted() {
        this.executionState.getLatestPlanRun().setCleanupStarted();
    }

    @Override
    public void describeFinished(Formatter fm, List<TaskRun> finished, int errorCount, boolean verbose) {
        if (verbose) {
            for (TaskRun tRun : finished) {
                if (tRun.getState() == Task.State.ERROR) {
                    this.describeOneFailedTask(fm, tRun);
                    continue;
                }
                fm.format("   Task %3d %11s at %25s: %s\n", new Object[]{tRun.getTaskNum(), tRun.getState(), FormatUtils.formatDateAndTime(tRun.getEndTime()), tRun.getTask()});
                String details = tRun.displayTaskDetails("              ");
                if (details == null) continue;
                fm.format("%s\n", details);
            }
            return;
        }
        if (errorCount > 0) {
            fm.format("\nFailures:", new Object[0]);
            for (TaskRun tRun : finished) {
                if (tRun.getState() != Task.State.ERROR) continue;
                this.describeOneFailedTask(fm, tRun);
            }
        }
    }

    void describeOneFailedTask(Formatter fm, TaskRun tRun) {
        String failDesc = tRun.getFailureDescription();
        if (failDesc == null) {
            fm.format("   Task %3d %11s at %25s: %s\n", new Object[]{tRun.getTaskNum(), tRun.getState(), FormatUtils.formatDateAndTime(tRun.getEndTime()), tRun.getTask()});
        } else {
            fm.format("   Task %3d %11s at %25s: %s: %s\n", new Object[]{tRun.getTaskNum(), tRun.getState(), FormatUtils.formatDateAndTime(tRun.getEndTime()), tRun.getTask(), failDesc});
        }
    }

    @Override
    public void describeRunning(Formatter fm, List<TaskRun> running, boolean verbose) {
        for (TaskRun tRun : running) {
            fm.format("   Task %d/%s started at %s\n", tRun.getTaskNum(), tRun.getTask(), FormatUtils.formatDateAndTime(tRun.getStartTime()));
        }
    }

    @Override
    public void describeNotStarted(Formatter fm, List<Task> notStarted, boolean verbose) {
        for (Task t : notStarted) {
            fm.format("   Task %s\n", t);
        }
    }

    @Override
    public void getCatalogLocks() throws PlanLocksHeldException {
        this.getPerTaskLocks();
    }

    protected void getPerTaskLocks() throws PlanLocksHeldException {
        for (Task t : this.taskList.getTasks()) {
            t.lockTopoComponents(this.planner);
        }
    }

    @Override
    public void preExecuteCheck(boolean force, Logger plannerlogger) {
    }

    public void upgradeToV3() {
        for (PlanRun pr : this.executionState.getHistory()) {
            pr.upgradeToV3(this.taskList.getTasks());
        }
    }

    synchronized void saveFailure(TaskRun taskRun, Throwable t, String problemDescription, Logger logger2) {
        taskRun.saveFailure(t, problemDescription, logger2);
    }

    synchronized void setTaskState(TaskRun taskRun, Task.State taskState, Logger logger2) {
        taskRun.setState(taskState, logger2);
    }

    @Override
    public synchronized void saveFailure(PlanRun planRun, Throwable t, String problem, Logger logger2) {
        planRun.saveFailure(t, problem, logger2);
    }

    synchronized TaskRun startTask(PlanRun planRun, Task task, Logger logger2) {
        return planRun.startTask(task, logger2);
    }

    synchronized void setEndTime(PlanRun planRun) {
        planRun.setEndTime();
    }

    synchronized void incrementEndCount(PlanRun planRun, Task.State state) {
        planRun.incrementEndCount(state);
    }

    synchronized void cleanupEnded(TaskRun taskRun) {
        taskRun.cleanupEnded();
    }

    synchronized void cleanupStarted(TaskRun taskRun) {
        taskRun.cleanupStarted();
    }

    synchronized void saveCleanupFailure(TaskRun taskRun, String info) {
        taskRun.saveCleanupFailure(info);
    }

    @Override
    public synchronized ExecutionState.ExceptionTransfer getLatestRunExceptionTransfer() {
        PlanRun run = this.executionState.getLatestPlanRun();
        if (run == null) {
            return null;
        }
        return run.getExceptionTransfer();
    }

    @Override
    public boolean updatingMetadata(Metadata<?> metadata) {
        return false;
    }

    public LoginManager getLoginManager() {
        return this.getAdmin().getLoginManager();
    }

    public DeploymentInfo getDeployedInfo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResourceOwner getOwner() {
        return this.owner;
    }

    @Override
    public Integer getIndexKey() {
        return this.id;
    }

    @Override
    public AdminEntity.EntityType getEntityType() {
        return AdminEntity.EntityType.PLAN;
    }

    @Override
    public boolean logicalCompare(Plan other) {
        if (this.getClass() != other.getClass()) {
            return false;
        }
        List<Task> tasks = PlanExecutor.getFlatTaskList(this, 0);
        List<Task> otherTasks = PlanExecutor.getFlatTaskList(other, 0);
        if (tasks.size() != otherTasks.size()) {
            return false;
        }
        for (int i = 0; i < tasks.size(); ++i) {
            Task otherTask;
            Task myTask = tasks.get(i);
            if (myTask.logicalCompare(otherTask = otherTasks.get(i))) continue;
            return false;
        }
        return true;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.version = in.readByte();
        }
        catch (EOFException eofe) {
            this.initTransientFields();
            return;
        }
        if (this.version < 1 || this.version > 2) {
            throw new IOException("Unsupported plan version: " + this.version);
        }
        boolean hasOwner = in.readBoolean();
        if (hasOwner) {
            this.owner = (ResourceOwner)in.readObject();
        }
        this.initTransientFields();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.version != null) {
            out.write(this.version);
        } else {
            out.write(1);
        }
        if (this.owner != null) {
            out.writeBoolean(true);
            out.writeObject(this.owner);
        } else {
            out.writeBoolean(false);
        }
    }

    void setVersion(int version) {
        this.version = version;
    }
}

