/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.param;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.kv.impl.admin.param.RMISocketPolicyBuilder;
import oracle.kv.impl.admin.param.RepNetConfigBuilder;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.ClearTransport;
import oracle.kv.impl.security.ssl.SSLTransport;
import oracle.kv.impl.util.registry.ClearSocketPolicy;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RMISocketPolicy;

public class SecurityParams {
    public static final String TRANS_TYPE_FACTORY = "factory";
    public static final String TRANS_TYPE_SSL = "ssl";
    public static final String TRANS_TYPE_CLEAR = "clear";
    private RMISocketPolicy clientRMISocketPolicy;
    private RMISocketPolicy trustedRMISocketPolicy;
    private final ParameterMap map;
    private final Map<String, ParameterMap> transportMaps;
    private File configDir;

    public SecurityParams() {
        this.map = new ParameterMap();
        this.map.setValidate(true);
        this.map.setName("params");
        this.map.setType("securityParams");
        this.transportMaps = new HashMap<String, ParameterMap>();
    }

    public SecurityParams(ParameterMap map) {
        this.map = map;
        map.setName("params");
        map.setType("securityParams");
        this.transportMaps = new HashMap<String, ParameterMap>();
        this.configDir = null;
    }

    public SecurityParams(LoadParameters lp, File configFile) {
        this.map = lp.getMapByType("securityParams");
        this.map.setName("params");
        this.map.setType("securityParams");
        this.transportMaps = new HashMap<String, ParameterMap>();
        for (ParameterMap pm : lp.getAllMaps("transportParams")) {
            this.transportMaps.put(pm.getName(), pm);
        }
        if (configFile != null) {
            File absConfigFile = configFile.getAbsoluteFile();
            this.configDir = absConfigFile.getParentFile();
        }
    }

    public static SecurityParams makeDefault() {
        SecurityParams sp = new SecurityParams();
        sp.setSecurityEnabled(false);
        sp.addTransportMap("client");
        sp.setTransType("client", TRANS_TYPE_CLEAR);
        sp.addTransportMap("internal");
        sp.setTransType("internal", TRANS_TYPE_CLEAR);
        sp.addTransportMap("ha");
        sp.setTransType("ha", TRANS_TYPE_CLEAR);
        return sp;
    }

    public boolean isSecure() {
        return this.getSecurityEnabled();
    }

    public boolean getSecurityEnabled() {
        return this.map.get("securityEnabled").asBoolean();
    }

    public void setSecurityEnabled(boolean enabled) {
        this.map.setParameter("securityEnabled", Boolean.toString(enabled));
    }

    void setConfigDir(File cfgDir) {
        this.configDir = cfgDir;
    }

    public File getConfigDir() {
        return this.configDir;
    }

    public ParameterMap getMap() {
        return this.map;
    }

    public Collection<ParameterMap> getTransportMaps() {
        return this.transportMaps.values();
    }

    public void addTransportMap(ParameterMap newMap, String name) {
        newMap.setName(name);
        newMap.setType("transportParams");
        this.transportMaps.put(name, newMap);
    }

    public void addTransportMap(String name) {
        ParameterMap transportMap = this.transportMaps.get(name);
        if (transportMap == null) {
            transportMap = new ParameterMap();
            transportMap.setValidate(true);
            transportMap.setName(name);
            transportMap.setType("transportParams");
            this.transportMaps.put(name, transportMap);
        }
    }

    public ParameterMap getTransportMap(String name) {
        return this.transportMaps.get(name);
    }

    public File resolveFile(String filename) {
        if (filename == null) {
            return null;
        }
        File origFile = new File(filename);
        if (!origFile.isAbsolute() && this.configDir != null) {
            return new File(this.configDir.getPath(), origFile.getPath());
        }
        return origFile;
    }

    public String getKeystoreFile() {
        return this.map.get("keystore").asString();
    }

    public void setKeystoreFile(String keystoreFile) {
        this.map.setParameter("keystore", keystoreFile);
    }

    public String getKeystoreType() {
        return this.map.get("keystoreType").asString();
    }

    public void setKeystoreType(String keystoreType) {
        this.map.setParameter("keystoreType", keystoreType);
    }

    public String getKeystoreSigPrivateKeyAlias() {
        String ksPrivateKeyAlias = this.map.get("keystoreSigPrivateKeyAlias").asString();
        if (ksPrivateKeyAlias != null && !ksPrivateKeyAlias.isEmpty()) {
            return ksPrivateKeyAlias;
        }
        return null;
    }

    public void setKeystoreSigPrivateKeyAlias(String keyAlias) {
        this.map.setParameter("keystoreSigPrivateKeyAlias", keyAlias);
    }

    public String getTruststoreFile() {
        return this.map.get("truststore").asString();
    }

    public void setTruststoreFile(String truststoreFile) {
        this.map.setParameter("truststore", truststoreFile);
    }

    public String getTruststoreType() {
        return this.map.get("truststoreType").asString();
    }

    public void setTruststoreType(String truststoreType) {
        this.map.setParameter("truststoreType", truststoreType);
    }

    public String getTruststoreSigPublicKeyAlias() {
        String tsPublicKeyAlias = this.map.get("truststoreSigPublicKeyAlias").asString();
        if (tsPublicKeyAlias != null && !tsPublicKeyAlias.isEmpty()) {
            return tsPublicKeyAlias;
        }
        return null;
    }

    public void setTruststoreSigPublicKeyAlias(String keyAlias) {
        this.map.setParameter("truststoreSigPublicKeyAlias", keyAlias);
    }

    public String getPasswordFile() {
        return this.map.get("passwordFile").asString();
    }

    public void setPasswordFile(String passwordFile) {
        this.map.setParameter("passwordFile", passwordFile);
    }

    public String getPasswordClass() {
        return this.map.get("passwordClass").asString();
    }

    public void setPasswordClass(String passwordClass) {
        this.map.setParameter("passwordClass", passwordClass);
    }

    public String getWalletDir() {
        return this.map.get("walletDir").asString();
    }

    public void setWalletDir(String walletDir) {
        this.map.setParameter("walletDir", walletDir);
    }

    public String getInternalAuth() {
        return this.map.get("internalAuth").asString();
    }

    public void setInternalAuth(String internalAuth) {
        this.map.setParameter("internalAuth", internalAuth);
    }

    public String getCertMode() {
        return this.map.get("certMode").asString();
    }

    public void setCertMode(String certMode) {
        this.map.setParameter("certMode", certMode);
    }

    public String getKeystorePasswordAlias() {
        String ksPwdAlias = this.map.get("keystorePasswordAlias").asString();
        if (ksPwdAlias != null && ksPwdAlias.length() > 0) {
            return ksPwdAlias;
        }
        return null;
    }

    public void setKeystorePasswordAlias(String alias) {
        this.map.setParameter("keystorePasswordAlias", alias);
    }

    public String getSignatureAlgorithm() {
        return this.map.get("signatureAlgorithm").asString();
    }

    public void setSignatureAlgorithm(String sigAlgo) {
        this.map.setParameter("signatureAlgorithm", sigAlgo);
    }

    public String getTransType(String transport) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        return this.getTransType(transportMap);
    }

    public String getTransType(ParameterMap transportMap) {
        return transportMap.get("transportType").asString();
    }

    public void setTransType(String transport, String transType) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        this.setTransType(transportMap, transType);
    }

    public void setTransType(ParameterMap transportMap, String transType) {
        transportMap.setParameter("transportType", transType);
    }

    public String getTransFactory(String transport) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        return this.getTransFactory(transportMap);
    }

    public String getTransFactory(ParameterMap transportMap) {
        return transportMap.get("transportFactory").asString();
    }

    public void setTransFactory(String transport, String factory) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        this.setTransFactory(transportMap, factory);
    }

    public void setTransFactory(ParameterMap transportMap, String factory) {
        transportMap.setParameter("transportFactory", factory);
    }

    public String getTransServerKeyAlias(String transport) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        return this.getTransServerKeyAlias(transportMap);
    }

    public String getTransServerKeyAlias(ParameterMap transportMap) {
        return transportMap.get("serverKeyAlias").asString();
    }

    public void setTransServerKeyAlias(String transport, String alias) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        this.setTransServerKeyAlias(transportMap, alias);
    }

    public void setTransServerKeyAlias(ParameterMap transportMap, String alias) {
        transportMap.setParameter("serverKeyAlias", alias);
    }

    public String getTransClientKeyAlias(String transport) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        return this.getTransClientKeyAlias(transportMap);
    }

    public String getTransClientKeyAlias(ParameterMap transportMap) {
        return transportMap.get("clientKeyAlias").asString();
    }

    public void setTransClientKeyAlias(String transport, String alias) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        this.setTransClientKeyAlias(transportMap, alias);
    }

    public void setTransClientKeyAlias(ParameterMap transportMap, String alias) {
        transportMap.setParameter("clientKeyAlias", alias);
    }

    public String getTransAllowCipherSuites(String transport) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        return this.getTransAllowCipherSuites(transportMap);
    }

    public String getTransAllowCipherSuites(ParameterMap transportMap) {
        return transportMap.get("allowCipherSuites").asString();
    }

    public void setTransAllowCipherSuites(String transport, String allowedSuites) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        this.setTransAllowCipherSuites(transportMap, allowedSuites);
    }

    public void setTransAllowCipherSuites(ParameterMap transportMap, String allowedSuites) {
        transportMap.setParameter("allowCipherSuites", allowedSuites);
    }

    public String getTransAllowProtocols(String transport) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        return this.getTransAllowProtocols(transportMap);
    }

    public String getTransAllowProtocols(ParameterMap transportMap) {
        return transportMap.get("allowProtocols").asString();
    }

    public void setTransAllowProtocols(String transport, String allowedProtocols) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        this.setTransAllowProtocols(transportMap, allowedProtocols);
    }

    public void setTransAllowProtocols(ParameterMap transportMap, String allowedProtocols) {
        transportMap.setParameter("allowProtocols", allowedProtocols);
    }

    public String getTransClientAllowCipherSuites(String transport) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        return this.getTransClientAllowCipherSuites(transportMap);
    }

    public String getTransClientAllowCipherSuites(ParameterMap transportMap) {
        return transportMap.get("clientAllowCipherSuites").asString();
    }

    public void setTransClientAllowCipherSuites(String transport, String allowedSuites) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        this.setTransClientAllowCipherSuites(transportMap, allowedSuites);
    }

    public void setTransClientAllowCipherSuites(ParameterMap transportMap, String allowedSuites) {
        transportMap.setParameter("clientAllowCipherSuites", allowedSuites);
    }

    public String getTransClientAllowProtocols(String transport) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        return this.getTransClientAllowProtocols(transportMap);
    }

    public String getTransClientAllowProtocols(ParameterMap transportMap) {
        return transportMap.get("clientAllowProtocols").asString();
    }

    public void setTransClientAllowProtocols(String transport, String allowedProtocols) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        this.setTransClientAllowProtocols(transportMap, allowedProtocols);
    }

    public void setTransClientAllowProtocols(ParameterMap transportMap, String allowedProtocols) {
        transportMap.setParameter("clientAllowProtocols", allowedProtocols);
    }

    public String getTransClientIdentityAllowed(String transport) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        return this.getTransClientIdentityAllowed(transportMap);
    }

    public String getTransClientIdentityAllowed(ParameterMap transportMap) {
        return transportMap.get("clientIdentityAllowed").asString();
    }

    public void setTransClientIdentityAllowed(String transport, String identAllowed) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        this.setTransClientIdentityAllowed(transportMap, identAllowed);
    }

    public void setTransClientIdentityAllowed(ParameterMap transportMap, String identAllowed) {
        transportMap.setParameter("clientIdentityAllowed", identAllowed);
    }

    public boolean getTransClientAuthRequired(String transport) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        return this.getTransClientAuthRequired(transportMap);
    }

    public boolean getTransClientAuthRequired(ParameterMap transportMap) {
        return transportMap.get("clientAuthRequired").asBoolean();
    }

    public void setTransClientAuthRequired(String transport, boolean authRequired) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        this.setTransClientAuthRequired(transportMap, authRequired);
    }

    public void setTransClientAuthRequired(ParameterMap transportMap, boolean authRequired) {
        transportMap.setParameter("clientAuthRequired", Boolean.toString(authRequired));
    }

    public String getTransServerIdentityAllowed(String transport) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        return this.getTransServerIdentityAllowed(transportMap);
    }

    public String getTransServerIdentityAllowed(ParameterMap transportMap) {
        return transportMap.get("serverIdentityAllowed").asString();
    }

    public void setTransServerIdentityAllowed(String transport, String identAllowed) {
        ParameterMap transportMap = this.requireTransportMap(transport);
        this.setTransServerIdentityAllowed(transportMap, identAllowed);
    }

    public void setTransServerIdentityAllowed(ParameterMap transportMap, String identAllowed) {
        transportMap.setParameter("serverIdentityAllowed", identAllowed);
    }

    public RMISocketPolicy getRMISocketPolicy() {
        if (this.clientRMISocketPolicy == null) {
            throw new IllegalStateException("No RMI socket policy is in force");
        }
        return this.clientRMISocketPolicy;
    }

    public RMISocketPolicy getTrustedRMISocketPolicy() {
        return this.trustedRMISocketPolicy;
    }

    public void initRMISocketPolicies() throws IllegalStateException {
        if (this.isSecure()) {
            this.useRMISocketPolicies();
        } else {
            this.useRMISocketPolicyDefaults();
        }
    }

    public Properties getClientAccessProps() {
        String transportName = "client";
        ParameterMap transMap = this.getTransportMap("client");
        RMISocketPolicyBuilder spb = (RMISocketPolicyBuilder)this.makeTransportFactory("client", transMap, RMISocketPolicyBuilder.class);
        Properties props = spb.getClientAccessProperties(this, transMap);
        String transportType = transMap.get("transportType").asString();
        if (transportType != null && !transportType.isEmpty()) {
            props.setProperty("oracle.kv.transport", transportType);
        }
        return props;
    }

    private void useRMISocketPolicies() throws IllegalStateException {
        RMISocketPolicy clientSocketPolicy = this.createClientRMISocketPolicy();
        ClientSocketFactory.setRMIPolicy(clientSocketPolicy);
        this.clientRMISocketPolicy = clientSocketPolicy;
        RMISocketPolicy trustedSocketPolicy = this.createTrustedRMISocketPolicy();
        if (trustedSocketPolicy != null) {
            trustedSocketPolicy.prepareClient(null);
            this.trustedRMISocketPolicy = trustedSocketPolicy;
        }
    }

    private ParameterMap requireTransportMap(String transport) {
        ParameterMap transportMap = this.transportMaps.get(transport);
        if (transportMap == null) {
            throw new IllegalStateException("Transport " + transport + " does not exist");
        }
        return transportMap;
    }

    private void useRMISocketPolicyDefaults() {
        this.clientRMISocketPolicy = SecurityParams.makeDefaultRMISocketPolicy();
        ClientSocketFactory.setRMIPolicy(this.clientRMISocketPolicy);
        this.trustedRMISocketPolicy = null;
    }

    private RMISocketPolicy createClientRMISocketPolicy() throws IllegalStateException {
        return this.makeRMISocketPolicy("client");
    }

    private RMISocketPolicy createTrustedRMISocketPolicy() throws IllegalStateException {
        RMISocketPolicy internalPolicy = this.makeRMISocketPolicy("internal");
        return internalPolicy.isTrustCapable() ? internalPolicy : null;
    }

    private static RMISocketPolicy makeDefaultRMISocketPolicy() {
        return new ClearSocketPolicy();
    }

    private RMISocketPolicy makeRMISocketPolicy(String transportName) throws IllegalStateException {
        ParameterMap transportParams = this.findTransportParams(transportName);
        RMISocketPolicyBuilder spb = (RMISocketPolicyBuilder)this.makeTransportFactory(transportName, transportParams, RMISocketPolicyBuilder.class);
        try {
            return spb.makeSocketPolicy(this, transportParams);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error contructing RMISocketPolicy using transport class for transport " + transportName, e);
        }
    }

    private RepNetConfigBuilder makeRepNetConfigBuilder(ParameterMap transportParams) throws IllegalStateException {
        String transportName = transportParams.getName();
        return (RepNetConfigBuilder)this.makeTransportFactory(transportName, transportParams, RepNetConfigBuilder.class);
    }

    private ParameterMap findTransportParams(String transportName) throws IllegalStateException {
        ParameterMap transportParams = this.transportMaps.get(transportName);
        if (transportParams == null) {
            throw new IllegalStateException("transport name " + transportName + " does not exist in the configuration");
        }
        return transportParams;
    }

    private Object makeTransportFactory(String transportName, ParameterMap transportParams, Class<?> factoryInterfaceClass) throws IllegalStateException {
        String transportType = this.getTransType(transportParams);
        String transportFactory = null;
        if (transportType == null || transportType.isEmpty() || TRANS_TYPE_FACTORY.equals(transportType)) {
            transportFactory = this.getTransFactory(transportParams);
        } else if (TRANS_TYPE_SSL.equals(transportType)) {
            transportFactory = SSLTransport.class.getName();
        } else if (TRANS_TYPE_CLEAR.equals(transportType)) {
            transportFactory = ClearTransport.class.getName();
        } else {
            throw new IllegalStateException("Transport " + transportName + " has an unrecognized transportType: " + transportType);
        }
        if (transportFactory == null) {
            throw new IllegalStateException("Transport " + transportName + " has no transportFactory parameter specified");
        }
        Class<?> factoryClass = null;
        try {
            factoryClass = Class.forName(transportFactory);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error resolving transport class " + transportFactory + " for transport " + transportName, e);
        }
        Object factoryObject = null;
        try {
            factoryObject = factoryClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error instantiating transport class " + transportFactory + " for transport " + transportName, e);
        }
        if (!factoryInterfaceClass.isInstance(factoryObject)) {
            throw new IllegalStateException("Transport factory class " + transportFactory + " for transport " + transportName + " does not implement " + factoryInterfaceClass.getName());
        }
        return factoryObject;
    }

    public Properties getJEHAProperties() {
        ParameterMap transportParams = this.findTransportParams("ha");
        if (transportParams == null) {
            return new Properties();
        }
        RepNetConfigBuilder builder = this.makeRepNetConfigBuilder(transportParams);
        return builder.makeChannelProperties(this, transportParams);
    }
}

