/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.param;

import com.sleepycat.je.LockMode;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Persistent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.DatacenterParams;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.ParametersHolder;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.param.StorageNodePool;
import oracle.kv.impl.param.Parameter;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class Parameters
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_POOL_NAME = "AllStorageNodes";
    private GlobalParams globalParams;
    private Map<StorageNodeId, StorageNodeParams> storageNodeParams;
    private Map<RepNodeId, RepNodeParams> repNodeParams;
    private Map<DatacenterId, DatacenterParams> datacenterParams;
    private Map<AdminId, AdminParams> adminParams;
    private int nextAdminId;
    private Map<String, StorageNodePool> storageNodePools;
    private ParameterMap policyParams;

    public Parameters(String kvsName) {
        this.globalParams = new GlobalParams(kvsName);
        this.repNodeParams = new HashMap<RepNodeId, RepNodeParams>();
        this.storageNodeParams = new HashMap<StorageNodeId, StorageNodeParams>();
        this.datacenterParams = new HashMap<DatacenterId, DatacenterParams>();
        this.adminParams = new HashMap<AdminId, AdminParams>();
        this.nextAdminId = 1;
        this.storageNodePools = new HashMap<String, StorageNodePool>();
        this.addStorageNodePool(DEFAULT_POOL_NAME);
        this.policyParams = ParameterMap.createDefaultPolicyMap();
    }

    private Parameters() {
    }

    public Parameters(Parameters orig) {
        this.globalParams = new GlobalParams(orig.globalParams.getMap().copy());
        this.repNodeParams = new HashMap<RepNodeId, RepNodeParams>(orig.repNodeParams);
        this.storageNodeParams = new HashMap<StorageNodeId, StorageNodeParams>(orig.storageNodeParams);
        this.datacenterParams = new HashMap<DatacenterId, DatacenterParams>(orig.datacenterParams);
        this.adminParams = new HashMap<AdminId, AdminParams>(orig.adminParams);
        this.nextAdminId = orig.nextAdminId;
        this.storageNodePools = new HashMap<String, StorageNodePool>(orig.storageNodePools);
        this.policyParams = orig.policyParams.copy();
    }

    public ParameterMap copyPolicies() {
        return this.policyParams.copy();
    }

    public ParameterMap getPolicies() {
        return this.policyParams;
    }

    public void setPolicies(ParameterMap newPolicyParams) {
        this.policyParams.merge(newPolicyParams, true);
    }

    public RepNodeParams get(RepNodeId id) {
        return this.repNodeParams.get(id);
    }

    public void add(RepNodeParams rnp) {
        this.update(rnp, true);
    }

    public void update(RepNodeParams rnp) {
        this.update(rnp, false);
    }

    private void update(RepNodeParams rnp, boolean shouldBeFirst) {
        RepNodeId rnid = rnp.getRepNodeId();
        RepNodeParams ov = this.repNodeParams.put(rnid, rnp);
        if (shouldBeFirst && ov != null) {
            throw new NonfatalAssertionException("Attempt to add a duplicate RepNodesParams with id " + rnid);
        }
    }

    public RepNodeParams remove(RepNodeId id) {
        RepNodeParams ov = this.repNodeParams.remove(id);
        if (ov == null) {
            throw new NonfatalAssertionException("Attempt to remove a nonexistent RepNodesParams with id " + id);
        }
        return ov;
    }

    public StorageNodeParams get(StorageNodeId id) {
        return this.storageNodeParams.get(id);
    }

    public void add(StorageNodeParams snp) {
        this.update(snp, true);
    }

    public void update(StorageNodeParams snp) {
        this.update(snp, false);
    }

    private void update(StorageNodeParams snp, boolean shouldBeFirst) {
        StorageNodeId snid = snp.getStorageNodeId();
        StorageNodeParams ov = this.storageNodeParams.put(snid, snp);
        if (shouldBeFirst && ov != null) {
            throw new NonfatalAssertionException("Attempt to add a duplicate StorageNodesParams with id " + snid);
        }
    }

    public StorageNodeParams remove(StorageNodeId id) {
        for (StorageNodePool pool : this.storageNodePools.values()) {
            if (!pool.contains(id)) continue;
            pool.remove(id);
        }
        StorageNodeParams ov = this.storageNodeParams.remove(id);
        return ov;
    }

    public DatacenterParams get(DatacenterId id) {
        return this.datacenterParams.get(id);
    }

    public Map<DatacenterId, DatacenterParams> getDatacenterMap() {
        return this.datacenterParams;
    }

    public void add(DatacenterParams dcp) {
        DatacenterId dcid = dcp.getDatacenterId();
        DatacenterParams ov = this.datacenterParams.put(dcid, dcp);
        if (ov != null) {
            throw new NonfatalAssertionException("Attempt to add a duplicate DatacentersParams with id " + dcid);
        }
    }

    public DatacenterParams remove(DatacenterId id) {
        DatacenterParams ov = this.datacenterParams.remove(id);
        if (ov == null) {
            throw new NonfatalAssertionException("Attempt to remove a nonexistent DatacentersParams with id " + id);
        }
        return ov;
    }

    public AdminParams get(AdminId id) {
        return this.adminParams.get(id);
    }

    public void add(AdminParams ap) {
        AdminId aid = ap.getAdminId();
        AdminParams ov = this.adminParams.put(aid, ap);
        if (ov != null) {
            throw new NonfatalAssertionException("Attempt to add a duplicate AdminParams with id " + aid);
        }
    }

    public void update(AdminParams ap) {
        AdminId aid = ap.getAdminId();
        this.adminParams.put(aid, ap);
    }

    public AdminParams remove(AdminId id) {
        AdminParams ov = this.adminParams.remove(id);
        if (ov == null) {
            throw new NonfatalAssertionException("Attempt to remove a nonexistent AdminsParams with id " + id);
        }
        return ov;
    }

    public AdminId getNextAdminId() {
        return new AdminId(this.nextAdminId++);
    }

    public int getAdminCount() {
        return this.adminParams.size();
    }

    public Set<AdminId> getAdminIds(DatacenterId dcid, Topology topology) {
        if (dcid == null) {
            return this.adminParams.keySet();
        }
        if (topology == null) {
            throw new IllegalArgumentException("topology cannot be null when dcid is non-null");
        }
        HashSet<AdminId> adminIds = new HashSet<AdminId>();
        for (Map.Entry<AdminId, AdminParams> entry : this.adminParams.entrySet()) {
            AdminId aid = entry.getKey();
            AdminParams params = entry.getValue();
            StorageNodeId sid = params.getStorageNodeId();
            if (!dcid.equals(topology.getDatacenter(sid).getResourceId())) continue;
            adminIds.add(aid);
        }
        return adminIds;
    }

    public Set<AdminId> getAdminIds() {
        return this.getAdminIds(null, null);
    }

    public Collection<AdminParams> getAdminParams() {
        return this.adminParams.values();
    }

    public Collection<RepNodeParams> getRepNodeParams() {
        return this.repNodeParams.values();
    }

    public GlobalParams getGlobalParams() {
        return this.globalParams;
    }

    public void update(GlobalParams gp) {
        this.globalParams = gp;
    }

    public Set<String> getStorageNodePoolNames() {
        return this.storageNodePools.keySet();
    }

    public StorageNodePool addStorageNodePool(String name) {
        StorageNodePool newPool = new StorageNodePool(name);
        StorageNodePool ov = this.storageNodePools.put(name, newPool);
        if (ov != null) {
            throw new NonfatalAssertionException("Attempt to add a Pool with a name that is already in use: " + name);
        }
        return newPool;
    }

    public void removeStorageNodePool(String name) {
        if (this.storageNodePools == null) {
            throw new NonfatalAssertionException("Attempt to get StorageNodePools in the wrong context.");
        }
        this.storageNodePools.remove(name);
    }

    public StorageNodePool getStorageNodePool(String name) {
        if (this.storageNodePools == null) {
            throw new NonfatalAssertionException("Attempt to get StorageNodePools in the wrong context.");
        }
        return this.storageNodePools.get(name);
    }

    public void persist(EntityStore estore, Transaction txn) {
        PrimaryIndex ti = estore.getPrimaryIndex(String.class, ParametersHolder.class);
        ti.put(txn, (Object)new ParametersHolder(this));
    }

    public static Parameters fetch(EntityStore estore, Transaction txn) {
        PrimaryIndex ti = estore.getPrimaryIndex(String.class, ParametersHolder.class);
        ParametersHolder holder = (ParametersHolder)ti.get(txn, (Object)ParametersHolder.getKey(), LockMode.READ_COMMITTED);
        return holder == null ? null : holder.getParameters();
    }

    public String printRepNodeParams() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<RepNodeId, RepNodeParams> e : this.repNodeParams.entrySet()) {
            sb.append("\n-- Parameters for ").append(e.getKey());
            sb.append(" --\n");
            ParameterMap pMap = e.getValue().getMap();
            ArrayList<String> sortedParamKeys = new ArrayList<String>(pMap.keys());
            Collections.sort(sortedParamKeys);
            for (String k : sortedParamKeys) {
                Parameter p = pMap.get(k);
                sb.append(k).append(" = ").append(p).append("\n");
            }
        }
        return sb.toString();
    }
}

