/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.param;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.param.SecurityParams;
import oracle.kv.impl.param.DefaultParameter;
import oracle.kv.impl.param.DurationParameter;
import oracle.kv.impl.param.Parameter;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterUtils;
import oracle.kv.impl.param.StringParameter;
import oracle.kv.impl.util.PortRange;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RMISocketPolicy;
import oracle.kv.impl.util.registry.RegistryUtils;

public class BootstrapParams {
    private static final String CSF_EMPTY_STORE_NAME = "$";
    private final ParameterMap map;
    private ParameterMap mountMap;

    public BootstrapParams(ParameterMap map, ParameterMap mountMap) {
        this.map = map;
        map.setName("params");
        map.setType("bootstrapParams");
        this.setMountMap(mountMap);
    }

    public BootstrapParams(String rootDir, String hostname, String haHostname, String haPortRange, String servicePortRange, String storeName, int rmiRegistryPort, int adminHttpPort, int capacity, List<String> mountPoints, boolean isSecure) {
        this.map = new ParameterMap("params", "bootstrapParams");
        this.mountMap = BootstrapParams.createMountMap();
        this.map.setParameter("rootDir", rootDir);
        this.map.setParameter("hostname", hostname);
        this.map.setParameter("haHostname", haHostname);
        this.map.setParameter("haPortRange", haPortRange);
        this.map.setParameter("storeName", storeName);
        this.map.setParameter("registryPort", Integer.toString(rmiRegistryPort));
        this.map.setParameter("adminHttpPort", Integer.toString(adminHttpPort));
        this.map.setParameter("storageNodeId", "0");
        this.map.setParameter("hostingAdmin", Boolean.toString(false));
        if (mountPoints != null) {
            BootstrapParams.addMountPoints(this.mountMap, mountPoints);
        }
        if (capacity > 0) {
            this.setCapacity(capacity);
        }
        if (servicePortRange != null) {
            PortRange.validateService(servicePortRange);
            PortRange.validateDisjoint(haPortRange, servicePortRange);
            this.map.setParameter("servicePortRange", servicePortRange);
            PortRange.validateSufficientPorts(servicePortRange, capacity, isSecure, adminHttpPort != 0, this.getMgmtPorts());
        }
        this.map.setParameter("softwareVersion", KVVersion.CURRENT_VERSION.getNumericVersionString());
    }

    public BootstrapParams(String rootDir, String hostname, String haHostname, String haPortRange, String storeName, int rmiRegistryPort, int adminHttpPort, int capacity, List<String> mountPoints, boolean isSecure) {
        this(rootDir, hostname, haHostname, haPortRange, null, storeName, rmiRegistryPort, adminHttpPort, capacity, mountPoints, isSecure);
    }

    public ParameterMap getMap() {
        return this.map;
    }

    public ParameterMap getMountMap() {
        return this.mountMap;
    }

    public void setMountMap(ParameterMap newMap) {
        if (newMap == null) {
            BootstrapParams.createMountMap();
            return;
        }
        this.mountMap = newMap;
        this.mountMap.setName("mountPoints");
        this.mountMap.setType("bootstrapParams");
        this.mountMap.setValidate(false);
    }

    public List<String> getMountPoints() {
        if (this.mountMap == null) {
            return null;
        }
        return BootstrapParams.getMountPoints(this.mountMap);
    }

    public void addMountPoint(String mp) {
        BootstrapParams.addMountPoint(this.mountMap, mp);
    }

    private static void addMountPoints(ParameterMap mMap, List<String> mountPoints) {
        for (String mountPoint : mountPoints) {
            BootstrapParams.validateMountPoint(mountPoint);
            StringParameter mp = new StringParameter(mountPoint, "");
            mMap.put(mp);
        }
    }

    public static void addMountPoint(ParameterMap mMap, String mp) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(mp);
        BootstrapParams.addMountPoints(mMap, list);
    }

    public static List<String> getMountPoints(ParameterMap mMap) {
        ArrayList<String> mps = new ArrayList<String>(mMap.size());
        for (Parameter p : mMap.values()) {
            mps.add(p.getName());
        }
        return mps;
    }

    public static ParameterMap createMountMap() {
        return new ParameterMap("mountPoints", "bootstrapParams", false, 1);
    }

    public int getRegistryPort() {
        return this.map.getOrZeroInt("registryPort");
    }

    public String getRootdir() {
        return this.map.get("rootDir").asString();
    }

    public void setRootdir(String rootDir) {
        this.map.setParameter("rootDir", rootDir);
    }

    public String getStoreName() {
        return this.map.get("storeName").asString();
    }

    public int getId() {
        return this.map.getOrZeroInt("storageNodeId");
    }

    public void setStoreName(String storeName) {
        this.map.setParameter("storeName", storeName);
    }

    public void setId(int snId) {
        this.map.setParameter("storageNodeId", Integer.toString(snId));
    }

    public String getHostname() {
        return this.map.get("hostname").asString();
    }

    public String getHAHostname() {
        String ret = this.map.get("haHostname").asString();
        if (ret == null) {
            ret = this.getHostname();
        }
        return ret;
    }

    public void setHAHostname(String newName) {
        this.map.setParameter("haHostname", newName);
    }

    public String getHAPortRange() {
        return this.map.get("haPortRange").asString();
    }

    public void setHAPortRange(String newRange) {
        this.map.setParameter("haPortRange", newRange);
    }

    public String getServicePortRange() {
        return this.map.get("servicePortRange").asString();
    }

    public void setServicePortRange(String newRange) {
        this.map.setParameter("servicePortRange", newRange);
    }

    public boolean isHostingAdmin() {
        return this.map.get("hostingAdmin").asBoolean();
    }

    public void setHostingAdmin(boolean value) {
        this.map.setParameter("hostingAdmin", Boolean.toString(value));
    }

    public int getAdminHttpPort() {
        return this.map.getOrZeroInt("adminHttpPort");
    }

    public int getStorageNodeId() {
        return this.map.getOrZeroInt("storageNodeId");
    }

    public int getNumCPUs() {
        return this.map.getOrDefault("numCPUs").asInt();
    }

    public int getCapacity() {
        return this.map.getOrDefault("capacity").asInt();
    }

    public int getMemoryMB() {
        return this.map.getOrDefault("memoryMB").asInt();
    }

    public RMISocketPolicy.SocketFactoryPair getStorageNodeAgentSFP(RMISocketPolicy policy) {
        RMISocketPolicy.SocketFactoryArgs args = new RMISocketPolicy.SocketFactoryArgs();
        if (this.getServicePortRange() == null && policy.isPolicyOptional()) {
            return new RMISocketPolicy.SocketFactoryPair(null, null);
        }
        String csfName = ClientSocketFactory.factoryName(CSF_EMPTY_STORE_NAME, "sna", RegistryUtils.InterfaceType.MAIN.interfaceName());
        args.setSsfName(RegistryUtils.InterfaceType.MAIN.interfaceName()).setSsfBacklog(this.map.getOrDefault("snAdminSOBacklog").asInt()).setSsfPortRange(this.getServicePortRange()).setCsfName(csfName);
        return policy.getBindPair(args);
    }

    public RMISocketPolicy.SocketFactoryPair getSNATrustedLoginSFP(RMISocketPolicy policy) {
        RMISocketPolicy.SocketFactoryArgs args = new RMISocketPolicy.SocketFactoryArgs();
        String csfName = ClientSocketFactory.factoryName(CSF_EMPTY_STORE_NAME, "sna", RegistryUtils.InterfaceType.TRUSTED_LOGIN.interfaceName());
        args.setSsfName(RegistryUtils.InterfaceType.TRUSTED_LOGIN.interfaceName()).setSsfBacklog(this.map.getOrDefault("snLoginSOBacklog").asInt()).setCsfConnectTimeout(this.getDurationParamMillis("snLoginSOConnectTimeout")).setCsfReadTimeout(this.getDurationParamMillis("snLoginSOReadTimeout")).setSsfPortRange(this.getServicePortRange()).setCsfName(csfName);
        return policy.getBindPair(args);
    }

    public static void initRegistryCSF(SecurityParams sp) {
        String registryCsfName = ClientSocketFactory.registryFactoryName();
        RMISocketPolicy.SocketFactoryArgs args = new RMISocketPolicy.SocketFactoryArgs().setCsfName(registryCsfName).setCsfConnectTimeout(BootstrapParams.getDefaultDurationParamMillis("snRegistrySOConnectTimeout")).setCsfReadTimeout(BootstrapParams.getDefaultDurationParamMillis("snMonitorSOReadTimeout"));
        RegistryUtils.setServerRegistryCSF(sp.getRMISocketPolicy().getRegistryCSF(args));
    }

    public void setNumCPUs(int ncpus) {
        this.map.setParameter("numCPUs", Integer.toString(ncpus));
    }

    public void setCapacity(int capacity) {
        this.map.setParameter("capacity", Integer.toString(capacity));
    }

    public void setMemoryMB(int memoryMB) {
        this.map.setParameter("memoryMB", Integer.toString(memoryMB));
    }

    public int getMgmtPorts() {
        if (this.map.exists("mgmtClass")) {
            return 1;
        }
        return 0;
    }

    public String getMgmtClass() {
        return this.map.getOrDefault("mgmtClass").asString();
    }

    public void setMgmtClass(String mgmtClass) {
        this.map.setParameter("mgmtClass", mgmtClass);
    }

    public int getMgmtPollingPort() {
        return this.map.getOrZeroInt("mgmtPollPort");
    }

    public void setMgmtPollingPort(int port) {
        this.map.setParameter("mgmtPollPort", Integer.toString(port));
    }

    public String getMgmtTrapHost() {
        return this.map.get("mgmtTrapHost").asString();
    }

    public void setMgmtTrapHost(String hostname) {
        this.map.setParameter("mgmtTrapHost", hostname);
    }

    public int getMgmtTrapPort() {
        return this.map.getOrZeroInt("mgmtTrapPort");
    }

    public void setMgmtTrapPort(int port) {
        this.map.setParameter("mgmtTrapPort", Integer.toString(port));
    }

    public String getSecurityDir() {
        String result = this.map.get("securityDir").asString();
        return result != null && !result.isEmpty() ? result : null;
    }

    public void setSecurityDir(String dir) {
        this.map.setParameter("securityDir", dir);
    }

    public static void validateMountPoint(String path) {
        if (new File(path).isAbsolute()) {
            return;
        }
        throw new IllegalArgumentException("Illegal storage directory: " + path + ", storage directories must be valid absolute pathnames");
    }

    public KVVersion getSoftwareVersion() {
        String versionString = this.map.get("softwareVersion").toString();
        return versionString == null ? null : KVVersion.parseVersion(versionString);
    }

    public void setSoftwareVersion(KVVersion version) {
        this.map.setParameter("softwareVersion", version.getNumericVersionString());
    }

    private static int getDefaultDurationParamMillis(String param) {
        DurationParameter dp = (DurationParameter)DefaultParameter.getDefaultParameter(param);
        return (int)dp.toMillis();
    }

    private int getDurationParamMillis(String param) {
        return (int)ParameterUtils.getDurationMillis(this.map, param);
    }

    public void setForceBootstrapAdmin(boolean force) {
        this.map.setParameter("forceBootstrapAdmin", Boolean.toString(force));
    }

    public boolean getForceBootstrapAdmin() {
        return this.map.getOrDefault("forceBootstrapAdmin").asBoolean();
    }
}

