/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.client;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.VerifyResults;
import oracle.kv.impl.admin.client.CommandShell;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellException;

class VerifyCommand
extends CommandWithSubs {
    private static final List<? extends CommandWithSubs.SubCommand> subs = Arrays.asList(new VerifyConfig(), new VerifyUpgrade(), new VerifyPrerequisite());

    VerifyCommand() {
        super(subs, "verify", 4, 0);
    }

    @Override
    protected String getCommandOverview() {
        return "The verify command encapsulates commands that check various parameters of the store.";
    }

    @Override
    public String execute(String[] args, Shell shell) throws ShellException {
        if (args.length == 1 || args.length == 2 && args[1].equals("-silent")) {
            String[] stringArray;
            if (args.length == 1) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "verify";
                stringArray = stringArray2;
                stringArray2[1] = "configuration";
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "verify";
                stringArray3[1] = "configuration";
                stringArray = stringArray3;
                stringArray3[2] = "-silent";
            }
            String[] newArgs = stringArray;
            return "The command:" + eol + eolt + "verify [-silent]" + eol + eol + "is deprecated and has been replaced by: " + eol + eolt + "verify configuration [-silent]" + eol + eol + super.execute(newArgs, shell);
        }
        return super.execute(args, shell);
    }

    private static class VerifyPrerequisite
    extends CommandWithSubs.SubCommand {
        private VerifyPrerequisite() {
            super("prerequisite", 3);
        }

        @Override
        protected String getCommandSyntax() {
            return "verify prerequisite [-silent] [-sn snX]*";
        }

        @Override
        protected String getCommandDescription() {
            return "Verifies the storage nodes are at or above the prerequisite software version needed to upgrade to the current version." + eolt + "This call may take a while on a large store.";
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            try {
                boolean showProgress = true;
                ArrayList<StorageNodeId> snIds = null;
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if (arg.equals("-silent")) {
                        showProgress = false;
                        continue;
                    }
                    if ("-sn".equals(arg)) {
                        if (snIds == null) {
                            snIds = new ArrayList<StorageNodeId>(1);
                        }
                        String sn = Shell.nextArg(args, i++, this);
                        try {
                            snIds.add(StorageNodeId.parse(sn));
                        }
                        catch (IllegalArgumentException iae) {
                            shell.invalidArgument(sn, this);
                        }
                        continue;
                    }
                    shell.unknownArgument(arg, this);
                }
                VerifyResults results = cs.verifyPrerequisite(KVVersion.CURRENT_VERSION, KVVersion.PREREQUISITE_VERSION, snIds, showProgress, true);
                return results.display();
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }
    }

    private static class VerifyUpgrade
    extends CommandWithSubs.SubCommand {
        private VerifyUpgrade() {
            super("upgrade", 3);
        }

        @Override
        protected String getCommandSyntax() {
            return "verify upgrade [-silent] [-sn snX]*";
        }

        @Override
        protected String getCommandDescription() {
            return "Verifies the storage nodes (and their managed components) are at or above the current version." + eolt + "This call may take a while on a large store.";
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            try {
                boolean showProgress = true;
                ArrayList<StorageNodeId> snIds = null;
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if (arg.equals("-silent")) {
                        showProgress = false;
                        continue;
                    }
                    if ("-sn".equals(arg)) {
                        if (snIds == null) {
                            snIds = new ArrayList<StorageNodeId>(1);
                        }
                        String sn = Shell.nextArg(args, i++, this);
                        try {
                            snIds.add(StorageNodeId.parse(sn));
                        }
                        catch (IllegalArgumentException iae) {
                            shell.invalidArgument(sn, this);
                        }
                        continue;
                    }
                    shell.unknownArgument(arg, this);
                }
                VerifyResults results = cs.verifyUpgrade(KVVersion.CURRENT_VERSION, snIds, showProgress, true);
                return results.display();
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }
    }

    static class VerifyConfig
    extends CommandWithSubs.SubCommand {
        VerifyConfig() {
            super("configuration", 3);
        }

        @Override
        protected String getCommandSyntax() {
            return "verify configuration [-silent] [-json]";
        }

        @Override
        protected String getCommandDescription() {
            return "Verifies the store configuration by iterating over the components and checking" + eolt + "their state " + "against that expected in the Admin database.  This call " + "may" + eolt + "take a while on a large store.";
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            if (args.length > 2) {
                shell.badArgCount(this);
            }
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            try {
                boolean showProgress = true;
                boolean json = false;
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if ("-silent".equals(arg)) {
                        showProgress = false;
                        continue;
                    }
                    if ("-json".equals(arg)) {
                        json = true;
                        continue;
                    }
                    shell.unknownArgument(arg, this);
                }
                VerifyResults results = cs.verifyConfiguration(showProgress, true, json);
                return results.display();
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }
    }
}

