/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.client;

import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.Snapshot;
import oracle.kv.impl.admin.client.CommandShell;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellException;
import oracle.kv.util.shell.ShellUsageException;

class SnapshotCommand
extends CommandWithSubs {
    private static final List<? extends CommandWithSubs.SubCommand> subs = Arrays.asList(new CreateSnapshotSub(), new RemoveSnapshotSub());

    SnapshotCommand() {
        super(subs, "snapshot", 3, 2);
    }

    @Override
    protected String getCommandOverview() {
        return "The snapshot command encapsulates commands that create and delete snapshots," + eol + "which are used for backup and " + "restore.";
    }

    static abstract class SnapshotSub
    extends CommandWithSubs.SubCommand {
        final boolean isCreate;
        private int numOfOperations;

        protected SnapshotSub(String name, int prefixMatchLength, boolean isCreate) {
            super(name, prefixMatchLength);
            this.isCreate = isCreate;
        }

        public int getNumOfOperations() {
            return this.numOfOperations;
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            String cannotMixMsg = "Use either -zn or -zname";
            String snapName = null;
            String zoneId = null;
            String zoneName = null;
            boolean removeAll = false;
            String zoneInfo = "";
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-name".equals(arg)) {
                    snapName = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-all".equals(arg)) {
                    removeAll = true;
                    continue;
                }
                if ("-zn".equals(arg)) {
                    zoneId = Shell.nextArg(args, i++, this);
                    if (zoneName == null) continue;
                    throw new ShellUsageException("Use either -zn or -zname", this);
                }
                if ("-zname".equals(arg)) {
                    zoneName = Shell.nextArg(args, i++, this);
                    if (zoneId == null) continue;
                    throw new ShellUsageException("Use either -zn or -zname", this);
                }
                shell.unknownArgument(arg, this);
            }
            if (snapName == null && !removeAll) {
                shell.requiredArg("-name", this);
            }
            try {
                Snapshot snapshot = new Snapshot(cs, shell.getVerbose(), shell.getOutput());
                String output = "";
                Topology topology = cs.getTopology();
                DatacenterId dcId = null;
                if (zoneId != null) {
                    dcId = DatacenterId.parse(zoneId);
                    Datacenter dc = topology.get(dcId);
                    if (dc == null) {
                        throw new IllegalArgumentException("The specified zone id does not exist");
                    }
                    zoneInfo = zoneInfo + "zn:[id=" + zoneId + " name=" + dc.getName() + "]";
                }
                if (zoneName != null) {
                    Datacenter zone = topology.getDatacenter(zoneName);
                    if (zone == null) {
                        throw new IllegalArgumentException("The specified zone name does not exist");
                    }
                    dcId = (DatacenterId)zone.getResourceId();
                    zoneInfo = zoneInfo + "zn:[id=" + dcId.getDatacenterId() + " name=" + zoneName + "]";
                }
                if (this.isCreate) {
                    if (removeAll) {
                        shell.invalidArgument("-all", this);
                    }
                    String newSnapName = null;
                    newSnapName = dcId != null ? snapshot.createSnapshot(snapName, dcId) : snapshot.createSnapshot(snapName);
                    if (snapshot.succeeded()) {
                        int numSuccess = snapshot.getSuccesses().size();
                        output = "Created snapshot named " + newSnapName + " on " + "all " + numSuccess + " nodes";
                        if (dcId != null) {
                            output = output + " in zone " + zoneInfo;
                        }
                    } else if (snapshot.getQuorumSucceeded()) {
                        output = "Create snapshot succeeded but not on all nodes" + eol;
                        if (dcId != null) {
                            output = "Create snapshot succeeded but not on all nodes in zone " + zoneInfo + eol;
                        }
                    }
                } else if (removeAll) {
                    if (snapName != null) {
                        shell.invalidArgument("-all", this);
                    }
                    if (dcId != null) {
                        snapshot.removeAllSnapshots(dcId);
                    } else {
                        snapshot.removeAllSnapshots();
                    }
                    if (snapshot.succeeded()) {
                        output = "Removed all snapshots";
                        if (dcId != null) {
                            output = output + " in zone " + zoneInfo;
                        }
                    }
                } else {
                    if (dcId != null) {
                        snapshot.removeSnapshot(snapName, dcId);
                    } else {
                        snapshot.removeSnapshot(snapName);
                    }
                    if (snapshot.succeeded()) {
                        output = "Removed snapshot " + snapName;
                        if (dcId != null) {
                            output = output + " in zone " + zoneInfo;
                        }
                    }
                }
                this.numOfOperations = snapshot.getFailures().size() + snapshot.getSuccesses().size();
                return output;
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
            }
            catch (Exception e) {
                shell.handleUnknownException("Snapshot " + snapName + " failed", e);
            }
            return "";
        }
    }

    static class RemoveSnapshotSub
    extends SnapshotSub {
        RemoveSnapshotSub() {
            super("remove", 3, false);
        }

        @Override
        protected String getCommandSyntax() {
            return "snapshot remove {-name <name> | -all} [-zn <id> | -znname <name>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Removes the named snapshot.  If -all is specified remove all snapshots. If a zone with the specified id or name is specified then the command applies to all the SNs executing in that zone";
        }
    }

    static class CreateSnapshotSub
    extends SnapshotSub {
        CreateSnapshotSub() {
            super("create", 3, true);
        }

        @Override
        protected String getCommandSyntax() {
            return "snapshot create -name <name> [-zn <id> | -znname <name>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Creates a new snapshot using the specified name as the prefix. If a zone with the specified id or name is specified then the command applies to all the SNs executing in that zone";
        }
    }
}

