/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.client;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.client.CommandShell;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellException;

class PoolCommand
extends CommandWithSubs {
    public static final List<? extends CommandWithSubs.SubCommand> subs = Arrays.asList(new CreatePool(), new RemovePool(), new JoinPool());

    PoolCommand() {
        super(subs, "pool", 3, 2);
    }

    @Override
    protected String getCommandOverview() {
        return "Encapsulates commands that manipulates Storage Node pools, which are used for" + eol + "resource allocations.";
    }

    private static class JoinPool
    extends CommandWithSubs.SubCommand {
        JoinPool() {
            super("join", 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            String poolName = null;
            ArrayList<String> storageNodes = new ArrayList<String>();
            ArrayList<StorageNodeId> snids = new ArrayList<StorageNodeId>();
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-name".equals(arg)) {
                    poolName = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-sn".equals(arg)) {
                    String sn = Shell.nextArg(args, i++, this);
                    try {
                        StorageNodeId snid = StorageNodeId.parse(sn);
                        snids.add(snid);
                    }
                    catch (IllegalArgumentException iae) {
                        shell.invalidArgument(sn, this);
                    }
                    storageNodes.add(sn);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (poolName == null) {
                shell.requiredArg("-name", this);
            }
            if (storageNodes.size() == 0) {
                shell.requiredArg("-sn", this);
            }
            try {
                List<String> poolNames = cs.getStorageNodePoolNames();
                if (poolNames.indexOf(poolName) == -1) {
                    return "Pool does not exist: " + poolName;
                }
                Topology t = cs.getTopology();
                for (StorageNodeId snid : snids) {
                    if (t.get(snid) == null) {
                        return "Storage Node does not exist: " + snid;
                    }
                    cs.addStorageNodeToPool(poolName, snid);
                }
                return "Added Storage Node(s) " + snids + " to pool " + poolName;
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "pool join -name <name> [-sn <snX>]*";
        }

        @Override
        protected String getCommandDescription() {
            return "Adds Storage Nodes to an existing Storage Node pool.";
        }
    }

    private static class RemovePool
    extends CommandWithSubs.SubCommand {
        RemovePool() {
            super("remove", 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            String poolName = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-name".equals(arg)) {
                    poolName = Shell.nextArg(args, i++, this);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (poolName == null) {
                shell.requiredArg("-name", this);
            }
            try {
                List<String> poolNames = cs.getStorageNodePoolNames();
                if (poolNames.indexOf(poolName) == -1) {
                    return "Pool does not exist: " + poolName;
                }
                cs.removeStorageNodePool(poolName);
                shell.verboseOutput("Removed pool " + poolName);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
            }
            return "";
        }

        @Override
        protected String getCommandSyntax() {
            return "pool remove -name <name>";
        }

        @Override
        protected String getCommandDescription() {
            return "Removes a Storage Node pool.";
        }
    }

    private static class CreatePool
    extends CommandWithSubs.SubCommand {
        CreatePool() {
            super("create", 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            String poolName = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-name".equals(arg)) {
                    poolName = Shell.nextArg(args, i++, this);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (poolName == null) {
                shell.requiredArg("-name", this);
            }
            try {
                List<String> poolNames = cs.getStorageNodePoolNames();
                if (poolNames.indexOf(poolName) >= 0) {
                    return "Pool already exists: " + poolName;
                }
                cs.addStorageNodePool(poolName);
                shell.verboseOutput("Added pool " + poolName);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
            }
            return "";
        }

        @Override
        protected String getCommandSyntax() {
            return "pool create -name <name>";
        }

        @Override
        protected String getCommandDescription() {
            return "Creates a new Storage Node pool to be used for resource distribution" + eolt + "when creating or modifying " + "a store.";
        }
    }
}

