/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.client;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.client.CommandShell;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.topo.Topology;
import oracle.kv.util.Ping;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellCommand;
import oracle.kv.util.shell.ShellException;

class PingCommand
extends ShellCommand {
    PingCommand() {
        super("ping", 3);
    }

    @Override
    public String execute(String[] args, Shell shell) throws ShellException {
        CommandShell cmd = (CommandShell)shell;
        CommandServiceAPI cs = cmd.getAdmin();
        boolean json = false;
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if ("-json".equals(arg)) {
                json = true;
                continue;
            }
            shell.unknownArgument(arg, this);
        }
        try {
            Topology topo = cs.getTopology();
            Parameters params = cs.getParameters();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(os);
            Ping.pingTopology(topo, params, false, json, ps, cmd.getLoginManager());
            return os.toString();
        }
        catch (RemoteException re) {
            cmd.noAdmin(re);
            return "";
        }
    }

    @Override
    protected String getCommandSyntax() {
        return "ping [-json]";
    }

    @Override
    public String getCommandDescription() {
        return "\"Ping\"s the runtime components of a store." + eolt + "Components available from the Topology are " + "contacted," + eolt + "as well as Admin services.";
    }
}

