/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.client;

import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Iterator;
import java.util.List;
import java.util.logging.LogRecord;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.client.CommandShell;
import oracle.kv.impl.monitor.Tracker;
import oracle.kv.impl.monitor.TrackerListenerImpl;
import oracle.kv.impl.util.LogFormatter;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellCommand;
import oracle.kv.util.shell.ShellException;

class LogtailCommand
extends ShellCommand {
    private RemoteException threadException = null;
    private boolean logTailThreadGo;
    private LogListener lh;
    CommandServiceAPI cs;
    CommandShell cmd;

    LogtailCommand() {
        super("logtail", 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute(String[] args, Shell shell) throws ShellException {
        if (args.length != 1) {
            shell.badArgCount(this);
        }
        this.cmd = (CommandShell)shell;
        this.cs = this.cmd.getAdmin();
        try {
            shell.getOutput().println("(Press <enter> to interrupt.)");
            Thread t = new Thread("logtail"){

                @Override
                public void run() {
                    try {
                        LogtailCommand.this.logtailWorker();
                    }
                    catch (RemoteException e) {
                        LogtailCommand.this.threadException = e;
                    }
                }
            };
            this.threadException = null;
            this.logTailThreadGo = true;
            t.start();
            shell.getInput().readLine();
            LogtailCommand logtailCommand = this;
            synchronized (logtailCommand) {
                this.logTailThreadGo = false;
                t.interrupt();
            }
            t.join();
            if (this.threadException != null) {
                return "Exception from logtail: " + this.threadException.getMessage();
            }
        }
        catch (RemoteException re) {
            this.cmd.noAdmin(re);
        }
        catch (IOException ioe) {
            return "Exception reading input during logtail";
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return "";
    }

    @Override
    public String getCommandDescription() {
        return "Monitors the store-wide log file until interrupted by an \"enter\"" + eolt + "keypress.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void logtailWorker() throws RemoteException {
        long logSince = 0L;
        boolean registered = false;
        try {
            this.lh = new LogListener(logSince, this);
            this.cs.registerLogTrackerListener(this.lh);
            LogFormatter lf = new LogFormatter(null);
            registered = true;
            block12: while (true) {
                List<LogRecord> logEvents;
                LogtailCommand logtailCommand = this;
                synchronized (logtailCommand) {
                    while (true) {
                        if (!this.logTailThreadGo) {
                            try {
                                this.cs.removeLogTrackerListener(this.lh);
                                registered = false;
                            }
                            finally {
                                UnicastRemoteObject.unexportObject(this.lh, true);
                                this.lh = null;
                            }
                            return;
                        }
                        Tracker.RetrievedEvents<LogRecord> logEventsContainer = this.cs.getLogSince(logSince);
                        logEvents = logEventsContainer.getEvents();
                        if (logEvents.size() != 0) {
                            logSince = logEventsContainer.getLastSyntheticTimestamp();
                            this.lh.setInterestingTime(logSince);
                            break;
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {}
                    }
                }
                Iterator<LogRecord> i$ = logEvents.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block12;
                    LogRecord lr = i$.next();
                    this.cmd.getOutput().print(lf.format(lr));
                }
                break;
            }
        }
        finally {
            if (registered) {
                this.cs.removeLogTrackerListener(this.lh);
            }
            if (this.lh != null) {
                UnicastRemoteObject.unexportObject(this.lh, true);
                this.lh = null;
            }
        }
    }

    protected LogListener getLogListener() {
        return this.lh;
    }

    private static class LogListener
    extends TrackerListenerImpl {
        private static final long serialVersionUID = 1L;
        final Object lockObject;

        LogListener(long interestingTime, Object lockObject) throws RemoteException {
            super(interestingTime);
            this.lockObject = lockObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyOfNewEvents() {
            Object object = this.lockObject;
            synchronized (object) {
                this.lockObject.notify();
            }
        }
    }
}

