/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.client;

import java.rmi.RemoteException;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.client.CommandShell;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellArgumentException;
import oracle.kv.util.shell.ShellCommand;
import oracle.kv.util.shell.ShellException;

class ConfigureCommand
extends ShellCommand {
    private static final int maxStoreNameLen = 255;

    ConfigureCommand() {
        super("configure", 4);
    }

    @Override
    public String execute(String[] args, Shell shell) throws ShellException {
        if (args.length < 3) {
            shell.badArgCount(this);
        }
        if (!"-name".equals(args[1])) {
            shell.requiredArg("-name", this);
        }
        String storeName = args[2];
        CommandShell cmd = (CommandShell)shell;
        CommandServiceAPI cs = cmd.getAdmin();
        try {
            this.validateStoreName(storeName);
            cs.configure(storeName);
        }
        catch (RemoteException re) {
            cmd.noAdmin(re);
        }
        return "Store configured: " + storeName;
    }

    @Override
    protected String getCommandSyntax() {
        return "configure -name <storename>";
    }

    @Override
    protected String getCommandDescription() {
        return "Configures a new store.  This call must be made before any other" + eolt + "administration can be performed.";
    }

    private void validateStoreName(String store) throws ShellException {
        if (store.length() > 255) {
            throw new ShellArgumentException("Invalid store name.  It exceeds the maximum length of 255");
        }
        for (char c : store.toCharArray()) {
            if (this.isValid(c)) continue;
            throw new ShellArgumentException("Invalid store name: " + store + ".  It must consist of " + "letters, digits, hyphen, underscore, period.");
        }
    }

    private boolean isValid(char c) {
        return Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.';
    }
}

