/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.client;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.Durability;
import oracle.kv.KVSecurityException;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreFactory;
import oracle.kv.KVVersion;
import oracle.kv.LoginCredentials;
import oracle.kv.PasswordCredentials;
import oracle.kv.impl.admin.AdminFaultException;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.admin.client.CommandUtils;
import oracle.kv.impl.admin.client.ConfigureCommand;
import oracle.kv.impl.admin.client.DdlCommand;
import oracle.kv.impl.admin.client.LogtailCommand;
import oracle.kv.impl.admin.client.PingCommand;
import oracle.kv.impl.admin.client.PlanCommand;
import oracle.kv.impl.admin.client.PolicyCommand;
import oracle.kv.impl.admin.client.PoolCommand;
import oracle.kv.impl.admin.client.ShowCommand;
import oracle.kv.impl.admin.client.SnapshotCommand;
import oracle.kv.impl.admin.client.TableCommand;
import oracle.kv.impl.admin.client.TopologyCommand;
import oracle.kv.impl.admin.client.VerifyCommand;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.security.PasswordExpiredException;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.AdminLoginManager;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.impl.security.util.ShellPasswordReader;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.shell.AggregateCommand;
import oracle.kv.shell.DeleteCommand;
import oracle.kv.shell.ExecuteCommand;
import oracle.kv.shell.GetCommand;
import oracle.kv.shell.PutCommand;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellArgumentException;
import oracle.kv.util.shell.ShellCommand;
import oracle.kv.util.shell.ShellException;

public class CommandShell
extends Shell {
    public static final String COMMAND_NAME = "runcli";
    public static final String COMMAND_NAME_ALIAS = "runadmin";
    public static final String COMMAND_DESC = "runs the command line interface";
    public static final String COMMAND_ARGS = CommandParser.getHostUsage() + " " + CommandParser.getPortUsage() + " " + CommandParser.optional(CommandParser.getStoreUsage()) + eolt + CommandParser.optional(CommandParser.getAdminHostUsage() + " " + CommandParser.getAdminPortUsage()) + eolt + CommandParser.optional(CommandParser.getUserUsage()) + " " + CommandParser.optional(CommandParser.getSecurityUsage()) + eolt + CommandParser.optional(CommandParser.getAdminUserUsage()) + " " + CommandParser.optional(CommandParser.getAdminSecurityUsage()) + eolt + "[single command and arguments]";
    public static final String RUN_BY_KVSTORE_MAIN = "-kvstore-main";
    private ShellParser parser;
    private CommandServiceAPI cs;
    private KVStore store = null;
    private boolean noprompt = false;
    private boolean noconnect = false;
    private boolean retry = false;
    private String[] commandToRun;
    private int nextCommandIdx = 0;
    private String adminHostname = null;
    private int adminRegistryPort = 0;
    private List<URI> knownAdmins = null;
    private ReplicatedEnvironment.State adminState = null;
    private String storeHostname = null;
    private int storePort = 0;
    private String kvstoreName = null;
    private String commandName = null;
    private String adminUser;
    private String adminSecurityFile;
    private String storeUser;
    private String storeSecurityFile;
    private final LoginHelper loginHelper;
    static final String prompt = "kv-> ";
    static final String usageHeader = "Oracle NoSQL Database Administrative Commands:" + eol;
    static final String versionString = " (" + KVVersion.CURRENT_VERSION.getNumericVersionString() + ")";
    private static List<? extends ShellCommand> commands = Arrays.asList(new AggregateCommand(), new ConfigureCommand(), new ConnectCommand(), new DdlCommand(), new DeleteCommand(), new ExecuteCommand(), new Shell.ExitCommand(), new GetCommand(), new Shell.HelpCommand(), new HiddenCommand(), new HistoryCommand(), new Shell.LoadCommand(), new LogtailCommand(), new PingCommand(), new PlanCommand(), new PolicyCommand(), new PoolCommand(), new PutCommand(), new ShowCommand(), new SnapshotCommand(), new TableCommand(), new TimeCommand(), new TopologyCommand(), new VerboseCommand(), new VerifyCommand());

    public CommandShell(InputStream input, PrintStream output) {
        super(input, output);
        Collections.sort(commands, new Shell.CommandComparator());
        this.loginHelper = new LoginHelper();
    }

    @Override
    public void init() {
        if (!this.noconnect) {
            try {
                this.connect();
            }
            catch (ShellException se) {
                this.output.println(se.getMessage());
            }
        }
    }

    @Override
    public void shutdown() {
        this.closeStore();
    }

    @Override
    public List<? extends ShellCommand> getCommands() {
        return commands;
    }

    @Override
    public String getPrompt() {
        return this.noprompt ? null : prompt;
    }

    @Override
    public String getUsageHeader() {
        return usageHeader;
    }

    @Override
    public boolean doRetry() {
        boolean oldVal = this.retry;
        this.retry = false;
        return oldVal;
    }

    @Override
    public void handleUnknownException(String line, Exception e) {
        if (e instanceof AdminFaultException) {
            AdminFaultException afe = (AdminFaultException)e;
            String faultClassName = afe.getFaultClassName();
            String msg = afe.getMessage();
            if (faultClassName.contains("IllegalCommandException")) {
                int endIndex = msg.indexOf(versionString);
                if (endIndex > 0) {
                    msg = msg.substring(0, endIndex);
                }
                e = null;
            }
            this.history.add(line, e);
            this.output.println(msg);
        } else if (e instanceof KVSecurityException) {
            super.handleKVSecurityException(line, (KVSecurityException)e);
        } else {
            super.handleUnknownException(line, e);
        }
    }

    @Override
    public boolean handleKVSecurityException(String line, KVSecurityException kvse) {
        if (kvse instanceof AuthenticationRequiredException) {
            try {
                this.connectAdmin(true);
                return true;
            }
            catch (ShellException se) {
                return this.handleShellException(line, se);
            }
            catch (Exception e) {
                this.handleUnknownException(line, e);
                return false;
            }
        }
        return super.handleKVSecurityException(line, kvse);
    }

    public CommandServiceAPI getAdmin() throws ShellException {
        this.ensureConnection();
        return this.cs;
    }

    public KVStore getStore() throws ShellException {
        if (this.store == null) {
            throw new ShellArgumentException("You are not connected to a store, please run 'connect store' to open a store.");
        }
        return this.store;
    }

    String getAdminHostname() {
        return this.adminHostname;
    }

    int getAdminPort() {
        return this.adminRegistryPort;
    }

    public void connect() throws ShellException {
        if (this.kvstoreName != null) {
            this.loginHelper.updateStoreLogin(this.storeUser, this.storeSecurityFile);
            this.openStore();
        }
        this.loginHelper.updateAdminLogin(this.adminUser, this.adminSecurityFile);
        this.connectAdmin(false);
    }

    public void openStore(String host, int port, String storeName, String user, String securityFile) throws ShellException {
        this.storeHostname = host;
        this.storePort = port;
        this.kvstoreName = storeName;
        try {
            this.loginHelper.updateStoreLogin(user, securityFile);
        }
        catch (IllegalStateException ise) {
            throw new ShellException(ise.getMessage());
        }
        catch (IllegalArgumentException iae) {
            this.output.println(iae.getMessage());
        }
        this.openStore();
    }

    public void start() {
        this.init();
        if (this.commandToRun != null) {
            try {
                String result = this.run(this.commandToRun[0], this.commandToRun);
                this.output.println(result);
            }
            catch (ShellException se) {
                this.handleShellException(this.commandToRun[0], se);
            }
            catch (Exception e) {
                this.handleUnknownException(this.commandToRun[0], e);
            }
        } else {
            this.loop();
        }
        this.shutdown();
    }

    public LoginManager getLoginManager() {
        return this.loginHelper.getAdminLoginMgr();
    }

    public void noAdmin(RemoteException e) throws ShellException {
        Throwable t;
        if (e != null && this.cs != null && (t = e.getCause()) != null && (t instanceof EOFException || t instanceof ConnectException || t instanceof java.rmi.ConnectException)) {
            this.cs = null;
            this.retry = true;
        }
        throw new ShellException("Cannot contact admin", e);
    }

    private void ensureConnection() throws ShellException {
        if (this.cs != null) {
            if (this.isReadOnly()) {
                this.connectAdmin(false);
            }
            return;
        }
        ShellException ce = null;
        this.output.println("Lost connection to Admin service.");
        this.output.print("Reconnecting...");
        for (int i = 0; i < 10; ++i) {
            try {
                this.output.print(".");
                this.connectAdmin(false);
                this.output.println("");
                return;
            }
            catch (ShellException se) {
                Throwable t = se.getCause();
                if (t != null && t instanceof AuthenticationFailureException) {
                    throw se;
                }
                ce = se;
                try {
                    Thread.sleep(6000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (ce != null) {
            throw ce;
        }
    }

    public void connectAdmin(String host, int port, String user, String securityFileName) throws ShellException {
        try {
            this.loginHelper.updateAdminLogin(user, securityFileName);
        }
        catch (IllegalStateException ise) {
            throw new ShellException(ise.getMessage());
        }
        catch (IllegalArgumentException iae) {
            this.output.println(iae.getMessage());
        }
        this.connectAdmin(host, port, false);
        this.updateKnownAdmins();
    }

    private void connectAdmin(boolean forceLogin) throws ShellException {
        ShellException e = null;
        try {
            this.connectAdmin(this.adminHostname, this.adminRegistryPort, forceLogin);
            if (!this.isReadOnly()) {
                this.updateKnownAdmins();
                return;
            }
        }
        catch (ShellException se) {
            e = se;
        }
        if (this.knownAdmins != null) {
            for (URI addr : this.knownAdmins) {
                try {
                    this.connectAdmin(addr.getHost(), addr.getPort(), forceLogin);
                    if (this.isReadOnly()) continue;
                    break;
                }
                catch (ShellException se) {
                    e = se;
                }
            }
        }
        if (this.cs == null) {
            if (e != null) {
                throw e;
            }
            throw new ShellException("Cannot connect to Admin at " + this.adminHostname + ":" + this.adminRegistryPort, e);
        }
        if (this.isReadOnly()) {
            this.output.println("Connected to Admin in read-only mode");
        }
        this.updateKnownAdmins();
    }

    private void updateKnownAdmins() {
        ArrayList<URI> admins = new ArrayList<URI>();
        try {
            Parameters p = this.cs.getParameters();
            for (AdminParams ap : p.getAdminParams()) {
                StorageNodeParams snp = p.get(ap.getStorageNodeId());
                try {
                    admins.add(new URI("rmi", null, snp.getHostname(), snp.getRegistryPort(), null, null, null));
                }
                catch (URISyntaxException use) {
                    throw new NonfatalAssertionException("Unexpected bad URL", use);
                }
            }
            this.knownAdmins = admins;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!admins.isEmpty()) {
            this.knownAdmins = admins;
        }
    }

    private void connectAdmin(String host, int port, boolean forceLogin) throws ShellException {
        Exception e;
        try {
            CommandServiceAPI admin = this.loginHelper.getAuthenticatedAdmin(host, port, forceLogin);
            ReplicatedEnvironment.State state = admin.getAdminState();
            if (state != null) {
                switch (state) {
                    case MASTER: {
                        this.setAdmin(admin, state, host, port);
                        return;
                    }
                    case REPLICA: {
                        this.setAdmin(admin, state, host, port);
                        URI rmiaddr = this.cs.getMasterRmiAddress();
                        this.output.println("Redirecting to master at " + rmiaddr);
                        this.connectAdmin(rmiaddr.getHost(), rmiaddr.getPort(), false);
                        return;
                    }
                }
            }
            if (this.cs == null) {
                this.setAdmin(admin, state, host, port);
            }
            return;
        }
        catch (AuthenticationRequiredException are) {
            this.output.println(String.format("Admin %s:%d requires authentication.", host, port));
            this.connectAdmin(host, port, true);
            return;
        }
        catch (AdminFaultException afe) {
            if (afe.getFaultClassName().equals(SessionAccessException.class.getName())) {
                this.output.println("Problem in verifying the redirected login. Need to log in admin at " + host + ":" + port + " again.");
                this.connectAdmin(host, port, true);
                return;
            }
            throw afe;
        }
        catch (RemoteException re) {
            e = re;
        }
        catch (NotBoundException nbe) {
            e = nbe;
        }
        throw new ShellException("Cannot connect to Admin at " + host + ":" + port, e);
    }

    private void setAdmin(CommandServiceAPI admin, ReplicatedEnvironment.State state, String host, int port) {
        this.cs = admin;
        this.adminState = state;
        this.adminHostname = host;
        this.adminRegistryPort = port;
    }

    boolean isReadOnly() {
        return this.adminState != null && !this.adminState.isMaster();
    }

    private void openStore() throws ShellException {
        KVStoreConfig kvstoreConfig = new KVStoreConfig(this.kvstoreName, this.storeHostname + ":" + this.storePort);
        kvstoreConfig.setDurability(Durability.COMMIT_SYNC);
        try {
            this.store = this.loginHelper.getAuthenticatedStore(kvstoreConfig);
        }
        catch (ShellException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ShellException("Cannot connect to " + this.kvstoreName + " at " + this.storeHostname + ":" + this.storePort, e);
        }
    }

    private void closeStore() {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    public void parseArgs(String[] args) {
        this.parser = new ShellParser(args);
        this.parser.parseArgs();
        this.storeUser = this.parser.getUserName();
        this.storeSecurityFile = this.parser.getSecurityFile();
        this.adminUser = this.parser.getAdminUserName();
        this.adminSecurityFile = this.parser.getAdminSecurityFile();
    }

    public static void main(String[] args) {
        CommandShell shell = new CommandShell(System.in, System.out);
        shell.parseArgs(args);
        shell.start();
        if (shell.getExitCode() != 0) {
            System.exit(shell.getExitCode());
        }
    }

    static /* synthetic */ String[] access$1602(CommandShell x0, String[] x1) {
        x0.commandToRun = x1;
        return x1;
    }

    private class LoginHelper
    implements KVStoreLogin.CredentialsProvider {
        private final KVStoreLogin storeLogin = new KVStoreLogin();
        private final KVStoreLogin adminLogin = new KVStoreLogin();
        private static final String loginConnErrMsg = "Cannot connect to Admin login service %s:%d";
        private LoginManager adminLoginMgr;
        private PasswordCredentials storeCreds;
        private boolean isSecuredAdmin;
        private boolean isSecuredStore;
        private AuthenticationFailureException lastAdminAfe;

        private LoginHelper() {
        }

        private void updateAdminLogin(String newUser, String newLoginFile) {
            this.adminLogin.updateLoginInfo(newUser, newLoginFile);
            this.isSecuredAdmin = this.adminLogin.foundSSLTransport();
            this.adminLogin.prepareRegistryCSF();
            this.adminLoginMgr = null;
        }

        private void updateStoreLogin(String newUser, String newLoginFile) {
            this.storeLogin.updateLoginInfo(newUser, newLoginFile);
            this.isSecuredStore = this.storeLogin.foundSSLTransport();
            this.storeCreds = null;
        }

        private CommandServiceAPI getAuthenticatedAdmin(String host, int port, boolean forceLogin) throws ShellException, RemoteException, NotBoundException {
            if (forceLogin || this.isSecuredAdmin && this.adminLoginMgr == null) {
                this.loginAdmin(host, port);
            }
            return RegistryUtils.getAdmin(host, port, this.adminLoginMgr);
        }

        private KVStore getAuthenticatedStore(KVStoreConfig config) throws ShellException {
            config.setSecurityProperties(this.storeLogin.getSecurityProperties());
            try {
                if (this.isSecuredStore && this.storeCreds == null) {
                    this.storeCreds = this.storeLogin.makeShellLoginCredentials();
                }
                return KVStoreFactory.getStore(config, this.storeCreds, KVStoreLogin.makeReauthenticateHandler(this));
            }
            catch (AuthenticationFailureException afe) {
                this.storeCreds = null;
                String errorMsg = "Login failed: ";
                errorMsg = afe.getFaultClassName().equals(PasswordExpiredException.class.getName()) ? errorMsg + "Password is expired. Please try log in Admin CLI and renew your password following prompts." : errorMsg + afe.getMessage();
                throw new ShellException(errorMsg, afe);
            }
            catch (IOException ioe) {
                throw new ShellException("Failed to get login credentials: " + ioe.getMessage());
            }
        }

        private LoginManager getAdminLoginMgr() {
            return this.adminLoginMgr;
        }

        private void loginAdmin(String host, int port) throws ShellException {
            String adminLoginUser = this.adminLogin.getUserName();
            this.lastAdminAfe = null;
            if (this.storeCreds != null && (adminLoginUser == null || adminLoginUser.equals(this.storeCreds.getUsername())) && this.loginAdmin(host, port, this.storeCreds)) {
                return;
            }
            if (adminLoginUser == null) {
                if (this.loginAdmin(host, port, null)) {
                    return;
                }
                CommandShell.this.output.println("Could not login as anonymous: " + this.lastAdminAfe.getMessage());
            }
            try {
                if (!this.loginAdmin(host, port, this.adminLogin.makeShellLoginCredentials())) {
                    throw new ShellException("Login failed: " + this.lastAdminAfe.getMessage(), this.lastAdminAfe);
                }
            }
            catch (IOException ioe) {
                throw new ShellException("Failed to get login credentials: " + ioe.getMessage());
            }
        }

        private boolean loginAdmin(String hostname, int registryPort, PasswordCredentials loginCreds) throws ShellException {
            String userName = loginCreds == null ? null : loginCreds.getUsername();
            AdminLoginManager alm = new AdminLoginManager(userName, true);
            try {
                if (alm.bootstrap(hostname, registryPort, loginCreds)) {
                    this.adminLoginMgr = alm;
                    CommandShell.this.println("Logged in admin as " + (userName == null ? "anonymous" : userName));
                    return true;
                }
                throw new ShellException(String.format(loginConnErrMsg, hostname, registryPort));
            }
            catch (AuthenticationFailureException afe) {
                if (userName != null && afe.getFaultClassName().equals(PasswordExpiredException.class.getName())) {
                    CommandShell.this.println(afe.getMessage());
                    if (this.renewPassword(alm, hostname, registryPort, loginCreds)) {
                        this.adminLoginMgr = alm;
                        CommandShell.this.println("Logged in admin as " + userName);
                        return true;
                    }
                }
                this.lastAdminAfe = afe;
                this.adminLoginMgr = null;
                return false;
            }
        }

        boolean isSecuredAdmin() {
            return this.isSecuredAdmin;
        }

        private boolean renewPassword(AdminLoginManager alm, String hostname, int registryPort, PasswordCredentials oldCreds) throws ShellException {
            try {
                ShellPasswordReader READER = new ShellPasswordReader();
                char[] newPlainPassword = READER.readPassword("Enter the new password: ");
                String errorMsg = CommandUtils.verifyPassword(READER, newPlainPassword);
                if (errorMsg != null) {
                    throw new ShellException("Renew password failed: " + errorMsg);
                }
                return alm.renewPassword(hostname, registryPort, oldCreds, newPlainPassword);
            }
            catch (IOException ioe) {
                throw new ShellException("Could not read password from console: " + ioe);
            }
        }

        @Override
        public LoginCredentials getCredentials() {
            return this.storeCreds;
        }
    }

    private class ShellParser
    extends CommandParser {
        public static final String NOCONNECT_FLAG = "-noconnect";
        public static final String NOPROMPT_FLAG = "-noprompt";
        public static final String HIDDEN_FLAG = "-hidden";

        private ShellParser(String[] args) {
            super(args, true);
        }

        @Override
        protected void verifyArgs() {
            if (!CommandShell.this.noconnect) {
                if (CommandShell.this.storeHostname == null || CommandShell.this.storePort == 0) {
                    this.usage("Missing required argument");
                }
                if (CommandShell.this.adminHostname == null && CommandShell.this.adminRegistryPort == 0) {
                    CommandShell.this.adminHostname = CommandShell.this.storeHostname;
                    CommandShell.this.adminRegistryPort = CommandShell.this.storePort;
                }
                if (CommandShell.this.adminHostname == null || CommandShell.this.adminRegistryPort == 0) {
                    this.usage("Missing required argument");
                }
                if (this.adminUserName == null && this.adminSecurityFilePath == null) {
                    this.adminUserName = this.userName;
                    this.adminSecurityFilePath = this.securityFile;
                }
            }
            if (CommandShell.this.commandToRun != null && CommandShell.this.nextCommandIdx < CommandShell.this.commandToRun.length) {
                this.usage("Flags may not follow commands");
            }
        }

        @Override
        public void usage(String errorMsg) {
            if (errorMsg != null) {
                System.err.println(errorMsg);
            }
            String usage = CommandShell.this.commandName == null ? "Usage: java -jar KVHOME/lib/kvcli.jar " + Shell.eolt + COMMAND_ARGS : "Usage: java -jar KVHOME/lib/kvstore.jar " + CommandShell.this.commandName + " " + Shell.eolt + COMMAND_ARGS;
            System.err.println(usage);
            System.exit(1);
        }

        @Override
        protected boolean checkArg(String arg) {
            if ("-host".equals(arg)) {
                if (CommandShell.this.storeHostname == null) {
                    CommandShell.this.storeHostname = this.nextArg(arg);
                    return true;
                }
            } else if ("-port".equals(arg)) {
                if (CommandShell.this.storePort == 0) {
                    CommandShell.this.storePort = Integer.parseInt(this.nextArg(arg));
                    return true;
                }
            } else if ("-store".equals(arg)) {
                if (CommandShell.this.kvstoreName == null) {
                    CommandShell.this.kvstoreName = this.nextArg(arg);
                    return true;
                }
            } else if ("-admin-host".equals(arg)) {
                if (CommandShell.this.adminHostname == null) {
                    CommandShell.this.adminHostname = this.nextArg(arg);
                    return true;
                }
            } else if ("-admin-port".equals(arg)) {
                if (CommandShell.this.adminRegistryPort == 0) {
                    CommandShell.this.adminRegistryPort = Integer.parseInt(this.nextArg(arg));
                    return true;
                }
            } else if (CommandShell.RUN_BY_KVSTORE_MAIN.equals(arg)) {
                if (CommandShell.this.commandName == null) {
                    CommandShell.this.commandName = this.nextArg(arg);
                    return true;
                }
            } else if ("-username".equals(arg)) {
                if (this.userName == null) {
                    this.userName = this.nextArg(arg);
                    return true;
                }
            } else if ("-security".equals(arg)) {
                if (this.securityFile == null) {
                    this.securityFile = this.nextArg(arg);
                    return true;
                }
            } else if ("-admin-username".equals(arg)) {
                if (this.adminUserName == null) {
                    this.adminUserName = this.nextArg(arg);
                    return true;
                }
            } else if ("-admin-security".equals(arg)) {
                if (this.adminSecurityFilePath == null) {
                    this.adminSecurityFilePath = this.nextArg(arg);
                    return true;
                }
            } else {
                if (NOCONNECT_FLAG.equals(arg)) {
                    CommandShell.this.noconnect = true;
                    return true;
                }
                if (NOPROMPT_FLAG.equals(arg)) {
                    CommandShell.this.noprompt = true;
                    return true;
                }
                if (HIDDEN_FLAG.equals(arg)) {
                    CommandShell.this.showHidden = true;
                    if (CommandShell.this.commandToRun != null) {
                        this.addToCommand(arg);
                    }
                    return true;
                }
            }
            this.addToCommand(arg);
            return true;
        }

        private void addToCommand(String arg) {
            if (CommandShell.this.commandToRun == null) {
                CommandShell.access$1602(CommandShell.this, new String[this.getNRemainingArgs() + 1]);
            }
            ((CommandShell)CommandShell.this).commandToRun[((CommandShell)CommandShell.this).nextCommandIdx++] = arg;
        }
    }

    static class TimeCommand
    extends ShellCommand {
        public TimeCommand() {
            super("time", 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            String commandName;
            ShellCommand command;
            if (args.length == 1) {
                shell.badArgCount(this);
            }
            if ((command = shell.findCommand(commandName = args[1])) != null) {
                String[] cmdArgs = Arrays.copyOfRange(args, 1, args.length);
                long startTime = System.currentTimeMillis();
                String retString = command.execute(cmdArgs, shell);
                retString = retString + eol + "Time: " + (System.currentTimeMillis() - startTime) + " ms.";
                return retString;
            }
            return "Could not find command: " + commandName + eol + shell.getUsage();
        }

        @Override
        protected String getCommandSyntax() {
            return "time command [sub-command]";
        }

        @Override
        protected String getCommandDescription() {
            return "Runs the specified command and prints " + eolt + "the elapsed time of the execution.";
        }
    }

    static class ConnectCommand
    extends CommandWithSubs {
        private static final String COMMAND = "connect";
        private static final String HOST_FLAG = "-host";
        private static final String HOST_FLAG_DESC = "-host <hostname>";
        private static final String PORT_FLAG = "-port";
        private static final List<? extends CommandWithSubs.SubCommand> subs = Arrays.asList(new ConnectAdminCommand(), new ConnectStoreCommand());

        ConnectCommand() {
            super(subs, COMMAND, 4, 2);
        }

        @Override
        protected String getCommandOverview() {
            return "Encapsulates commands that connect to the specified host and registry port" + eol + "to perform administrative " + "functions or connect to the specified store to" + eol + "perform data access functions.";
        }

        static class ConnectStoreCommand
        extends CommandWithSubs.SubCommand {
            private static final String SUB_COMMAND = "store";
            private static final String PORT_FLAG_DESC = "-port <port>";
            private static final String STORE_FLAG = "-name";
            private static final String STORE_FLAG_DESC = "-name <storename>";
            static final String CONNECT_STORE_COMMAND_DESC = "Connects to a KVStore to perform data access functions." + eolt + "If the instance is secured, you may need to provide " + "login credentials.";
            static final String CONNECT_STORE_COMMAND_SYNTAX = "connect store " + CommandParser.optional("-host <hostname>") + " " + CommandParser.optional("-port <port>") + " " + "-name <storename>" + eolt + CommandParser.optional(CommandParser.getUserUsage()) + " " + CommandParser.optional(CommandParser.getSecurityUsage());

            ConnectStoreCommand() {
                super(SUB_COMMAND, 4);
            }

            @Override
            public String execute(String[] args, Shell shell) throws ShellException {
                Shell.checkHelp(args, this);
                String hostname = ((CommandShell)shell).storeHostname;
                int port = ((CommandShell)shell).storePort;
                String storeName = null;
                String user = null;
                String security = null;
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if (ConnectCommand.HOST_FLAG.equals(arg)) {
                        hostname = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (ConnectCommand.PORT_FLAG.equals(arg)) {
                        try {
                            port = Integer.parseInt(Shell.nextArg(args, i++, this));
                        }
                        catch (IllegalArgumentException iae) {
                            shell.invalidArgument(arg, this);
                        }
                        continue;
                    }
                    if (STORE_FLAG.equals(arg)) {
                        storeName = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if ("-username".equals(arg)) {
                        user = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if ("-security".equals(arg)) {
                        security = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    shell.unknownArgument(arg, this);
                }
                if (hostname == null || port == 0 || storeName == null) {
                    shell.badArgCount(this);
                }
                CommandShell cmd = (CommandShell)shell;
                cmd.closeStore();
                try {
                    cmd.openStore(hostname, port, storeName, user, security);
                }
                catch (ShellException se) {
                    throw new ShellException(se.getMessage() + eol + "Warning: You are no longer connected to a store.");
                }
                return "Connected to " + storeName + " at " + hostname + ":" + port + ".";
            }

            @Override
            protected String getCommandSyntax() {
                return CONNECT_STORE_COMMAND_SYNTAX;
            }

            @Override
            protected String getCommandDescription() {
                return CONNECT_STORE_COMMAND_DESC;
            }
        }

        static class ConnectAdminCommand
        extends CommandWithSubs.SubCommand {
            private static final String SUB_COMMAND = "admin";
            private static final String PORT_FLAG_DESC = "-port <registry port>";
            static final String CONNECT_ADMIN_COMMAND_DESC = "Connects to the specified host and registry port to perform" + eolt + "administrative functions.  An Admin " + "service must be active on the" + eolt + "target host.  " + "If the instance is secured, you may need to provide" + eolt + "login credentials.";
            static final String CONNECT_ADMIN_COMMAND_SYNTAX = "connect admin -host <hostname> -port <registry port>" + eolt + CommandParser.optional(CommandParser.getUserUsage()) + " " + CommandParser.optional(CommandParser.getSecurityUsage());

            ConnectAdminCommand() {
                super(SUB_COMMAND, 3);
            }

            @Override
            public String execute(String[] args, Shell shell) throws ShellException {
                Shell.checkHelp(args, this);
                String host = null;
                int port = 0;
                String user = null;
                String security = null;
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if (ConnectCommand.HOST_FLAG.equals(arg)) {
                        host = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (ConnectCommand.PORT_FLAG.equals(arg)) {
                        try {
                            port = Integer.parseInt(Shell.nextArg(args, i++, this));
                        }
                        catch (IllegalArgumentException iae) {
                            shell.invalidArgument(arg, this);
                        }
                        continue;
                    }
                    if ("-username".equals(arg)) {
                        user = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if ("-security".equals(arg)) {
                        security = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    shell.invalidArgument(arg, this);
                }
                if (host == null || port == 0) {
                    shell.badArgCount(this);
                }
                CommandShell cmd = (CommandShell)shell;
                cmd.connectAdmin(host, port, user, security);
                if (cmd.loginHelper.isSecuredAdmin()) {
                    cmd.getHistory().clear();
                }
                return "Connected.";
            }

            @Override
            protected String getCommandSyntax() {
                return CONNECT_ADMIN_COMMAND_SYNTAX;
            }

            @Override
            protected String getCommandDescription() {
                return CONNECT_ADMIN_COMMAND_DESC;
            }
        }
    }

    static class HistoryCommand
    extends ShellCommand {
        HistoryCommand() {
            super("history", 4);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.CommandHistory history = shell.getHistory();
            int from = 0;
            int to = history.getSize();
            String parseFrom = null;
            String parseTo = null;
            boolean isLast = false;
            if (args.length > 1) {
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if ("-last".equals(arg)) {
                        parseFrom = Shell.nextArg(args, i++, this);
                        isLast = true;
                        continue;
                    }
                    if ("-from".equals(arg)) {
                        parseFrom = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if ("-to".equals(arg)) {
                        parseTo = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    return "Invalid argument: " + arg + eolt + this.getBriefHelp();
                }
                try {
                    if (parseFrom != null) {
                        from = Integer.parseInt(parseFrom);
                    }
                    if (parseTo != null) {
                        to = Integer.parseInt(parseTo);
                    }
                    if (isLast) {
                        from = history.getSize() - from + 1;
                    }
                }
                catch (IllegalArgumentException e) {
                    return "Invalid integer argument:" + eolt + this.getBriefHelp();
                }
            }
            return history.dump(this.toZeroBasedIndex(from), this.toZeroBasedIndex(to));
        }

        private int toZeroBasedIndex(int index) {
            return index > 0 ? index - 1 : 0;
        }

        @Override
        protected String getCommandSyntax() {
            return "history [-last <n>] [-from <n>] [-to <n>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Displays command history.  By default all history is displayed." + eolt + "Optional flags are used to choose " + "ranges for display";
        }
    }

    static class HiddenCommand
    extends ShellCommand {
        HiddenCommand() {
            super("hidden", 3);
        }

        @Override
        protected boolean isHidden() {
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            CommandShell cs = (CommandShell)shell;
            if (args.length > 2) {
                shell.badArgCount(this);
            }
            if (args.length > 1) {
                String arg = args[1];
                if ("on".equals(arg)) {
                    cs.setHidden(true);
                    return "Hidden parameters are " + (cs.showHidden() ? "enabled" : "disabled");
                } else {
                    if (!"off".equals(arg)) return "Invalid argument: " + arg + eolt + this.getBriefHelp();
                    cs.setHidden(false);
                }
                return "Hidden parameters are " + (cs.showHidden() ? "enabled" : "disabled");
            } else {
                cs.toggleHidden();
            }
            return "Hidden parameters are " + (cs.showHidden() ? "enabled" : "disabled");
        }

        @Override
        protected String getCommandSyntax() {
            return "hidden [on|off]";
        }

        @Override
        public String getCommandDescription() {
            return "Toggles or sets visibility and setting of parameters that are normally hidden." + eolt + "Use these " + "parameters only if advised to do so by Oracle Support.";
        }
    }

    static class VerboseCommand
    extends ShellCommand {
        VerboseCommand() {
            super("verbose", 4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            if (args.length > 2) {
                shell.badArgCount(this);
                return "Verbose mode is now " + (shell.getVerbose() ? "on" : "off");
            } else if (args.length > 1) {
                String arg = args[1];
                if ("on".equals(arg)) {
                    shell.setVerbose(true);
                    return "Verbose mode is now " + (shell.getVerbose() ? "on" : "off");
                } else {
                    if (!"off".equals(arg)) return "Invalid argument: " + arg + eolt + this.getBriefHelp();
                    shell.setVerbose(false);
                }
                return "Verbose mode is now " + (shell.getVerbose() ? "on" : "off");
            } else {
                shell.toggleVerbose();
            }
            return "Verbose mode is now " + (shell.getVerbose() ? "on" : "off");
        }

        @Override
        protected String getCommandSyntax() {
            return "verbose [on|off]";
        }

        @Override
        public String getCommandDescription() {
            return "Toggles or sets the global verbosity setting.  This property can also" + eolt + "be set per-command using " + "the -verbose flag.";
        }
    }
}

