/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import java.util.ArrayList;
import java.util.List;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.DdlHandler;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.security.AccessCheckUtils;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.OperationContext;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.security.TablePrivilege;
import oracle.kv.table.Index;
import oracle.kv.table.Table;

public abstract class TableDdlOperation
implements DdlHandler.DdlOperation {
    private final String opName;
    private final TableImpl table;

    TableDdlOperation(String opName, TableImpl table) {
        this.opName = opName;
        this.table = table;
    }

    TableImpl getTable() {
        return this.table;
    }

    String opName() {
        return this.opName;
    }

    private static final class NoTableOpContext
    implements OperationContext {
        private final String phantomTable;

        NoTableOpContext(String phantomTable) {
            this.phantomTable = phantomTable;
        }

        @Override
        public String describe() {
            return "Operation on an non-existing table: " + this.phantomTable;
        }

        @Override
        public List<? extends KVStorePrivilege> getRequiredPrivileges() {
            return SystemPrivilege.dbviewPrivList;
        }
    }

    public static class DescribeTable
    extends TableDdlOperation {
        private final String tableName;
        private final String indexName;
        private final boolean asJson;
        private final String[] fields;

        public DescribeTable(String tableName, String indexName, String[] fields, boolean asJson) {
            super("DESCRIBE TABLE", null);
            assert (tableName != null);
            this.asJson = asJson;
            this.tableName = tableName;
            this.indexName = indexName;
            this.fields = fields;
        }

        @Override
        public void perform(DdlHandler ddlHandler) {
            Admin admin = ddlHandler.getAdmin();
            String resultString = null;
            TableMetadata metadata = admin.getMetadata(TableMetadata.class, Metadata.MetadataType.TABLE);
            TableImpl table = null;
            if (metadata != null) {
                table = metadata.getTable(this.tableName);
            }
            if (table == null) {
                ddlHandler.operationFails("Table does not exist: " + this.tableName);
                return;
            }
            if (this.indexName != null) {
                Index index = table.getIndex(this.indexName);
                if (index == null) {
                    ddlHandler.operationFails("Index does not exist: " + this.indexName + ", on table " + this.tableName);
                    return;
                }
                resultString = this.formatIndex(index, this.asJson);
            } else {
                try {
                    resultString = this.formatTable(table, ddlHandler, this.asJson);
                    if (resultString == null) {
                        return;
                    }
                }
                catch (IllegalArgumentException iae) {
                    ddlHandler.operationFails(iae.getMessage());
                    return;
                }
            }
            ddlHandler.setResultString(resultString);
        }

        private String formatTable(TableImpl table, DdlHandler ddlHandler, boolean asJson1) {
            String retVal = table.formatTable(asJson1, this.fields);
            if (retVal == null) {
                ddlHandler.operationFails("DESCRIBE TABLE without 'AS JSON' not yet implemented");
            }
            return retVal;
        }

        private String formatIndex(Index index, boolean asJson1) {
            return ShowTableOrIndex.formatList(index.getName(), index.getFields(), asJson1);
        }

        @Override
        public OperationContext getOperationCtx() {
            return new OperationContext(){

                @Override
                public String describe() {
                    return DescribeTable.this.opName() + ": " + DescribeTable.this.tableName;
                }

                @Override
                public List<? extends KVStorePrivilege> getRequiredPrivileges() {
                    return SystemPrivilege.dbviewPrivList;
                }
            };
        }
    }

    public static class ShowTableOrIndex
    extends TableDdlOperation {
        private final String tableName;
        private final boolean isShowTables;
        private final boolean showIndexes;
        private final boolean asJson;

        public ShowTableOrIndex(String tableName, boolean isShowTables, boolean showIndexes, boolean asJson) {
            super("ShowTableOrIndex", null);
            this.tableName = tableName;
            this.isShowTables = isShowTables;
            this.showIndexes = showIndexes;
            this.asJson = asJson;
        }

        @Override
        public void perform(DdlHandler ddlHandler) {
            Admin admin = ddlHandler.getAdmin();
            String resultString = null;
            TableMetadata metadata = admin.getMetadata(TableMetadata.class, Metadata.MetadataType.TABLE);
            if (this.isShowTables) {
                if (metadata == null) {
                    resultString = "";
                } else {
                    resultString = ShowTableOrIndex.formatList("tables", metadata.listTables(), this.asJson);
                    ddlHandler.operationSucceeds();
                }
            } else {
                TableImpl table = null;
                if (metadata != null) {
                    table = metadata.getTable(this.tableName);
                }
                if (table == null) {
                    ddlHandler.operationFails("Table does not exist: " + this.tableName);
                    return;
                }
                ddlHandler.operationSucceeds();
                resultString = this.showIndexes ? ShowTableOrIndex.formatList("indexes", new ArrayList<String>(table.getIndexes().keySet()), this.asJson) : this.formatTableNames(table);
            }
            ddlHandler.setResultString(resultString);
        }

        private String formatTableNames(TableImpl table) {
            Table current = table;
            while (current.getParent() != null) {
                current = current.getParent();
            }
            ArrayList<String> tableNames = new ArrayList<String>();
            this.listTableHierarchy(current, tableNames);
            return ShowTableOrIndex.formatList("tableHierarchy", tableNames, this.asJson);
        }

        private void listTableHierarchy(Table table, List<String> tableNames) {
            tableNames.add(table.getFullName());
            for (Table t : table.getChildTables().values()) {
                this.listTableHierarchy(t, tableNames);
            }
        }

        private static String formatList(String listName, List<String> list, boolean asJson) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            if (asJson) {
                sb.append("{\"");
                sb.append(listName);
                sb.append("\" : [");
                for (String s : list) {
                    if (!first) {
                        sb.append(",");
                    }
                    first = false;
                    sb.append("\"");
                    sb.append(s);
                    sb.append("\"");
                }
                sb.append("]}");
            } else {
                sb.append(listName);
                for (String s : list) {
                    sb.append("\n  ");
                    sb.append(s);
                }
            }
            return sb.toString();
        }

        @Override
        public OperationContext getOperationCtx() {
            return new OperationContext(){

                @Override
                public String describe() {
                    StringBuilder sb = new StringBuilder();
                    sb.append("SHOW");
                    if (ShowTableOrIndex.this.asJson) {
                        sb.append(" AS JSON");
                    }
                    if (ShowTableOrIndex.this.isShowTables) {
                        sb.append(" TABLES");
                    } else if (ShowTableOrIndex.this.showIndexes) {
                        sb.append(" INDEXES ON ");
                        sb.append(ShowTableOrIndex.this.tableName);
                    } else {
                        sb.append(" TABLE ");
                        sb.append(ShowTableOrIndex.this.tableName);
                    }
                    return sb.toString();
                }

                @Override
                public List<? extends KVStorePrivilege> getRequiredPrivileges() {
                    return SystemPrivilege.dbviewPrivList;
                }
            };
        }
    }

    public static class DropIndex
    extends TableDdlOperation {
        private final OperationContext opCtx;
        private final boolean ifExists;
        private final String indexName;
        private final String tableName;

        public DropIndex(String tableName, TableImpl tableIfExists, String indexName, boolean ifExists) {
            super("DROP INDEX", tableIfExists);
            this.ifExists = ifExists;
            this.indexName = indexName;
            this.tableName = tableName;
            this.opCtx = tableIfExists == null ? new NoTableOpContext(tableName) : new AccessCheckUtils.TableContext(this.opName(), tableIfExists, new TablePrivilege.DropIndex(tableIfExists.getId()));
        }

        @Override
        public OperationContext getOperationCtx() {
            return this.opCtx;
        }

        @Override
        public void perform(DdlHandler ddlHandler) {
            Admin admin = ddlHandler.getAdmin();
            if (this.ifExists && !this.indexExists(admin)) {
                ddlHandler.operationSucceeds();
                return;
            }
            try {
                int planId = admin.getPlanner().createRemoveIndexPlan("DropIndex", this.indexName, this.tableName);
                ddlHandler.approveAndExecute(planId);
            }
            catch (IllegalCommandException ice) {
                ddlHandler.operationFails("DROP INDEX failed, index does not exist: " + this.tableName + ":" + this.indexName);
            }
        }

        private boolean indexExists(Admin admin) {
            if (this.getTable() == null) {
                return false;
            }
            TableMetadata metadata = admin.getMetadata(TableMetadata.class, Metadata.MetadataType.TABLE);
            return metadata != null && metadata.getIndex(this.tableName, this.indexName) != null;
        }
    }

    public static class CreateIndex
    extends TableDdlOperation {
        private final OperationContext opCtx;
        private final boolean ifNotExists;
        private final String indexName;
        private final String tableName;
        private final String[] newFields;
        private final String indexComments;

        public CreateIndex(TableImpl tableIfExists, String tableName, String indexName, String[] newFields, String indexComments, boolean ifNotExists) {
            super("CREATE INDEX" + (ifNotExists ? " IF NOT EXISTS" : ""), tableIfExists);
            this.ifNotExists = ifNotExists;
            this.indexName = indexName;
            this.tableName = tableName;
            this.newFields = newFields;
            this.indexComments = indexComments;
            this.opCtx = tableIfExists == null ? new NoTableOpContext(tableName) : new AccessCheckUtils.TableContext(this.opName(), tableIfExists, new TablePrivilege.CreateIndex(tableIfExists.getId()));
        }

        @Override
        public OperationContext getOperationCtx() {
            return this.opCtx;
        }

        private boolean indexExistsAndEqual(Admin admin) {
            List<String> fields;
            Index index;
            TableMetadata metadata = admin.getMetadata(TableMetadata.class, Metadata.MetadataType.TABLE);
            if (metadata != null && (index = metadata.getIndex(this.tableName, this.indexName)) != null && this.newFields.length == (fields = index.getFields()).size()) {
                for (int i = 0; i < this.newFields.length; ++i) {
                    if (this.newFields[i].equalsIgnoreCase(fields.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public void perform(DdlHandler ddlHandler) {
            Admin admin = ddlHandler.getAdmin();
            if (this.ifNotExists && this.indexExistsAndEqual(admin)) {
                ddlHandler.operationSucceeds();
                return;
            }
            try {
                int planId = admin.getPlanner().createAddIndexPlan("CreateIndex", this.indexName, this.tableName, this.newFields, this.indexComments);
                ddlHandler.approveAndExecute(planId);
            }
            catch (IllegalCommandException ice) {
                ddlHandler.operationFails("CREATE INDEX failed for table " + this.tableName + ", index " + this.indexName + ": " + ice.getMessage());
            }
        }
    }

    public static class DropTable
    extends TableDdlOperation {
        private final OperationContext opCtx;
        private final boolean ifExists;
        private final boolean removeData;
        private final String tableName;

        public DropTable(String tableName, TableImpl tableIfExists, boolean ifExists, boolean removeData) {
            super("DROP TABLE", tableIfExists);
            this.ifExists = ifExists;
            this.removeData = removeData;
            this.tableName = tableName;
            if (tableIfExists == null) {
                this.opCtx = new NoTableOpContext(tableName);
            } else {
                ArrayList<KVStorePrivilege> privsToCheck = new ArrayList<KVStorePrivilege>();
                if (removeData && !tableIfExists.getIndexes().isEmpty()) {
                    privsToCheck.add(new TablePrivilege.DropIndex(tableIfExists.getId()));
                }
                privsToCheck.add(SystemPrivilege.DROP_ANY_TABLE);
                this.opCtx = new AccessCheckUtils.TableContext(this.opName(), tableIfExists, privsToCheck);
            }
        }

        @Override
        public void perform(DdlHandler ddlHandler) {
            Admin admin = ddlHandler.getAdmin();
            if (this.ifExists && this.getTable() == null) {
                ddlHandler.operationSucceeds();
                return;
            }
            try {
                int planId = admin.getPlanner().createRemoveTablePlan("DropTable", this.tableName, this.removeData);
                ddlHandler.approveAndExecute(planId);
            }
            catch (IllegalCommandException ice) {
                ddlHandler.operationFails(this.opName() + " failed for table " + this.tableName + ": " + ice.getMessage());
            }
        }

        @Override
        public OperationContext getOperationCtx() {
            return this.opCtx;
        }
    }

    public static class EvolveTable
    extends TableDdlOperation {
        private final AccessCheckUtils.TableContext opCtx;

        public EvolveTable(TableImpl table) {
            super("EVOLVE TABLE", table);
            this.opCtx = new AccessCheckUtils.TableContext(this.opName(), table, new TablePrivilege.EvolveTable(table.getId()));
        }

        @Override
        public OperationContext getOperationCtx() {
            return this.opCtx;
        }

        @Override
        public void perform(DdlHandler ddlHandler) {
            TableImpl table = this.getTable();
            try {
                int tableVersion = table.getTableVersion() - 1;
                assert (tableVersion > 0);
                int planId = ddlHandler.getAdmin().getPlanner().createEvolveTablePlan("AlterTable", table.getFullName(), tableVersion, table.getFieldMap());
                ddlHandler.approveAndExecute(planId);
            }
            catch (IllegalCommandException ice) {
                ddlHandler.operationFails("ALTER TABLE failed for table " + table.getFullName() + ": " + ice.getMessage());
            }
        }
    }

    public static class CreateTable
    extends TableDdlOperation {
        private final boolean ifNotExists;

        public CreateTable(TableImpl table, boolean ifNotExists) {
            super("CREATE TABLE", table);
            this.ifNotExists = ifNotExists;
        }

        @Override
        public OperationContext getOperationCtx() {
            return new OperationContext(){

                @Override
                public String describe() {
                    return CreateTable.this.opName() + (CreateTable.this.ifNotExists ? " IF NOT EXISTS " : " ") + CreateTable.this.getTable().getFullName();
                }

                @Override
                public List<? extends KVStorePrivilege> getRequiredPrivileges() {
                    return SystemPrivilege.tableCreatePrivList;
                }
            };
        }

        @Override
        public void perform(DdlHandler ddlHandler) {
            TableImpl table = this.getTable();
            try {
                Admin admin = ddlHandler.getAdmin();
                if (this.ifNotExists && this.tableExistsAndEqual(admin)) {
                    ddlHandler.operationSucceeds();
                    return;
                }
                int planId = admin.getPlanner().createAddTablePlan("CreateTable", table.getName(), table.getParentName(), table.getFieldMap(), table.getPrimaryKey(), table.getShardKey(), false, 0, table.getDescription());
                ddlHandler.approveAndExecute(planId);
            }
            catch (IllegalCommandException ice) {
                ddlHandler.operationFails(this.opName() + " failed for table " + table.getFullName() + ": " + ice.getMessage());
            }
        }

        private boolean tableExistsAndEqual(Admin admin) {
            TableImpl existing;
            TableImpl table = this.getTable();
            TableMetadata metadata = admin.getMetadata(TableMetadata.class, Metadata.MetadataType.TABLE);
            if (metadata != null && (existing = metadata.getTable(table.getFullName())) != null) {
                if (existing.fieldsEqual(table)) {
                    return true;
                }
                throw new IllegalCommandException("Table exists but definitions do not match");
            }
            return false;
        }
    }
}

