/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import java.io.PrintStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepGroupMap;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.KVThreadFactory;
import oracle.kv.impl.util.server.LoggerUtils;

public class Snapshot {
    Topology topo;
    CommandServiceAPI cs;
    ExecutorService threadPool;
    boolean verboseOutput;
    PrintStream output;
    SnapshotOperation op;
    private List<SnapResult> success;
    private List<SnapResult> failure;
    private boolean allSucceeded;
    private boolean quorumSucceeded;

    public Snapshot(CommandServiceAPI cs, boolean verboseOutput, PrintStream output) throws RemoteException {
        this.cs = cs;
        this.verboseOutput = verboseOutput;
        this.output = output;
        this.allSucceeded = true;
        this.quorumSucceeded = true;
        this.topo = cs.getTopology();
    }

    public boolean succeeded() {
        return this.allSucceeded;
    }

    public boolean getQuorumSucceeded() {
        return this.quorumSucceeded;
    }

    public List<SnapResult> getSuccesses() {
        return this.success;
    }

    public List<SnapResult> getFailures() {
        return this.failure;
    }

    public SnapshotOperation getOperation() {
        return this.op;
    }

    public String createSnapshot(String name) throws Exception {
        return this.createSnapshot(name, null);
    }

    public String createSnapshot(String name, DatacenterId dcId) throws Exception {
        String snapName = this.makeSnapshotName(name);
        this.verbose("Start create snapshot " + snapName);
        this.resetOperation(SnapshotOperation.CREATE);
        this.makeSnapshotTasks(snapName, dcId);
        this.verbose("Complete create snapshot " + snapName);
        return snapName;
    }

    public void removeSnapshot(String name) throws Exception {
        this.removeSnapshot(name, null);
    }

    public void removeSnapshot(String name, DatacenterId dcId) throws Exception {
        this.verbose("Start remove snapshot " + name);
        this.resetOperation(SnapshotOperation.REMOVE);
        this.makeSnapshotTasks(name, dcId);
        this.verbose("Complete remove snapshot " + name);
    }

    public void removeAllSnapshots() throws Exception {
        this.removeAllSnapshots(null);
    }

    public void removeAllSnapshots(DatacenterId dcId) throws Exception {
        this.verbose("Start remove all snapshots");
        this.resetOperation(SnapshotOperation.REMOVEALL);
        this.makeSnapshotTasks(null, dcId);
        this.verbose("Complete remove all snapshots");
    }

    public String[] listSnapshots() throws RemoteException {
        return this.cs.listSnapshots(null);
    }

    public String[] listSnapshots(StorageNodeId snid) throws RemoteException {
        StorageNode sn = this.topo.get(snid);
        if (sn == null) {
            throw new IllegalArgumentException("No Storage Node found with id " + snid);
        }
        this.verbose("Listing snapshots from Storage Node: " + snid);
        return this.cs.listSnapshots(snid);
    }

    private void resetOperation(SnapshotOperation newOp) {
        this.op = newOp;
        this.allSucceeded = true;
        this.quorumSucceeded = true;
        this.success = null;
        this.failure = null;
    }

    private void makeSnapshotTasks(String name, DatacenterId dcId) throws Exception {
        List<RepNode> repNodes = this.topo.getSortedRepNodes();
        this.createThreadPool();
        List<Future<SnapResult>> taskResults = this.createFutureList();
        Parameters p = this.cs.getParameters();
        for (AdminId id : p.getAdminIds()) {
            AdminParams ap = p.get(id);
            StorageNode sn = this.topo.get(ap.getStorageNodeId());
            if (dcId != null && !sn.getDatacenterId().equals(dcId)) continue;
            this.verbose("Creating task (" + (Object)((Object)this.op) + ") for " + id);
            taskResults.add(this.threadPool.submit(new SnapshotTask(name, (StorageNodeId)sn.getResourceId(), id)));
        }
        for (RepNode rn : repNodes) {
            StorageNode sn = this.topo.get(rn.getStorageNodeId());
            if (dcId != null && !sn.getDatacenterId().equals(dcId)) continue;
            this.verbose("Creating task (" + (Object)((Object)this.op) + ") for " + rn);
            taskResults.add(this.threadPool.submit(new SnapshotTask(name, (StorageNodeId)sn.getResourceId(), (ResourceId)rn.getResourceId())));
        }
        this.waitForResults(taskResults);
    }

    private String makeSnapshotName(String name) {
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyMMdd-HHmmss");
        return format.format(now) + "-" + name;
    }

    private void message(String msg) {
        if (this.output != null) {
            this.output.println(msg);
        }
    }

    private void verbose(String msg) {
        if (this.verboseOutput) {
            this.message(msg);
        }
    }

    private void createThreadPool() {
        if (this.threadPool == null) {
            this.threadPool = Executors.newCachedThreadPool(new KVThreadFactory("Snapshot", null));
        }
    }

    private List<Future<SnapResult>> createFutureList() {
        return new ArrayList<Future<SnapResult>>();
    }

    private void waitForResults(List<Future<SnapResult>> taskResults) {
        this.success = new ArrayList<SnapResult>();
        this.failure = new ArrayList<SnapResult>();
        for (Future<SnapResult> result : taskResults) {
            SnapResult snapResult = null;
            try {
                snapResult = result.get();
            }
            catch (InterruptedException e) {
                snapResult = new SnapResult(this.op, false, null, e, "Interrupted");
            }
            catch (ExecutionException e) {
                snapResult = new SnapResult(this.op, false, null, e, "Fail");
            }
            this.verbose("Task result (" + (Object)((Object)this.op) + "): " + snapResult);
            if (snapResult.getSucceeded()) {
                this.success.add(snapResult);
                continue;
            }
            this.allSucceeded = false;
            this.failure.add(snapResult);
        }
        this.verbose("Operation " + (Object)((Object)this.op) + ", Successful nodes: " + this.success.size() + ", failed nodes: " + this.failure.size());
        this.processResults();
    }

    private void processResults() {
        if (this.allSucceeded) {
            this.verbose("Operation " + (Object)((Object)this.op) + " succeeded for all nodes");
            this.quorumSucceeded = true;
            return;
        }
        HashSet<RepGroupId> repGroups = new HashSet<RepGroupId>();
        boolean adminOK = false;
        for (SnapResult res : this.success) {
            ResourceId rid = res.getService();
            if (rid == null) continue;
            if (rid instanceof RepNodeId) {
                RepGroupId rgid = new RepGroupId(((RepNodeId)rid).getGroupId());
                repGroups.add(rgid);
                continue;
            }
            adminOK = true;
        }
        if (!adminOK) {
            this.quorumSucceeded = false;
        }
        RepGroupMap rgm = this.topo.getRepGroupMap();
        for (RepGroup rg : rgm.getAll()) {
            if (!repGroups.contains(rg.getResourceId())) {
                this.message("Operation " + (Object)((Object)this.op) + " did not succeed for shard " + rg);
                this.quorumSucceeded = false;
                continue;
            }
            this.verbose("Operation " + (Object)((Object)this.op) + " succeeded for shard " + rg);
        }
    }

    private class SnapshotTask
    implements Callable<SnapResult> {
        String name;
        StorageNodeId snid;
        ResourceId rid;

        public SnapshotTask(String name, StorageNodeId snid, ResourceId rid) {
            this.name = name;
            this.snid = snid;
            this.rid = rid;
        }

        @Override
        public SnapResult call() {
            try {
                return Snapshot.this.cs.executeSnapshotOperation(Snapshot.this.op, this.snid, this.rid, this.name);
            }
            catch (Exception e) {
                return new SnapResult(Snapshot.this.op, false, this.rid, e, "Failed");
            }
        }
    }

    public static class SnapResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean result;
        private final ResourceId service;
        private final Exception ex;
        private final String message;
        private final SnapshotOperation op;

        protected SnapResult(SnapshotOperation op, boolean result, ResourceId service, Exception ex, String message) {
            this.op = op;
            this.result = result;
            this.service = service;
            this.ex = ex;
            this.message = ex != null ? message + ", Exception: " + ex : message;
        }

        public boolean getSucceeded() {
            return this.result;
        }

        public ResourceId getService() {
            return this.service;
        }

        public String getMessage() {
            return this.message;
        }

        public Exception getException() {
            return this.ex;
        }

        public String getExceptionStackTrace() {
            if (this.ex != null) {
                return LoggerUtils.getStackTrace(this.ex);
            }
            return "";
        }

        public String toString() {
            return "Operation " + (Object)((Object)this.op) + " on " + this.service + (this.result ? " succeeded" : " failed") + ": " + this.message;
        }
    }

    public static enum SnapshotOperation {
        CREATE,
        REMOVE,
        REMOVEALL;

    }
}

