/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import oracle.kv.KVSecurityException;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.api.table.query.TableDdl;
import oracle.kv.impl.fault.ClientAccessException;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.security.AccessChecker;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.OperationContext;
import oracle.kv.impl.security.SessionAccessException;

public class DdlHandler {
    private final TableDdl tableDdl;
    private final Admin admin;
    private boolean success;
    private String errorString;
    private String resultString;
    private int planId;
    private boolean hasPlan;
    private boolean canRetry;
    private final String statement;
    private final DdlOperationExecutor ddlOpExecutor;

    DdlHandler(String statement, Admin admin, AccessChecker accessChecker) {
        this.admin = admin;
        this.statement = statement;
        this.ddlOpExecutor = new DdlOperationExecutor(this, accessChecker);
        TableMetadata metadata = admin.getMetadata(TableMetadata.class, Metadata.MetadataType.TABLE);
        this.tableDdl = TableDdl.parse(statement, metadata);
        this.success = this.tableDdl.succeeded();
        this.handleResults();
    }

    boolean getSuccess() {
        return this.success;
    }

    String getErrorMessage() {
        return this.errorString;
    }

    String getResultString() {
        return this.resultString;
    }

    void setResultString(String resultStr) {
        this.resultString = resultStr;
    }

    int getPlanId() {
        return this.planId;
    }

    boolean canRetry() {
        return this.canRetry;
    }

    boolean hasPlan() {
        return this.hasPlan;
    }

    boolean isDescribe() {
        return this.tableDdl.isDescribe();
    }

    boolean isShow() {
        return this.tableDdl.isShow();
    }

    Admin getAdmin() {
        return this.admin;
    }

    void operationSucceeds() {
        this.success = true;
    }

    void operationFails(String errMsg) {
        this.success = false;
        this.errorString = errMsg;
    }

    private void handleResults() {
        if (!this.success) {
            this.errorString = this.tableDdl.getErrorMessage();
            return;
        }
        DdlOperation ddlOp = this.tableDdl.getDdlOperation();
        if (ddlOp == null) {
            throw new IllegalStateException("Problem parsing " + this.statement + ": " + this.tableDdl);
        }
        this.ddlOpExecutor.execute(ddlOp);
    }

    void approveAndExecute(int planId1) {
        this.planId = planId1;
        this.approveAndExecute();
    }

    void approveAndExecute() {
        assert (this.planId != 0);
        try {
            this.admin.approvePlan(this.planId);
            this.planId = this.admin.executePlanOrFindMatch(this.planId);
            this.hasPlan = true;
        }
        catch (IllegalCommandException ice) {
            this.errorString = "Failed to execute plan: " + ice.getMessage();
            try {
                this.admin.cancelPlan(this.planId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.planId = 0;
            this.success = false;
            this.canRetry = true;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Success: ");
        sb.append(this.success);
        if (this.success) {
            if (this.hasPlan) {
                sb.append(", plan succeeded: ");
                sb.append(this.planId);
            }
            if (this.resultString != null) {
                sb.append(", success, result string: ");
                sb.append(this.resultString);
            }
        } else {
            sb.append(", operation failed: ");
            sb.append(this.errorString);
        }
        return sb.toString();
    }

    boolean isJson() {
        return this.tableDdl.isDescribeAsJson();
    }

    public static interface DdlOperation {
        public OperationContext getOperationCtx();

        public void perform(DdlHandler var1);
    }

    static class DdlOperationExecutor {
        private final AccessChecker accessChecker;
        private final DdlHandler ddlHandler;

        DdlOperationExecutor(DdlHandler ddlHandler, AccessChecker accessChecker) {
            this.accessChecker = accessChecker;
            this.ddlHandler = ddlHandler;
        }

        void execute(DdlOperation ddlOp) throws SessionAccessException, ClientAccessException {
            ExecutionContext exeCtx = ExecutionContext.getCurrent();
            if (exeCtx != null && this.accessChecker != null) {
                try {
                    this.accessChecker.checkAccess(exeCtx, ddlOp.getOperationCtx());
                }
                catch (KVSecurityException kvse) {
                    throw new ClientAccessException(kvse);
                }
            }
            ddlOp.perform(this.ddlHandler);
        }
    }
}

