/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import com.sleepycat.je.Environment;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.util.DbBackup;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.AdminService;
import oracle.kv.impl.admin.CommandService;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.Snapshot;
import oracle.kv.impl.admin.SnapshotOperationProxy;
import oracle.kv.impl.admin.UpgradeUtil;
import oracle.kv.impl.admin.VerifyConfiguration;
import oracle.kv.impl.admin.VerifyResults;
import oracle.kv.impl.admin.criticalevent.CriticalEvent;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.param.StorageNodePool;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.admin.plan.PlanStateChange;
import oracle.kv.impl.admin.topo.Rules;
import oracle.kv.impl.admin.topo.TopologyCandidate;
import oracle.kv.impl.api.avro.AvroDdl;
import oracle.kv.impl.api.avro.AvroSchemaMetadata;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.mgmt.AdminStatusReceiver;
import oracle.kv.impl.monitor.Tracker;
import oracle.kv.impl.monitor.TrackerListener;
import oracle.kv.impl.monitor.views.PerfEvent;
import oracle.kv.impl.monitor.views.ServiceChange;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.AccessCheckUtils;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.KVStorePrivilegeLabel;
import oracle.kv.impl.security.KVStoreUserPrincipal;
import oracle.kv.impl.security.OperationContext;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.security.TablePrivilege;
import oracle.kv.impl.security.annotations.PublicMethod;
import oracle.kv.impl.security.annotations.SecureAPI;
import oracle.kv.impl.security.annotations.SecureAutoMethod;
import oracle.kv.impl.security.annotations.SecureInternalMethod;
import oracle.kv.impl.security.annotations.SecureR2Method;
import oracle.kv.impl.security.metadata.KVStoreUser;
import oracle.kv.impl.security.metadata.SecurityMetadata;
import oracle.kv.impl.test.RemoteTestInterface;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.AdminType;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.DatacenterType;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.FileNames;
import oracle.kv.impl.util.registry.VersionedRemoteImpl;

@SecureAPI
public class CommandServiceImpl
extends VersionedRemoteImpl
implements CommandService {
    private final AdminService aservice;
    private RemoteTestInterface rti;
    private static final String TEST_INTERFACE_NAME = "oracle.kv.impl.admin.CommandServiceTestInterface";
    private Admin admin;
    private DbBackup dbBackup;

    public CommandServiceImpl(AdminService aservice) {
        this.aservice = aservice;
        this.admin = aservice.getAdmin();
        this.startTestInterface();
    }

    private void startTestInterface() {
        try {
            Class<?> cl = Class.forName(TEST_INTERFACE_NAME);
            Constructor<?> c = cl.getConstructor(this.aservice.getClass());
            this.rti = (RemoteTestInterface)c.newInstance(this.aservice);
            this.rti.start((short)7);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @SecureR2Method
    public synchronized ConfigurableService.ServiceStatus ping(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @PublicMethod
    public synchronized ConfigurableService.ServiceStatus ping(AuthContext authCtx, short serialVersion) {
        return ConfigurableService.ServiceStatus.RUNNING;
    }

    @Override
    @SecureR2Method
    public List<String> getStorageNodePoolNames(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public List<String> getStorageNodePoolNames(AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<List<String>>(){

            @Override
            public List<String> execute() {
                CommandServiceImpl.this.requireConfigured();
                Parameters p = CommandServiceImpl.this.admin.getCurrentParameters();
                ArrayList<String> names = new ArrayList<String>(p.getStorageNodePoolNames());
                Collections.sort(names);
                return names;
            }
        });
    }

    @Override
    @SecureR2Method
    public void addStorageNodePool(String name, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public void addStorageNodePool(final String name, AuthContext authCtx, short serialVersion) {
        this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                CommandServiceImpl.this.requireConfigured();
                CommandServiceImpl.this.admin.addStorageNodePool(name);
            }
        });
    }

    @Override
    @SecureR2Method
    public void removeStorageNodePool(String name, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public void removeStorageNodePool(final String name, AuthContext authCtx, short serialVersion) {
        this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                CommandServiceImpl.this.requireConfigured();
                CommandServiceImpl.this.admin.removeStorageNodePool(name);
            }
        });
    }

    @Override
    @SecureR2Method
    public List<StorageNodeId> getStorageNodePoolIds(String name, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public List<StorageNodeId> getStorageNodePoolIds(final String name, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<List<StorageNodeId>>(){

            @Override
            public List<StorageNodeId> execute() {
                CommandServiceImpl.this.requireConfigured();
                Parameters p = CommandServiceImpl.this.admin.getCurrentParameters();
                StorageNodePool pool = p.getStorageNodePool(name);
                if (pool == null) {
                    throw new IllegalCommandException("No such Storage Node Pool: " + name);
                }
                return pool.getList();
            }
        });
    }

    @Override
    @SecureR2Method
    public void addStorageNodeToPool(String name, StorageNodeId snId, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public void addStorageNodeToPool(final String name, final StorageNodeId snId, AuthContext authCtx, short serialVersion) {
        this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                CommandServiceImpl.this.requireConfigured();
                CommandServiceImpl.this.admin.addStorageNodeToPool(name, snId);
            }
        });
    }

    @Override
    @SecureR2Method
    public void replaceStorageNodePool(String name, List<StorageNodeId> ids, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public void replaceStorageNodePool(final String name, final List<StorageNodeId> ids, AuthContext authCtx, short serialVersion) {
        this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                CommandServiceImpl.this.requireConfigured();
                CommandServiceImpl.this.admin.replaceStorageNodePool(name, ids);
            }
        });
    }

    @Override
    @SecureR2Method
    public String createTopology(String candidateName, String snPoolName, int numPartitions, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public String createTopology(final String candidateName, final String snPoolName, final int numPartitions, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<String>(){

            @Override
            public String execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.createTopoCandidate(candidateName, snPoolName, numPartitions);
            }
        });
    }

    @Override
    @SecureR2Method
    public String copyCurrentTopology(String candidateName, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public String copyCurrentTopology(final String candidateName, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<String>(){

            @Override
            public String execute() {
                CommandServiceImpl.this.requireConfigured();
                CommandServiceImpl.this.admin.addTopoCandidate(candidateName, CommandServiceImpl.this.admin.getCurrentTopology());
                return "Created " + candidateName;
            }
        });
    }

    @Override
    @SecureR2Method
    public String copyTopology(String sourceCandidateName, String targetCandidateName, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public String copyTopology(final String sourceCandidateName, final String targetCandidateName, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<String>(){

            @Override
            public String execute() {
                CommandServiceImpl.this.requireConfigured();
                CommandServiceImpl.this.admin.addTopoCandidate(targetCandidateName, sourceCandidateName);
                return "Created " + targetCandidateName;
            }
        });
    }

    @Override
    @SecureR2Method
    public String validateTopology(String candidateName, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public String validateTopology(final String candidateName, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<String>(){

            @Override
            public String execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.validateTopology(candidateName);
            }
        });
    }

    @Override
    @SecureR2Method
    public List<String> listTopologies(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public List<String> listTopologies(AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<List<String>>(){

            @Override
            public List<String> execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.listTopoCandidates();
            }
        });
    }

    @Override
    @SecureR2Method
    public String deleteTopology(String candidateName, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public String deleteTopology(final String candidateName, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<String>(){

            @Override
            public String execute() {
                CommandServiceImpl.this.requireConfigured();
                CommandServiceImpl.this.admin.deleteTopoCandidate(candidateName);
                return "Removed " + candidateName;
            }
        });
    }

    @Override
    @SecureR2Method
    public String rebalanceTopology(String candidateName, String snPoolName, DatacenterId dcId, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public String rebalanceTopology(final String candidateName, final String snPoolName, final DatacenterId dcId, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<String>(){

            @Override
            public String execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.rebalanceTopology(candidateName, snPoolName, dcId);
            }
        });
    }

    @Override
    @SecureR2Method
    public String changeRepFactor(String candidateName, String snPoolName, DatacenterId dcId, int repFactor, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public String changeRepFactor(final String candidateName, final String snPoolName, final DatacenterId dcId, final int repFactor, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<String>(){

            @Override
            public String execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.changeRepFactor(candidateName, snPoolName, dcId, repFactor);
            }
        });
    }

    @Override
    @SecureR2Method
    public String redistributeTopology(String candidateName, String snPoolName, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public String redistributeTopology(final String candidateName, final String snPoolName, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<String>(){

            @Override
            public String execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.redistributeTopology(candidateName, snPoolName);
            }
        });
    }

    @Override
    @SecureR2Method
    public String moveRN(String candidateName, RepNodeId rnId, StorageNodeId snId, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public String moveRN(final String candidateName, final RepNodeId rnId, final StorageNodeId snId, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<String>(){

            @Override
            public String execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.moveRN(candidateName, rnId, snId);
            }
        });
    }

    @Override
    @SecureR2Method
    public String preview(String targetTopoName, String startTopoName, boolean verbose, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public String preview(final String targetTopoName, final String startTopoName, final boolean verbose, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<String>(){

            @Override
            public String execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.previewTopology(targetTopoName, startTopoName, verbose);
            }
        });
    }

    @Override
    @SecureR2Method
    public List<ParameterMap> getAdmins(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public List<ParameterMap> getAdmins(AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<List<ParameterMap>>(){

            @Override
            public List<ParameterMap> execute() {
                CommandServiceImpl.this.requireConfigured();
                Parameters p = CommandServiceImpl.this.admin.getCurrentParameters();
                ArrayList<ParameterMap> list = new ArrayList<ParameterMap>();
                for (AdminId id : p.getAdminIds()) {
                    list.add(p.get(id).getMap());
                }
                return list;
            }
        });
    }

    @Override
    @SecureR2Method
    public Plan getPlanById(int planId, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureInternalMethod
    public Plan getPlanById(final int planId, AuthContext authCtx, final short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Plan>(){

            @Override
            public Plan execute() {
                CommandServiceImpl.this.requireConfigured();
                CommandServiceImpl.this.checkClientSupported(serialVersion, (short)5);
                Plan plan = CommandServiceImpl.this.admin.getPlanById(planId);
                if (plan != null) {
                    AccessCheckUtils.checkPermission(CommandServiceImpl.this.aservice, new AccessCheckUtils.PlanAccessContext(plan, "Get plan"));
                }
                return plan;
            }
        });
    }

    @Override
    @SecureR2Method
    @Deprecated
    public Map<Integer, Plan> getPlans(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    @Deprecated
    public Map<Integer, Plan> getPlans(AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Map<Integer, Plan>>(){

            @Override
            public Map<Integer, Plan> execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getRecentPlansCopy();
            }
        });
    }

    @Override
    @SecureR2Method
    public void approvePlan(int planId, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureInternalMethod
    public void approvePlan(final int planId, AuthContext authCtx, short serialVersion) {
        this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                CommandServiceImpl.this.requireConfigured();
                Plan plan = CommandServiceImpl.this.admin.getAndCheckPlan(planId);
                AccessCheckUtils.checkPermission(CommandServiceImpl.this.aservice, new AccessCheckUtils.PlanOperationContext(plan, "Approve plan"));
                CommandServiceImpl.this.admin.approvePlan(planId);
            }
        });
    }

    @Override
    @SecureR2Method
    public void executePlan(int planId, boolean force, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureInternalMethod
    public void executePlan(final int planId, final boolean force, AuthContext authCtx, short serialVersion) {
        this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                CommandServiceImpl.this.requireConfigured();
                Plan plan = CommandServiceImpl.this.admin.getAndCheckPlan(planId);
                AccessCheckUtils.checkPermission(CommandServiceImpl.this.aservice, new AccessCheckUtils.PlanOperationContext(plan, "Execute plan"));
                CommandServiceImpl.this.admin.executePlan(planId, force);
            }
        });
    }

    @Override
    @SecureR2Method
    public Plan.State awaitPlan(int planId, int timeout, TimeUnit timeUnit, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureInternalMethod
    public Plan.State awaitPlan(final int planId, final int timeout, final TimeUnit timeUnit, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Plan.State>(){

            @Override
            public Plan.State execute() {
                CommandServiceImpl.this.requireConfigured();
                Plan plan = CommandServiceImpl.this.admin.getAndCheckPlan(planId);
                AccessCheckUtils.checkPermission(CommandServiceImpl.this.aservice, new AccessCheckUtils.PlanOperationContext(plan, "Await plan"));
                return CommandServiceImpl.this.admin.awaitPlan(planId, timeout, timeUnit);
            }
        });
    }

    @Override
    @SecureR2Method
    public void cancelPlan(int planId, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureInternalMethod
    public void cancelPlan(final int planId, AuthContext authCtx, short serialVersion) {
        this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                CommandServiceImpl.this.requireConfigured();
                Plan plan = CommandServiceImpl.this.admin.getAndCheckPlan(planId);
                AccessCheckUtils.checkPermission(CommandServiceImpl.this.aservice, new AccessCheckUtils.PlanOperationContext(plan, "Cancel plan"));
                CommandServiceImpl.this.admin.cancelPlan(planId);
            }
        });
    }

    @Override
    @SecureR2Method
    public void interruptPlan(int planId, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureInternalMethod
    public void interruptPlan(final int planId, AuthContext authCtx, short serialVersion) {
        this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                CommandServiceImpl.this.requireConfigured();
                Plan plan = CommandServiceImpl.this.admin.getAndCheckPlan(planId);
                AccessCheckUtils.checkPermission(CommandServiceImpl.this.aservice, new AccessCheckUtils.PlanOperationContext(plan, "Interrupt plan"));
                CommandServiceImpl.this.admin.interruptPlan(planId);
            }
        });
    }

    @Override
    @SecureR2Method
    public void retryPlan(int planId, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureInternalMethod
    public void retryPlan(final int planId, AuthContext authCtx, short serialVersion) {
        this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                CommandServiceImpl.this.requireConfigured();
                Plan plan = CommandServiceImpl.this.admin.getAndCheckPlan(planId);
                AccessCheckUtils.checkPermission(CommandServiceImpl.this.aservice, new AccessCheckUtils.PlanOperationContext(plan, "Retry plan"));
                CommandServiceImpl.this.admin.executePlan(planId, false);
            }
        });
    }

    @Override
    @Deprecated
    @SecureR2Method
    public void createAndExecuteConfigurationPlan(String kvsName, String dcName, int repFactor, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @Deprecated
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public void createAndExecuteConfigurationPlan(String kvsName, String dcName, int repFactor, AuthContext authCtx, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureR2Method
    public int createDeployDatacenterPlan(String planName, String datacenterName, int repFactor, String datacenterComment, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createDeployDatacenterPlan(final String planName, final String datacenterName, final int repFactor, String datacenterComment, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                try {
                    Rules.validateReplicationFactor(repFactor);
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalCommandException("Bad replication factor", iae);
                }
                return CommandServiceImpl.this.admin.getPlanner().createDeployDatacenterPlan(planName, datacenterName, repFactor, DatacenterType.PRIMARY);
            }
        });
    }

    @Override
    @SecureR2Method
    public int createDeployDatacenterPlan(String planName, String datacenterName, int repFactor, DatacenterType datacenterType, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createDeployDatacenterPlan(final String planName, final String datacenterName, final int repFactor, final DatacenterType datacenterType, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                try {
                    Rules.validateReplicationFactor(repFactor);
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalCommandException("Bad replication factor", iae);
                }
                return CommandServiceImpl.this.admin.getPlanner().createDeployDatacenterPlan(planName, datacenterName, repFactor, datacenterType);
            }
        });
    }

    @Override
    @SecureR2Method
    public int createDeploySNPlan(String planName, DatacenterId datacenterId, String hostName, int registryPort, String comment, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createDeploySNPlan(final String planName, final DatacenterId datacenterId, final String hostName, final int registryPort, final String comment, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                ParameterMap pMap = CommandServiceImpl.this.admin.copyPolicy();
                StorageNodeParams snParams = new StorageNodeParams(pMap, null, hostName, registryPort, comment);
                return CommandServiceImpl.this.admin.getPlanner().createDeploySNPlan(planName, datacenterId, snParams);
            }
        });
    }

    @Override
    @SecureR2Method
    public int createDeployAdminPlan(String planName, StorageNodeId snid, int httpPort, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createDeployAdminPlan(final String planName, final StorageNodeId snid, final int httpPort, final AdminType adminType, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getPlanner().createDeployAdminPlan(planName, snid, httpPort, adminType);
            }
        });
    }

    @Override
    @Deprecated
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createDeployAdminPlan(String planName, StorageNodeId snid, int httpPort, AuthContext authCtx, short serialVersion) {
        return this.createDeployAdminPlan(planName, snid, httpPort, AdminType.PRIMARY, authCtx, serialVersion);
    }

    @Override
    @SecureR2Method
    public int createRemoveAdminPlan(String planName, DatacenterId dcid, AdminId aid, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createRemoveAdminPlan(final String planName, final DatacenterId dcid, final AdminId aid, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getPlanner().createRemoveAdminPlan(planName, dcid, aid);
            }
        });
    }

    @Override
    @SecureR2Method
    public int createDeployTopologyPlan(String planName, String candidateName, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createDeployTopologyPlan(final String planName, final String candidateName, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getPlanner().createDeployTopoPlan(planName, candidateName);
            }
        });
    }

    @Override
    @SecureR2Method
    public int createStopAllRepNodesPlan(String planName, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createStopAllRepNodesPlan(final String planName, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getPlanner().createStopAllRepNodesPlan(planName);
            }
        });
    }

    @Override
    @SecureR2Method
    public int createStartAllRepNodesPlan(String planName, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createStartAllRepNodesPlan(final String planName, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getPlanner().createStartAllRepNodesPlan(planName);
            }
        });
    }

    @Override
    @SecureR2Method
    public int createStopRepNodesPlan(String planName, Set<RepNodeId> ids, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createStopRepNodesPlan(final String planName, final Set<RepNodeId> ids, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getPlanner().createStopRepNodesPlan(planName, ids);
            }
        });
    }

    @Override
    @SecureR2Method
    public int createStartRepNodesPlan(String planName, Set<RepNodeId> ids, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createStartRepNodesPlan(final String planName, final Set<RepNodeId> ids, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getPlanner().createStartRepNodesPlan(planName, ids);
            }
        });
    }

    @Override
    @SecureR2Method
    public int createChangeParamsPlan(String planName, ResourceId rid, ParameterMap newParams, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createChangeParamsPlan(final String planName, final ResourceId rid, final ParameterMap newParams, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getPlanner().createChangeParamsPlan(planName, rid, newParams);
            }
        });
    }

    @Override
    @SecureR2Method
    public int createChangeAllParamsPlan(String planName, DatacenterId dcid, ParameterMap newParams, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createChangeAllParamsPlan(final String planName, final DatacenterId dcid, final ParameterMap newParams, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getPlanner().createChangeAllParamsPlan(planName, dcid, newParams);
            }
        });
    }

    @Override
    @SecureR2Method
    public int createChangeAllAdminsPlan(String planName, DatacenterId dcid, ParameterMap newParams, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createChangeAllAdminsPlan(final String planName, final DatacenterId dcid, final ParameterMap newParams, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getPlanner().createChangeAllAdminsPlan(planName, dcid, newParams);
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createChangeGlobalSecurityParamsPlan(final String planName, final ParameterMap newParams, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getPlanner().createChangeGlobalSecurityParamsPlan(planName, newParams);
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createCreateUserPlan(final String planName, final String userName, final boolean isEnabled, final boolean isAdmin, final char[] plainPassword, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getPlanner().createCreateUserPlan(planName, userName, isEnabled, isAdmin, plainPassword);
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createDropUserPlan(final String planName, final String userName, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getPlanner().createDropUserPlan(planName, userName);
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.USRVIEW})
    public int createChangeUserPlan(final String planName, final String userName, final Boolean isEnabled, final char[] plainPassword, final boolean retainPassword, final boolean clearRetainedPassword, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getPlanner().createChangeUserPlan(planName, userName, isEnabled, plainPassword, retainPassword, clearRetainedPassword);
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createGrantPlan(final String planName, final String grantee, final Set<String> roles, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getPlanner().createGrantPlan(planName, grantee, roles);
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createRevokePlan(final String planName, final String userName, final Set<String> roles, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getPlanner().createRevokePlan(planName, userName, roles);
            }
        });
    }

    @Override
    @SecureR2Method
    public int createMigrateSNPlan(String planName, StorageNodeId oldNode, StorageNodeId newNode, int newHttpPort, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createMigrateSNPlan(final String planName, final StorageNodeId oldNode, final StorageNodeId newNode, final int newHttpPort, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getPlanner().createMigrateSNPlan(planName, oldNode, newNode, newHttpPort);
            }
        });
    }

    @Override
    @SecureR2Method
    public int createRemoveSNPlan(String planName, StorageNodeId targetNode, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createRemoveSNPlan(final String planName, final StorageNodeId targetNode, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getPlanner().createRemoveSNPlan(planName, targetNode);
            }
        });
    }

    @Override
    @SecureR2Method
    public int createRemoveDatacenterPlan(String planName, DatacenterId targetId, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createRemoveDatacenterPlan(final String planName, final DatacenterId targetId, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getPlanner().createRemoveDatacenterPlan(planName, targetId);
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public int createRepairPlan(final String planName, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getPlanner().createRepairPlan(planName);
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.CREATE_ANY_TABLE})
    public int createAddTablePlan(final String planName, final String tableName, final String parentName, final FieldMap fieldMap, final List<String> primaryKey, final List<String> majorKey, final boolean r2compat, final int schemaId, final String description, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                if (schemaId != 0) {
                    CommandServiceImpl.this.validateSchemaId(schemaId);
                }
                return CommandServiceImpl.this.admin.getPlanner().createAddTablePlan(planName, tableName, parentName, fieldMap, primaryKey, majorKey, r2compat, schemaId, description);
            }
        });
    }

    @Override
    @SecureInternalMethod
    public int createRemoveTablePlan(final String planName, final String tableName, final boolean removeData, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                TableImpl table = CommandServiceImpl.this.getAndCheckTable(tableName);
                ArrayList<KVStorePrivilege> privsToCheck = new ArrayList<KVStorePrivilege>();
                if (removeData && !table.getIndexes().isEmpty()) {
                    privsToCheck.add(new TablePrivilege.DropIndex(table.getId()));
                }
                privsToCheck.add(SystemPrivilege.DROP_ANY_TABLE);
                AccessCheckUtils.checkPermission(CommandServiceImpl.this.aservice, new AccessCheckUtils.TableContext("Drop table", table, privsToCheck));
                return CommandServiceImpl.this.admin.getPlanner().createRemoveTablePlan(planName, tableName, removeData);
            }
        });
    }

    @Override
    @SecureInternalMethod
    public int createAddIndexPlan(final String planName, final String indexName, final String tableName, final String[] indexedFields, final String description, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                TableImpl table = CommandServiceImpl.this.getAndCheckTable(tableName);
                TablePrivilege.CreateIndex privToCheck = new TablePrivilege.CreateIndex(table.getId());
                AccessCheckUtils.checkPermission(CommandServiceImpl.this.aservice, new AccessCheckUtils.TableContext("Create index", table, privToCheck));
                return CommandServiceImpl.this.admin.getPlanner().createAddIndexPlan(planName, indexName, tableName, indexedFields, description);
            }
        });
    }

    @Override
    @SecureInternalMethod
    public int createRemoveIndexPlan(final String planName, final String indexName, final String tableName, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                TableImpl table = CommandServiceImpl.this.getAndCheckTable(tableName);
                TablePrivilege.DropIndex privToCheck = new TablePrivilege.DropIndex(table.getId());
                AccessCheckUtils.checkPermission(CommandServiceImpl.this.aservice, new AccessCheckUtils.TableContext("Drop index", table, privToCheck));
                return CommandServiceImpl.this.admin.getPlanner().createRemoveIndexPlan(planName, indexName, tableName);
            }
        });
    }

    @Override
    @SecureInternalMethod
    public int createEvolveTablePlan(final String planName, final String tableName, final int tableVersion, final FieldMap fieldMap, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                CommandServiceImpl.this.requireConfigured();
                TableImpl table = CommandServiceImpl.this.getAndCheckTable(tableName);
                TablePrivilege.EvolveTable privToCheck = new TablePrivilege.EvolveTable(table.getId());
                AccessCheckUtils.checkPermission(CommandServiceImpl.this.aservice, new AccessCheckUtils.TableContext("Evolve table", table, privToCheck));
                return CommandServiceImpl.this.admin.getPlanner().createEvolveTablePlan(planName, tableName, tableVersion, fieldMap);
            }
        });
    }

    @Override
    @SecureInternalMethod
    public <T extends Metadata<? extends MetadataInfo>> T getMetadata(final Class<T> returnType, final Metadata.MetadataType metadataType, AuthContext authCtx, short serialVersion) {
        return (T)((Metadata)this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<T>(){

            @Override
            public T execute() {
                CommandServiceImpl.this.requireConfigured();
                AccessCheckUtils.checkPermission(CommandServiceImpl.this.aservice, new MetadataAccessContext(metadataType));
                return CommandServiceImpl.this.admin.getMetadata(returnType, metadataType);
            }
        }));
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public void putMetadata(final Metadata<?> metadata, AuthContext authCtx, short serialVersion) {
        this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                CommandServiceImpl.this.requireConfigured();
                CommandServiceImpl.this.admin.saveMetadata(metadata, null);
                Metadata.MetadataType type = metadata.getType();
                int planId = 0;
                switch (type) {
                    case TABLE: {
                        planId = CommandServiceImpl.this.admin.getPlanner().createBroadcastTableMDPlan();
                        break;
                    }
                    case SECURITY: {
                        planId = CommandServiceImpl.this.admin.getPlanner().createBroadcastSecurityMDPlan();
                        break;
                    }
                    default: {
                        throw new IllegalCommandException("Invalid metadata type: " + (Object)((Object)type));
                    }
                }
                CommandServiceImpl.this.admin.approvePlan(planId);
                CommandServiceImpl.this.admin.executePlan(planId, false);
                CommandServiceImpl.this.admin.awaitPlan(planId, 0, null);
                CommandServiceImpl.this.admin.assertSuccess(planId);
            }
        });
    }

    @Override
    @SecureR2Method
    public Topology getTopology(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public Topology getTopology(AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Topology>(){

            @Override
            public Topology execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getCurrentTopology();
            }
        });
    }

    @Override
    @SecureR2Method
    public Parameters getParameters(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public Parameters getParameters(AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Parameters>(){

            @Override
            public Parameters execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getCurrentParameters();
            }
        });
    }

    @Override
    @SecureR2Method
    public ParameterMap getRepNodeParameters(RepNodeId rnid, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public ParameterMap getRepNodeParameters(final RepNodeId rnid, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<ParameterMap>(){

            @Override
            public ParameterMap execute() {
                CommandServiceImpl.this.requireConfigured();
                Parameters p = CommandServiceImpl.this.admin.getCurrentParameters();
                if (p.get(rnid) != null) {
                    return p.get(rnid).getMap();
                }
                throw new IllegalCommandException("RepNode does not exist: " + rnid);
            }
        });
    }

    @Override
    @SecureR2Method
    public ParameterMap getPolicyParameters(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public ParameterMap getPolicyParameters(AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<ParameterMap>(){

            @Override
            public ParameterMap execute() {
                CommandServiceImpl.this.requireConfigured();
                Parameters p = CommandServiceImpl.this.admin.getCurrentParameters();
                return p.getPolicies();
            }
        });
    }

    @Override
    @SecureR2Method
    public void newParameters(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public void newParameters(AuthContext authCtx, short serialVersion) {
        this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                if (CommandServiceImpl.this.admin != null) {
                    CommandServiceImpl.this.admin.newParameters();
                }
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public void newGlobalParameters(AuthContext authCtx, short serialVersion) {
        this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                if (CommandServiceImpl.this.admin != null) {
                    CommandServiceImpl.this.admin.newGlobalParameters();
                }
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public void newSecurityMDChange(AuthContext authCtx, short serialVersion) {
        this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                CommandServiceImpl.this.requireConfigured();
                CommandServiceImpl.this.admin.newSecurityMDChange();
            }
        });
    }

    @Override
    @SecureR2Method
    public void configure(String storeName, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public void configure(final String storeName, AuthContext authCtx, short serialVersion) {
        this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                CommandServiceImpl.this.requireNotConfigured();
                CommandServiceImpl.this.aservice.configure(storeName);
                CommandServiceImpl.this.admin = CommandServiceImpl.this.aservice.getAdmin();
            }
        });
    }

    @Override
    @SecureR2Method
    public String getStoreName(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public String getStoreName(AuthContext authCtx, short serialVersion) {
        if (this.admin != null) {
            return this.admin.getParams().getGlobalParams().getKVStoreName();
        }
        return null;
    }

    @Override
    @SecureR2Method
    public String getRootDir(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public String getRootDir(AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<String>(){

            @Override
            public String execute() {
                if (CommandServiceImpl.this.admin != null) {
                    return CommandServiceImpl.this.admin.getParams().getStorageNodeParams().getRootDirPath();
                }
                return null;
            }
        });
    }

    @Override
    @SecureR2Method
    public void stop(boolean force, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public void stop(final boolean force, AuthContext authCtx, short serialVersion) {
        this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                block3: {
                    CommandServiceImpl.this.aservice.stop(force);
                    try {
                        if (CommandServiceImpl.this.rti != null) {
                            CommandServiceImpl.this.rti.stop((short)7);
                        }
                    }
                    catch (RemoteException e) {
                        Logger logger;
                        if (CommandServiceImpl.this.admin == null || (logger = CommandServiceImpl.this.admin.getLogger()) == null) break block3;
                        logger.log(Level.INFO, "Ignore exception while stopping  remoteTestInterface", e);
                    }
                }
            }
        });
    }

    @Override
    @SecureR2Method
    public void setPolicies(ParameterMap policyMap, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public void setPolicies(final ParameterMap policyMap, AuthContext authCtx, short serialVersion) {
        this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                CommandServiceImpl.this.admin.setPolicy(policyMap);
            }
        });
    }

    @Override
    @SecureR2Method
    public Map<ResourceId, ServiceChange> getStatusMap(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public Map<ResourceId, ServiceChange> getStatusMap(AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Map<ResourceId, ServiceChange>>(){

            @Override
            public Map<ResourceId, ServiceChange> execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getMonitor().getServiceChangeTracker().getStatus();
            }
        });
    }

    @Override
    @SecureR2Method
    public Map<ResourceId, PerfEvent> getPerfMap(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public Map<ResourceId, PerfEvent> getPerfMap(AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Map<ResourceId, PerfEvent>>(){

            @Override
            public Map<ResourceId, PerfEvent> execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getMonitor().getPerfTracker().getPerf();
            }
        });
    }

    @Override
    @SecureR2Method
    public Tracker.RetrievedEvents<ServiceChange> getStatusSince(long since, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public Tracker.RetrievedEvents<ServiceChange> getStatusSince(final long since, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Tracker.RetrievedEvents<ServiceChange>>(){

            @Override
            public Tracker.RetrievedEvents<ServiceChange> execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getMonitor().getServiceChangeTracker().retrieveNewEvents(since);
            }
        });
    }

    @Override
    @SecureR2Method
    public Tracker.RetrievedEvents<PerfEvent> getPerfSince(long since, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public Tracker.RetrievedEvents<PerfEvent> getPerfSince(long since, AuthContext authCtx, short serialVersion) {
        this.requireConfigured();
        return this.admin.getMonitor().getPerfTracker().retrieveNewEvents(since);
    }

    @Override
    @SecureR2Method
    public Tracker.RetrievedEvents<LogRecord> getLogSince(long since, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public Tracker.RetrievedEvents<LogRecord> getLogSince(long since, AuthContext authCtx, short serialVersion) {
        this.requireConfigured();
        this.checkClientSupported(serialVersion, (short)5);
        return this.admin.getMonitor().getLogTracker().retrieveNewEvents(since);
    }

    @Override
    @SecureR2Method
    public Tracker.RetrievedEvents<PlanStateChange> getPlanSince(long since, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public Tracker.RetrievedEvents<PlanStateChange> getPlanSince(long since, AuthContext authCtx, short serialVersion) {
        this.requireConfigured();
        return this.admin.getMonitor().getPlanTracker().retrieveNewEvents(since);
    }

    @Override
    @SecureR2Method
    public void registerLogTrackerListener(TrackerListener tl, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public void registerLogTrackerListener(TrackerListener tl, AuthContext authCtx, short serialVersion) {
        this.requireConfigured();
        this.admin.getMonitor().getLogTracker().registerListener(tl);
    }

    @Override
    @SecureR2Method
    public void removeLogTrackerListener(TrackerListener tl, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public void removeLogTrackerListener(TrackerListener tl, AuthContext authCtx, short serialVersion) {
        this.requireConfigured();
        this.admin.getMonitor().getLogTracker().removeListener(tl);
    }

    @Override
    @SecureR2Method
    public void registerStatusTrackerListener(TrackerListener tl, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public void registerStatusTrackerListener(TrackerListener tl, AuthContext authCtx, short serialVersion) {
        this.requireConfigured();
        this.admin.getMonitor().getServiceChangeTracker().registerListener(tl);
    }

    @Override
    @SecureR2Method
    public void removeStatusTrackerListener(TrackerListener tl, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public void removeStatusTrackerListener(TrackerListener tl, AuthContext authCtx, short serialVersion) {
        this.requireConfigured();
        this.admin.getMonitor().getServiceChangeTracker().removeListener(tl);
    }

    @Override
    @SecureR2Method
    public void registerPerfTrackerListener(TrackerListener tl, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public void registerPerfTrackerListener(TrackerListener tl, AuthContext authCtx, short serialVersion) {
        this.requireConfigured();
        this.admin.getMonitor().getPerfTracker().registerListener(tl);
    }

    @Override
    @SecureR2Method
    public void removePerfTrackerListener(TrackerListener tl, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public void removePerfTrackerListener(TrackerListener tl, AuthContext authCtx, short serialVersion) {
        this.requireConfigured();
        this.admin.getMonitor().getPerfTracker().removeListener(tl);
    }

    @Override
    @SecureR2Method
    public void registerPlanTrackerListener(TrackerListener tl, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public void registerPlanTrackerListener(TrackerListener tl, AuthContext authCtx, short serialVersion) {
        this.requireConfigured();
        this.admin.getMonitor().getPlanTracker().registerListener(tl);
    }

    @Override
    @SecureR2Method
    public void removePlanTrackerListener(TrackerListener tl, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public void removePlanTrackerListener(TrackerListener tl, AuthContext authCtx, short serialVersion) {
        this.requireConfigured();
        this.admin.getMonitor().getPlanTracker().removeListener(tl);
    }

    @Override
    @SecureR2Method
    public Map<String, Long> getLogFileNames(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public Map<String, Long> getLogFileNames(final AuthContext authCtx, final short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Map<String, Long>>(){

            @Override
            public Map<String, Long> execute() {
                File[] files;
                CommandServiceImpl.this.requireConfigured();
                HashMap<String, Long> namesToTimes = new HashMap<String, Long>();
                File logDir = FileNames.getLoggingDir(new File(CommandServiceImpl.this.getRootDir(authCtx, serialVersion)), CommandServiceImpl.this.getStoreName(authCtx, serialVersion));
                for (File f : files = logDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String fname) {
                        return fname.endsWith("log") || fname.endsWith("perf") || fname.endsWith("stat") || fname.endsWith("_detail.csv") || fname.endsWith("_summary.csv");
                    }
                })) {
                    String name = f.getName();
                    long modTime = f.lastModified();
                    namesToTimes.put(name, new Long(modTime));
                }
                return namesToTimes;
            }
        });
    }

    private void checkReady() {
        if (!this.admin.isReady()) {
            throw new IllegalCommandException("The Admin is not ready to serve this request.  Please try again later");
        }
    }

    private void requireConfigured() {
        if (this.admin == null) {
            throw new IllegalCommandException("This command can't be used until the Admin is configured.");
        }
        this.checkReady();
    }

    private void requireNotConfigured() {
        if (this.admin != null) {
            throw new IllegalCommandException("This command is valid only in bootstrap/configuration mode.");
        }
    }

    private void checkClientSupported(short clientSerialVersion, short requiredSerialVersion) {
        if (clientSerialVersion < requiredSerialVersion) {
            throw new UnsupportedOperationException("The client is incompatible with the Admin service. Please upgrade the client to version " + KVVersion.CURRENT_VERSION.getNumericVersionString());
        }
    }

    @Override
    @SecureR2Method
    public ReplicatedEnvironment.State getAdminState(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.USRVIEW})
    public ReplicatedEnvironment.State getAdminState(AuthContext authCtx, final short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<ReplicatedEnvironment.State>(){

            @Override
            public ReplicatedEnvironment.State execute() {
                CommandServiceImpl.this.checkClientSupported(serialVersion, (short)2);
                if (CommandServiceImpl.this.admin == null) {
                    return null;
                }
                try {
                    return CommandServiceImpl.this.admin.getReplicationMode();
                }
                catch (IllegalStateException iae) {
                    return ReplicatedEnvironment.State.DETACHED;
                }
            }
        });
    }

    @Override
    @SecureR2Method
    public URI getMasterRmiAddress(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.USRVIEW})
    public URI getMasterRmiAddress(AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<URI>(){

            @Override
            public URI execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getMasterRmiAddress();
            }
        });
    }

    @Override
    @SecureR2Method
    public URI getMasterHttpAddress(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.USRVIEW})
    public URI getMasterHttpAddress(AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<URI>(){

            @Override
            public URI execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getMasterHttpAddress();
            }
        });
    }

    @Override
    @SecureR2Method
    public List<CriticalEvent> getEvents(long startTime, long endTime, CriticalEvent.EventType type, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public List<CriticalEvent> getEvents(final long startTime, final long endTime, final CriticalEvent.EventType type, AuthContext authCtx, final short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<List<CriticalEvent>>(){

            @Override
            public List<CriticalEvent> execute() {
                CommandServiceImpl.this.requireConfigured();
                CommandServiceImpl.this.checkClientSupported(serialVersion, (short)5);
                return CommandServiceImpl.this.admin.getEvents(startTime, endTime, type);
            }
        });
    }

    @Override
    @SecureR2Method
    public CriticalEvent getOneEvent(String eventId, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public CriticalEvent getOneEvent(final String eventId, AuthContext authCtx, final short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<CriticalEvent>(){

            @Override
            public CriticalEvent execute() {
                CommandServiceImpl.this.requireConfigured();
                CommandServiceImpl.this.checkClientSupported(serialVersion, (short)5);
                return CommandServiceImpl.this.admin.getOneEvent(eventId);
            }
        });
    }

    @Override
    @SecureR2Method
    public String[] startBackup(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public String[] startBackup(AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<String[]>(){

            @Override
            public String[] execute() {
                CommandServiceImpl.this.requireConfigured();
                ReplicatedEnvironment env = CommandServiceImpl.this.admin.getEnv();
                if (CommandServiceImpl.this.dbBackup != null) {
                    CommandServiceImpl.this.dbBackup.endBackup();
                }
                CommandServiceImpl.this.dbBackup = new DbBackup((Environment)env);
                CommandServiceImpl.this.dbBackup.startBackup();
                return CommandServiceImpl.this.dbBackup.getLogFilesInBackupSet();
            }
        });
    }

    @Override
    @SecureR2Method
    public long stopBackup(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public long stopBackup(AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Long>(){

            @Override
            public Long execute() {
                CommandServiceImpl.this.requireConfigured();
                long lastFile = -1L;
                if (CommandServiceImpl.this.dbBackup != null) {
                    lastFile = CommandServiceImpl.this.dbBackup.getLastFileInBackupSet();
                    CommandServiceImpl.this.dbBackup.endBackup();
                    CommandServiceImpl.this.dbBackup = null;
                }
                return lastFile;
            }
        });
    }

    @Override
    @SecureR2Method
    public void updateMemberHAAddress(AdminId targetId, String targetHelperHosts, String newNodeHostPort, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public void updateMemberHAAddress(final AdminId targetId, final String targetHelperHosts, final String newNodeHostPort, AuthContext authCtx, short serialVersion) {
        this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                CommandServiceImpl.this.requireConfigured();
                CommandServiceImpl.this.aservice.updateMemberHAAddress(targetId, targetHelperHosts, newNodeHostPort);
            }
        });
    }

    @Override
    @SecureR2Method
    public VerifyResults verifyConfiguration(boolean showProgress, boolean listAll, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    @Deprecated
    public VerifyResults verifyConfiguration(boolean showProgress, boolean listAll, AuthContext authCtx, short serialVersion) {
        return this.verifyConfiguration(showProgress, listAll, false, authCtx, serialVersion);
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public VerifyResults verifyConfiguration(final boolean showProgress, final boolean listAll, final boolean json, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<VerifyResults>(){

            @Override
            public VerifyResults execute() {
                CommandServiceImpl.this.requireConfigured();
                VerifyConfiguration checker = new VerifyConfiguration(CommandServiceImpl.this.admin, showProgress, listAll, json, CommandServiceImpl.this.admin.getLogger());
                checker.verifyTopology();
                return checker.getResults();
            }
        });
    }

    @Override
    @SecureR2Method
    public VerifyResults verifyUpgrade(KVVersion targetVersion, List<StorageNodeId> snIds, boolean showProgress, boolean listAll, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public VerifyResults verifyUpgrade(final KVVersion targetVersion, final List<StorageNodeId> snIds, final boolean showProgress, final boolean listAll, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<VerifyResults>(){

            @Override
            public VerifyResults execute() {
                CommandServiceImpl.this.requireConfigured();
                VerifyConfiguration checker = new VerifyConfiguration(CommandServiceImpl.this.admin, showProgress, listAll, false, CommandServiceImpl.this.admin.getLogger());
                checker.verifyUpgrade(targetVersion, snIds);
                return checker.getResults();
            }
        });
    }

    @Override
    @SecureR2Method
    public VerifyResults verifyPrerequisite(KVVersion targetVersion, KVVersion prerequisiteVersion, List<StorageNodeId> snIds, boolean showProgress, boolean listAll, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public VerifyResults verifyPrerequisite(final KVVersion targetVersion, final KVVersion prerequisiteVersion, final List<StorageNodeId> snIds, final boolean showProgress, final boolean listAll, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<VerifyResults>(){

            @Override
            public VerifyResults execute() {
                CommandServiceImpl.this.requireConfigured();
                VerifyConfiguration checker = new VerifyConfiguration(CommandServiceImpl.this.admin, showProgress, listAll, false, CommandServiceImpl.this.admin.getLogger());
                checker.verifyPrerequisite(targetVersion, prerequisiteVersion, snIds);
                return checker.getResults();
            }
        });
    }

    @Override
    @SecureR2Method
    public LoadParameters getParams(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public LoadParameters getParams(AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<LoadParameters>(){

            @Override
            public LoadParameters execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getAllParams();
            }
        });
    }

    @Override
    @SecureR2Method
    public String getStorewideLogName(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public String getStorewideLogName(AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<String>(){

            @Override
            public String execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getStorewideLogName();
            }
        });
    }

    @Override
    @SecureR2Method
    public TopologyCandidate getTopologyCandidate(String candidateName, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public TopologyCandidate getTopologyCandidate(final String candidateName, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<TopologyCandidate>(){

            @Override
            public TopologyCandidate execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.getCandidate(candidateName);
            }
        });
    }

    @Override
    @SecureR2Method
    public List<String> getTopologyHistory(boolean concise, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public List<String> getTopologyHistory(final boolean concise, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<List<String>>(){

            @Override
            public List<String> execute() {
                CommandServiceImpl.this.requireConfigured();
                return CommandServiceImpl.this.admin.displayRealizedTopologies(concise);
            }
        });
    }

    @Override
    @SecureR2Method
    public SortedMap<String, AvroDdl.SchemaSummary> getSchemaSummaries(boolean includeDisabled, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.DBVIEW})
    public SortedMap<String, AvroDdl.SchemaSummary> getSchemaSummaries(final boolean includeDisabled, AuthContext authCtx, short serialVersion) {
        this.requireConfigured();
        return AvroDdl.execute(this.aservice, new AvroDdl.Command<SortedMap<String, AvroDdl.SchemaSummary>>(){

            @Override
            public SortedMap<String, AvroDdl.SchemaSummary> execute(AvroDdl ddl) {
                return ddl.getSchemaSummaries(includeDisabled);
            }
        });
    }

    @Override
    @SecureR2Method
    public AvroDdl.SchemaDetails getSchemaDetails(int schemaId, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.DBVIEW})
    public AvroDdl.SchemaDetails getSchemaDetails(final int schemaId, AuthContext authCtx, short serialVersion) {
        this.requireConfigured();
        return AvroDdl.execute(this.aservice, new AvroDdl.Command<AvroDdl.SchemaDetails>(){

            @Override
            public AvroDdl.SchemaDetails execute(AvroDdl ddl) {
                return ddl.getSchemaDetails(schemaId);
            }
        });
    }

    @Override
    @SecureR2Method
    public AvroDdl.AddSchemaResult addSchema(AvroSchemaMetadata metadata, String schemaText, AvroDdl.AddSchemaOptions options, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSDBA})
    public AvroDdl.AddSchemaResult addSchema(final AvroSchemaMetadata metadata, final String schemaText, final AvroDdl.AddSchemaOptions options, AuthContext authCtx, short serialVersion) {
        this.requireConfigured();
        return AvroDdl.execute(this.aservice, new AvroDdl.Command<AvroDdl.AddSchemaResult>(){

            @Override
            public AvroDdl.AddSchemaResult execute(AvroDdl ddl) {
                return ddl.addSchema(metadata, schemaText, options, CommandServiceImpl.this.admin.getStoreVersion());
            }
        });
    }

    @Override
    @SecureR2Method
    public boolean updateSchemaStatus(int schemaId, AvroSchemaMetadata newMeta, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSDBA})
    public boolean updateSchemaStatus(final int schemaId, final AvroSchemaMetadata newMeta, AuthContext authCtx, short serialVersion) {
        this.requireConfigured();
        return AvroDdl.execute(this.aservice, new AvroDdl.Command<Boolean>(){

            @Override
            public Boolean execute(AvroDdl ddl) {
                return ddl.updateSchemaStatus(schemaId, newMeta, CommandServiceImpl.this.admin.getStoreVersion());
            }
        });
    }

    @Override
    @SecureR2Method
    public void assertSuccess(int planId, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureInternalMethod
    public void assertSuccess(final int planId, AuthContext authCtx, short serialVersion) throws RemoteException {
        this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                CommandServiceImpl.this.requireConfigured();
                Plan plan = CommandServiceImpl.this.admin.getAndCheckPlan(planId);
                AccessCheckUtils.checkPermission(CommandServiceImpl.this.aservice, new AccessCheckUtils.PlanAccessContext(plan, "Assert success"));
                CommandServiceImpl.this.admin.assertSuccess(planId);
            }
        });
    }

    @Override
    @SecureR2Method
    public String getPlanStatus(int planId, long options, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureInternalMethod
    public String getPlanStatus(final int planId, final long options, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<String>(){

            @Override
            public String execute() {
                CommandServiceImpl.this.requireConfigured();
                Plan plan = CommandServiceImpl.this.admin.getAndCheckPlan(planId);
                AccessCheckUtils.checkPermission(CommandServiceImpl.this.aservice, new AccessCheckUtils.PlanAccessContext(plan, "Get plan status"));
                return CommandServiceImpl.this.admin.getPlanStatus(planId, options);
            }
        });
    }

    @Override
    @SecureR2Method
    public void installStatusReceiver(AdminStatusReceiver asr, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public void installStatusReceiver(final AdminStatusReceiver asr, AuthContext authCtx, short serialVersion) throws RemoteException {
        this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                CommandServiceImpl.this.aservice.installStatusReceiver(asr);
            }
        });
    }

    @Override
    @SecureR2Method
    public String getUpgradeOrder(KVVersion targetVersion, KVVersion prerequisiteVersion, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public String getUpgradeOrder(final KVVersion targetVersion, final KVVersion prerequisiteVersion, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<String>(){

            @Override
            public String execute() {
                CommandServiceImpl.this.requireConfigured();
                return UpgradeUtil.generateUpgradeList(CommandServiceImpl.this.admin, targetVersion, prerequisiteVersion);
            }
        });
    }

    @Override
    @SecureR2Method
    public int[] getPlanIdRange(long startTime, long endTime, int howMany, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.USRVIEW})
    public int[] getPlanIdRange(final long startTime, final long endTime, final int howMany, AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<int[]>(){

            @Override
            public int[] execute() {
                CommandServiceImpl.this.requireConfigured();
                ExecutionContext currentCtx = ExecutionContext.getCurrent();
                if (currentCtx == null || currentCtx.hasPrivilege(SystemPrivilege.SYSVIEW)) {
                    return CommandServiceImpl.this.admin.getPlanIdRange(startTime, endTime, howMany, null);
                }
                return CommandServiceImpl.this.admin.getPlanIdRange(startTime, endTime, howMany, CommandServiceImpl.getCurrentUserId());
            }
        });
    }

    @Override
    @SecureR2Method
    public Map<Integer, Plan> getPlanRange(int firstPlanId, int howMany, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.USRVIEW})
    public Map<Integer, Plan> getPlanRange(final int firstPlanId, final int howMany, AuthContext authCtx, final short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Map<Integer, Plan>>(){

            @Override
            public Map<Integer, Plan> execute() {
                CommandServiceImpl.this.requireConfigured();
                CommandServiceImpl.this.checkClientSupported(serialVersion, (short)5);
                ExecutionContext currentCtx = ExecutionContext.getCurrent();
                if (currentCtx == null || currentCtx.hasPrivilege(SystemPrivilege.SYSVIEW)) {
                    return CommandServiceImpl.this.admin.getPlanRange(firstPlanId, howMany, null);
                }
                return CommandServiceImpl.this.admin.getPlanRange(firstPlanId, howMany, CommandServiceImpl.getCurrentUserId());
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.USRVIEW})
    public Map<String, KVStoreUser.UserDescription> getUsersDescription(AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Map<String, KVStoreUser.UserDescription>>(){

            @Override
            public Map<String, KVStoreUser.UserDescription> execute() {
                CommandServiceImpl.this.requireConfigured();
                SecurityMetadata md = CommandServiceImpl.this.admin.getMetadata(SecurityMetadata.class, Metadata.MetadataType.SECURITY);
                if (md == null) {
                    return null;
                }
                ExecutionContext currentCtx = ExecutionContext.getCurrent();
                if (currentCtx == null || currentCtx.hasPrivilege(SystemPrivilege.SYSVIEW)) {
                    return md.getUsersDescription();
                }
                return md.getCurrentUserDescription();
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public boolean verifyUserPassword(final String userName, final char[] password, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Boolean>(){

            @Override
            public Boolean execute() {
                CommandServiceImpl.this.requireConfigured();
                SecurityMetadata md = CommandServiceImpl.this.admin.getMetadata(SecurityMetadata.class, Metadata.MetadataType.SECURITY);
                return md == null ? false : md.verifyUserPassword(userName, password);
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    public Snapshot.SnapResult executeSnapshotOperation(final Snapshot.SnapshotOperation sop, final StorageNodeId snid, final ResourceId rid, final String sname, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Snapshot.SnapResult>(){

            @Override
            public Snapshot.SnapResult execute() {
                CommandServiceImpl.this.requireConfigured();
                return new SnapshotOperationProxy(CommandServiceImpl.this.admin).executeSnapshotOp(sop, snid, rid, sname);
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public String[] listSnapshots(final StorageNodeId snid, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<String[]>(){

            @Override
            public String[] execute() {
                CommandServiceImpl.this.requireConfigured();
                return new SnapshotOperationProxy(CommandServiceImpl.this.admin).listSnapshots(snid);
            }
        });
    }

    private void validateSchemaId(int schemaId) {
        AvroDdl.SchemaDetails details = this.getSchemaDetails(schemaId, null, (short)0);
    }

    private static String getCurrentUserId() {
        KVStoreUserPrincipal currentUser = KVStoreUserPrincipal.getCurrentUser();
        if (currentUser == null) {
            throw new IllegalCommandException("Cannot identify current user");
        }
        return currentUser.getUserId();
    }

    private TableImpl getAndCheckTable(String tableName) {
        TableImpl table;
        TableMetadata tableMd = this.aservice.getAdmin().getMetadata(TableMetadata.class, Metadata.MetadataType.TABLE);
        TableImpl tableImpl = table = tableMd == null ? null : tableMd.getTable(tableName);
        if (table == null) {
            throw new IllegalCommandException("Could not find table: " + tableName);
        }
        return table;
    }

    private static class MetadataAccessContext
    implements OperationContext {
        private final Metadata.MetadataType mdType;

        private MetadataAccessContext(Metadata.MetadataType type) {
            this.mdType = type;
        }

        @Override
        public String describe() {
            return "Metadata request for type: " + (Object)((Object)this.mdType);
        }

        @Override
        public List<? extends KVStorePrivilege> getRequiredPrivileges() {
            if (this.mdType.equals((Object)Metadata.MetadataType.TABLE)) {
                return SystemPrivilege.dbviewPrivList;
            }
            return SystemPrivilege.internalPrivList;
        }
    }
}

