/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import java.net.URI;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.AdminFaultException;
import oracle.kv.impl.admin.AdminService;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.client.admin.ClientAdminService;
import oracle.kv.impl.client.admin.ExecutionInfo;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.security.AccessCheckUtils;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.KVStorePrivilegeLabel;
import oracle.kv.impl.security.annotations.SecureAPI;
import oracle.kv.impl.security.annotations.SecureAutoMethod;
import oracle.kv.impl.security.annotations.SecureInternalMethod;
import oracle.kv.impl.util.registry.VersionedRemoteImpl;

@SecureAPI
public class ClientAdminServiceImpl
extends VersionedRemoteImpl
implements ClientAdminService {
    private final AdminService aservice;

    public ClientAdminServiceImpl(AdminService aservice) {
        this.aservice = aservice;
    }

    @Override
    @SecureInternalMethod
    public ExecutionInfo execute(final String statement, AuthContext authCtx, final short serialVersion) {
        final Admin admin = this.aservice.getAdmin();
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<ExecutionInfo>(){

            @Override
            public ExecutionInfo execute() {
                return admin.executeStatement(statement, serialVersion);
            }
        });
    }

    @Override
    @SecureInternalMethod
    public ExecutionInfo getExecutionStatus(final int planId, AuthContext authCtx, final short serialVersion) {
        final Admin admin = this.aservice.getAdmin();
        ExecutionInfo info = this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<ExecutionInfo>(){

            @Override
            public ExecutionInfo execute() {
                Plan plan = admin.getAndCheckPlan(planId);
                AccessCheckUtils.checkPermission(ClientAdminServiceImpl.this.aservice, new AccessCheckUtils.PlanAccessContext(plan, "getExecutionStatus"));
                return admin.getExecutionStatus(planId, serialVersion);
            }
        });
        return info;
    }

    @Override
    @SecureInternalMethod
    public ExecutionInfo interruptAndCancel(final int planId, AuthContext nullCtx, final short serialVersion) {
        final Admin admin = this.aservice.getAdmin();
        ExecutionInfo info = this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<ExecutionInfo>(){

            @Override
            public ExecutionInfo execute() {
                Plan plan = admin.getAndCheckPlan(planId);
                AccessCheckUtils.checkPermission(ClientAdminServiceImpl.this.aservice, new AccessCheckUtils.PlanOperationContext(plan, "interruptAndCancel"));
                Plan.State currentState = admin.getCurrentPlanState(planId);
                if (currentState.equals((Object)Plan.State.RUNNING)) {
                    admin.interruptPlan(planId);
                    currentState = admin.awaitPlan(planId, 0, null);
                }
                if (currentState.checkTransition(Plan.State.CANCELED)) {
                    admin.cancelPlan(planId);
                } else if (!currentState.isTerminal()) {
                    throw new AdminFaultException(new NonfatalAssertionException("Cancellation of operation " + planId + "unsuccessful, current state = " + (Object)((Object)currentState)));
                }
                return admin.getExecutionStatus(planId, serialVersion);
            }
        });
        return info;
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.USRVIEW})
    public boolean canHandleDDL(AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<Boolean>(){

            @Override
            public Boolean execute() {
                Admin admin = ClientAdminServiceImpl.this.aservice.getAdmin();
                if (admin == null) {
                    return false;
                }
                try {
                    ReplicatedEnvironment.State repState = admin.getReplicationMode();
                    return repState.isMaster();
                }
                catch (IllegalStateException iae) {
                    return false;
                }
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.USRVIEW})
    public URI getMasterRmiAddress(AuthContext authCtx, short serialVersion) {
        return this.aservice.getFaultHandler().execute(new ProcessFaultHandler.SimpleOperation<URI>(){

            @Override
            public URI execute() {
                Admin admin = ClientAdminServiceImpl.this.aservice.getAdmin();
                if (admin == null) {
                    return null;
                }
                return admin.getMasterRmiAddress();
            }
        });
    }
}

