/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import java.util.logging.Level;
import javax.security.auth.Subject;
import oracle.kv.LoginCredentials;
import oracle.kv.PasswordCredentials;
import oracle.kv.impl.admin.AdminService;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVStoreUserPrincipal;
import oracle.kv.impl.security.PasswordExpiredException;
import oracle.kv.impl.security.UserVerifier;
import oracle.kv.impl.security.metadata.KVStoreUser;
import oracle.kv.impl.security.metadata.SecurityMetadata;

public class AdminUserVerifier
implements UserVerifier {
    private final AdminService adminService;

    public AdminUserVerifier(AdminService aService) {
        this.adminService = aService;
    }

    @Override
    public Subject verifyUser(LoginCredentials creds) {
        if (!(creds instanceof PasswordCredentials)) {
            this.logMsg(Level.INFO, "Encountered unsupported login credentials of type " + creds.getClass());
            return null;
        }
        PasswordCredentials pwCreds = (PasswordCredentials)creds;
        SecurityMetadata secMd = this.adminService.getAdmin().getMetadata(SecurityMetadata.class, Metadata.MetadataType.SECURITY);
        if (secMd == null || secMd.getAllUsers().isEmpty()) {
            this.logMsg(Level.INFO, "Unable to verify user credentials with no security metadata available");
            return null;
        }
        String userName = pwCreds.getUsername();
        KVStoreUser user = secMd.getUser(userName);
        if (user == null || !user.verifyPassword(pwCreds.getPassword())) {
            this.logMsg(Level.INFO, "User password credentials are not valid");
            return null;
        }
        if (user.isPasswordExpired()) {
            this.logMsg(Level.INFO, "User password credentials are expired");
            throw new PasswordExpiredException(String.format("The password of %s has expired, it is required to change the password.", userName));
        }
        return user.makeKVSubject();
    }

    @Override
    public Subject verifyUser(Subject subj) {
        KVStoreUserPrincipal userPrinc = ExecutionContext.getSubjectUserPrincipal(subj);
        if (userPrinc == null) {
            return subj;
        }
        SecurityMetadata secMd = this.adminService.getAdmin().getMetadata(SecurityMetadata.class, Metadata.MetadataType.SECURITY);
        if (secMd == null) {
            this.logMsg(Level.INFO, "Unable to verify user with no security metadata available");
            return null;
        }
        KVStoreUser user = secMd.getUser(userPrinc.getName());
        if (user == null || !user.isEnabled()) {
            this.logMsg(Level.INFO, "User " + userPrinc.getName() + " is not valid");
            return null;
        }
        return subj;
    }

    public boolean userDataExists() {
        SecurityMetadata secMd = this.adminService.getAdmin() != null ? this.adminService.getAdmin().getMetadata(SecurityMetadata.class, Metadata.MetadataType.SECURITY) : null;
        return secMd != null && !secMd.getAllUsers().isEmpty();
    }

    private void logMsg(Level level, String msg) {
        if (this.adminService != null) {
            this.adminService.getLogger().log(level, msg);
        }
    }
}

