/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationGroup;
import com.sleepycat.je.rep.ReplicationNetworkConfig;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.util.ReplicationGroupAdmin;
import com.sleepycat.je.rep.utilint.HostPortPair;
import java.net.InetSocketAddress;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.AdminSecurity;
import oracle.kv.impl.admin.AdminServiceFaultHandler;
import oracle.kv.impl.admin.AdminServiceParams;
import oracle.kv.impl.admin.ClientAdminServiceImpl;
import oracle.kv.impl.admin.CommandService;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.CommandServiceImpl;
import oracle.kv.impl.admin.LoginService;
import oracle.kv.impl.admin.WebService;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.BootstrapParams;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.SecurityParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.client.admin.ClientAdminService;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.measurement.ServiceStatusChange;
import oracle.kv.impl.mgmt.AdminStatusReceiver;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.ParameterListener;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.ConfigurationException;
import oracle.kv.impl.security.RoleResolver;
import oracle.kv.impl.security.SecureProxy;
import oracle.kv.impl.security.login.InternalLoginManager;
import oracle.kv.impl.security.login.UserLogin;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.AdminType;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.PortRange;
import oracle.kv.impl.util.registry.RMISocketPolicy;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.impl.util.server.LoggerUtils;

public class AdminService
implements ConfigurableService {
    private AdminServiceParams params;
    private Admin admin = null;
    private CommandService commandService;
    private CommandService exportableCommandService;
    private LoginService loginService;
    private UserLogin exportableUL;
    private ClientAdminService clientService;
    private ClientAdminService exportableClientService;
    private WebService webService;
    private AdminStatusReceiver statusReceiver = null;
    private ParameterListener parameterListener = null;
    private AdminSecurity adminSecurity;
    private Logger logger;
    private AdminServiceFaultHandler faultHandler;
    private final boolean usingThreads;
    public static final String DEFAULT_JAVA_ARGS = "-XX:+DisableExplicitGC -Xms96M -Xmx128M -XX:+HeapDumpOnOutOfMemoryError -server -Dje.rep.skipHelperHostResolution=true";
    private boolean active = false;

    public AdminService(boolean usingThreads) {
        this.usingThreads = usingThreads;
        this.faultHandler = null;
    }

    public AdminService(BootstrapParams bp, SecurityParams sp, boolean usingThreads) {
        this.usingThreads = usingThreads;
        this.deriveASParams(bp, sp);
        this.logger = this.params.getGlobalParams().getKVStoreName() == null ? LoggerUtils.getBootstrapLogger(bp.getRootdir(), "adminboot", "BootstrapAdmin") : LoggerUtils.getLogger(this.getClass(), this.params);
        this.faultHandler = new AdminServiceFaultHandler(this.logger, this);
        this.adminSecurity = new AdminSecurity(this, this.logger);
    }

    public void initialize(SecurityParams securityParams, AdminParams adminParams, LoadParameters lp) {
        securityParams.initRMISocketPolicies();
        GlobalParams globalParams = new GlobalParams(lp.getMap("globalParams"));
        StorageNodeParams storageNodeParams = new StorageNodeParams(lp.getMap("storageNodeParams"));
        this.params = new AdminServiceParams(securityParams, globalParams, storageNodeParams, adminParams);
        this.logger = LoggerUtils.getLogger(this.getClass(), this.params);
        if (this.faultHandler == null) {
            this.faultHandler = new AdminServiceFaultHandler(this.logger, this);
        }
        if (!this.usingThreads) {
            storageNodeParams.setRegistryCSF(securityParams);
        }
        this.adminSecurity = new AdminSecurity(this, this.logger);
    }

    @Override
    public synchronized void start() {
        this.getFaultHandler().execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                AdminService.this.startInternal();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startInternal() {
        ServiceBinder serviceBinder;
        StorageNodeParams snParams = this.params.getStorageNodeParams();
        String hostName = snParams.getHostname();
        System.setProperty("java.rmi.server.hostname", hostName);
        System.setProperty("java.rmi.server.disableHttp", "true");
        String kvStoreName = this.params.getGlobalParams().getKVStoreName();
        if (kvStoreName == null) {
            this.logger.info("Starting in bootstrap mode");
        } else {
            this.logger.info("Starting AdminService");
            this.admin = new Admin(this.params, this);
        }
        if (this.params.getSecurityParams().isSecure()) {
            serviceBinder = new ServiceBinder<UserLogin, LoginService>("admin:LOGIN", this){

                @Override
                LoginService makeInsecureService() {
                    return new LoginService(this.aservice);
                }

                @Override
                UserLogin getRemote() {
                    return ((LoginService)this.insecureService).getUserLogin();
                }
            };
            this.loginService = (LoginService)serviceBinder.getInsecureService();
            this.exportableUL = (UserLogin)serviceBinder.getSecureService();
            if (this.admin != null) {
                this.admin.installSecurityUpdater();
            }
        }
        serviceBinder = new ServiceBinder<CommandService, CommandService>("commandService", this){

            @Override
            CommandServiceImpl makeInsecureService() {
                return new CommandServiceImpl(this.aservice);
            }

            @Override
            CommandService getRemote() {
                return (CommandService)this.insecureService;
            }
        };
        this.commandService = (CommandService)serviceBinder.getInsecureService();
        this.exportableCommandService = (CommandService)serviceBinder.getSecureService();
        ServiceBinder<ClientAdminService, ClientAdminService> stmtBinder = new ServiceBinder<ClientAdminService, ClientAdminService>("admin:CLIENT_ADMIN", this){

            @Override
            ClientAdminServiceImpl makeInsecureService() {
                return new ClientAdminServiceImpl(this.aservice);
            }

            @Override
            ClientAdminService getRemote() {
                return (ClientAdminService)this.insecureService;
            }
        };
        this.clientService = (ClientAdminService)stmtBinder.getInsecureService();
        this.exportableClientService = (ClientAdminService)stmtBinder.getSecureService();
        int httpPort = this.params.getAdminParams().getHttpPort();
        if (httpPort != 0) {
            this.logger.info("Starting Web service on port " + httpPort);
            try {
                this.webService = new WebService(CommandServiceAPI.wrap(this.commandService, null), this.logger);
                this.webService.start(httpPort);
            }
            catch (Exception e) {
                String msg = "Starting WebService failed. ";
                this.logger.severe(msg + LoggerUtils.getStackTrace(e));
            }
        }
        AdminService adminService = this;
        synchronized (adminService) {
            this.active = true;
            this.notifyAll();
        }
        this.logger.info("Started AdminService");
    }

    @Override
    public synchronized void stop(boolean force) {
        this.logger.info("Shutting down AdminService instance" + (force ? " (force)" : ""));
        this.updateAdminStatus(this.admin, ConfigurableService.ServiceStatus.STOPPING);
        String hostName = this.params.getStorageNodeParams().getHostname();
        if (this.commandService != null) {
            try {
                this.logger.info("Unbinding CommandService");
                RegistryUtils.unbind(hostName, this.params.getStorageNodeParams().getRegistryPort(), "commandService", this.exportableCommandService);
                this.commandService = null;
            }
            catch (RemoteException re) {
                String msg = "Can't unbind CommandService. ";
                this.logger.severe(msg + LoggerUtils.getStackTrace(re));
                throw new IllegalStateException(msg, re);
            }
        }
        if (this.clientService != null) {
            try {
                this.logger.info("Unbinding ClientAdminService");
                RegistryUtils.unbind(hostName, this.params.getStorageNodeParams().getRegistryPort(), "admin:CLIENT_ADMIN", this.exportableClientService);
                this.clientService = null;
            }
            catch (RemoteException re) {
                String msg = "Can't unbind ClientAdminService. ";
                this.logger.severe(msg + LoggerUtils.getStackTrace(re));
                throw new IllegalStateException(msg, re);
            }
        }
        if (this.loginService != null) {
            try {
                this.logger.info("Unbinding LoginService");
                RegistryUtils.unbind(hostName, this.params.getStorageNodeParams().getRegistryPort(), "admin:LOGIN", this.exportableUL);
                this.loginService = null;
            }
            catch (RemoteException re) {
                String msg = "Can't unbind LoginService. ";
                this.logger.severe(msg + LoggerUtils.getStackTrace(re));
                throw new IllegalStateException(msg, re);
            }
        }
        if (this.webService != null) {
            this.logger.info("Shutting down WebService");
            try {
                this.webService.stop();
                this.webService = null;
            }
            catch (Exception e) {
                String msg = "Can't stop WebService. ";
                this.logger.severe(msg + LoggerUtils.getStackTrace(e));
                throw new IllegalStateException(msg, e);
            }
        }
        if (this.admin != null) {
            this.logger.info("Shutting down Admin");
            this.admin.shutdown(force);
            this.admin = null;
        }
        this.active = false;
        this.notifyAll();
    }

    public synchronized void waitForActive(boolean desiredState) throws InterruptedException {
        while (this.active != desiredState) {
            this.wait();
        }
    }

    public Admin getAdmin() {
        return this.admin;
    }

    public AdminServiceParams getParams() {
        return this.params;
    }

    public AdminSecurity getAdminSecurity() {
        return this.adminSecurity;
    }

    public LoginService getLoginService() {
        return this.loginService;
    }

    public InternalLoginManager getLoginManager() {
        return this.adminSecurity == null ? null : this.adminSecurity.getLoginManager();
    }

    public void configure(String storeName) {
        assert (this.admin == null);
        this.params.getGlobalParams().setKVStoreName(storeName);
        StorageNodeParams snp = this.params.getStorageNodeParams();
        int haPort = PortRange.getRange(snp.getHAPortRange()).get(0);
        AdminParams ap = this.params.getAdminParams();
        ap.setJEInfo(snp.getHAHostname(), haPort, snp.getHAHostname(), haPort);
        this.admin = new Admin(this.params, this);
        this.logger.info("Changing log files to log directory for store " + storeName);
        this.logger = LoggerUtils.getLogger(this.getClass(), this.params);
        if (this.webService != null) {
            this.webService.resetLog(this.logger);
        }
        this.faultHandler.setLogger(this.logger);
        this.adminSecurity.configure(storeName);
        if (this.loginService != null) {
            this.loginService.resetLogger(this.logger);
        }
        this.logger.info("Configured Admin for store: " + storeName);
        if (this.params.getSecurityParams() != null) {
            this.admin.installSecurityUpdater();
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ProcessFaultHandler getFaultHandler() {
        return this.faultHandler;
    }

    public boolean getUsingThreads() {
        return this.usingThreads;
    }

    private void deriveASParams(BootstrapParams bp, SecurityParams sp) {
        String storeName = bp.getStoreName();
        StorageNodeId snid = new StorageNodeId(storeName == null ? 1 : bp.getId());
        GlobalParams gp = new GlobalParams(storeName);
        StorageNodeParams snp = new StorageNodeParams(snid, bp.getHostname(), bp.getRegistryPort(), "Admin Bootstrap");
        snp.setRootDirPath(bp.getRootdir());
        snp.setHAHostname(bp.getHAHostname());
        snp.setHAPortRange(bp.getHAPortRange());
        snp.setServicePortRange(bp.getServicePortRange());
        AdminParams ap = new AdminParams(new AdminId(1), snp.getStorageNodeId(), bp.getAdminHttpPort(), AdminType.PRIMARY);
        this.params = new AdminServiceParams(sp, gp, snp, ap);
    }

    public void updateMemberHAAddress(AdminId targetId, String targetHelperHosts, String newNodeHostPort) {
        ReplicationNetworkConfig repNetConfig;
        HashSet<InetSocketAddress> helperSockets = new HashSet<InetSocketAddress>();
        StringTokenizer tokenizer = new StringTokenizer(targetHelperHosts, ",");
        while (tokenizer.hasMoreTokens()) {
            String helper = tokenizer.nextToken();
            helperSockets.add(HostPortPair.getSocket((String)helper));
        }
        String storeName = this.params.getGlobalParams().getKVStoreName();
        String groupName = Admin.getAdminRepGroupName(storeName);
        this.logger.info("Updating rep group " + groupName + " using helpers " + targetHelperHosts + " to change " + targetId + " to " + newNodeHostPort);
        String targetNodeName = Admin.getAdminRepNodeName(targetId);
        if (this.admin != null) {
            repNetConfig = this.admin.getRepNetConfig();
        } else if (this.params.getSecurityParams() == null) {
            repNetConfig = null;
        } else {
            Properties haProps = this.params.getSecurityParams().getJEHAProperties();
            this.logger.info("DataChannelFactory: " + haProps.getProperty("je.rep.channelType"));
            repNetConfig = ReplicationNetworkConfig.create((Properties)haProps);
        }
        ReplicationGroupAdmin rga = new ReplicationGroupAdmin(groupName, helperSockets, repNetConfig);
        ReplicationGroup rg = rga.getGroup();
        ReplicationNode jeRN = rg.getMember(targetNodeName);
        if (jeRN == null) {
            throw new IllegalStateException(targetNodeName + " does not exist in replication group " + groupName);
        }
        String newHostName = HostPortPair.getHostname((String)newNodeHostPort);
        int newPort = HostPortPair.getPort((String)newNodeHostPort);
        if (jeRN.getHostName().equals(newHostName) && jeRN.getPort() == newPort) {
            return;
        }
        rga.updateAddress(targetNodeName, newHostName, newPort);
    }

    public void installStatusReceiver(AdminStatusReceiver asr) {
        this.statusReceiver = asr;
        if (this.admin == null) {
            this.updateAdminStatus(null, ConfigurableService.ServiceStatus.WAITING_FOR_DEPLOY);
        } else {
            this.updateAdminStatus(this.admin, ConfigurableService.ServiceStatus.RUNNING);
        }
    }

    void updateAdminStatus(Admin a, ConfigurableService.ServiceStatus newStatus) {
        if (this.statusReceiver == null) {
            return;
        }
        if (a != null && this.parameterListener == null) {
            this.parameterListener = new ParameterChangeListener();
            a.addParameterListener(this.parameterListener);
            this.parameterListener.newParameters(null, a.getParams().getAdminParams().getMap());
        }
        ReplicatedEnvironment.State adminState = a == null ? null : a.getReplicationMode();
        boolean isMaster = adminState != null && adminState == ReplicatedEnvironment.State.MASTER;
        try {
            this.statusReceiver.updateAdminStatus(new ServiceStatusChange(newStatus), isMaster);
        }
        catch (RemoteException e) {
            this.logger.log(Level.WARNING, "Failed to send status updateof " + newStatus.toString() + " to MgmtAgent", e);
        }
    }

    WebService getWebService() {
        return this.webService;
    }

    public RoleResolver getRoleResolver() {
        return this.adminSecurity == null ? null : this.adminSecurity.getRoleResolver();
    }

    private abstract class ServiceBinder<S extends Remote, I> {
        private final String svcName;
        protected final AdminService aservice;
        protected I insecureService;
        private S secureService;

        ServiceBinder(String svcName, AdminService aservice) {
            this.svcName = svcName;
            this.aservice = aservice;
            this.initService();
        }

        public S getSecureService() {
            return this.secureService;
        }

        public I getInsecureService() {
            return this.insecureService;
        }

        abstract I makeInsecureService();

        abstract S getRemote();

        private void initService() {
            StorageNodeParams snParams = AdminService.this.params.getStorageNodeParams();
            String hostName = snParams.getHostname();
            int registryPort = snParams.getRegistryPort();
            String kvStoreName = AdminService.this.params.getGlobalParams().getKVStoreName();
            AdminService.this.logger.info("Starting " + this.svcName + " on rmi://" + hostName + ":" + registryPort + "/" + this.svcName);
            try {
                this.insecureService = this.makeInsecureService();
                try {
                    this.secureService = (Remote)SecureProxy.create(this.getRemote(), AdminService.this.adminSecurity.getAccessChecker(), AdminService.this.faultHandler);
                    AdminService.this.logger.info("Successfully created a secure proxy for " + this.svcName);
                }
                catch (ConfigurationException ce) {
                    throw new IllegalStateException("Unable to create a secure proxy for " + this.svcName, ce);
                }
                RMISocketPolicy rmiSocketPolicy = AdminService.this.params.getSecurityParams().getRMISocketPolicy();
                RMISocketPolicy.SocketFactoryPair sfp = AdminService.this.params.getStorageNodeParams().getAdminCommandServiceSFP(rmiSocketPolicy, kvStoreName);
                RegistryUtils.rebind(hostName, registryPort, this.svcName, this.secureService, sfp.getClientFactory(), sfp.getServerFactory());
            }
            catch (RemoteException re) {
                String msg = "Starting " + this.svcName + " failed";
                AdminService.this.logger.severe(msg + LoggerUtils.getStackTrace(re));
                throw new IllegalStateException(msg, re);
            }
        }
    }

    private class ParameterChangeListener
    implements ParameterListener {
        private ParameterChangeListener() {
        }

        @Override
        public void newParameters(ParameterMap oldMap, ParameterMap newMap) {
            try {
                AdminService.this.statusReceiver.receiveNewParams(newMap);
            }
            catch (RemoteException re) {
                AdminService.this.logger.log(Level.WARNING, "Failure to deliver parameter change to MgmtAgent", re);
                return;
            }
        }
    }
}

