/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Durability;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.rep.MasterTransferFailureException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.util.ReplicationGroupAdmin;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.AdminFaultException;
import oracle.kv.impl.admin.AdminPlanDatabase;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.DeploymentInfo;
import oracle.kv.impl.admin.plan.PlanStore;
import oracle.kv.impl.admin.topo.RealizedTopology;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.TopologyServerUtil;
import oracle.kv.impl.util.TxnUtil;
import oracle.kv.impl.util.VersionUtil;

public class AdminSchemaVersion {
    private static final int SCHEMA_VERSION_3 = 3;
    public static final int SCHEMA_VERSION_4 = 4;
    public static final int CURRENT_SCHEMA = 4;
    private static final String DB_NAME = "AdminSchemaVersion";
    private static final String SCHEMA_VERSION_KEY = "schemaVersion";
    private static final String SOFTWARE_VERSION_KEY = "softwareVersion";
    private static final KVVersion FIRST_KV_VERSION = KVVersion.R1_2_123;
    private final Admin admin;
    private final ReplicatedEnvironment repEnv;
    private final Logger logger;

    public AdminSchemaVersion(Admin admin, Logger logger) {
        this.logger = logger;
        this.admin = admin;
        this.repEnv = admin.getEnv();
    }

    void checkAndUpdateVersion(Transaction txn) {
        this.checkAndUpdateVersion(txn, 4, true);
    }

    void checkVersion(Transaction txn) {
        this.checkAndUpdateVersion(txn, 4, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkAndUpdateVersion(Transaction txn, int useSchemaVersion, boolean doUpdate) {
        KVVersion existingKVVersion;
        int existingVersion;
        List dbNames = this.repEnv.getDatabaseNames();
        if (dbNames.isEmpty()) {
            if (doUpdate) {
                this.init(txn, useSchemaVersion);
            }
            return;
        }
        if (!dbNames.contains(DB_NAME)) {
            existingVersion = 1;
            existingKVVersion = FIRST_KV_VERSION;
        } else {
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setAllowCreate(false);
            dbConfig.setTransactional(true);
            dbConfig.setReadOnly(true);
            Database versionDb = null;
            try {
                versionDb = this.repEnv.openDatabase(null, DB_NAME, dbConfig);
                existingVersion = this.readSchemaVersion(txn, versionDb);
                existingKVVersion = this.readSoftwareVersion(txn, versionDb);
                if (existingVersion > useSchemaVersion) {
                    throw new IllegalStateException("This Admin Service software is at " + KVVersion.CURRENT_VERSION.getNumericVersionString() + ", schema version " + useSchemaVersion + " but the stored schema is at version " + existingVersion + "/" + existingKVVersion.getNumericVersionString() + ". Please upgrade this node's NoSQL Database" + " software version to " + existingKVVersion.getNumericVersionString() + " or higher.");
                }
            }
            finally {
                if (versionDb != null) {
                    versionDb.close();
                }
            }
        }
        if (existingKVVersion.equals(KVVersion.CURRENT_VERSION)) {
            assert (existingVersion == 4);
            return;
        }
        VersionUtil.checkUpgrade(existingKVVersion);
        if (existingKVVersion.compareTo(KVVersion.CURRENT_VERSION) < 0) {
            if (doUpdate) {
                this.update(existingVersion, existingKVVersion.toString(), txn, useSchemaVersion);
            } else {
                if (this.masterHasCurrentVersion()) {
                    if (existingVersion < 4 && existingVersion == 3 && !this.readyForV4Upgrade()) {
                        return;
                    }
                    if (!this.readyForSoftwareVersionUpdate()) {
                        return;
                    }
                }
                try {
                    ReplicationGroupAdmin repGroupAdmin = new ReplicationGroupAdmin(this.repEnv.getGroup().getName(), this.repEnv.getRepConfig().getHelperSockets(), this.admin.getRepNetConfig());
                    repGroupAdmin.transferMaster(Collections.singleton(this.repEnv.getNodeName()), 1, TimeUnit.MINUTES, false);
                    this.logger.log(Level.INFO, "Master transfer initiated due to upgrade to {0}", KVVersion.CURRENT_VERSION.getNumericVersionString());
                }
                catch (MasterTransferFailureException mtfe) {
                    this.logger.log(Level.INFO, "Attempt to transfer master to this node failed: {0}", mtfe.getMessage());
                }
                catch (Exception ex) {
                    this.logger.log(Level.INFO, "Attempt to transfer master to this node failed", ex);
                }
            }
        }
    }

    private void update(int existingVersion, String existingKVVersion, Transaction txn, int useSchemaVersion) {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setTransactional(true);
        Database versionDb = this.repEnv.openDatabase(txn, DB_NAME, dbConfig);
        this.updateSchemaVersion(existingVersion, existingKVVersion, txn, versionDb, useSchemaVersion);
        versionDb.close();
    }

    private void init(Transaction txn, int useSchemaVersion) {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setExclusiveCreate(true);
        dbConfig.setTransactional(true);
        Database versionDb = this.repEnv.openDatabase(txn, DB_NAME, dbConfig);
        this.updateSchemaVersion(0, null, txn, versionDb, useSchemaVersion);
        versionDb.close();
    }

    private void updateSchemaVersion(int existingVersion, String existingKVVersion, Transaction txn, Database versionDb, int useSchemaVersion) {
        if (existingVersion == 0) {
            this.logger.info("Initializing Admin Schema to schema version " + useSchemaVersion + "/NoSQL DB " + KVVersion.CURRENT_VERSION);
        } else if (existingVersion < 4) {
            this.logger.info("Updating Admin Schema version from schema version " + existingVersion + "/NoSQL DB " + existingKVVersion + " to schema version " + useSchemaVersion + "/NoSQL DB " + KVVersion.CURRENT_VERSION);
            if (!this.upgradeToV4(existingVersion, versionDb, txn)) {
                return;
            }
        }
        this.updateSchemaVersion(4, versionDb, txn);
        if (existingVersion != 0 && !this.readyForSoftwareVersionUpdate()) {
            return;
        }
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        StringBinding.stringToEntry((String)SOFTWARE_VERSION_KEY, (DatabaseEntry)key);
        StringBinding.stringToEntry((String)KVVersion.CURRENT_VERSION.toString(), (DatabaseEntry)value);
        versionDb.put(txn, key, value);
    }

    private int readSchemaVersion(Transaction txn, Database versionDb) {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        StringBinding.stringToEntry((String)SCHEMA_VERSION_KEY, (DatabaseEntry)key);
        OperationStatus status = versionDb.get(txn, key, value, LockMode.DEFAULT);
        if (status == OperationStatus.SUCCESS) {
            return IntegerBinding.entryToInt((DatabaseEntry)value);
        }
        return 1;
    }

    private KVVersion readSoftwareVersion(Transaction txn, Database versionDb) {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        StringBinding.stringToEntry((String)SOFTWARE_VERSION_KEY, (DatabaseEntry)key);
        OperationStatus status = versionDb.get(txn, key, value, LockMode.DEFAULT);
        if (status == OperationStatus.SUCCESS) {
            return KVVersion.parseVersion(StringBinding.entryToString((DatabaseEntry)value));
        }
        return FIRST_KV_VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int openAndReadSchemaVersion() {
        int version;
        Transaction txn;
        block3: {
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setAllowCreate(false);
            dbConfig.setTransactional(true);
            dbConfig.setReadOnly(true);
            Database versionDb = null;
            txn = null;
            version = 0;
            try {
                txn = this.repEnv.beginTransaction(null, new TransactionConfig().setDurability(Durability.COMMIT_SYNC));
                versionDb = this.repEnv.openDatabase(txn, DB_NAME, dbConfig);
                version = this.readSchemaVersion(txn, versionDb);
                txn.commit();
                if (versionDb == null) break block3;
            }
            catch (Throwable throwable) {
                if (versionDb != null) {
                    versionDb.close();
                }
                TxnUtil.abort(txn);
                throw throwable;
            }
            versionDb.close();
        }
        TxnUtil.abort(txn);
        return version;
    }

    private void upgradeToV3(int existingVersion, Database versionDb, Transaction txn) {
        if (existingVersion >= 3) {
            return;
        }
        EntityStore eStore = this.admin.initEstore();
        PlanStore planStore = PlanStore.getStoreByVersion(this.admin, 3);
        this.upgradeAdminTopologyToV3(eStore, txn);
        this.upgradeAllPlansToV3(planStore, txn);
        this.updateSchemaVersion(3, versionDb, txn);
    }

    private boolean upgradeToV4(int existingVersion, Database versionDb, Transaction txn) {
        this.upgradeToV3(existingVersion, versionDb, txn);
        if (!this.readyForV4Upgrade()) {
            return false;
        }
        EntityStore eStore = this.admin.initEstore();
        AdminPlanDatabase planDb = this.admin.initAdminPlanDb();
        this.upgradeAllPlansToV4(eStore, planDb, txn);
        return true;
    }

    private boolean readyForV4Upgrade() {
        this.admin.initEstore();
        try {
            if (!this.admin.checkAdminGroupVersion(KVVersion.R3_1)) {
                this.logger.info("Unable to upgrade to Admin DB version 4 while not all Admins in the store have version of " + KVVersion.R3_1.getNumericVersionString() + " or later.");
                return false;
            }
        }
        catch (AdminFaultException afe) {
            this.logger.info("Unable to confirm the lowest supported version of all Admins. Skipped upgrading Admin DB version to 4");
            return false;
        }
        return true;
    }

    private boolean readyForSoftwareVersionUpdate() {
        this.admin.initEstore();
        try {
            KVVersion versionLowest = this.admin.getAdminGroupVersion();
            KVVersion versionHighest = this.admin.getAdminHighestVersion();
            return VersionUtil.compareMinorVersion(versionLowest, versionHighest) == 0;
        }
        catch (AdminFaultException afe) {
            this.logger.info("Unable to confirm the versions of all Admins, not ready for version DB update now.");
            return false;
        }
    }

    private boolean masterHasCurrentVersion() {
        this.admin.initEstore();
        try {
            if (!this.admin.checkAdminMasterVersion(KVVersion.CURRENT_VERSION)) {
                this.logger.info("Admin master has not upgraded to current version of " + KVVersion.CURRENT_VERSION.getNumericVersionString() + ". Try to become master to support upgrade operations.");
                return false;
            }
        }
        catch (AdminFaultException afe) {
            this.logger.info("Unable to confirm the version of current admin master.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeAllPlansToV3(PlanStore planStore, Transaction txn) {
        this.logger.info("Upgrading all plans to Admin DB version 3.");
        PlanStore.PlanCursor cursor = planStore.getPlanCursor(txn, null);
        try {
            AbstractPlan p = cursor.first();
            while (p != null) {
                p.upgradeToV3();
                p.persist(planStore, txn);
                p = cursor.next();
            }
        }
        finally {
            cursor.close();
        }
    }

    private void upgradeAdminTopologyToV3(EntityStore eStore, Transaction txn) {
        Topology oldTopo = TopologyServerUtil.fetchCommitted(eStore, txn);
        this.logger.info("Upgrading current topology to Admin DB version 3.");
        if (oldTopo.getVersion() != 0) {
            throw new IllegalStateException("Unexpected Topology version " + oldTopo.getVersion() + " found in legacy Admin database.");
        }
        if (!oldTopo.upgrade()) {
            this.logger.severe("Unable to upgrade the Topology from its earlier version. The store will continue to run with this Topology, But certain features that are new in R2, such as dynamic master rebalancing, and elasticity operations, will not be available. To enable these features will require dumping the database contents and restoring them to an R2 topology, using the snapshot and load commands.  Please see the NoSQL Database Administrator's Guide, chap. 7, for more information");
        }
        DeploymentInfo info = DeploymentInfo.makeStartupDeploymentInfo();
        RealizedTopology rt = new RealizedTopology(oldTopo, info);
        rt.setStartTime();
        this.admin.getTopoStore().save(txn, rt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeAllPlansToV4(EntityStore eStore, AdminPlanDatabase planDb, Transaction txn) {
        this.logger.info("Upgrading all plans to store in non-DPL JE database.");
        PrimaryIndex pi = eStore.getPrimaryIndex(Integer.class, AbstractPlan.class);
        EntityCursor cursor = pi.entities(txn, null);
        try {
            AbstractPlan p = (AbstractPlan)cursor.first();
            while (p != null) {
                planDb.persistEntity(txn, p);
                pi.delete(txn, (Object)p.getId());
                p = (AbstractPlan)cursor.next();
            }
        }
        finally {
            cursor.close();
        }
    }

    private void updateSchemaVersion(int newVersion, Database versionDb, Transaction txn) {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        StringBinding.stringToEntry((String)SCHEMA_VERSION_KEY, (DatabaseEntry)key);
        IntegerBinding.intToEntry((int)newVersion, (DatabaseEntry)value);
        versionDb.put(txn, key, value);
    }
}

