/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import java.net.URI;
import java.util.logging.Level;
import oracle.kv.impl.admin.AdminService;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.security.PasswordRenewer;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.ServiceUtils;

public class AdminPasswordRenewer
implements PasswordRenewer {
    private final AdminService adminService;

    public AdminPasswordRenewer(AdminService aService) {
        this.adminService = aService;
    }

    @Override
    public boolean renewPassword(String userName, char[] newPassword) {
        URI masterURI = this.adminService.getAdmin().getMasterRmiAddress();
        CommandServiceAPI cs = null;
        int planId = 0;
        try {
            cs = ServiceUtils.waitForAdmin(masterURI.getHost(), masterURI.getPort(), this.adminService.getLoginManager(), 40L, ConfigurableService.ServiceStatus.RUNNING);
            planId = cs.createChangeUserPlan("renew-password", userName, true, newPassword, false, false);
            assert (planId != 0);
            cs.approvePlan(planId);
            cs.executePlan(planId, false);
            Plan.State state = cs.awaitPlan(planId, 0, null);
            if (state == Plan.State.SUCCEEDED) {
                return true;
            }
            this.cancelPlan(cs, planId);
        }
        catch (Exception e) {
            this.logPasswordRenewFailure(userName, e);
            this.cancelPlan(cs, planId);
        }
        return false;
    }

    private void logPasswordRenewFailure(String userName, Exception e) {
        if (e == null) {
            return;
        }
        this.logMsg(Level.SEVERE, "Attempting to change password of user " + userName + " failed: " + e);
    }

    private void cancelPlan(CommandServiceAPI cs, int planId) {
        if (cs == null || planId == 0) {
            return;
        }
        try {
            cs.cancelPlan(planId);
        }
        catch (Exception e) {
            this.logCancelPlanFailure(planId, e);
        }
    }

    private void logCancelPlanFailure(int planId, Exception e) {
        if (planId != 0 && e != null) {
            return;
        }
        this.logMsg(Level.INFO, "Attempts to cancel plan of renew password " + planId + " failed: " + e.getMessage());
    }

    private void logMsg(Level level, String msg) {
        if (this.adminService != null) {
            this.adminService.getLogger().log(level, msg);
        }
    }
}

